/*
 * Decompiled with CFR 0.152.
 */
package org.proton.plug.context.client;

import java.util.concurrent.TimeUnit;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.message.ProtonJMessage;
import org.proton.plug.AMQPClientSenderContext;
import org.proton.plug.AMQPSessionCallback;
import org.proton.plug.context.AbstractConnectionContext;
import org.proton.plug.context.AbstractProtonContextSender;
import org.proton.plug.context.AbstractProtonSessionContext;
import org.proton.plug.exceptions.HornetQAMQPException;
import org.proton.plug.util.FutureRunnable;

public class ProtonClientContext
extends AbstractProtonContextSender
implements AMQPClientSenderContext {
    FutureRunnable catchUpRunnable = new FutureRunnable();

    public ProtonClientContext(AbstractConnectionContext connection, Sender sender, AbstractProtonSessionContext protonSession, AMQPSessionCallback server) {
        super(connection, sender, protonSession, server);
    }

    @Override
    public void onMessage(Delivery delivery) throws HornetQAMQPException {
        if (delivery.getRemoteState() instanceof Accepted && delivery.getContext() instanceof FutureRunnable) {
            ((FutureRunnable)delivery.getContext()).countDown();
        }
    }

    @Override
    public void send(ProtonJMessage message) {
        if (this.sender.getSenderSettleMode() != SenderSettleMode.SETTLED) {
            this.catchUpRunnable.countUp();
        }
        this.performSend(message, this.catchUpRunnable);
    }

    public boolean sync(long timeout, TimeUnit unit) {
        try {
            return this.catchUpRunnable.await(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

