/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;
import org.hornetq.core.client.ClientSession;
import org.hornetq.core.client.ClientSessionFactory;
import org.hornetq.core.config.TransportConfiguration;
import org.hornetq.core.exception.HornetQException;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.ra.ConnectionFactoryProperties;
import org.hornetq.ra.HornetQRAProperties;
import org.hornetq.ra.Util;
import org.hornetq.ra.inflow.HornetQActivation;
import org.hornetq.ra.inflow.HornetQActivationSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HornetQResourceAdapter
implements ResourceAdapter {
    private static final Logger log = Logger.getLogger(HornetQResourceAdapter.class);
    private static boolean trace = log.isTraceEnabled();
    private BootstrapContext ctx;
    private final HornetQRAProperties raProperties;
    private ClientSessionFactory sessionFactory;
    private final AtomicBoolean configured;
    private final Map<ActivationSpec, HornetQActivation> activations;
    private HornetQConnectionFactory defaultHornetQConnectionFactory;

    public HornetQResourceAdapter() {
        if (trace) {
            log.trace((Object)"constructor()");
        }
        this.raProperties = new HornetQRAProperties();
        this.sessionFactory = null;
        this.configured = new AtomicBoolean(false);
        this.activations = new ConcurrentHashMap<ActivationSpec, HornetQActivation>();
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        if (!this.configured.getAndSet(true)) {
            try {
                this.setup();
            }
            catch (HornetQException e) {
                throw new ResourceException("Unable to create activation", (Throwable)e);
            }
        }
        if (trace) {
            log.trace((Object)("endpointActivation(" + endpointFactory + ", " + spec + ")"));
        }
        HornetQActivation activation = new HornetQActivation(this, endpointFactory, (HornetQActivationSpec)spec);
        this.activations.put(spec, activation);
        activation.start();
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        HornetQActivation activation;
        if (trace) {
            log.trace((Object)("endpointDeactivation(" + endpointFactory + ", " + spec + ")"));
        }
        if ((activation = this.activations.remove(spec)) != null) {
            activation.stop();
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        if (trace) {
            log.trace((Object)("getXAResources(" + specs + ")"));
        }
        throw new ResourceException("Unsupported");
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        if (trace) {
            log.trace((Object)("start(" + ctx + ")"));
        }
        this.ctx = ctx;
        log.info((Object)"HornetQ resource adaptor started");
    }

    public void stop() {
        if (trace) {
            log.trace((Object)"stop()");
        }
        for (Map.Entry<ActivationSpec, HornetQActivation> entry : this.activations.entrySet()) {
            try {
                entry.getValue().stop();
            }
            catch (Exception ignored) {
                log.debug((Object)"Ignored", (Throwable)ignored);
            }
        }
        this.activations.clear();
        log.info((Object)"HornetQ resource adapter stopped");
    }

    public void setConnectorClassName(String connectorClassName) {
        if (trace) {
            log.trace((Object)("setTransportType(" + connectorClassName + ")"));
        }
        this.raProperties.setConnectorClassName(connectorClassName);
    }

    public String getConnectorClassName() {
        return this.raProperties.getConnectorClassName();
    }

    public Map<String, Object> getConnectionParameters() {
        return this.raProperties.getParsedConnectionParameters();
    }

    public void setConnectionParameters(String config) {
        if (config != null) {
            this.raProperties.setParsedConnectionParameters(Util.parseConfig(config));
        }
    }

    public String getBackupConnectorClassName() {
        return this.raProperties.getBackupConnectorClassName();
    }

    public void setBackupConnectorClassName(String backupConnector) {
        if (trace) {
            log.trace((Object)("setBackUpTransportType(" + backupConnector + ")"));
        }
        this.raProperties.setBackupConnectorClassName(backupConnector);
    }

    public Map<String, Object> getBackupConnectionParameters() {
        return this.raProperties.getParsedBackupConnectionParameters();
    }

    public void setBackupTransportConfiguration(String config) {
        if (config != null) {
            this.raProperties.setParsedBackupConnectionParameters(Util.parseConfig(config));
        }
    }

    public String getDiscoveryAddress() {
        if (trace) {
            log.trace((Object)"getDiscoveryGroupAddress()");
        }
        return this.raProperties.getDiscoveryAddress();
    }

    public void setDiscoveryAddress(String dgn) {
        if (trace) {
            log.trace((Object)("setDiscoveryGroupAddress(" + dgn + ")"));
        }
        this.raProperties.setDiscoveryAddress(dgn);
    }

    public Integer getDiscoveryPort() {
        if (trace) {
            log.trace((Object)"getDiscoveryGroupPort()");
        }
        return this.raProperties.getDiscoveryPort();
    }

    public void setDiscoveryPort(Integer dgp) {
        if (trace) {
            log.trace((Object)("setDiscoveryGroupPort(" + dgp + ")"));
        }
        this.raProperties.setDiscoveryPort(dgp);
    }

    public Long getDiscoveryRefreshTimeout() {
        if (trace) {
            log.trace((Object)"getDiscoveryRefreshTimeout()");
        }
        return this.raProperties.getDiscoveryRefreshTimeout();
    }

    public void setDiscoveryRefreshTimeout(Long discoveryRefreshTimeout) {
        if (trace) {
            log.trace((Object)("setDiscoveryRefreshTimeout(" + discoveryRefreshTimeout + ")"));
        }
        this.raProperties.setDiscoveryRefreshTimeout(discoveryRefreshTimeout);
    }

    public Long getDiscoveryInitialWaitTimeout() {
        if (trace) {
            log.trace((Object)"getDiscoveryInitialWaitTimeout()");
        }
        return this.raProperties.getDiscoveryInitialWaitTimeout();
    }

    public void setDiscoveryInitialWaitTimeout(Long discoveryInitialWaitTimeout) {
        if (trace) {
            log.trace((Object)("setDiscoveryInitialWaitTimeout(" + discoveryInitialWaitTimeout + ")"));
        }
        this.raProperties.setDiscoveryInitialWaitTimeout(discoveryInitialWaitTimeout);
    }

    public String getLoadBalancingPolicyClassName() {
        if (trace) {
            log.trace((Object)"getLoadBalancingPolicyClassName()");
        }
        return this.raProperties.getConnectionLoadBalancingPolicyClassName();
    }

    public void setLoadBalancingPolicyClassName(String loadBalancingPolicyClassName) {
        if (trace) {
            log.trace((Object)("setLoadBalancingPolicyClassName(" + loadBalancingPolicyClassName + ")"));
        }
        this.raProperties.setConnectionLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
    }

    public Long getClientFailureCheckPeriod() {
        if (trace) {
            log.trace((Object)"getClientFailureCheckPeriod()");
        }
        return this.raProperties.getClientFailureCheckPeriod();
    }

    public void setClientFailureCheckPeriod(Long clientFailureCheckPeriod) {
        if (trace) {
            log.trace((Object)("setClientFailureCheckPeriod(" + clientFailureCheckPeriod + ")"));
        }
        this.raProperties.setClientFailureCheckPeriod(clientFailureCheckPeriod);
    }

    public Long getConnectionTTL() {
        if (trace) {
            log.trace((Object)"getConnectionTTL()");
        }
        return this.raProperties.getConnectionTTL();
    }

    public void setConnectionTTL(Long connectionTTL) {
        if (trace) {
            log.trace((Object)("setConnectionTTL(" + connectionTTL + ")"));
        }
        this.raProperties.setConnectionTTL(connectionTTL);
    }

    public Long getCallTimeout() {
        if (trace) {
            log.trace((Object)"getCallTimeout()");
        }
        return this.raProperties.getCallTimeout();
    }

    public void setCallTimeout(Long callTimeout) {
        if (trace) {
            log.trace((Object)("setCallTimeout(" + callTimeout + ")"));
        }
        this.raProperties.setCallTimeout(callTimeout);
    }

    public Integer getDupsOKBatchSize() {
        if (trace) {
            log.trace((Object)"getDupsOKBatchSize()");
        }
        return this.raProperties.getDupsOKBatchSize();
    }

    public void setDupsOKBatchSize(Integer dupsOKBatchSize) {
        if (trace) {
            log.trace((Object)("setDupsOKBatchSize(" + dupsOKBatchSize + ")"));
        }
        this.raProperties.setDupsOKBatchSize(dupsOKBatchSize);
    }

    public Integer getTransactionBatchSize() {
        if (trace) {
            log.trace((Object)"getTransactionBatchSize()");
        }
        return this.raProperties.getTransactionBatchSize();
    }

    public void setTransactionBatchSize(Integer transactionBatchSize) {
        if (trace) {
            log.trace((Object)("setTransactionBatchSize(" + transactionBatchSize + ")"));
        }
        this.raProperties.setTransactionBatchSize(transactionBatchSize);
    }

    public Integer getConsumerWindowSize() {
        if (trace) {
            log.trace((Object)"getConsumerWindowSize()");
        }
        return this.raProperties.getConsumerWindowSize();
    }

    public void setConsumerWindowSize(Integer consumerWindowSize) {
        if (trace) {
            log.trace((Object)("setConsumerWindowSize(" + consumerWindowSize + ")"));
        }
        this.raProperties.setConsumerWindowSize(consumerWindowSize);
    }

    public Integer getConsumerMaxRate() {
        if (trace) {
            log.trace((Object)"getConsumerMaxRate()");
        }
        return this.raProperties.getConsumerMaxRate();
    }

    public void setConsumerMaxRate(Integer consumerMaxRate) {
        if (trace) {
            log.trace((Object)("setConsumerMaxRate(" + consumerMaxRate + ")"));
        }
        this.raProperties.setConsumerMaxRate(consumerMaxRate);
    }

    public Integer getProducerWindowSize() {
        if (trace) {
            log.trace((Object)"getProducerWindowSize()");
        }
        return this.raProperties.getProducerWindowSize();
    }

    public void setProducerWindowSize(Integer producerWindowSize) {
        if (trace) {
            log.trace((Object)("setProducerWindowSize(" + producerWindowSize + ")"));
        }
        this.raProperties.setProducerWindowSize(producerWindowSize);
    }

    public Integer getProducerMaxRate() {
        if (trace) {
            log.trace((Object)"getProducerMaxRate()");
        }
        return this.raProperties.getProducerMaxRate();
    }

    public void setProducerMaxRate(Integer producerMaxRate) {
        if (trace) {
            log.trace((Object)("setProducerMaxRate(" + producerMaxRate + ")"));
        }
        this.raProperties.setProducerMaxRate(producerMaxRate);
    }

    public Integer getMinLargeMessageSize() {
        if (trace) {
            log.trace((Object)"getMinLargeMessageSize()");
        }
        return this.raProperties.getMinLargeMessageSize();
    }

    public void setMinLargeMessageSize(Integer minLargeMessageSize) {
        if (trace) {
            log.trace((Object)("setMinLargeMessageSize(" + minLargeMessageSize + ")"));
        }
        this.raProperties.setMinLargeMessageSize(minLargeMessageSize);
    }

    public Boolean getBlockOnAcknowledge() {
        if (trace) {
            log.trace((Object)"getBlockOnAcknowledge()");
        }
        return this.raProperties.isBlockOnAcknowledge();
    }

    public void setBlockOnAcknowledge(Boolean blockOnAcknowledge) {
        if (trace) {
            log.trace((Object)("setBlockOnAcknowledge(" + blockOnAcknowledge + ")"));
        }
        this.raProperties.setBlockOnAcknowledge(blockOnAcknowledge);
    }

    public Boolean getBlockOnNonPersistentSend() {
        if (trace) {
            log.trace((Object)"getBlockOnNonPersistentSend()");
        }
        return this.raProperties.isBlockOnNonPersistentSend();
    }

    public void setBlockOnNonPersistentSend(Boolean blockOnNonPersistentSend) {
        if (trace) {
            log.trace((Object)("setBlockOnNonPersistentSend(" + blockOnNonPersistentSend + ")"));
        }
        this.raProperties.setBlockOnNonPersistentSend(blockOnNonPersistentSend);
    }

    public Boolean getBlockOnPersistentSend() {
        if (trace) {
            log.trace((Object)"getBlockOnPersistentSend()");
        }
        return this.raProperties.isBlockOnPersistentSend();
    }

    public void setBlockOnPersistentSend(Boolean blockOnPersistentSend) {
        if (trace) {
            log.trace((Object)("setBlockOnPersistentSend(" + blockOnPersistentSend + ")"));
        }
        this.raProperties.setBlockOnPersistentSend(blockOnPersistentSend);
    }

    public Boolean getAutoGroup() {
        if (trace) {
            log.trace((Object)"getAutoGroup()");
        }
        return this.raProperties.isAutoGroup();
    }

    public void setAutoGroup(Boolean autoGroup) {
        if (trace) {
            log.trace((Object)("setAutoGroup(" + autoGroup + ")"));
        }
        this.raProperties.setAutoGroup(autoGroup);
    }

    public Integer getMaxConnections() {
        if (trace) {
            log.trace((Object)"getMaxConnections()");
        }
        return this.raProperties.getMaxConnections();
    }

    public void setMaxConnections(Integer maxConnections) {
        if (trace) {
            log.trace((Object)("setMaxConnections(" + maxConnections + ")"));
        }
        this.raProperties.setMaxConnections(maxConnections);
    }

    public Boolean getPreAcknowledge() {
        if (trace) {
            log.trace((Object)"getPreAcknowledge()");
        }
        return this.raProperties.isPreAcknowledge();
    }

    public void setPreAcknowledge(Boolean preAcknowledge) {
        if (trace) {
            log.trace((Object)("setPreAcknowledge(" + preAcknowledge + ")"));
        }
        this.raProperties.setPreAcknowledge(preAcknowledge);
    }

    public Long getRetryInterval() {
        if (trace) {
            log.trace((Object)"getRetryInterval()");
        }
        return this.raProperties.getRetryInterval();
    }

    public void setRetryInterval(Long retryInterval) {
        if (trace) {
            log.trace((Object)("setRetryInterval(" + retryInterval + ")"));
        }
        this.raProperties.setRetryInterval(retryInterval);
    }

    public Double getRetryIntervalMultiplier() {
        if (trace) {
            log.trace((Object)"getRetryIntervalMultiplier()");
        }
        return this.raProperties.getRetryIntervalMultiplier();
    }

    public void setRetryIntervalMultiplier(Double retryIntervalMultiplier) {
        if (trace) {
            log.trace((Object)("setRetryIntervalMultiplier(" + retryIntervalMultiplier + ")"));
        }
        this.raProperties.setRetryIntervalMultiplier(retryIntervalMultiplier);
    }

    public Integer getReconnectAttempts() {
        if (trace) {
            log.trace((Object)"getReconnectAttempts()");
        }
        return this.raProperties.getReconnectAttempts();
    }

    public void setReconnectAttempts(Integer reconnectAttempts) {
        if (trace) {
            log.trace((Object)("setReconnectAttempts(" + reconnectAttempts + ")"));
        }
        this.raProperties.setReconnectAttempts(reconnectAttempts);
    }

    public Boolean isFailoverOnServerShutdown() {
        if (trace) {
            log.trace((Object)"isFailoverOnServerShutdown()");
        }
        return this.raProperties.isFailoverOnServerShutdown();
    }

    public Boolean getFailoverOnServerShutdown() {
        return this.isFailoverOnServerShutdown();
    }

    public void setFailoverOnServerShutdown(Boolean failoverOnServerShutdown) {
        if (trace) {
            log.trace((Object)("setFailoverOnServerShutdown(" + failoverOnServerShutdown + ")"));
        }
        this.raProperties.setFailoverOnServerShutdown(failoverOnServerShutdown);
    }

    public String getConnectionLoadBalancingPolicyClassName() {
        return this.raProperties.getConnectionLoadBalancingPolicyClassName();
    }

    public void setConnectionLoadBalancingPolicyClassName(String connectionLoadBalancingPolicyClassName) {
        if (trace) {
            log.trace((Object)("setFailoverOnServerShutdown(" + connectionLoadBalancingPolicyClassName + ")"));
        }
        this.raProperties.setConnectionLoadBalancingPolicyClassName(connectionLoadBalancingPolicyClassName);
    }

    public Integer getScheduledThreadPoolMaxSize() {
        return this.raProperties.getScheduledThreadPoolMaxSize();
    }

    public void setScheduledThreadPoolMaxSize(Integer scheduledThreadPoolMaxSize) {
        if (trace) {
            log.trace((Object)("setFailoverOnServerShutdown(" + scheduledThreadPoolMaxSize + ")"));
        }
        this.raProperties.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
    }

    public Integer getThreadPoolMaxSize() {
        return this.raProperties.getThreadPoolMaxSize();
    }

    public void setThreadPoolMaxSize(Integer threadPoolMaxSize) {
        if (trace) {
            log.trace((Object)("setFailoverOnServerShutdown(" + threadPoolMaxSize + ")"));
        }
        this.raProperties.setThreadPoolMaxSize(threadPoolMaxSize);
    }

    public Boolean getUseGlobalPools() {
        return this.raProperties.isUseGlobalPools();
    }

    public void setUseGlobalPools(Boolean useGlobalPools) {
        if (trace) {
            log.trace((Object)("setFailoverOnServerShutdown(" + useGlobalPools + ")"));
        }
        this.raProperties.setUseGlobalPools(useGlobalPools);
    }

    public String getUserName() {
        if (trace) {
            log.trace((Object)"getUserName()");
        }
        return this.raProperties.getUserName();
    }

    public void setUserName(String userName) {
        if (trace) {
            log.trace((Object)("setUserName(" + userName + ")"));
        }
        this.raProperties.setUserName(userName);
    }

    public String getPassword() {
        if (trace) {
            log.trace((Object)"getPassword()");
        }
        return this.raProperties.getPassword();
    }

    public void setPassword(String password) {
        if (trace) {
            log.trace((Object)"setPassword(****)");
        }
        this.raProperties.setPassword(password);
    }

    public String getClientID() {
        if (trace) {
            log.trace((Object)"getClientID()");
        }
        return this.raProperties.getClientID();
    }

    public void setClientID(String clientID) {
        if (trace) {
            log.trace((Object)("setClientID(" + clientID + ")"));
        }
        this.raProperties.setClientID(clientID);
    }

    public Boolean getUseLocalTx() {
        if (trace) {
            log.trace((Object)"getUseLocalTx()");
        }
        return this.raProperties.getUseLocalTx();
    }

    public void setUseLocalTx(Boolean localTx) {
        if (trace) {
            log.trace((Object)("setUseXA(" + localTx + ")"));
        }
        this.raProperties.setUseLocalTx(localTx);
    }

    public Boolean getUseXA() {
        if (trace) {
            log.trace((Object)"getUseXA()");
        }
        return this.raProperties.getUseXA();
    }

    public void setUseXA(Boolean xa) {
        if (trace) {
            log.trace((Object)("setUseXA(" + xa + ")"));
        }
        this.raProperties.setUseXA(xa);
    }

    public boolean equals(Object obj) {
        if (trace) {
            log.trace((Object)("equals(" + obj + ")"));
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof HornetQResourceAdapter) {
            return this.raProperties.equals(((HornetQResourceAdapter)obj).getProperties());
        }
        return false;
    }

    public int hashCode() {
        if (trace) {
            log.trace((Object)"hashCode()");
        }
        return this.raProperties.hashCode();
    }

    public WorkManager getWorkManager() {
        if (trace) {
            log.trace((Object)"getWorkManager()");
        }
        if (this.ctx == null) {
            return null;
        }
        return this.ctx.getWorkManager();
    }

    public ClientSession createSession(ClientSessionFactory parameterFactory, int ackMode, String user, String pass, Boolean preAck, Integer dupsOkBatchSize, Integer transactionBatchSize, boolean deliveryTransacted, boolean useLocalTx) throws Exception {
        ClientSession result;
        if (deliveryTransacted || useLocalTx) {
            int actTxBatchSize;
            int n = actTxBatchSize = transactionBatchSize != null ? transactionBatchSize : 0x100000;
            result = useLocalTx ? parameterFactory.createSession(user, pass, false, false, false, false, actTxBatchSize) : parameterFactory.createSession(user, pass, true, false, false, false, actTxBatchSize);
        } else if (preAck != null && preAck.booleanValue()) {
            result = parameterFactory.createSession(user, pass, false, true, true, true, -1);
        } else {
            switch (ackMode) {
                case 1: {
                    result = parameterFactory.createSession(user, pass, false, true, true, false, 0);
                    break;
                }
                case 3: {
                    int actDupsOkBatchSize = dupsOkBatchSize != null ? dupsOkBatchSize : 0x100000;
                    result = parameterFactory.createSession(user, pass, false, true, true, false, actDupsOkBatchSize);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid ackmode: " + ackMode);
                }
            }
        }
        log.debug((Object)("Using queue connection " + result));
        return result;
    }

    protected HornetQRAProperties getProperties() {
        if (trace) {
            log.trace((Object)"getProperties()");
        }
        return this.raProperties;
    }

    protected void setup() throws HornetQException {
        this.defaultHornetQConnectionFactory = this.createHornetQConnectionFactory(this.raProperties);
        this.sessionFactory = this.defaultHornetQConnectionFactory.getCoreFactory();
    }

    public HornetQConnectionFactory getDefaultHornetQConnectionFactory() throws ResourceException {
        if (!this.configured.getAndSet(true)) {
            try {
                this.setup();
            }
            catch (HornetQException e) {
                throw new ResourceException("Unable to create activation", (Throwable)e);
            }
        }
        return this.defaultHornetQConnectionFactory;
    }

    public HornetQConnectionFactory createHornetQConnectionFactory(ConnectionFactoryProperties overrideProperties) {
        HornetQConnectionFactory cf;
        String discoveryAddress;
        String connectorClassName = overrideProperties.getConnectorClassName() != null ? overrideProperties.getConnectorClassName() : this.getConnectorClassName();
        String string = discoveryAddress = overrideProperties.getDiscoveryAddress() != null ? overrideProperties.getDiscoveryAddress() : this.getDiscoveryAddress();
        if (connectorClassName != null) {
            Map<String, Object> connectionParams = overrideProperties.getParsedConnectionParameters() != null ? overrideProperties.getParsedConnectionParameters() : this.getConnectionParameters();
            TransportConfiguration transportConf = new TransportConfiguration(connectorClassName, connectionParams);
            String backUpCOnnectorClassname = overrideProperties.getBackupConnectorClassName() != null ? overrideProperties.getBackupConnectorClassName() : this.getBackupConnectorClassName();
            Map<String, Object> backupConnectionParams = overrideProperties.getParsedBackupConnectionParameters() != null ? overrideProperties.getParsedBackupConnectionParameters() : this.getBackupConnectionParameters();
            TransportConfiguration backup = backUpCOnnectorClassname == null ? null : new TransportConfiguration(backUpCOnnectorClassname, backupConnectionParams);
            cf = new HornetQConnectionFactory(transportConf, backup);
        } else if (discoveryAddress != null) {
            Integer discoveryPort = overrideProperties.getDiscoveryPort() != null ? overrideProperties.getDiscoveryPort() : this.getDiscoveryPort();
            cf = new HornetQConnectionFactory(discoveryAddress, discoveryPort.intValue());
        } else {
            throw new IllegalArgumentException("must provide either TransportType or DiscoveryGroupAddress and DiscoveryGroupPort for HornetQ ResourceAdapter Connection Factory");
        }
        this.setParams(cf, overrideProperties);
        return cf;
    }

    private void setParams(HornetQConnectionFactory cf, ConnectionFactoryProperties overrideProperties) {
        String val5;
        Double val4;
        Long val3;
        Integer val2;
        Boolean val;
        Boolean bl = val = overrideProperties.isAutoGroup() != null ? overrideProperties.isAutoGroup() : this.raProperties.isAutoGroup();
        if (val != null) {
            cf.setAutoGroup(val.booleanValue());
        }
        Boolean bl2 = val = overrideProperties.isBlockOnAcknowledge() != null ? overrideProperties.isBlockOnAcknowledge() : this.raProperties.isBlockOnAcknowledge();
        if (val != null) {
            cf.setBlockOnAcknowledge(val.booleanValue());
        }
        Boolean bl3 = val = overrideProperties.isBlockOnNonPersistentSend() != null ? overrideProperties.isBlockOnNonPersistentSend() : this.raProperties.isBlockOnNonPersistentSend();
        if (val != null) {
            cf.setBlockOnNonPersistentSend(val.booleanValue());
        }
        Boolean bl4 = val = overrideProperties.isBlockOnPersistentSend() != null ? overrideProperties.isBlockOnPersistentSend() : this.raProperties.isBlockOnPersistentSend();
        if (val != null) {
            cf.setBlockOnPersistentSend(val.booleanValue());
        }
        Boolean bl5 = val = overrideProperties.isFailoverOnServerShutdown() != null ? overrideProperties.isFailoverOnServerShutdown() : this.raProperties.isFailoverOnServerShutdown();
        if (val != null) {
            cf.setFailoverOnServerShutdown(val.booleanValue());
        }
        Boolean bl6 = val = overrideProperties.isPreAcknowledge() != null ? overrideProperties.isPreAcknowledge() : this.raProperties.isPreAcknowledge();
        if (val != null) {
            cf.setPreAcknowledge(val.booleanValue());
        }
        Boolean bl7 = val = overrideProperties.isUseGlobalPools() != null ? overrideProperties.isUseGlobalPools() : this.raProperties.isUseGlobalPools();
        if (val != null) {
            cf.setUseGlobalPools(val.booleanValue());
        }
        Integer n = val2 = overrideProperties.getConsumerMaxRate() != null ? overrideProperties.getConsumerMaxRate() : this.raProperties.getConsumerMaxRate();
        if (val2 != null) {
            cf.setConsumerMaxRate(val2.intValue());
        }
        Integer n2 = val2 = overrideProperties.getConsumerWindowSize() != null ? overrideProperties.getConsumerWindowSize() : this.raProperties.getConsumerWindowSize();
        if (val2 != null) {
            cf.setConsumerWindowSize(val2.intValue());
        }
        Integer n3 = val2 = overrideProperties.getDupsOKBatchSize() != null ? overrideProperties.getDupsOKBatchSize() : this.raProperties.getDupsOKBatchSize();
        if (val2 != null) {
            cf.setDupsOKBatchSize(val2.intValue());
        }
        Integer n4 = val2 = overrideProperties.getMaxConnections() != null ? overrideProperties.getMaxConnections() : this.raProperties.getMaxConnections();
        if (val2 != null) {
            cf.setMaxConnections(val2.intValue());
        }
        Integer n5 = val2 = overrideProperties.getMinLargeMessageSize() != null ? overrideProperties.getMinLargeMessageSize() : this.raProperties.getMinLargeMessageSize();
        if (val2 != null) {
            cf.setMinLargeMessageSize(val2.intValue());
        }
        Integer n6 = val2 = overrideProperties.getProducerMaxRate() != null ? overrideProperties.getProducerMaxRate() : this.raProperties.getProducerMaxRate();
        if (val2 != null) {
            cf.setProducerMaxRate(val2.intValue());
        }
        Integer n7 = val2 = overrideProperties.getProducerWindowSize() != null ? overrideProperties.getProducerWindowSize() : this.raProperties.getProducerWindowSize();
        if (val2 != null) {
            cf.setProducerWindowSize(val2.intValue());
        }
        Integer n8 = val2 = overrideProperties.getReconnectAttempts() != null ? overrideProperties.getReconnectAttempts() : this.raProperties.getReconnectAttempts();
        if (val2 != null) {
            cf.setReconnectAttempts(val2.intValue());
        }
        Integer n9 = val2 = overrideProperties.getThreadPoolMaxSize() != null ? overrideProperties.getThreadPoolMaxSize() : this.raProperties.getThreadPoolMaxSize();
        if (val2 != null) {
            cf.setThreadPoolMaxSize(val2.intValue());
        }
        Integer n10 = val2 = overrideProperties.getScheduledThreadPoolMaxSize() != null ? overrideProperties.getScheduledThreadPoolMaxSize() : this.raProperties.getScheduledThreadPoolMaxSize();
        if (val2 != null) {
            cf.setScheduledThreadPoolMaxSize(val2.intValue());
        }
        Integer n11 = val2 = overrideProperties.getTransactionBatchSize() != null ? overrideProperties.getTransactionBatchSize() : this.raProperties.getTransactionBatchSize();
        if (val2 != null) {
            cf.setTransactionBatchSize(val2.intValue());
        }
        Long l = val3 = overrideProperties.getClientFailureCheckPeriod() != null ? overrideProperties.getClientFailureCheckPeriod() : this.raProperties.getClientFailureCheckPeriod();
        if (val3 != null) {
            cf.setClientFailureCheckPeriod(val3.longValue());
        }
        Long l2 = val3 = overrideProperties.getCallTimeout() != null ? overrideProperties.getCallTimeout() : this.raProperties.getCallTimeout();
        if (val3 != null) {
            cf.setCallTimeout(val3.longValue());
        }
        Long l3 = val3 = overrideProperties.getConnectionTTL() != null ? overrideProperties.getConnectionTTL() : this.raProperties.getConnectionTTL();
        if (val3 != null) {
            cf.setConnectionTTL(val3.longValue());
        }
        Long l4 = val3 = overrideProperties.getDiscoveryInitialWaitTimeout() != null ? overrideProperties.getDiscoveryInitialWaitTimeout() : this.raProperties.getDiscoveryInitialWaitTimeout();
        if (val3 != null) {
            cf.setDiscoveryInitialWaitTimeout(val3.longValue());
        }
        Long l5 = val3 = overrideProperties.getDiscoveryRefreshTimeout() != null ? overrideProperties.getDiscoveryRefreshTimeout() : this.raProperties.getDiscoveryRefreshTimeout();
        if (val3 != null) {
            cf.setDiscoveryRefreshTimeout(val3.longValue());
        }
        Long l6 = val3 = overrideProperties.getRetryInterval() != null ? overrideProperties.getRetryInterval() : this.raProperties.getRetryInterval();
        if (val3 != null) {
            cf.setRetryInterval(val3.longValue());
        }
        Double d = val4 = overrideProperties.getRetryIntervalMultiplier() != null ? overrideProperties.getRetryIntervalMultiplier() : this.raProperties.getRetryIntervalMultiplier();
        if (val4 != null) {
            cf.setRetryIntervalMultiplier(val4.doubleValue());
        }
        String string = val5 = overrideProperties.getClientID() != null ? overrideProperties.getClientID() : this.raProperties.getClientID();
        if (val5 != null) {
            cf.setClientID(val5);
        }
        String string2 = val5 = overrideProperties.getConnectionLoadBalancingPolicyClassName() != null ? overrideProperties.getConnectionLoadBalancingPolicyClassName() : this.raProperties.getConnectionLoadBalancingPolicyClassName();
        if (val5 != null) {
            cf.setConnectionLoadBalancingPolicyClassName(val5);
        }
    }
}

