/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra.inflow;

import java.util.UUID;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.hornetq.core.client.ClientConsumer;
import org.hornetq.core.client.ClientMessage;
import org.hornetq.core.client.ClientSession;
import org.hornetq.core.client.MessageHandler;
import org.hornetq.core.exception.HornetQException;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.remoting.impl.wireformat.SessionQueueQueryResponseMessage;
import org.hornetq.jms.HornetQTopic;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.ra.inflow.HornetQActivation;
import org.hornetq.ra.inflow.HornetQActivationSpec;
import org.hornetq.utils.SimpleString;

public class HornetQMessageHandler
implements MessageHandler {
    private static final Logger log = Logger.getLogger(HornetQMessageHandler.class);
    private static boolean trace = log.isTraceEnabled();
    private final ClientSession session;
    private MessageEndpoint endpoint;
    private final HornetQActivation activation;
    private final DemarcationStrategyFactory strategyFactory = new DemarcationStrategyFactory();

    public HornetQMessageHandler(HornetQActivation activation, ClientSession session) {
        this.activation = activation;
        this.session = session;
    }

    public void setup() throws Exception {
        ClientConsumer consumer;
        HornetQActivationSpec spec;
        String selector;
        SimpleString selectorString;
        if (trace) {
            log.trace((Object)"setup()");
        }
        SimpleString simpleString = selectorString = (selector = (spec = this.activation.getActivationSpec()).getMessageSelector()) == null || selector.trim().equals("") ? null : new SimpleString(selector);
        if (this.activation.isTopic() && spec.isSubscriptionDurable()) {
            String subscriptionName = spec.getSubscriptionName();
            if (this.activation.getActivationSpec().getClientID() == null) {
                throw new InvalidClientIDException("Cannot create durable subscription - client ID has not been set");
            }
            SimpleString queueName = new SimpleString(HornetQTopic.createQueueNameForDurableSubscription((String)this.activation.getActivationSpec().getClientID(), (String)subscriptionName));
            SessionQueueQueryResponseMessage subResponse = this.session.queueQuery(queueName);
            if (!subResponse.isExists()) {
                this.session.createQueue(this.activation.getAddress(), queueName, selectorString, true);
            } else {
                boolean topicChanged;
                if (subResponse.getConsumerCount() > 0) {
                    throw new IllegalStateException("Cannot create a subscriber on the durable subscription since it already has subscriber(s)");
                }
                SimpleString oldFilterString = subResponse.getFilterString();
                boolean selectorChanged = selector == null && oldFilterString != null || oldFilterString == null && selector != null || oldFilterString != null && selector != null && !oldFilterString.equals((Object)selector);
                SimpleString oldTopicName = subResponse.getAddress();
                boolean bl = topicChanged = !oldTopicName.equals((Object)this.activation.getAddress());
                if (selectorChanged || topicChanged) {
                    this.session.deleteQueue(queueName);
                    this.session.createQueue(this.activation.getAddress(), queueName, selectorString, true);
                }
            }
            consumer = this.session.createConsumer(queueName, null, false);
        } else {
            SimpleString queueName;
            if (this.activation.isTopic()) {
                queueName = new SimpleString(UUID.randomUUID().toString());
                this.session.createQueue(this.activation.getAddress(), queueName, selectorString, false);
            } else {
                queueName = this.activation.getAddress();
            }
            consumer = this.session.createConsumer(queueName, selectorString);
        }
        MessageEndpointFactory endpointFactory = this.activation.getMessageEndpointFactory();
        this.endpoint = this.activation.isDeliveryTransacted() && this.activation.getActivationSpec().isUseLocalTx() == false ? endpointFactory.createEndpoint((XAResource)this.session) : endpointFactory.createEndpoint(null);
        consumer.setMessageHandler((MessageHandler)this);
    }

    public void teardown() {
        if (trace) {
            log.trace((Object)"teardown()");
        }
        try {
            if (this.endpoint != null) {
                this.endpoint.release();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error releasing endpoint " + this.endpoint), t);
        }
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error releasing session " + this.session), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ClientMessage message) {
        if (trace) {
            log.trace((Object)("onMessage(" + message + ")"));
        }
        TransactionDemarcationStrategy txnStrategy = this.strategyFactory.getStrategy();
        try {
            txnStrategy.start();
        }
        catch (Throwable throwable) {
            log.warn((Object)("Unable to create transaction: " + throwable.getMessage()));
            txnStrategy = new NoTXTransactionDemarcationStrategy();
        }
        HornetQMessage msg = HornetQMessage.createMessage((ClientMessage)message, (ClientSession)this.session);
        try {
            msg.doBeforeReceive();
            message.acknowledge();
        }
        catch (Exception e) {
            log.error((Object)"Failed to prepare message for receipt", (Throwable)e);
            return;
        }
        try {
            ((MessageListener)this.endpoint).onMessage((Message)msg);
        }
        catch (Throwable t) {
            log.error((Object)("Unexpected error delivering message " + message), t);
            txnStrategy.error();
        }
        finally {
            txnStrategy.end();
        }
    }

    private class NoTXTransactionDemarcationStrategy
    implements TransactionDemarcationStrategy {
        private NoTXTransactionDemarcationStrategy() {
        }

        public void start() throws Throwable {
        }

        public void error() {
        }

        public void end() {
        }
    }

    private class XATransactionDemarcationStrategy
    implements TransactionDemarcationStrategy {
        private final TransactionManager tm;
        private Transaction trans;

        private XATransactionDemarcationStrategy() {
            this.tm = HornetQMessageHandler.this.activation.getTransactionManager();
        }

        public void start() throws Throwable {
            int timeout = HornetQMessageHandler.this.activation.getActivationSpec().getTransactionTimeout();
            if (timeout > 0) {
                if (trace) {
                    log.trace((Object)("Setting transactionTimeout for JMSSessionPool to " + timeout));
                }
                this.tm.setTransactionTimeout(timeout);
            }
            this.tm.begin();
            try {
                this.trans = this.tm.getTransaction();
                if (trace) {
                    log.trace((Object)(this + " using tx=" + this.trans));
                }
                if (!this.trans.enlistResource((XAResource)HornetQMessageHandler.this.session)) {
                    throw new JMSException("could not enlist resource");
                }
                if (trace) {
                    log.trace((Object)(this + " XAResource '" + HornetQMessageHandler.this.session + " enlisted."));
                }
            }
            catch (Throwable t) {
                try {
                    this.tm.rollback();
                }
                catch (Throwable ignored) {
                    log.trace((Object)(this + " ignored error rolling back after failed enlist"), ignored);
                }
                throw t;
            }
        }

        public void error() {
            try {
                if (trace) {
                    log.trace((Object)(this + " using TM to mark TX for rollback tx=" + this.trans));
                }
                this.trans.setRollbackOnly();
            }
            catch (Throwable t) {
                log.error((Object)(this + " failed to set rollback only"), t);
            }
        }

        public void end() {
            try {
                Transaction currentTx = this.tm.getTransaction();
                if (!this.trans.equals(currentTx)) {
                    throw new java.lang.IllegalStateException("Wrong tx association: expected " + this.trans + " was " + currentTx);
                }
                if (this.trans.getStatus() == 1) {
                    if (trace) {
                        log.trace((Object)(this + " rolling back JMS transaction tx=" + this.trans));
                    }
                    this.tm.rollback();
                } else if (this.trans.getStatus() == 0) {
                    if (trace) {
                        log.trace((Object)(this + " commiting the JMS transaction tx=" + this.trans));
                    }
                    this.tm.commit();
                } else {
                    this.tm.suspend();
                }
            }
            catch (Throwable t) {
                log.error((Object)(this + " failed to commit/rollback"), t);
            }
        }
    }

    private class LocalDemarcationStrategy
    implements TransactionDemarcationStrategy {
        private boolean rolledBack = false;

        private LocalDemarcationStrategy() {
        }

        public void start() {
        }

        public void error() {
            if (trace) {
                log.trace((Object)"error()");
            }
            if (HornetQMessageHandler.this.session != null) {
                try {
                    HornetQMessageHandler.this.session.rollback();
                    this.rolledBack = true;
                }
                catch (HornetQException e) {
                    log.error((Object)"Failed to rollback session transaction", (Throwable)e);
                }
            }
        }

        public void end() {
            if (trace) {
                log.trace((Object)"end()");
            }
            if (!this.rolledBack && HornetQMessageHandler.this.session != null) {
                try {
                    HornetQMessageHandler.this.session.commit();
                }
                catch (HornetQException e) {
                    log.error((Object)"Failed to commit session transaction", (Throwable)e);
                }
            }
        }
    }

    private static interface TransactionDemarcationStrategy {
        public void start() throws Throwable;

        public void error();

        public void end();
    }

    private class DemarcationStrategyFactory {
        private DemarcationStrategyFactory() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        TransactionDemarcationStrategy getStrategy() {
            if (trace) {
                log.trace((Object)"getStrategy()");
            }
            if (HornetQMessageHandler.this.activation.isDeliveryTransacted()) {
                if (HornetQMessageHandler.this.activation.getActivationSpec().isUseLocalTx().booleanValue()) return new LocalDemarcationStrategy();
                try {
                    return new XATransactionDemarcationStrategy();
                }
                catch (Throwable t) {
                    log.error((Object)(this + " error creating transaction demarcation "), t);
                    return null;
                }
            } else {
                if (HornetQMessageHandler.this.activation.getActivationSpec().isUseLocalTx().booleanValue()) return new LocalDemarcationStrategy();
                return new NoTXTransactionDemarcationStrategy();
            }
        }
    }
}

