/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.ResourceAllocationException;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.SecurityException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.hornetq.core.logging.Logger;
import org.hornetq.ra.HornetQRAConnectionRequestInfo;
import org.hornetq.ra.HornetQRACredential;
import org.hornetq.ra.HornetQRALocalTransaction;
import org.hornetq.ra.HornetQRAManagedConnectionFactory;
import org.hornetq.ra.HornetQRAMetaData;
import org.hornetq.ra.HornetQRASession;
import org.hornetq.ra.HornetQRAXAResource;

public class HornetQRAManagedConnection
implements ManagedConnection,
ExceptionListener {
    private static final Logger log = Logger.getLogger(HornetQRAManagedConnection.class);
    private static boolean trace = log.isTraceEnabled();
    private final HornetQRAManagedConnectionFactory mcf;
    private final HornetQRAConnectionRequestInfo cri;
    private final String userName;
    private final String password;
    private final AtomicBoolean isDestroyed = new AtomicBoolean(false);
    private final List<ConnectionEventListener> eventListeners;
    private final Set<HornetQRASession> handles;
    private ReentrantLock lock = new ReentrantLock();
    private Connection connection;
    private Session session;
    private XASession xaSession;
    private XAResource xaResource;
    private boolean inManagedTx;

    public HornetQRAManagedConnection(HornetQRAManagedConnectionFactory mcf, HornetQRAConnectionRequestInfo cri, String userName, String password) throws ResourceException {
        if (trace) {
            log.trace((Object)("constructor(" + mcf + ", " + cri + ", " + userName + ", ****)"));
        }
        this.mcf = mcf;
        this.cri = cri;
        this.userName = userName;
        this.password = password;
        this.eventListeners = Collections.synchronizedList(new ArrayList());
        this.handles = Collections.synchronizedSet(new HashSet());
        this.connection = null;
        this.session = null;
        this.xaSession = null;
        this.xaResource = null;
        try {
            this.setup();
        }
        catch (Throwable t) {
            try {
                this.destroy();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            throw new ResourceException("Error during setup", t);
        }
    }

    public synchronized Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (trace) {
            log.trace((Object)("getConnection(" + subject + ", " + cxRequestInfo + ")"));
        }
        HornetQRACredential credential = HornetQRACredential.getCredential(this.mcf, subject, cxRequestInfo);
        if (this.userName != null && !this.userName.equals(credential.getUserName())) {
            throw new SecurityException("Password credentials not the same, reauthentication not allowed");
        }
        if (this.userName == null && credential.getUserName() != null) {
            throw new SecurityException("Password credentials not the same, reauthentication not allowed");
        }
        if (this.isDestroyed.get()) {
            throw new IllegalStateException("The managed connection is already destroyed");
        }
        HornetQRASession session = new HornetQRASession(this, (HornetQRAConnectionRequestInfo)cxRequestInfo);
        this.handles.add(session);
        return session;
    }

    private void destroyHandles() throws ResourceException {
        if (trace) {
            log.trace((Object)"destroyHandles()");
        }
        try {
            if (this.connection != null) {
                this.connection.stop();
            }
        }
        catch (Throwable t) {
            log.trace((Object)"Ignored error stopping connection", t);
        }
        for (HornetQRASession session : this.handles) {
            session.destroy();
        }
        this.handles.clear();
    }

    public void destroy() throws ResourceException {
        if (trace) {
            log.trace((Object)"destroy()");
        }
        if (this.isDestroyed.get() || this.connection == null) {
            return;
        }
        this.isDestroyed.set(true);
        try {
            this.connection.setExceptionListener(null);
        }
        catch (JMSException e) {
            log.debug((Object)("Error unsetting the exception listener " + this), (Throwable)e);
        }
        this.destroyHandles();
        try {
            try {
                if (this.session != null) {
                    this.session.close();
                }
                if (this.xaSession != null) {
                    this.xaSession.close();
                }
            }
            catch (JMSException e) {
                log.debug((Object)("Error closing session " + this), (Throwable)e);
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Throwable e) {
            throw new ResourceException("Could not properly close the session and connection", e);
        }
    }

    public void cleanup() throws ResourceException {
        if (trace) {
            log.trace((Object)"cleanup()");
        }
        if (this.isDestroyed.get()) {
            throw new IllegalStateException("ManagedConnection already destroyed");
        }
        this.destroyHandles();
        this.inManagedTx = false;
        this.lock = new ReentrantLock();
    }

    public void associateConnection(Object obj) throws ResourceException {
        if (trace) {
            log.trace((Object)("associateConnection(" + obj + ")"));
        }
        if (this.isDestroyed.get() || !(obj instanceof HornetQRASession)) {
            throw new IllegalStateException("ManagedConnection in an illegal state");
        }
        HornetQRASession h = (HornetQRASession)obj;
        h.setManagedConnection(this);
        this.handles.add(h);
    }

    protected void lock() {
        if (trace) {
            log.trace((Object)"lock()");
        }
        this.lock.lock();
    }

    protected void tryLock() throws JMSException {
        Integer tryLock;
        if (trace) {
            log.trace((Object)"tryLock()");
        }
        if ((tryLock = this.mcf.getUseTryLock()) == null || tryLock <= 0) {
            this.lock();
            return;
        }
        try {
            if (!this.lock.tryLock(tryLock.intValue(), TimeUnit.SECONDS)) {
                throw new ResourceAllocationException("Unable to obtain lock in " + tryLock + " seconds: " + this);
            }
        }
        catch (InterruptedException e) {
            throw new ResourceAllocationException("Interrupted attempting lock: " + this);
        }
    }

    protected void unlock() {
        if (trace) {
            log.trace((Object)"unlock()");
        }
        this.lock.unlock();
    }

    public void addConnectionEventListener(ConnectionEventListener l) {
        if (trace) {
            log.trace((Object)("addConnectionEventListener(" + l + ")"));
        }
        this.eventListeners.add(l);
    }

    public void removeConnectionEventListener(ConnectionEventListener l) {
        if (trace) {
            log.trace((Object)("removeConnectionEventListener(" + l + ")"));
        }
        this.eventListeners.remove(l);
    }

    public XAResource getXAResource() throws ResourceException {
        if (trace) {
            log.trace((Object)"getXAResource()");
        }
        if (this.xaResource == null) {
            this.xaResource = this.xaSession.getXAResource();
        }
        if (trace) {
            log.trace((Object)("XAResource=" + this.xaResource));
        }
        this.xaResource = new HornetQRAXAResource(this, this.xaResource);
        return this.xaResource;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        if (trace) {
            log.trace((Object)"getLocalTransaction()");
        }
        HornetQRALocalTransaction tx = new HornetQRALocalTransaction(this);
        if (trace) {
            log.trace((Object)("LocalTransaction=" + tx));
        }
        return tx;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        if (trace) {
            log.trace((Object)"getMetaData()");
        }
        if (this.isDestroyed.get()) {
            throw new IllegalStateException("The managed connection is already destroyed");
        }
        return new HornetQRAMetaData(this);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        if (trace) {
            log.trace((Object)("setLogWriter(" + out + ")"));
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        if (trace) {
            log.trace((Object)"getLogWriter()");
        }
        return null;
    }

    public void onException(JMSException exception) {
        if (trace) {
            log.trace((Object)("onException(" + (Object)((Object)exception) + ")"));
        }
        if (this.isDestroyed.get()) {
            if (trace) {
                log.trace((Object)("Ignoring error on already destroyed connection " + this), (Throwable)exception);
            }
            return;
        }
        log.warn((Object)("Handling JMS exception failure: " + this), (Throwable)exception);
        try {
            this.connection.setExceptionListener(null);
        }
        catch (JMSException e) {
            log.debug((Object)"Unable to unset exception listener", (Throwable)e);
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5, (Exception)((Object)exception));
        this.sendEvent(event);
    }

    protected Session getSession() throws JMSException {
        if (this.xaResource != null && this.inManagedTx) {
            if (trace) {
                log.trace((Object)("getSession() -> XA session " + this.xaSession.getSession()));
            }
            return this.xaSession.getSession();
        }
        if (trace) {
            log.trace((Object)("getSession() -> session " + this.xaSession.getSession()));
        }
        return this.session;
    }

    protected void sendEvent(ConnectionEvent event) {
        ConnectionEventListener[] list;
        if (trace) {
            log.trace((Object)("sendEvent(" + event + ")"));
        }
        int type = event.getId();
        block7: for (ConnectionEventListener l : list = this.eventListeners.toArray(new ConnectionEventListener[this.eventListeners.size()])) {
            switch (type) {
                case 1: {
                    l.connectionClosed(event);
                    continue block7;
                }
                case 2: {
                    l.localTransactionStarted(event);
                    continue block7;
                }
                case 3: {
                    l.localTransactionCommitted(event);
                    continue block7;
                }
                case 4: {
                    l.localTransactionRolledback(event);
                    continue block7;
                }
                case 5: {
                    l.connectionErrorOccurred(event);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Illegal eventType: " + type);
                }
            }
        }
    }

    protected void removeHandle(HornetQRASession handle) {
        if (trace) {
            log.trace((Object)("removeHandle(" + handle + ")"));
        }
        this.handles.remove(handle);
    }

    protected HornetQRAConnectionRequestInfo getCRI() {
        if (trace) {
            log.trace((Object)"getCRI()");
        }
        return this.cri;
    }

    protected HornetQRAManagedConnectionFactory getManagedConnectionFactory() {
        if (trace) {
            log.trace((Object)"getManagedConnectionFactory()");
        }
        return this.mcf;
    }

    void start() throws JMSException {
        if (trace) {
            log.trace((Object)"start()");
        }
        if (this.connection != null) {
            this.connection.start();
        }
    }

    void stop() throws JMSException {
        if (trace) {
            log.trace((Object)"stop()");
        }
        if (this.connection != null) {
            this.connection.stop();
        }
    }

    protected String getUserName() {
        if (trace) {
            log.trace((Object)"getUserName()");
        }
        return this.userName;
    }

    private void setup() throws ResourceException {
        if (trace) {
            log.trace((Object)"setup()");
        }
        try {
            boolean transacted = this.cri.isTransacted();
            int acknowledgeMode = 1;
            if (this.cri.getType() == 2) {
                this.connection = this.userName != null && this.password != null ? this.mcf.getHornetQConnectionFactory().createXATopicConnection(this.userName, this.password) : this.mcf.getHornetQConnectionFactory().createXATopicConnection();
                this.connection.setExceptionListener((ExceptionListener)this);
                this.xaSession = ((XATopicConnection)this.connection).createXATopicSession();
                this.session = ((TopicConnection)this.connection).createTopicSession(transacted, acknowledgeMode);
            } else if (this.cri.getType() == 1) {
                this.connection = this.userName != null && this.password != null ? this.mcf.getHornetQConnectionFactory().createXAQueueConnection(this.userName, this.password) : this.mcf.getHornetQConnectionFactory().createXAQueueConnection();
                this.connection.setExceptionListener((ExceptionListener)this);
                this.xaSession = ((XAQueueConnection)this.connection).createXAQueueSession();
                this.session = ((QueueConnection)this.connection).createQueueSession(transacted, acknowledgeMode);
            } else {
                this.connection = this.userName != null && this.password != null ? this.mcf.getHornetQConnectionFactory().createXAConnection(this.userName, this.password) : this.mcf.getHornetQConnectionFactory().createXAConnection();
                this.connection.setExceptionListener((ExceptionListener)this);
                this.xaSession = ((XAConnection)this.connection).createXASession();
                this.session = this.connection.createSession(transacted, acknowledgeMode);
            }
        }
        catch (JMSException je) {
            throw new ResourceException(je.getMessage(), (Throwable)je);
        }
    }

    protected void setInManagedTx(boolean inManagedTx) {
        this.inManagedTx = inManagedTx;
    }
}

