/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import java.io.Serializable;
import javax.jms.Queue;
import javax.jms.Topic;
import org.hornetq.ra.ConnectionFactoryProperties;
import org.hornetq.ra.HornetQRALogger;
import org.hornetq.ra.HornetQRaUtils;

public class HornetQRAMCFProperties
extends ConnectionFactoryProperties
implements Serializable {
    static final long serialVersionUID = -5951352236582886862L;
    private static boolean trace = HornetQRALogger.LOGGER.isTraceEnabled();
    private static final String QUEUE_TYPE = Queue.class.getName();
    private static final String TOPIC_TYPE = Topic.class.getName();
    private String strConnectorClassName;
    public String strConnectionParameters;
    private int type = 0;
    private Integer useTryLock;

    public HornetQRAMCFProperties() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("constructor()");
        }
        this.useTryLock = null;
    }

    public int getType() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getType()");
        }
        return this.type;
    }

    public String getConnectorClassName() {
        return this.strConnectorClassName;
    }

    public void setConnectorClassName(String connectorClassName) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setConnectorClassName(" + connectorClassName + ")");
        }
        this.strConnectorClassName = connectorClassName;
        this.setParsedConnectorClassNames(HornetQRaUtils.parseConnectorConnectorConfig(connectorClassName));
    }

    public String getStrConnectionParameters() {
        return this.strConnectionParameters;
    }

    public void setConnectionParameters(String configuration) {
        this.strConnectionParameters = configuration;
        this.setParsedConnectionParameters(HornetQRaUtils.parseConfig(configuration));
    }

    public void setSessionDefaultType(String defaultType) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setSessionDefaultType(" + this.type + ")");
        }
        this.type = defaultType.equals(QUEUE_TYPE) ? 1 : (defaultType.equals(TOPIC_TYPE) ? 2 : 0);
    }

    public String getSessionDefaultType() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getSessionDefaultType()");
        }
        if (this.type == 0) {
            return "BOTH";
        }
        if (this.type == 1) {
            return TOPIC_TYPE;
        }
        return QUEUE_TYPE;
    }

    public Integer getUseTryLock() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getUseTryLock()");
        }
        return this.useTryLock;
    }

    public void setUseTryLock(Integer useTryLock) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setUseTryLock(" + useTryLock + ")");
        }
        this.useTryLock = useTryLock;
    }
}

