/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.server.JournalType;
import org.hornetq.tests.util.RandomUtil;
import org.hornetq.tests.util.UnitTestCase;

public class ConfigurationImplTest
extends UnitTestCase {
    protected Configuration conf;

    public void testDefaults() {
        Assert.assertEquals((boolean)true, (boolean)this.conf.isSharedStore());
        Assert.assertEquals((int)5, (int)this.conf.getScheduledThreadPoolMaxSize());
        Assert.assertEquals((long)10000L, (long)this.conf.getSecurityInvalidationInterval());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isSecurityEnabled());
        Assert.assertEquals((String)"data/bindings", (String)this.conf.getBindingsDirectory());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isCreateBindingsDir());
        Assert.assertEquals((String)"data/journal", (String)this.conf.getJournalDirectory());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isCreateJournalDir());
        Assert.assertEquals((Object)ConfigurationImpl.DEFAULT_JOURNAL_TYPE, (Object)this.conf.getJournalType());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isJournalSyncTransactional());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isJournalSyncNonTransactional());
        Assert.assertEquals((int)0xA00000, (int)this.conf.getJournalFileSize());
        Assert.assertEquals((int)2, (int)this.conf.getJournalMinFiles());
        Assert.assertEquals((int)500, (int)this.conf.getJournalMaxIO_AIO());
        Assert.assertEquals((int)1, (int)this.conf.getJournalMaxIO_NIO());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isWildcardRoutingEnabled());
        Assert.assertEquals((long)300000L, (long)this.conf.getTransactionTimeout());
        Assert.assertEquals((long)30000L, (long)this.conf.getMessageExpiryScanPeriod());
        Assert.assertEquals((int)3, (int)this.conf.getMessageExpiryThreadPriority());
        Assert.assertEquals((long)1000L, (long)this.conf.getTransactionTimeoutScanPeriod());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.DEFAULT_MANAGEMENT_ADDRESS, (Object)this.conf.getManagementAddress());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.DEFAULT_MANAGEMENT_NOTIFICATION_ADDRESS, (Object)this.conf.getManagementNotificationAddress());
        Assert.assertEquals((String)"HORNETQ.CLUSTER.ADMIN.USER", (String)this.conf.getClusterUser());
        Assert.assertEquals((String)"CHANGE ME!!", (String)this.conf.getClusterPassword());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isPersistenceEnabled());
        Assert.assertEquals((boolean)false, (boolean)this.conf.isFileDeploymentEnabled());
        Assert.assertEquals((boolean)false, (boolean)this.conf.isPersistDeliveryCountBeforeDelivery());
        Assert.assertEquals((long)5000L, (long)this.conf.getFileDeployerScanPeriod());
        Assert.assertEquals((int)30, (int)this.conf.getThreadPoolMaxSize());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isJMXManagementEnabled());
        Assert.assertEquals((long)-1L, (long)this.conf.getConnectionTTLOverride());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isAsyncConnectionExecutionEnabled());
        Assert.assertEquals((String)"data/paging", (String)this.conf.getPagingDirectory());
        Assert.assertEquals((String)"data/largemessages", (String)this.conf.getLargeMessagesDirectory());
        Assert.assertEquals((int)30, (int)this.conf.getJournalCompactPercentage());
        Assert.assertEquals((int)500000, (int)this.conf.getJournalBufferTimeout_AIO());
        Assert.assertEquals((int)3333333, (int)this.conf.getJournalBufferTimeout_NIO());
        Assert.assertEquals((int)501760, (int)this.conf.getJournalBufferSize_AIO());
        Assert.assertEquals((int)501760, (int)this.conf.getJournalBufferSize_NIO());
        Assert.assertEquals((boolean)false, (boolean)this.conf.isLogJournalWriteRate());
        Assert.assertEquals((int)-1, (int)this.conf.getJournalPerfBlastPages());
        Assert.assertEquals((boolean)false, (boolean)this.conf.isMessageCounterEnabled());
        Assert.assertEquals((int)10, (int)this.conf.getMessageCounterMaxDayHistory());
        Assert.assertEquals((long)10000L, (long)this.conf.getMessageCounterSamplePeriod());
        Assert.assertEquals((int)20000, (int)this.conf.getIDCacheSize());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isPersistIDCache());
        Assert.assertEquals((long)-1L, (long)this.conf.getServerDumpInterval());
        Assert.assertEquals((int)25, (int)this.conf.getMemoryWarningThreshold());
        Assert.assertEquals((long)-1L, (long)this.conf.getMemoryMeasureInterval());
    }

    public void testSetGetAttributes() throws Exception {
        for (int j = 0; j < 100; ++j) {
            boolean b = RandomUtil.randomBoolean();
            this.conf.setBackup(b);
            Assert.assertEquals((boolean)b, (boolean)this.conf.isBackup());
            b = RandomUtil.randomBoolean();
            this.conf.setSharedStore(b);
            Assert.assertEquals((boolean)b, (boolean)this.conf.isSharedStore());
            int i = RandomUtil.randomInt();
            this.conf.setScheduledThreadPoolMaxSize(i);
            Assert.assertEquals((int)i, (int)this.conf.getScheduledThreadPoolMaxSize());
            long l = RandomUtil.randomLong();
            this.conf.setSecurityInvalidationInterval(l);
            Assert.assertEquals((long)l, (long)this.conf.getSecurityInvalidationInterval());
            b = RandomUtil.randomBoolean();
            this.conf.setSecurityEnabled(b);
            Assert.assertEquals((boolean)b, (boolean)this.conf.isSecurityEnabled());
            String s = RandomUtil.randomString();
            this.conf.setBindingsDirectory(s);
            Assert.assertEquals((String)s, (String)this.conf.getBindingsDirectory());
            b = RandomUtil.randomBoolean();
            this.conf.setCreateBindingsDir(b);
            Assert.assertEquals((boolean)b, (boolean)this.conf.isCreateBindingsDir());
            s = RandomUtil.randomString();
            this.conf.setJournalDirectory(s);
            Assert.assertEquals((String)s, (String)this.conf.getJournalDirectory());
            b = RandomUtil.randomBoolean();
            this.conf.setCreateJournalDir(b);
            Assert.assertEquals((boolean)b, (boolean)this.conf.isCreateJournalDir());
            i = RandomUtil.randomInt() % 2;
            JournalType journal = i == 0 ? JournalType.ASYNCIO : JournalType.NIO;
            this.conf.setJournalType(journal);
            Assert.assertEquals((Object)journal, (Object)this.conf.getJournalType());
            b = RandomUtil.randomBoolean();
            this.conf.setJournalSyncTransactional(b);
            Assert.assertEquals((boolean)b, (boolean)this.conf.isJournalSyncTransactional());
            b = RandomUtil.randomBoolean();
            this.conf.setJournalSyncNonTransactional(b);
            Assert.assertEquals((boolean)b, (boolean)this.conf.isJournalSyncNonTransactional());
            i = RandomUtil.randomInt();
            this.conf.setJournalFileSize(i);
            Assert.assertEquals((int)i, (int)this.conf.getJournalFileSize());
            i = RandomUtil.randomInt();
            this.conf.setJournalMinFiles(i);
            Assert.assertEquals((int)i, (int)this.conf.getJournalMinFiles());
            i = RandomUtil.randomInt();
            this.conf.setJournalMaxIO_AIO(i);
            Assert.assertEquals((int)i, (int)this.conf.getJournalMaxIO_AIO());
            i = RandomUtil.randomInt();
            this.conf.setJournalMaxIO_NIO(i);
            Assert.assertEquals((int)i, (int)this.conf.getJournalMaxIO_NIO());
            s = RandomUtil.randomString();
            this.conf.setManagementAddress(new SimpleString(s));
            Assert.assertEquals((String)s, (String)this.conf.getManagementAddress().toString());
            i = RandomUtil.randomInt();
            this.conf.setMessageExpiryThreadPriority(i);
            Assert.assertEquals((int)i, (int)this.conf.getMessageExpiryThreadPriority());
            l = RandomUtil.randomLong();
            this.conf.setMessageExpiryScanPeriod(l);
            Assert.assertEquals((long)l, (long)this.conf.getMessageExpiryScanPeriod());
            b = RandomUtil.randomBoolean();
            this.conf.setPersistDeliveryCountBeforeDelivery(b);
            Assert.assertEquals((boolean)b, (boolean)this.conf.isPersistDeliveryCountBeforeDelivery());
            b = RandomUtil.randomBoolean();
            this.conf.setEnabledAsyncConnectionExecution(b);
            Assert.assertEquals((boolean)b, (boolean)this.conf.isAsyncConnectionExecutionEnabled());
            b = RandomUtil.randomBoolean();
            this.conf.setFileDeploymentEnabled(b);
            Assert.assertEquals((boolean)b, (boolean)this.conf.isFileDeploymentEnabled());
            b = RandomUtil.randomBoolean();
            this.conf.setPersistenceEnabled(b);
            Assert.assertEquals((boolean)b, (boolean)this.conf.isPersistenceEnabled());
            b = RandomUtil.randomBoolean();
            this.conf.setJMXManagementEnabled(b);
            Assert.assertEquals((boolean)b, (boolean)this.conf.isJMXManagementEnabled());
            l = RandomUtil.randomLong();
            this.conf.setFileDeployerScanPeriod(l);
            Assert.assertEquals((long)l, (long)this.conf.getFileDeployerScanPeriod());
            l = RandomUtil.randomLong();
            this.conf.setConnectionTTLOverride(l);
            Assert.assertEquals((long)l, (long)this.conf.getConnectionTTLOverride());
            i = RandomUtil.randomInt();
            this.conf.setThreadPoolMaxSize(i);
            Assert.assertEquals((int)i, (int)this.conf.getThreadPoolMaxSize());
            SimpleString ss = RandomUtil.randomSimpleString();
            this.conf.setManagementNotificationAddress(ss);
            Assert.assertEquals((Object)ss, (Object)this.conf.getManagementNotificationAddress());
            s = RandomUtil.randomString();
            this.conf.setClusterUser(s);
            Assert.assertEquals((String)s, (String)this.conf.getClusterUser());
            i = RandomUtil.randomInt();
            this.conf.setIDCacheSize(i);
            Assert.assertEquals((int)i, (int)this.conf.getIDCacheSize());
            b = RandomUtil.randomBoolean();
            this.conf.setPersistIDCache(b);
            Assert.assertEquals((boolean)b, (boolean)this.conf.isPersistIDCache());
            i = RandomUtil.randomInt();
            this.conf.setJournalCompactMinFiles(i);
            Assert.assertEquals((int)i, (int)this.conf.getJournalCompactMinFiles());
            i = RandomUtil.randomInt();
            this.conf.setJournalCompactPercentage(i);
            Assert.assertEquals((int)i, (int)this.conf.getJournalCompactPercentage());
            i = RandomUtil.randomInt();
            this.conf.setJournalBufferSize_AIO(i);
            Assert.assertEquals((int)i, (int)this.conf.getJournalBufferSize_AIO());
            i = RandomUtil.randomInt();
            this.conf.setJournalBufferTimeout_AIO(i);
            Assert.assertEquals((int)i, (int)this.conf.getJournalBufferTimeout_AIO());
            i = RandomUtil.randomInt();
            this.conf.setJournalBufferSize_NIO(i);
            Assert.assertEquals((int)i, (int)this.conf.getJournalBufferSize_NIO());
            i = RandomUtil.randomInt();
            this.conf.setJournalBufferTimeout_NIO(i);
            Assert.assertEquals((int)i, (int)this.conf.getJournalBufferTimeout_NIO());
            b = RandomUtil.randomBoolean();
            this.conf.setLogJournalWriteRate(b);
            Assert.assertEquals((boolean)b, (boolean)this.conf.isLogJournalWriteRate());
            i = RandomUtil.randomInt();
            this.conf.setJournalPerfBlastPages(i);
            Assert.assertEquals((int)i, (int)this.conf.getJournalPerfBlastPages());
            l = RandomUtil.randomLong();
            this.conf.setServerDumpInterval(l);
            Assert.assertEquals((long)l, (long)this.conf.getServerDumpInterval());
            s = RandomUtil.randomString();
            this.conf.setPagingDirectory(s);
            Assert.assertEquals((String)s, (String)this.conf.getPagingDirectory());
            s = RandomUtil.randomString();
            this.conf.setLargeMessagesDirectory(s);
            Assert.assertEquals((String)s, (String)this.conf.getLargeMessagesDirectory());
            b = RandomUtil.randomBoolean();
            this.conf.setWildcardRoutingEnabled(b);
            Assert.assertEquals((boolean)b, (boolean)this.conf.isWildcardRoutingEnabled());
            l = RandomUtil.randomLong();
            this.conf.setTransactionTimeout(l);
            Assert.assertEquals((long)l, (long)this.conf.getTransactionTimeout());
            b = RandomUtil.randomBoolean();
            this.conf.setMessageCounterEnabled(b);
            Assert.assertEquals((boolean)b, (boolean)this.conf.isMessageCounterEnabled());
            l = RandomUtil.randomPositiveLong();
            this.conf.setMessageCounterSamplePeriod(l);
            Assert.assertEquals((long)l, (long)this.conf.getMessageCounterSamplePeriod());
            i = RandomUtil.randomInt();
            this.conf.setMessageCounterMaxDayHistory(i);
            Assert.assertEquals((int)i, (int)this.conf.getMessageCounterMaxDayHistory());
            l = RandomUtil.randomLong();
            this.conf.setTransactionTimeoutScanPeriod(l);
            Assert.assertEquals((long)l, (long)this.conf.getTransactionTimeoutScanPeriod());
            s = RandomUtil.randomString();
            this.conf.setClusterPassword(s);
            Assert.assertEquals((String)s, (String)this.conf.getClusterPassword());
        }
    }

    public void testGetSetInterceptors() {
        String name1 = "uqwyuqywuy";
        String name2 = "yugyugyguyg";
        this.conf.getIncomingInterceptorClassNames().add("uqwyuqywuy");
        this.conf.getIncomingInterceptorClassNames().add("yugyugyguyg");
        Assert.assertTrue((boolean)this.conf.getIncomingInterceptorClassNames().contains("uqwyuqywuy"));
        Assert.assertTrue((boolean)this.conf.getIncomingInterceptorClassNames().contains("yugyugyguyg"));
        Assert.assertFalse((boolean)this.conf.getIncomingInterceptorClassNames().contains("iijij"));
    }

    public void testSerialize() throws Exception {
        boolean b = RandomUtil.randomBoolean();
        this.conf.setBackup(b);
        Assert.assertEquals((boolean)b, (boolean)this.conf.isBackup());
        b = RandomUtil.randomBoolean();
        this.conf.setSharedStore(b);
        int i = RandomUtil.randomInt();
        this.conf.setScheduledThreadPoolMaxSize(i);
        Assert.assertEquals((int)i, (int)this.conf.getScheduledThreadPoolMaxSize());
        long l = RandomUtil.randomLong();
        this.conf.setSecurityInvalidationInterval(l);
        Assert.assertEquals((long)l, (long)this.conf.getSecurityInvalidationInterval());
        b = RandomUtil.randomBoolean();
        this.conf.setSecurityEnabled(b);
        Assert.assertEquals((boolean)b, (boolean)this.conf.isSecurityEnabled());
        String s = RandomUtil.randomString();
        this.conf.setBindingsDirectory(s);
        Assert.assertEquals((String)s, (String)this.conf.getBindingsDirectory());
        b = RandomUtil.randomBoolean();
        this.conf.setCreateBindingsDir(b);
        Assert.assertEquals((boolean)b, (boolean)this.conf.isCreateBindingsDir());
        s = RandomUtil.randomString();
        this.conf.setJournalDirectory(s);
        Assert.assertEquals((String)s, (String)this.conf.getJournalDirectory());
        b = RandomUtil.randomBoolean();
        this.conf.setCreateJournalDir(b);
        Assert.assertEquals((boolean)b, (boolean)this.conf.isCreateJournalDir());
        i = RandomUtil.randomInt() % 2;
        JournalType journal = i == 0 ? JournalType.ASYNCIO : JournalType.NIO;
        this.conf.setJournalType(journal);
        Assert.assertEquals((Object)journal, (Object)this.conf.getJournalType());
        b = RandomUtil.randomBoolean();
        this.conf.setJournalSyncTransactional(b);
        Assert.assertEquals((boolean)b, (boolean)this.conf.isJournalSyncTransactional());
        b = RandomUtil.randomBoolean();
        this.conf.setJournalSyncNonTransactional(b);
        Assert.assertEquals((boolean)b, (boolean)this.conf.isJournalSyncNonTransactional());
        i = RandomUtil.randomInt();
        this.conf.setJournalFileSize(i);
        Assert.assertEquals((int)i, (int)this.conf.getJournalFileSize());
        i = RandomUtil.randomInt();
        this.conf.setJournalMinFiles(i);
        Assert.assertEquals((int)i, (int)this.conf.getJournalMinFiles());
        i = RandomUtil.randomInt();
        this.conf.setJournalMaxIO_AIO(i);
        Assert.assertEquals((int)i, (int)this.conf.getJournalMaxIO_AIO());
        i = RandomUtil.randomInt();
        this.conf.setJournalMaxIO_NIO(i);
        Assert.assertEquals((int)i, (int)this.conf.getJournalMaxIO_NIO());
        s = RandomUtil.randomString();
        this.conf.setManagementAddress(new SimpleString(s));
        Assert.assertEquals((String)s, (String)this.conf.getManagementAddress().toString());
        i = RandomUtil.randomInt();
        this.conf.setMessageExpiryThreadPriority(i);
        Assert.assertEquals((int)i, (int)this.conf.getMessageExpiryThreadPriority());
        l = RandomUtil.randomLong();
        this.conf.setMessageExpiryScanPeriod(l);
        Assert.assertEquals((long)l, (long)this.conf.getMessageExpiryScanPeriod());
        b = RandomUtil.randomBoolean();
        this.conf.setPersistDeliveryCountBeforeDelivery(b);
        Assert.assertEquals((boolean)b, (boolean)this.conf.isPersistDeliveryCountBeforeDelivery());
        b = RandomUtil.randomBoolean();
        this.conf.setEnabledAsyncConnectionExecution(b);
        Assert.assertEquals((boolean)b, (boolean)this.conf.isAsyncConnectionExecutionEnabled());
        b = RandomUtil.randomBoolean();
        this.conf.setFileDeploymentEnabled(b);
        Assert.assertEquals((boolean)b, (boolean)this.conf.isFileDeploymentEnabled());
        b = RandomUtil.randomBoolean();
        this.conf.setPersistenceEnabled(b);
        Assert.assertEquals((boolean)b, (boolean)this.conf.isPersistenceEnabled());
        b = RandomUtil.randomBoolean();
        this.conf.setJMXManagementEnabled(b);
        Assert.assertEquals((boolean)b, (boolean)this.conf.isJMXManagementEnabled());
        l = RandomUtil.randomLong();
        this.conf.setFileDeployerScanPeriod(l);
        Assert.assertEquals((long)l, (long)this.conf.getFileDeployerScanPeriod());
        l = RandomUtil.randomLong();
        this.conf.setConnectionTTLOverride(l);
        Assert.assertEquals((long)l, (long)this.conf.getConnectionTTLOverride());
        i = RandomUtil.randomInt();
        this.conf.setThreadPoolMaxSize(i);
        Assert.assertEquals((int)i, (int)this.conf.getThreadPoolMaxSize());
        SimpleString ss = RandomUtil.randomSimpleString();
        this.conf.setManagementNotificationAddress(ss);
        Assert.assertEquals((Object)ss, (Object)this.conf.getManagementNotificationAddress());
        s = RandomUtil.randomString();
        this.conf.setClusterUser(s);
        Assert.assertEquals((String)s, (String)this.conf.getClusterUser());
        i = RandomUtil.randomInt();
        this.conf.setIDCacheSize(i);
        Assert.assertEquals((int)i, (int)this.conf.getIDCacheSize());
        b = RandomUtil.randomBoolean();
        this.conf.setPersistIDCache(b);
        Assert.assertEquals((boolean)b, (boolean)this.conf.isPersistIDCache());
        i = RandomUtil.randomInt();
        this.conf.setJournalCompactMinFiles(i);
        Assert.assertEquals((int)i, (int)this.conf.getJournalCompactMinFiles());
        i = RandomUtil.randomInt();
        this.conf.setJournalCompactPercentage(i);
        Assert.assertEquals((int)i, (int)this.conf.getJournalCompactPercentage());
        i = RandomUtil.randomInt();
        this.conf.setJournalBufferSize_AIO(i);
        Assert.assertEquals((int)i, (int)this.conf.getJournalBufferSize_AIO());
        i = RandomUtil.randomInt();
        this.conf.setJournalBufferTimeout_AIO(i);
        Assert.assertEquals((int)i, (int)this.conf.getJournalBufferTimeout_AIO());
        i = RandomUtil.randomInt();
        this.conf.setJournalBufferSize_NIO(i);
        Assert.assertEquals((int)i, (int)this.conf.getJournalBufferSize_NIO());
        i = RandomUtil.randomInt();
        this.conf.setJournalBufferTimeout_NIO(i);
        Assert.assertEquals((int)i, (int)this.conf.getJournalBufferTimeout_NIO());
        b = RandomUtil.randomBoolean();
        this.conf.setLogJournalWriteRate(b);
        Assert.assertEquals((boolean)b, (boolean)this.conf.isLogJournalWriteRate());
        i = RandomUtil.randomInt();
        this.conf.setJournalPerfBlastPages(i);
        Assert.assertEquals((int)i, (int)this.conf.getJournalPerfBlastPages());
        l = RandomUtil.randomLong();
        this.conf.setServerDumpInterval(l);
        Assert.assertEquals((long)l, (long)this.conf.getServerDumpInterval());
        s = RandomUtil.randomString();
        this.conf.setPagingDirectory(s);
        Assert.assertEquals((String)s, (String)this.conf.getPagingDirectory());
        s = RandomUtil.randomString();
        this.conf.setLargeMessagesDirectory(s);
        Assert.assertEquals((String)s, (String)this.conf.getLargeMessagesDirectory());
        b = RandomUtil.randomBoolean();
        this.conf.setWildcardRoutingEnabled(b);
        Assert.assertEquals((boolean)b, (boolean)this.conf.isWildcardRoutingEnabled());
        l = RandomUtil.randomLong();
        this.conf.setTransactionTimeout(l);
        Assert.assertEquals((long)l, (long)this.conf.getTransactionTimeout());
        b = RandomUtil.randomBoolean();
        this.conf.setMessageCounterEnabled(b);
        Assert.assertEquals((boolean)b, (boolean)this.conf.isMessageCounterEnabled());
        l = RandomUtil.randomPositiveLong();
        this.conf.setMessageCounterSamplePeriod(l);
        Assert.assertEquals((long)l, (long)this.conf.getMessageCounterSamplePeriod());
        i = RandomUtil.randomInt();
        this.conf.setMessageCounterMaxDayHistory(i);
        Assert.assertEquals((int)i, (int)this.conf.getMessageCounterMaxDayHistory());
        l = RandomUtil.randomLong();
        this.conf.setTransactionTimeoutScanPeriod(l);
        Assert.assertEquals((long)l, (long)this.conf.getTransactionTimeoutScanPeriod());
        s = RandomUtil.randomString();
        this.conf.setClusterPassword(s);
        Assert.assertEquals((String)s, (String)this.conf.getClusterPassword());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.conf);
        oos.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Configuration conf2 = (Configuration)ois.readObject();
        Assert.assertTrue((boolean)this.conf.equals(conf2));
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.conf = this.createConfiguration();
    }

    protected Configuration createConfiguration() throws Exception {
        return new ConfigurationImpl();
    }
}

