/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config.impl;

import java.util.Collections;
import junit.framework.Assert;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.ConfigurationImplTest;
import org.hornetq.core.config.impl.FileConfiguration;

public class DefaultsFileConfigurationTest
extends ConfigurationImplTest {
    @Override
    public void testDefaults() {
        Assert.assertEquals((boolean)false, (boolean)this.conf.isBackup());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isSharedStore());
        Assert.assertEquals((int)5, (int)this.conf.getScheduledThreadPoolMaxSize());
        Assert.assertEquals((int)30, (int)this.conf.getThreadPoolMaxSize());
        Assert.assertEquals((long)10000L, (long)this.conf.getSecurityInvalidationInterval());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isSecurityEnabled());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isJMXManagementEnabled());
        Assert.assertEquals((String)"org.hornetq", (String)this.conf.getJMXDomain());
        Assert.assertEquals((int)0, (int)this.conf.getIncomingInterceptorClassNames().size());
        Assert.assertEquals((long)-1L, (long)this.conf.getConnectionTTLOverride());
        Assert.assertEquals((int)0, (int)this.conf.getAcceptorConfigurations().size());
        Assert.assertEquals(Collections.emptyMap(), (Object)this.conf.getConnectorConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getBroadcastGroupConfigurations());
        Assert.assertEquals(Collections.emptyMap(), (Object)this.conf.getDiscoveryGroupConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getBridgeConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getDivertConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getClusterConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getQueueConfigurations());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.DEFAULT_MANAGEMENT_ADDRESS, (Object)this.conf.getManagementAddress());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.DEFAULT_MANAGEMENT_NOTIFICATION_ADDRESS, (Object)this.conf.getManagementNotificationAddress());
        Assert.assertEquals((String)"HORNETQ.CLUSTER.ADMIN.USER", (String)this.conf.getClusterUser());
        Assert.assertEquals((String)"CHANGE ME!!", (String)this.conf.getClusterPassword());
        Assert.assertEquals((int)20000, (int)this.conf.getIDCacheSize());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isPersistIDCache());
        Assert.assertEquals((String)"data/bindings", (String)this.conf.getBindingsDirectory());
        Assert.assertEquals((String)"data/journal", (String)this.conf.getJournalDirectory());
        Assert.assertEquals((Object)DefaultsFileConfigurationTest.getDefaultJournalType(), (Object)this.conf.getJournalType());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isJournalSyncTransactional());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isJournalSyncNonTransactional());
        Assert.assertEquals((int)0xA00000, (int)this.conf.getJournalFileSize());
        Assert.assertEquals((int)10, (int)this.conf.getJournalCompactMinFiles());
        Assert.assertEquals((int)30, (int)this.conf.getJournalCompactPercentage());
        Assert.assertEquals((int)2, (int)this.conf.getJournalMinFiles());
        Assert.assertEquals((int)500, (int)this.conf.getJournalMaxIO_AIO());
        Assert.assertEquals((int)500000, (int)this.conf.getJournalBufferTimeout_AIO());
        Assert.assertEquals((int)501760, (int)this.conf.getJournalBufferSize_AIO());
        Assert.assertEquals((int)1, (int)this.conf.getJournalMaxIO_NIO());
        Assert.assertEquals((int)3333333, (int)this.conf.getJournalBufferTimeout_NIO());
        Assert.assertEquals((int)501760, (int)this.conf.getJournalBufferSize_NIO());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isCreateBindingsDir());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isCreateJournalDir());
        Assert.assertEquals((String)"data/paging", (String)this.conf.getPagingDirectory());
        Assert.assertEquals((String)"data/largemessages", (String)this.conf.getLargeMessagesDirectory());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isWildcardRoutingEnabled());
        Assert.assertEquals((long)300000L, (long)this.conf.getTransactionTimeout());
        Assert.assertEquals((boolean)false, (boolean)this.conf.isMessageCounterEnabled());
        Assert.assertEquals((long)1000L, (long)this.conf.getTransactionTimeoutScanPeriod());
        Assert.assertEquals((long)30000L, (long)this.conf.getMessageExpiryScanPeriod());
        Assert.assertEquals((int)3, (int)this.conf.getMessageExpiryThreadPriority());
        Assert.assertEquals((String)"replication cluster name", null, (String)this.conf.getReplicationClustername());
    }

    @Override
    protected Configuration createConfiguration() throws Exception {
        FileConfiguration fc = new FileConfiguration();
        fc.setConfigurationUrl("ConfigurationTest-defaults.xml");
        fc.start();
        return fc;
    }
}

