/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config.impl;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.hornetq.core.config.impl.Validators;
import org.hornetq.core.server.JournalType;
import org.hornetq.tests.util.RandomUtil;

public class ValidatorsTest
extends TestCase {
    private static void success(Validators.Validator validator, Object value) {
        validator.validate(RandomUtil.randomString(), value);
    }

    private static void failure(Validators.Validator validator, Object value) {
        try {
            validator.validate(RandomUtil.randomString(), value);
            Assert.fail((String)(validator + " must not validate " + value));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGE_ZERO() throws Exception {
        ValidatorsTest.failure(Validators.GE_ZERO, -1);
        ValidatorsTest.success(Validators.GE_ZERO, 0);
        ValidatorsTest.success(Validators.GE_ZERO, 0.1);
        ValidatorsTest.success(Validators.GE_ZERO, 1);
    }

    public void testGT_ZERO() throws Exception {
        ValidatorsTest.failure(Validators.GT_ZERO, -1);
        ValidatorsTest.failure(Validators.GT_ZERO, 0);
        ValidatorsTest.success(Validators.GT_ZERO, 0.1);
        ValidatorsTest.success(Validators.GT_ZERO, 1);
    }

    public void testMINUS_ONE_OR_GE_ZERO() throws Exception {
        ValidatorsTest.failure(Validators.MINUS_ONE_OR_GE_ZERO, -2);
        ValidatorsTest.success(Validators.MINUS_ONE_OR_GE_ZERO, -1);
        ValidatorsTest.success(Validators.MINUS_ONE_OR_GE_ZERO, 0);
        ValidatorsTest.success(Validators.MINUS_ONE_OR_GE_ZERO, 0.1);
        ValidatorsTest.success(Validators.MINUS_ONE_OR_GE_ZERO, 1);
    }

    public void testMINUS_ONE_OR_GT_ZERO() throws Exception {
        ValidatorsTest.failure(Validators.MINUS_ONE_OR_GT_ZERO, -2);
        ValidatorsTest.success(Validators.MINUS_ONE_OR_GT_ZERO, -1);
        ValidatorsTest.failure(Validators.MINUS_ONE_OR_GT_ZERO, 0);
        ValidatorsTest.success(Validators.MINUS_ONE_OR_GT_ZERO, 0.1);
        ValidatorsTest.success(Validators.MINUS_ONE_OR_GT_ZERO, 1);
    }

    public void testNO_CHECK() throws Exception {
        ValidatorsTest.success(Validators.NO_CHECK, -1);
        ValidatorsTest.success(Validators.NO_CHECK, null);
        ValidatorsTest.success(Validators.NO_CHECK, "");
        ValidatorsTest.success(Validators.NO_CHECK, true);
        ValidatorsTest.success(Validators.NO_CHECK, false);
    }

    public void testNOT_NULL_OR_EMPTY() throws Exception {
        ValidatorsTest.failure(Validators.NOT_NULL_OR_EMPTY, null);
        ValidatorsTest.failure(Validators.NOT_NULL_OR_EMPTY, "");
        ValidatorsTest.success(Validators.NOT_NULL_OR_EMPTY, RandomUtil.randomString());
    }

    public void testJOURNAL_TYPE() throws Exception {
        for (JournalType type : JournalType.values()) {
            ValidatorsTest.success(Validators.JOURNAL_TYPE, type.toString());
        }
        ValidatorsTest.failure(Validators.JOURNAL_TYPE, null);
        ValidatorsTest.failure(Validators.JOURNAL_TYPE, "");
        ValidatorsTest.failure(Validators.JOURNAL_TYPE, RandomUtil.randomString());
    }

    public void testPERCENTAGE() {
        ValidatorsTest.success(Validators.PERCENTAGE, 99);
        ValidatorsTest.success(Validators.PERCENTAGE, 100);
        ValidatorsTest.success(Validators.PERCENTAGE, 0);
        ValidatorsTest.failure(Validators.PERCENTAGE, -1);
        ValidatorsTest.failure(Validators.PERCENTAGE, 101);
        ValidatorsTest.failure(Validators.PERCENTAGE, null);
    }
}

