/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.tests.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Context;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import junit.framework.Assert;
import junit.framework.TestSuite;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.core.asyncio.impl.AsynchronousFileImpl;
import org.hornetq.core.client.impl.ClientSessionFactoryImpl;
import org.hornetq.core.client.impl.ServerLocatorImpl;
import org.hornetq.core.config.ClusterConnectionConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.journal.RecordInfo;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.impl.AIOSequentialFileFactory;
import org.hornetq.core.journal.impl.JournalImpl;
import org.hornetq.core.journal.impl.NIOSequentialFileFactory;
import org.hornetq.core.persistence.impl.journal.JournalStorageManager;
import org.hornetq.core.persistence.impl.journal.OperationContextImpl;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.Bindings;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.postoffice.QueueBinding;
import org.hornetq.core.postoffice.impl.LocalQueueBinding;
import org.hornetq.core.remoting.impl.invm.InVMAcceptorFactory;
import org.hornetq.core.remoting.impl.invm.InVMConnectorFactory;
import org.hornetq.core.remoting.impl.invm.InVMRegistry;
import org.hornetq.core.remoting.impl.netty.NettyAcceptorFactory;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.cluster.ClusterManager;
import org.hornetq.core.server.impl.ServerMessageImpl;
import org.hornetq.core.transaction.impl.XidImpl;
import org.hornetq.tests.CoreUnitTestCase;
import org.hornetq.tests.util.RandomUtil;
import org.hornetq.utils.UUIDGenerator;

public abstract class UnitTestCase
extends CoreUnitTestCase {
    private static final HornetQServerLogger log = HornetQServerLogger.LOGGER;
    public static final String INVM_ACCEPTOR_FACTORY = InVMAcceptorFactory.class.getCanonicalName();
    public static final String INVM_CONNECTOR_FACTORY = InVMConnectorFactory.class.getCanonicalName();
    public static final String NETTY_ACCEPTOR_FACTORY = NettyAcceptorFactory.class.getCanonicalName();
    public static final String NETTY_CONNECTOR_FACTORY = NettyConnectorFactory.class.getCanonicalName();
    protected static final String CLUSTER_PASSWORD = "UnitTestsClusterPassword";
    private static final String OS_TYPE = System.getProperty("os.name").toLowerCase();
    private static final String testDir = System.getProperty("java.io.tmpdir", "/tmp") + "/hornetq-unit-test";
    private static Set<Thread> alreadyFailedThread = new HashSet<Thread>();
    private final Collection<HornetQServer> servers = new ArrayList<HornetQServer>();
    private final Collection<ServerLocator> locators = new ArrayList<ServerLocator>();
    private final Collection<ClientSessionFactory> sessionFactories = new ArrayList<ClientSessionFactory>();
    private final Collection<ClientSession> clientSessions = new HashSet<ClientSession>();
    private final Collection<ClientConsumer> clientConsumers = new HashSet<ClientConsumer>();
    private final Collection<ClientProducer> clientProducers = new HashSet<ClientProducer>();
    private final Collection<HornetQComponent> otherComponents = new HashSet<HornetQComponent>();
    private boolean checkThread = true;
    Map<Thread, StackTraceElement[]> previousThreads;

    protected void disableCheckThread() {
        this.checkThread = false;
    }

    protected boolean isWindows() {
        return OS_TYPE.indexOf("win") >= 0;
    }

    protected Configuration createDefaultConfig() throws Exception {
        return this.createDefaultConfig(false);
    }

    protected Configuration createDefaultConfig(boolean netty) throws Exception {
        if (netty) {
            return UnitTestCase.createDefaultConfig(new HashMap<String, Object>(), INVM_ACCEPTOR_FACTORY, NETTY_ACCEPTOR_FACTORY);
        }
        return UnitTestCase.createDefaultConfig(new HashMap<String, Object>(), INVM_ACCEPTOR_FACTORY);
    }

    protected static final void basicClusterConnectionConfig(Configuration mainConfig, String connectorName, String ... connectors) {
        ArrayList<String> connectors0 = new ArrayList<String>();
        for (String c : connectors) {
            connectors0.add(c);
        }
        UnitTestCase.basicClusterConnectionConfig(mainConfig, connectorName, connectors0);
    }

    protected static final void basicClusterConnectionConfig(Configuration mainConfig, String connectorName, List<String> connectors) {
        ClusterConnectionConfiguration ccc = new ClusterConnectionConfiguration("cluster1", "jms", connectorName, 10L, false, false, 1, 1, connectors, false);
        mainConfig.getClusterConfigurations().add(ccc);
    }

    protected static Configuration createDefaultConfig(int index, Map<String, Object> params, String ... acceptors) throws Exception {
        ConfigurationImpl configuration = UnitTestCase.createBasicConfig(index);
        configuration.getAcceptorConfigurations().clear();
        for (String acceptor : acceptors) {
            TransportConfiguration transportConfig = new TransportConfiguration(acceptor, params);
            configuration.getAcceptorConfigurations().add(transportConfig);
        }
        return configuration;
    }

    protected static ConfigurationImpl createBasicConfig() throws Exception {
        return UnitTestCase.createBasicConfig(0);
    }

    protected static final ConfigurationImpl createBasicConfig(int serverID) throws Exception {
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.setSecurityEnabled(false);
        configuration.setJournalMinFiles(2);
        configuration.setJournalFileSize(102400);
        configuration.setJournalType(UnitTestCase.getDefaultJournalType());
        configuration.setJournalDirectory(UnitTestCase.getJournalDir(serverID, false));
        configuration.setBindingsDirectory(UnitTestCase.getBindingsDir(serverID, false));
        configuration.setPagingDirectory(UnitTestCase.getPageDir(serverID, false));
        configuration.setLargeMessagesDirectory(UnitTestCase.getLargeMessagesDir(serverID, false));
        configuration.setJournalCompactMinFiles(0);
        configuration.setJournalCompactPercentage(0);
        configuration.setClusterPassword(CLUSTER_PASSWORD);
        return configuration;
    }

    protected static Configuration createDefaultConfig(Map<String, Object> params, String ... acceptors) throws Exception {
        ConfigurationImpl configuration = UnitTestCase.createBasicConfig(-1);
        configuration.setFileDeploymentEnabled(false);
        configuration.setJMXManagementEnabled(false);
        configuration.getAcceptorConfigurations().clear();
        for (String acceptor : acceptors) {
            TransportConfiguration transportConfig = new TransportConfiguration(acceptor, params);
            configuration.getAcceptorConfigurations().add(transportConfig);
        }
        return configuration;
    }

    protected static String getUDPDiscoveryAddress() {
        return System.getProperty("TEST-UDP-ADDRESS", "230.1.2.3");
    }

    protected static String getUDPDiscoveryAddress(int variant) {
        String value = UnitTestCase.getUDPDiscoveryAddress();
        int posPoint = value.lastIndexOf(46);
        int last = Integer.valueOf(value.substring(posPoint + 1));
        return value.substring(0, posPoint + 1) + (last + variant);
    }

    public static int getUDPDiscoveryPort() {
        return Integer.parseInt(System.getProperty("TEST-UDP-PORT", "6750"));
    }

    public static int getUDPDiscoveryPort(int variant) {
        return UnitTestCase.getUDPDiscoveryPort() + variant;
    }

    protected static JournalType getDefaultJournalType() {
        if (AsynchronousFileImpl.isLoaded()) {
            return JournalType.ASYNCIO;
        }
        return JournalType.NIO;
    }

    public UnitTestCase(String name) {
        super(name);
    }

    public UnitTestCase() {
    }

    public static void forceGC() {
        log.info((Object)"#test forceGC");
        WeakReference<Object> dumbReference = new WeakReference<Object>(new Object());
        while (dumbReference.get() != null) {
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        log.info((Object)"#test forceGC Done");
    }

    public static void forceGC(Reference<?> ref, long timeout) {
        long waitUntil = System.currentTimeMillis() + timeout;
        while (ref.get() != null && System.currentTimeMillis() < waitUntil) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < 1000; ++i) {
                list.add("Some string with garbage with concatenation " + i);
            }
            list.clear();
            list = null;
            System.gc();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
    }

    public static void checkWeakReferences(WeakReference<?> ... references) {
        int i = 0;
        boolean hasValue = false;
        block0: do {
            hasValue = false;
            if (i > 0) {
                UnitTestCase.forceGC();
            }
            for (WeakReference<?> ref : references) {
                if (ref.get() == null) continue;
                hasValue = true;
                continue block0;
            }
        } while (i++ <= 30 && hasValue);
        for (WeakReference<?> ref : references) {
            Assert.assertNull(ref.get());
        }
    }

    public static String threadDump(String msg) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        Map<Thread, StackTraceElement[]> stackTrace = Thread.getAllStackTraces();
        out.println("*******************************************************************************");
        out.println("Complete Thread dump " + msg);
        for (Map.Entry<Thread, StackTraceElement[]> el : stackTrace.entrySet()) {
            out.println("===============================================================================");
            out.println("Thread " + el.getKey() + " name = " + el.getKey().getName() + " id = " + el.getKey().getId() + " group = " + el.getKey().getThreadGroup());
            out.println();
            for (StackTraceElement traceEl : el.getValue()) {
                out.println(traceEl);
            }
        }
        out.println("===============================================================================");
        out.println("End Thread dump " + msg);
        out.println("*******************************************************************************");
        return str.toString();
    }

    public void logAndSystemOut(String message, Exception e) {
        HornetQServerLogger log0 = HornetQServerLogger.LOGGER;
        log0.info((Object)message, (Throwable)e);
        System.out.println(message);
        e.printStackTrace(System.out);
    }

    public void logAndSystemOut(String message) {
        HornetQServerLogger log0 = HornetQServerLogger.LOGGER;
        log0.info((Object)message);
        System.out.println(((Object)((Object)this)).getClass().getName() + "::" + message);
    }

    protected static TestSuite createAIOTestSuite(Class<?> clazz) {
        TestSuite suite = new TestSuite(clazz.getName() + " testsuite");
        if (AIOSequentialFileFactory.isSupported()) {
            suite.addTestSuite(clazz);
        } else {
            System.out.println("Test " + clazz.getName() + " ignored as AIO is not available." + "Add this to your java arguments if you are on a Linux system:" + "\n-Djava.library.path=<project_home>/distribution/hornetq/src/main/resources/bin");
        }
        return suite;
    }

    public static String dumpBytes(byte[] bytes) {
        StringBuffer buff = new StringBuffer();
        buff.append(System.identityHashCode(bytes) + ", size: " + bytes.length + " [");
        for (int i = 0; i < bytes.length; ++i) {
            buff.append(bytes[i]);
            if (i == bytes.length - 1) continue;
            buff.append(", ");
        }
        buff.append("]");
        return buff.toString();
    }

    public static String dumbBytesHex(byte[] buffer, int bytesPerLine) {
        StringBuffer buff = new StringBuffer();
        buff.append("[");
        for (int i = 0; i < buffer.length; ++i) {
            buff.append(String.format("%1$2X", buffer[i]));
            if (i + 1 < buffer.length) {
                buff.append(", ");
            }
            if ((i + 1) % bytesPerLine != 0) continue;
            buff.append("\n ");
        }
        buff.append("]");
        return buff.toString();
    }

    public static void assertEqualsByteArrays(byte[] expected, byte[] actual) {
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("byte at index " + i), (byte)expected[i], (byte)actual[i]);
        }
    }

    public static void assertEqualsTransportConfigurations(TransportConfiguration[] expected, TransportConfiguration[] actual) {
        UnitTestCase.assertEquals((int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("TransportConfiguration at index " + i), (Object)expected[i], (Object)actual[i]);
        }
    }

    public static void assertEqualsBuffers(int size, HornetQBuffer expected, HornetQBuffer actual) {
        expected.readerIndex(0);
        actual.readerIndex(0);
        for (int i = 0; i < size; ++i) {
            byte b1 = expected.readByte();
            byte b2 = actual.readByte();
            Assert.assertEquals((String)("byte at index " + i), (byte)b1, (byte)b2);
        }
        expected.resetReaderIndex();
        actual.resetReaderIndex();
    }

    public static void assertEqualsByteArrays(int length, byte[] expected, byte[] actual) {
        Assert.assertTrue((expected.length >= length ? 1 : 0) != 0);
        Assert.assertTrue((actual.length >= length ? 1 : 0) != 0);
        for (int i = 0; i < length; ++i) {
            Assert.assertEquals((String)("byte at index " + i), (byte)expected[i], (byte)actual[i]);
        }
    }

    public static void assertSameXids(List<Xid> expected, List<Xid> actual) {
        Assert.assertNotNull(expected);
        Assert.assertNotNull(actual);
        Assert.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Xid expectedXid = expected.get(i);
            Xid actualXid = actual.get(i);
            UnitTestCase.assertEqualsByteArrays(expectedXid.getBranchQualifier(), actualXid.getBranchQualifier());
            Assert.assertEquals((int)expectedXid.getFormatId(), (int)actualXid.getFormatId());
            UnitTestCase.assertEqualsByteArrays(expectedXid.getGlobalTransactionId(), actualXid.getGlobalTransactionId());
        }
    }

    protected static void checkNoBinding(Context context, String binding) {
        try {
            context.lookup(binding);
            Assert.fail((String)("there must be no resource to look up for " + binding));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static Object checkBinding(Context context, String binding) throws Exception {
        Object o = context.lookup(binding);
        Assert.assertNotNull((Object)o);
        return o;
    }

    protected ArrayList<String> registerConnectors(HornetQServer server, List<TransportConfiguration> connectorConfigs) {
        ArrayList<String> connectors = new ArrayList<String>();
        for (TransportConfiguration tnsp : connectorConfigs) {
            String name = RandomUtil.randomString();
            server.getConfiguration().getConnectorConfigurations().put(name, tnsp);
            connectors.add(name);
        }
        return connectors;
    }

    protected static final void checkFreePort(int ... ports) {
        for (int port : ports) {
            ServerSocket ssocket = null;
            try {
                ssocket = new ServerSocket(port);
            }
            catch (Exception e) {
                throw new IllegalStateException("port " + port + " is bound", e);
            }
            finally {
                if (ssocket != null) {
                    try {
                        ssocket.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    protected static String getTestDir() {
        return testDir;
    }

    protected void clearData() {
        this.clearData(UnitTestCase.getTestDir());
    }

    protected void clearData(String testDir) {
        File file = new File(testDir);
        UnitTestCase.deleteDirectory(file);
        file.mkdirs();
        UnitTestCase.recreateDirectory(UnitTestCase.getJournalDir(testDir));
        UnitTestCase.recreateDirectory(UnitTestCase.getBindingsDir(testDir));
        UnitTestCase.recreateDirectory(UnitTestCase.getPageDir(testDir));
        UnitTestCase.recreateDirectory(UnitTestCase.getLargeMessagesDir(testDir));
        UnitTestCase.recreateDirectory(this.getClientLargeMessagesDir(testDir));
        UnitTestCase.recreateDirectory(this.getTemporaryDir(testDir));
    }

    public static String getJournalDir() {
        return UnitTestCase.getJournalDir(UnitTestCase.getTestDir());
    }

    protected static String getJournalDir(String testDir) {
        return testDir + "/journal";
    }

    protected static String getJournalDir(int index, boolean backup) {
        return UnitTestCase.getJournalDir(UnitTestCase.getTestDir()) + UnitTestCase.directoryNameSuffix(index, backup);
    }

    protected static String getBindingsDir() {
        return UnitTestCase.getBindingsDir(UnitTestCase.getTestDir());
    }

    protected static String getBindingsDir(String testDir) {
        return testDir + "/bindings";
    }

    protected static String getBindingsDir(int index, boolean backup) {
        return UnitTestCase.getBindingsDir(UnitTestCase.getTestDir()) + UnitTestCase.directoryNameSuffix(index, backup);
    }

    protected static String getPageDir() {
        return UnitTestCase.getPageDir(UnitTestCase.getTestDir());
    }

    protected static String getPageDir(String testDir) {
        return testDir + "/page";
    }

    protected static String getPageDir(int index, boolean backup) {
        return UnitTestCase.getPageDir(UnitTestCase.getTestDir()) + UnitTestCase.directoryNameSuffix(index, backup);
    }

    protected static String getLargeMessagesDir() {
        return UnitTestCase.getLargeMessagesDir(UnitTestCase.getTestDir());
    }

    protected static String getLargeMessagesDir(String testDir) {
        return testDir + "/large-msg";
    }

    protected static String getLargeMessagesDir(int index, boolean backup) {
        return UnitTestCase.getLargeMessagesDir(UnitTestCase.getTestDir()) + UnitTestCase.directoryNameSuffix(index, backup);
    }

    private static String directoryNameSuffix(int index, boolean backup) {
        if (index == -1) {
            return "";
        }
        return index + "-" + (backup ? "B" : "L");
    }

    protected String getClientLargeMessagesDir() {
        return this.getClientLargeMessagesDir(UnitTestCase.getTestDir());
    }

    protected String getClientLargeMessagesDir(String testDir) {
        return testDir + "/client-large-msg";
    }

    protected String getTemporaryDir() {
        return this.getTemporaryDir(UnitTestCase.getTestDir());
    }

    protected String getTemporaryDir(String testDir) {
        return testDir + "/temp";
    }

    protected static void expectHornetQException(String message, HornetQExceptionType errorCode, HornetQAction action) {
        try {
            action.run();
            Assert.fail((String)message);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof HornetQException));
            Assert.assertEquals((Object)errorCode, (Object)((HornetQException)((Object)e)).getType());
        }
    }

    protected static void expectHornetQException(HornetQExceptionType errorCode, HornetQAction action) {
        UnitTestCase.expectHornetQException("must throw a HornetQException with the expected errorCode: " + errorCode, errorCode, action);
    }

    protected static void expectXAException(int errorCode, HornetQAction action) {
        try {
            action.run();
            Assert.fail((String)("must throw a XAException with the expected errorCode: " + errorCode));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof XAException));
            Assert.assertEquals((int)errorCode, (int)((XAException)e).errorCode);
        }
    }

    public static byte getSamplebyte(long position) {
        return (byte)(97L + position % 26L);
    }

    public static InputStream createFakeLargeStream(final long size) throws Exception {
        return new InputStream(){
            private long count;
            private boolean closed = false;

            @Override
            public void close() throws IOException {
                super.close();
                this.closed = true;
            }

            @Override
            public int read() throws IOException {
                if (this.closed) {
                    throw new IOException("Stream was closed");
                }
                if (this.count++ < size) {
                    return UnitTestCase.getSamplebyte(this.count - 1L);
                }
                return -1;
            }
        };
    }

    protected void validateGettersAndSetters(Object pojo, String ... ignoredProperties) throws Exception {
        PropertyDescriptor[] properties;
        HashSet<String> ignoreSet = new HashSet<String>();
        for (String ignore : ignoredProperties) {
            ignoreSet.add(ignore);
        }
        BeanInfo info = Introspector.getBeanInfo(pojo.getClass());
        for (PropertyDescriptor prop : properties = info.getPropertyDescriptors()) {
            Object value;
            if (prop.getPropertyType() == String.class) {
                value = RandomUtil.randomString();
            } else if (prop.getPropertyType() == Integer.class || prop.getPropertyType() == Integer.TYPE) {
                value = RandomUtil.randomInt();
            } else if (prop.getPropertyType() == Long.class || prop.getPropertyType() == Long.TYPE) {
                value = RandomUtil.randomLong();
            } else if (prop.getPropertyType() == Boolean.class || prop.getPropertyType() == Boolean.TYPE) {
                value = RandomUtil.randomBoolean();
            } else if (prop.getPropertyType() == Double.class || prop.getPropertyType() == Double.TYPE) {
                value = RandomUtil.randomDouble();
            } else {
                System.out.println("Can't validate property of type " + prop.getPropertyType() + " on " + prop.getName());
                value = null;
            }
            if (value != null && prop.getWriteMethod() != null && prop.getReadMethod() == null) {
                System.out.println("WriteOnly property " + prop.getName() + " on " + pojo.getClass());
                continue;
            }
            if (!(value != null & prop.getWriteMethod() != null) || prop.getReadMethod() == null || ignoreSet.contains(prop.getName())) continue;
            System.out.println("Validating " + prop.getName() + " type = " + prop.getPropertyType());
            prop.getWriteMethod().invoke(pojo, value);
            Assert.assertEquals((String)("Property " + prop.getName()), (Object)value, (Object)prop.getReadMethod().invoke(pojo, new Object[0]));
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        OperationContextImpl.clearContext();
        UnitTestCase.deleteDirectory(new File(UnitTestCase.getTestDir()));
        InVMRegistry.instance.clear();
        this.previousThreads = Thread.getAllStackTraces();
        this.logAndSystemOut("#test " + this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        this.closeAllSessionFactories();
        this.closeAllServerLocatorsFactories();
        try {
            this.assertAllClientConsumersAreClosed();
            this.assertAllClientProducersAreClosed();
            this.assertAllClientSessionsAreClosed();
        }
        finally {
            ArrayList<Exception> exceptions;
            Collection<HornetQServer> collection = this.servers;
            synchronized (collection) {
                for (HornetQServer server : this.servers) {
                    if (server == null) continue;
                    try {
                        ClusterManager clusterManager = server.getClusterManager();
                        if (clusterManager != null) {
                            for (ClusterConnection cc : clusterManager.getClusterConnections()) {
                                UnitTestCase.stopComponent((HornetQComponent)cc);
                            }
                        }
                    }
                    catch (Exception e) {}
                    UnitTestCase.stopComponentOutputExceptions((HornetQComponent)server);
                }
                this.servers.clear();
            }
            this.closeAllOtherComponents();
            try {
                exceptions = this.checkCsfStopped();
            }
            finally {
                this.cleanupPools();
            }
            if (!exceptions.isEmpty()) {
                for (Exception exception : exceptions) {
                    exception.printStackTrace();
                }
                UnitTestCase.fail((String)"Client Session Factories still trying to reconnect, see above to see where created");
            }
            Map<Thread, StackTraceElement[]> threadMap = Thread.getAllStackTraces();
            for (Thread thread : threadMap.keySet()) {
                StackTraceElement[] stack;
                for (StackTraceElement stackTraceElement : stack = threadMap.get(thread)) {
                    if (stackTraceElement.getMethodName().contains("getConnectionWithRetry") && !alreadyFailedThread.contains(thread)) {
                        alreadyFailedThread.add(thread);
                        System.out.println(UnitTestCase.threadDump(this.getName() + " has left threads running. Look at thread " + thread.getName() + " id = " + thread.getId() + " has running locators on test " + this.getName() + " on this following dump"));
                        UnitTestCase.fail((String)("test '" + this.getName() + "' left serverlocator running, this could effect other tests"));
                        continue;
                    }
                    if (!stackTraceElement.getMethodName().contains("BroadcastGroupImpl.run") || alreadyFailedThread.contains(thread)) continue;
                    alreadyFailedThread.add(thread);
                    System.out.println(UnitTestCase.threadDump(this.getName() + " has left threads running. Look at thread " + thread.getName() + " id = " + thread.getId() + " is still broadcasting " + this.getName() + " on this following dump"));
                    UnitTestCase.fail((String)"test left broadcastgroupimpl running, this could effect other tests");
                }
            }
            if (this.checkThread) {
                StringBuffer buffer = null;
                boolean failed = true;
                long timeout = System.currentTimeMillis() + 60000L;
                while (failed && timeout > System.currentTimeMillis()) {
                    buffer = new StringBuffer();
                    failed = this.checkThread(buffer);
                    if (!failed) continue;
                    UnitTestCase.forceGC();
                    Thread.sleep(500L);
                    log.info((Object)"There are still threads running, trying again");
                }
                if (failed) {
                    this.logAndSystemOut("Thread leaked on test " + ((Object)((Object)this)).getClass().getName() + "::" + this.getName() + "\n" + buffer);
                    this.logAndSystemOut("Thread leakage");
                    UnitTestCase.fail((String)"Thread leaked");
                }
            } else {
                this.checkThread = true;
            }
            this.checkFilesUsage();
            this.clearData();
            super.tearDown();
        }
    }

    private ArrayList<Exception> checkCsfStopped() {
        long time = System.currentTimeMillis();
        long waitUntil = time + 5000L;
        while (!ClientSessionFactoryImpl.CLOSE_RUNNABLES.isEmpty() && time < waitUntil) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            time = System.currentTimeMillis();
        }
        ArrayList closeRunnables = new ArrayList(ClientSessionFactoryImpl.CLOSE_RUNNABLES);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        if (!closeRunnables.isEmpty()) {
            for (ClientSessionFactoryImpl.CloseRunnable closeRunnable : closeRunnables) {
                if (closeRunnable == null) continue;
                exceptions.add(closeRunnable.stop().e);
            }
        }
        return exceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertAllClientProducersAreClosed() {
        Collection<ClientProducer> collection = this.clientProducers;
        synchronized (collection) {
            for (ClientProducer p : this.clientProducers) {
                UnitTestCase.assertTrue((String)(p + " should be closed"), (boolean)p.isClosed());
            }
            this.clientProducers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllOtherComponents() {
        Collection<HornetQComponent> collection = this.otherComponents;
        synchronized (collection) {
            for (HornetQComponent c : this.otherComponents) {
                UnitTestCase.stopComponent(c);
            }
            this.otherComponents.clear();
        }
    }

    private boolean checkThread(StringBuffer buffer) {
        boolean failedThread = false;
        Map<Thread, StackTraceElement[]> postThreads = Thread.getAllStackTraces();
        if (postThreads.size() > this.previousThreads.size()) {
            buffer.append("*********************************************************************************\n");
            buffer.append("LEAKING THREADS\n");
            for (Thread aliveThread : postThreads.keySet()) {
                StackTraceElement[] elements;
                boolean notProcessReaper;
                String name = aliveThread.getName();
                boolean notSunPKCS11 = !name.contains("SunPKCS11");
                boolean notAttachListener = !name.contains("Attach Listener");
                ThreadGroup group = aliveThread.getThreadGroup();
                boolean isSystemThread = group != null && "system".equals(group.getName());
                boolean bl = notProcessReaper = isSystemThread && !name.equals("process reaper");
                if (!notSunPKCS11 || !notAttachListener || !notProcessReaper || this.previousThreads.containsKey(aliveThread)) continue;
                failedThread = true;
                buffer.append("=============================================================================\n");
                buffer.append("Thread " + aliveThread + " is still alive with the following stackTrace:\n");
                for (StackTraceElement el : elements = postThreads.get(aliveThread)) {
                    buffer.append(el + "\n");
                }
            }
            buffer.append("*********************************************************************************\n");
        }
        return failedThread;
    }

    private void checkFilesUsage() {
        long timeout = System.currentTimeMillis() + 15000L;
        while (AsynchronousFileImpl.getTotalMaxIO() != 0 && System.currentTimeMillis() > timeout) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception ignored) {}
        }
        int invmSize = InVMRegistry.instance.size();
        if (invmSize > 0) {
            InVMRegistry.instance.clear();
            log.info((Object)UnitTestCase.threadDump("Thread dump"));
            UnitTestCase.fail((String)"invm registry still had acceptors registered");
        }
        if (AsynchronousFileImpl.getTotalMaxIO() != 0) {
            AsynchronousFileImpl.resetMaxAIO();
            Assert.fail((String)("test did not close all its files " + AsynchronousFileImpl.getTotalMaxIO()));
        }
    }

    private void cleanupPools() {
        OperationContextImpl.clearContext();
        try {
            ServerLocatorImpl.clearThreadPools();
        }
        catch (Throwable e) {
            log.info((Object)UnitTestCase.threadDump(e.getMessage()));
            System.err.println(UnitTestCase.threadDump(e.getMessage()));
        }
    }

    protected static final byte[] autoEncode(Object ... args) {
        int size = 0;
        for (Object arg : args) {
            if (arg instanceof Byte) {
                ++size;
                continue;
            }
            if (arg instanceof Boolean) {
                ++size;
                continue;
            }
            if (arg instanceof Integer) {
                size += 4;
                continue;
            }
            if (arg instanceof Long) {
                size += 8;
                continue;
            }
            if (arg instanceof Float) {
                size += 4;
                continue;
            }
            if (arg instanceof Double) {
                size += 8;
                continue;
            }
            throw HornetQMessageBundle.BUNDLE.autoConvertError(arg.getClass());
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (Object arg : args) {
            if (arg instanceof Byte) {
                buffer.put((Byte)arg);
                continue;
            }
            if (arg instanceof Boolean) {
                Boolean b = (Boolean)arg;
                buffer.put((byte)(b != false ? 1 : 0));
                continue;
            }
            if (arg instanceof Integer) {
                buffer.putInt((Integer)arg);
                continue;
            }
            if (arg instanceof Long) {
                buffer.putLong((Long)arg);
                continue;
            }
            if (arg instanceof Float) {
                buffer.putFloat(((Float)arg).floatValue());
                continue;
            }
            if (arg instanceof Double) {
                buffer.putDouble((Double)arg);
                continue;
            }
            throw HornetQMessageBundle.BUNDLE.autoConvertError(arg.getClass());
        }
        return buffer.array();
    }

    protected static final void recreateDirectory(String directory) {
        File file = new File(directory);
        UnitTestCase.deleteDirectory(file);
        file.mkdirs();
    }

    protected static final boolean deleteDirectory(File directory) {
        if (directory.isDirectory()) {
            String[] files = directory.list();
            for (int j = 0; j < files.length; ++j) {
                if (UnitTestCase.deleteDirectory(new File(directory, files[j]))) continue;
                return false;
            }
        }
        return directory.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void copyRecursive(File from, File to) throws Exception {
        if (from.isDirectory()) {
            String[] subs;
            if (!to.exists()) {
                to.mkdir();
            }
            for (String sub : subs = from.list()) {
                UnitTestCase.copyRecursive(new File(from, sub), new File(to, sub));
            }
        } else {
            InputStream in = null;
            OutputStream out = null;
            try {
                int b;
                in = new BufferedInputStream(new FileInputStream(from));
                out = new BufferedOutputStream(new FileOutputStream(to));
                while ((b = in.read()) != -1) {
                    out.write(b);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    protected void assertRefListsIdenticalRefs(List<MessageReference> l1, List<MessageReference> l2) {
        if (l1.size() != l2.size()) {
            Assert.fail((String)("Lists different sizes: " + l1.size() + ", " + l2.size()));
        }
        Iterator<MessageReference> iter1 = l1.iterator();
        Iterator<MessageReference> iter2 = l2.iterator();
        while (iter1.hasNext()) {
            MessageReference o1 = iter1.next();
            MessageReference o2 = iter2.next();
            Assert.assertTrue((String)("expected " + o1 + " but was " + o2), (o1 == o2 ? 1 : 0) != 0);
        }
    }

    protected ServerMessage generateMessage(long id) {
        ServerMessageImpl message = new ServerMessageImpl(id, 1000);
        message.setMessageID(id);
        message.getBodyBuffer().writeString(UUID.randomUUID().toString());
        message.setAddress(new SimpleString("foo"));
        return message;
    }

    protected MessageReference generateReference(Queue queue, long id) {
        ServerMessage message = this.generateMessage(id);
        return message.createReference(queue);
    }

    protected int calculateRecordSize(int size, int alignment) {
        return (size / alignment + (size % alignment != 0 ? 1 : 0)) * alignment;
    }

    protected ClientMessage createTextMessage(ClientSession session, String s) {
        return this.createTextMessage(session, s, true);
    }

    protected ClientMessage createTextMessage(ClientSession session, String s, boolean durable) {
        ClientMessage message = session.createMessage((byte)3, durable, 0L, System.currentTimeMillis(), (byte)4);
        message.getBodyBuffer().writeString(s);
        return message;
    }

    protected XidImpl newXID() {
        return new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
    }

    protected int getMessageCount(HornetQServer service, String address) throws Exception {
        return this.getMessageCount(service.getPostOffice(), address);
    }

    protected int getMessageCount(PostOffice postOffice, String address) throws Exception {
        int messageCount = 0;
        List<QueueBinding> bindings = this.getLocalQueueBindings(postOffice, address);
        for (QueueBinding qBinding : bindings) {
            messageCount = (int)((long)messageCount + qBinding.getQueue().getMessageCount());
        }
        return messageCount;
    }

    protected List<QueueBinding> getLocalQueueBindings(PostOffice postOffice, String address) throws Exception {
        ArrayList<QueueBinding> bindingsFound = new ArrayList<QueueBinding>();
        Bindings bindings = postOffice.getBindingsForAddress(new SimpleString(address));
        for (Binding binding : bindings.getBindings()) {
            if (!(binding instanceof LocalQueueBinding)) continue;
            bindingsFound.add((QueueBinding)binding);
        }
        return bindingsFound;
    }

    protected Map<Long, AtomicInteger> loadQueues(HornetQServer serverToInvestigate) throws Exception {
        NIOSequentialFileFactory messagesFF = new NIOSequentialFileFactory(serverToInvestigate.getConfiguration().getJournalDirectory());
        JournalImpl messagesJournal = new JournalImpl(serverToInvestigate.getConfiguration().getJournalFileSize(), serverToInvestigate.getConfiguration().getJournalMinFiles(), 0, 0, (SequentialFileFactory)messagesFF, "hornetq-data", "hq", 1);
        LinkedList records = new LinkedList();
        LinkedList preparedTransactions = new LinkedList();
        messagesJournal.start();
        messagesJournal.load(records, preparedTransactions, null);
        HashMap<Long, AtomicInteger> messageRefCounts = new HashMap<Long, AtomicInteger>();
        for (RecordInfo info : records) {
            Object o = JournalStorageManager.newObjectEncoding((RecordInfo)info);
            if (info.getUserRecordType() != 32) continue;
            JournalStorageManager.ReferenceDescribe ref = (JournalStorageManager.ReferenceDescribe)o;
            AtomicInteger count = (AtomicInteger)messageRefCounts.get(ref.refEncoding.queueID);
            if (count == null) {
                count = new AtomicInteger(1);
                messageRefCounts.put(ref.refEncoding.queueID, count);
                continue;
            }
            count.incrementAndGet();
        }
        messagesJournal.stop();
        return messageRefCounts;
    }

    protected final ServerLocator createInVMNonHALocator() {
        return this.createNonHALocator(false);
    }

    protected final ServerLocator createNettyNonHALocator() {
        return this.createNonHALocator(true);
    }

    protected final ServerLocator createNonHALocator(boolean isNetty) {
        ServerLocator locatorWithoutHA = isNetty ? HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(NETTY_CONNECTOR_FACTORY)}) : HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        return this.addServerLocator(locatorWithoutHA);
    }

    protected static final void stopComponent(HornetQComponent component) {
        if (component == null) {
            return;
        }
        try {
            component.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static final void stopComponentOutputExceptions(HornetQComponent component) {
        if (component == null) {
            return;
        }
        try {
            component.stop();
        }
        catch (Exception e) {
            System.err.println("Exception closing " + component);
            e.printStackTrace();
        }
    }

    protected final ClientSessionFactory createSessionFactory(ServerLocator locator) throws Exception {
        ClientSessionFactory sf = locator.createSessionFactory();
        this.addSessionFactory(sf);
        return sf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final HornetQServer addServer(HornetQServer server) {
        if (server != null) {
            Collection<HornetQServer> collection = this.servers;
            synchronized (collection) {
                this.servers.add(server);
            }
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ServerLocator addServerLocator(ServerLocator locator) {
        if (locator != null) {
            Collection<ServerLocator> collection = this.locators;
            synchronized (collection) {
                this.locators.add(locator);
            }
        }
        return locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ClientSession addClientSession(ClientSession session) {
        if (session != null) {
            Collection<ClientSession> collection = this.clientSessions;
            synchronized (collection) {
                this.clientSessions.add(session);
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ClientConsumer addClientConsumer(ClientConsumer consumer) {
        if (consumer != null) {
            Collection<ClientConsumer> collection = this.clientConsumers;
            synchronized (collection) {
                this.clientConsumers.add(consumer);
            }
        }
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ClientProducer addClientProducer(ClientProducer producer) {
        if (producer != null) {
            Collection<ClientProducer> collection = this.clientProducers;
            synchronized (collection) {
                this.clientProducers.add(producer);
            }
        }
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addHornetQComponent(HornetQComponent component) {
        if (component != null) {
            Collection<HornetQComponent> collection = this.otherComponents;
            synchronized (collection) {
                this.otherComponents.add(component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ClientSessionFactory addSessionFactory(ClientSessionFactory sf) {
        if (sf != null) {
            Collection<ClientSessionFactory> collection = this.sessionFactories;
            synchronized (collection) {
                this.sessionFactories.add(sf);
            }
        }
        return sf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertAllClientConsumersAreClosed() {
        Collection<ClientConsumer> collection = this.clientConsumers;
        synchronized (collection) {
            for (ClientConsumer cc : this.clientConsumers) {
                if (cc == null) continue;
                UnitTestCase.assertTrue((boolean)cc.isClosed());
            }
            this.clientConsumers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertAllClientSessionsAreClosed() {
        Collection<ClientSession> collection = this.clientSessions;
        synchronized (collection) {
            for (ClientSession cs : this.clientSessions) {
                if (cs == null) continue;
                UnitTestCase.assertTrue((boolean)cs.isClosed());
            }
            this.clientSessions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllSessionFactories() {
        Collection<ClientSessionFactory> collection = this.sessionFactories;
        synchronized (collection) {
            for (ClientSessionFactory sf : this.sessionFactories) {
                UnitTestCase.closeSessionFactory(sf);
                assert (sf.isClosed());
            }
            this.sessionFactories.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllServerLocatorsFactories() {
        Collection<ServerLocator> collection = this.locators;
        synchronized (collection) {
            for (ServerLocator locator : this.locators) {
                UnitTestCase.closeServerLocator(locator);
            }
            this.locators.clear();
        }
    }

    public static final void closeServerLocator(ServerLocator locator) {
        if (locator == null) {
            return;
        }
        try {
            locator.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void closeSessionFactory(ClientSessionFactory sf) {
        if (sf == null) {
            return;
        }
        try {
            sf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void waitForLatch(CountDownLatch latch) throws InterruptedException {
        UnitTestCase.assertTrue((String)"Latch has got to return within a minute", (boolean)latch.await(1L, TimeUnit.MINUTES));
    }

    protected static interface HornetQAction {
        public void run() throws Exception;
    }
}

