/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.tests.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Context;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.core.asyncio.impl.AsynchronousFileImpl;
import org.hornetq.core.client.impl.ClientSessionFactoryImpl;
import org.hornetq.core.client.impl.ServerLocatorImpl;
import org.hornetq.core.config.ClusterConnectionConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.journal.RecordInfo;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.impl.JournalImpl;
import org.hornetq.core.journal.impl.NIOSequentialFileFactory;
import org.hornetq.core.persistence.impl.journal.DescribeJournal;
import org.hornetq.core.persistence.impl.journal.OperationContextImpl;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.Bindings;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.postoffice.QueueBinding;
import org.hornetq.core.postoffice.impl.LocalQueueBinding;
import org.hornetq.core.remoting.impl.invm.InVMAcceptorFactory;
import org.hornetq.core.remoting.impl.invm.InVMConnectorFactory;
import org.hornetq.core.remoting.impl.invm.InVMRegistry;
import org.hornetq.core.remoting.impl.netty.NettyAcceptorFactory;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.cluster.ClusterManager;
import org.hornetq.core.server.impl.ServerMessageImpl;
import org.hornetq.core.transaction.impl.XidImpl;
import org.hornetq.tests.CoreUnitTestCase;
import org.hornetq.tests.util.CountDownSessionFailureListener;
import org.hornetq.tests.util.RandomUtil;
import org.hornetq.utils.UUIDGenerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;

public abstract class UnitTestCase
extends CoreUnitTestCase {
    @Rule
    public TestName name = new TestName();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private String testDir;
    private static final HornetQServerLogger log = HornetQServerLogger.LOGGER;
    public static final String INVM_ACCEPTOR_FACTORY = InVMAcceptorFactory.class.getCanonicalName();
    public static final String INVM_CONNECTOR_FACTORY = InVMConnectorFactory.class.getCanonicalName();
    public static final String NETTY_ACCEPTOR_FACTORY = NettyAcceptorFactory.class.getCanonicalName();
    public static final String NETTY_CONNECTOR_FACTORY = NettyConnectorFactory.class.getCanonicalName();
    protected static final String CLUSTER_PASSWORD = "UnitTestsClusterPassword";
    private static final String OS_TYPE = System.getProperty("os.name").toLowerCase();
    private static final int DEFAULT_UDP_PORT;
    private static Set<Thread> alreadyFailedThread;
    private final Collection<HornetQServer> servers = new ArrayList<HornetQServer>();
    private final Collection<ServerLocator> locators = new ArrayList<ServerLocator>();
    private final Collection<ClientSessionFactory> sessionFactories = new ArrayList<ClientSessionFactory>();
    private final Collection<ClientSession> clientSessions = new HashSet<ClientSession>();
    private final Collection<ClientConsumer> clientConsumers = new HashSet<ClientConsumer>();
    private final Collection<ClientProducer> clientProducers = new HashSet<ClientProducer>();
    private final Collection<HornetQComponent> otherComponents = new HashSet<HornetQComponent>();
    private boolean checkThread = true;
    Map<Thread, StackTraceElement[]> previousThreads;

    protected void disableCheckThread() {
        this.checkThread = false;
    }

    protected String getName() {
        return this.name.getMethodName();
    }

    protected boolean isWindows() {
        return OS_TYPE.indexOf("win") >= 0;
    }

    protected Configuration createDefaultConfig() throws Exception {
        return this.createDefaultConfig(false);
    }

    protected Configuration createDefaultConfig(boolean netty) throws Exception {
        if (netty) {
            return this.createDefaultConfig(new HashMap<String, Object>(), INVM_ACCEPTOR_FACTORY, NETTY_ACCEPTOR_FACTORY);
        }
        return this.createDefaultConfig(new HashMap<String, Object>(), INVM_ACCEPTOR_FACTORY);
    }

    protected static final void basicClusterConnectionConfig(Configuration mainConfig, String connectorName, String ... connectors) {
        ArrayList<String> connectors0 = new ArrayList<String>();
        for (String c : connectors) {
            connectors0.add(c);
        }
        UnitTestCase.basicClusterConnectionConfig(mainConfig, connectorName, connectors0);
    }

    protected static final void basicClusterConnectionConfig(Configuration mainConfig, String connectorName, List<String> connectors) {
        ClusterConnectionConfiguration ccc = new ClusterConnectionConfiguration("cluster1", "jms", connectorName, 10L, false, false, 1, 1, connectors, false);
        mainConfig.getClusterConfigurations().add(ccc);
    }

    protected Configuration createDefaultConfig(int index, Map<String, Object> params, String ... acceptors) {
        ConfigurationImpl configuration = this.createBasicConfig(index);
        configuration.getAcceptorConfigurations().clear();
        for (String acceptor : acceptors) {
            TransportConfiguration transportConfig = new TransportConfiguration(acceptor, params);
            configuration.getAcceptorConfigurations().add(transportConfig);
        }
        return configuration;
    }

    protected ConfigurationImpl createBasicConfig() throws Exception {
        return this.createBasicConfig(0);
    }

    protected final ConfigurationImpl createBasicConfig(int serverID) {
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.setSecurityEnabled(false);
        configuration.setJournalMinFiles(2);
        configuration.setJournalFileSize(102400);
        configuration.setJournalType(UnitTestCase.getDefaultJournalType());
        configuration.setJournalDirectory(this.getJournalDir(serverID, false));
        configuration.setBindingsDirectory(this.getBindingsDir(serverID, false));
        configuration.setPagingDirectory(this.getPageDir(serverID, false));
        configuration.setLargeMessagesDirectory(this.getLargeMessagesDir(serverID, false));
        configuration.setJournalCompactMinFiles(0);
        configuration.setJournalCompactPercentage(0);
        configuration.setClusterPassword(CLUSTER_PASSWORD);
        return configuration;
    }

    protected Configuration createDefaultConfig(Map<String, Object> params, String ... acceptors) throws Exception {
        ConfigurationImpl configuration = this.createBasicConfig(-1);
        configuration.setFileDeploymentEnabled(false);
        configuration.setJMXManagementEnabled(false);
        configuration.getAcceptorConfigurations().clear();
        for (String acceptor : acceptors) {
            TransportConfiguration transportConfig = new TransportConfiguration(acceptor, params);
            configuration.getAcceptorConfigurations().add(transportConfig);
        }
        return configuration;
    }

    protected static String getUDPDiscoveryAddress() {
        return System.getProperty("TEST-UDP-ADDRESS", "230.1.2.3");
    }

    protected static String getUDPDiscoveryAddress(int variant) {
        String value = UnitTestCase.getUDPDiscoveryAddress();
        int posPoint = value.lastIndexOf(46);
        int last = Integer.valueOf(value.substring(posPoint + 1));
        return value.substring(0, posPoint + 1) + (last + variant);
    }

    public static int getUDPDiscoveryPort() {
        String port = System.getProperty("TEST-UDP-PORT");
        if (port != null) {
            return Integer.parseInt(port);
        }
        return DEFAULT_UDP_PORT;
    }

    public static int getUDPDiscoveryPort(int variant) {
        return UnitTestCase.getUDPDiscoveryPort() + variant;
    }

    protected static JournalType getDefaultJournalType() {
        if (AsynchronousFileImpl.isLoaded()) {
            return JournalType.ASYNCIO;
        }
        return JournalType.NIO;
    }

    public UnitTestCase(String name) {
        super(name);
    }

    public UnitTestCase() {
    }

    public static void forceGC() {
        log.info((Object)"#test forceGC");
        WeakReference<Object> dumbReference = new WeakReference<Object>(new Object());
        while (dumbReference.get() != null) {
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        log.info((Object)"#test forceGC Done");
    }

    public static void forceGC(Reference<?> ref, long timeout) {
        long waitUntil = System.currentTimeMillis() + timeout;
        while (ref.get() != null && System.currentTimeMillis() < waitUntil) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < 1000; ++i) {
                list.add("Some string with garbage with concatenation " + i);
            }
            list.clear();
            list = null;
            System.gc();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
    }

    public static void checkWeakReferences(WeakReference<?> ... references) {
        int i = 0;
        boolean hasValue = false;
        block0: do {
            hasValue = false;
            if (i > 0) {
                UnitTestCase.forceGC();
            }
            for (WeakReference<?> ref : references) {
                if (ref.get() == null) continue;
                hasValue = true;
                continue block0;
            }
        } while (i++ <= 30 && hasValue);
        for (WeakReference<?> ref : references) {
            Assert.assertNull(ref.get());
        }
    }

    public static String threadDump(String msg) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        Map<Thread, StackTraceElement[]> stackTrace = Thread.getAllStackTraces();
        out.println("*******************************************************************************");
        out.println("Complete Thread dump " + msg);
        for (Map.Entry<Thread, StackTraceElement[]> el : stackTrace.entrySet()) {
            out.println("===============================================================================");
            out.println("Thread " + el.getKey() + " name = " + el.getKey().getName() + " id = " + el.getKey().getId() + " group = " + el.getKey().getThreadGroup());
            out.println();
            for (StackTraceElement traceEl : el.getValue()) {
                out.println(traceEl);
            }
        }
        out.println("===============================================================================");
        out.println("End Thread dump " + msg);
        out.println("*******************************************************************************");
        return str.toString();
    }

    public void logAndSystemOut(String message, Exception e) {
        HornetQServerLogger log0 = HornetQServerLogger.LOGGER;
        log0.info((Object)message, (Throwable)e);
        System.out.println(message);
        e.printStackTrace(System.out);
    }

    public void logAndSystemOut(String message) {
        HornetQServerLogger log0 = HornetQServerLogger.LOGGER;
        log0.info((Object)message);
        System.out.println(((Object)((Object)this)).getClass().getName() + "::" + message);
    }

    public static String dumpBytes(byte[] bytes) {
        StringBuffer buff = new StringBuffer();
        buff.append(System.identityHashCode(bytes) + ", size: " + bytes.length + " [");
        for (int i = 0; i < bytes.length; ++i) {
            buff.append(bytes[i]);
            if (i == bytes.length - 1) continue;
            buff.append(", ");
        }
        buff.append("]");
        return buff.toString();
    }

    public static String dumbBytesHex(byte[] buffer, int bytesPerLine) {
        StringBuffer buff = new StringBuffer();
        buff.append("[");
        for (int i = 0; i < buffer.length; ++i) {
            buff.append(String.format("%1$2X", buffer[i]));
            if (i + 1 < buffer.length) {
                buff.append(", ");
            }
            if ((i + 1) % bytesPerLine != 0) continue;
            buff.append("\n ");
        }
        buff.append("]");
        return buff.toString();
    }

    public static void assertEqualsByteArrays(byte[] expected, byte[] actual) {
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("byte at index " + i), (long)expected[i], (long)actual[i]);
        }
    }

    public static void assertEqualsTransportConfigurations(TransportConfiguration[] expected, TransportConfiguration[] actual) {
        UnitTestCase.assertEquals((long)expected.length, (long)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("TransportConfiguration at index " + i), (Object)expected[i], (Object)actual[i]);
        }
    }

    public static void assertEqualsBuffers(int size, HornetQBuffer expected, HornetQBuffer actual) {
        expected.readerIndex(0);
        actual.readerIndex(0);
        for (int i = 0; i < size; ++i) {
            byte b1 = expected.readByte();
            byte b2 = actual.readByte();
            Assert.assertEquals((String)("byte at index " + i), (long)b1, (long)b2);
        }
        expected.resetReaderIndex();
        actual.resetReaderIndex();
    }

    public static void assertEqualsByteArrays(int length, byte[] expected, byte[] actual) {
        Assert.assertTrue((expected.length >= length ? 1 : 0) != 0);
        Assert.assertTrue((actual.length >= length ? 1 : 0) != 0);
        for (int i = 0; i < length; ++i) {
            Assert.assertEquals((String)("byte at index " + i), (long)expected[i], (long)actual[i]);
        }
    }

    public static void assertSameXids(List<Xid> expected, List<Xid> actual) {
        Assert.assertNotNull(expected);
        Assert.assertNotNull(actual);
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Xid expectedXid = expected.get(i);
            Xid actualXid = actual.get(i);
            UnitTestCase.assertEqualsByteArrays(expectedXid.getBranchQualifier(), actualXid.getBranchQualifier());
            Assert.assertEquals((long)expectedXid.getFormatId(), (long)actualXid.getFormatId());
            UnitTestCase.assertEqualsByteArrays(expectedXid.getGlobalTransactionId(), actualXid.getGlobalTransactionId());
        }
    }

    protected static void checkNoBinding(Context context, String binding) {
        try {
            context.lookup(binding);
            Assert.fail((String)("there must be no resource to look up for " + binding));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static Object checkBinding(Context context, String binding) throws Exception {
        Object o = context.lookup(binding);
        Assert.assertNotNull((Object)o);
        return o;
    }

    protected ArrayList<String> registerConnectors(HornetQServer server, List<TransportConfiguration> connectorConfigs) {
        ArrayList<String> connectors = new ArrayList<String>();
        for (TransportConfiguration tnsp : connectorConfigs) {
            String name1 = RandomUtil.randomString();
            server.getConfiguration().getConnectorConfigurations().put(name1, tnsp);
            connectors.add(name1);
        }
        return connectors;
    }

    protected static final void checkFreePort(int ... ports) {
        for (int port : ports) {
            ServerSocket ssocket = null;
            try {
                ssocket = new ServerSocket(port);
            }
            catch (Exception e) {
                throw new IllegalStateException("port " + port + " is bound", e);
            }
            finally {
                if (ssocket != null) {
                    try {
                        ssocket.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    protected final String getTestDir() {
        return this.testDir;
    }

    protected final void setTestDir(String testDir) {
        this.testDir = testDir;
    }

    protected final void clearDataRecreateServerDirs() {
        this.clearDataRecreateServerDirs(this.getTestDir());
    }

    private final void deleteTmpDir() {
        File file = new File(this.getTestDir());
        UnitTestCase.deleteDirectory(file);
    }

    protected void clearDataRecreateServerDirs(String testDir1) {
        File file = new File(testDir1);
        UnitTestCase.deleteDirectory(file);
        file.mkdirs();
        UnitTestCase.recreateDirectory(this.getJournalDir(testDir1));
        UnitTestCase.recreateDirectory(UnitTestCase.getBindingsDir(testDir1));
        UnitTestCase.recreateDirectory(UnitTestCase.getPageDir(testDir1));
        UnitTestCase.recreateDirectory(UnitTestCase.getLargeMessagesDir(testDir1));
        UnitTestCase.recreateDirectory(this.getClientLargeMessagesDir(testDir1));
        UnitTestCase.recreateDirectory(this.getTemporaryDir(testDir1));
    }

    public String getJournalDir() {
        return this.getJournalDir(this.getTestDir());
    }

    protected String getJournalDir(String testDir1) {
        return testDir1 + "/journal";
    }

    protected String getJournalDir(int index, boolean backup) {
        return this.getJournalDir(this.getTestDir()) + UnitTestCase.directoryNameSuffix(index, backup);
    }

    protected String getBindingsDir() {
        return UnitTestCase.getBindingsDir(this.getTestDir());
    }

    protected static String getBindingsDir(String testDir1) {
        return testDir1 + "/bindings";
    }

    protected String getBindingsDir(int index, boolean backup) {
        return UnitTestCase.getBindingsDir(this.getTestDir()) + UnitTestCase.directoryNameSuffix(index, backup);
    }

    protected String getPageDir() {
        return UnitTestCase.getPageDir(this.getTestDir());
    }

    protected static String getPageDir(String testDir1) {
        return testDir1 + "/page";
    }

    protected String getPageDir(int index, boolean backup) {
        return UnitTestCase.getPageDir(this.getTestDir()) + UnitTestCase.directoryNameSuffix(index, backup);
    }

    protected String getLargeMessagesDir() {
        return UnitTestCase.getLargeMessagesDir(this.getTestDir());
    }

    protected static String getLargeMessagesDir(String testDir1) {
        return testDir1 + "/large-msg";
    }

    protected String getLargeMessagesDir(int index, boolean backup) {
        return UnitTestCase.getLargeMessagesDir(this.getTestDir()) + UnitTestCase.directoryNameSuffix(index, backup);
    }

    private static String directoryNameSuffix(int index, boolean backup) {
        if (index == -1) {
            return "";
        }
        return index + "-" + (backup ? "B" : "L");
    }

    protected String getClientLargeMessagesDir() {
        return this.getClientLargeMessagesDir(this.getTestDir());
    }

    protected String getClientLargeMessagesDir(String testDir1) {
        return testDir1 + "/client-large-msg";
    }

    protected final String getTemporaryDir() {
        return this.getTemporaryDir(this.getTestDir());
    }

    protected String getTemporaryDir(String testDir1) {
        return testDir1 + "/temp";
    }

    protected static void expectHornetQException(String message, HornetQExceptionType errorCode, HornetQAction action) {
        try {
            action.run();
            Assert.fail((String)message);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof HornetQException));
            Assert.assertEquals((Object)errorCode, (Object)((HornetQException)((Object)e)).getType());
        }
    }

    protected static void expectHornetQException(HornetQExceptionType errorCode, HornetQAction action) {
        UnitTestCase.expectHornetQException("must throw a HornetQException with the expected errorCode: " + errorCode, errorCode, action);
    }

    protected static void expectXAException(int errorCode, HornetQAction action) {
        try {
            action.run();
            Assert.fail((String)("must throw a XAException with the expected errorCode: " + errorCode));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof XAException));
            Assert.assertEquals((long)errorCode, (long)((XAException)e).errorCode);
        }
    }

    public static byte getSamplebyte(long position) {
        return (byte)(97L + position % 26L);
    }

    public static InputStream createFakeLargeStream(final long size) throws Exception {
        return new InputStream(){
            private long count;
            private boolean closed = false;

            @Override
            public void close() throws IOException {
                super.close();
                this.closed = true;
            }

            @Override
            public int read() throws IOException {
                if (this.closed) {
                    throw new IOException("Stream was closed");
                }
                if (this.count++ < size) {
                    return UnitTestCase.getSamplebyte(this.count - 1L);
                }
                return -1;
            }
        };
    }

    protected void validateGettersAndSetters(Object pojo, String ... ignoredProperties) throws Exception {
        PropertyDescriptor[] properties;
        HashSet<String> ignoreSet = new HashSet<String>();
        for (String ignore : ignoredProperties) {
            ignoreSet.add(ignore);
        }
        BeanInfo info = Introspector.getBeanInfo(pojo.getClass());
        for (PropertyDescriptor prop : properties = info.getPropertyDescriptors()) {
            Object value;
            if (prop.getPropertyType() == String.class) {
                value = RandomUtil.randomString();
            } else if (prop.getPropertyType() == Integer.class || prop.getPropertyType() == Integer.TYPE) {
                value = RandomUtil.randomInt();
            } else if (prop.getPropertyType() == Long.class || prop.getPropertyType() == Long.TYPE) {
                value = RandomUtil.randomLong();
            } else if (prop.getPropertyType() == Boolean.class || prop.getPropertyType() == Boolean.TYPE) {
                value = RandomUtil.randomBoolean();
            } else if (prop.getPropertyType() == Double.class || prop.getPropertyType() == Double.TYPE) {
                value = RandomUtil.randomDouble();
            } else {
                System.out.println("Can't validate property of type " + prop.getPropertyType() + " on " + prop.getName());
                value = null;
            }
            if (value != null && prop.getWriteMethod() != null && prop.getReadMethod() == null) {
                System.out.println("WriteOnly property " + prop.getName() + " on " + pojo.getClass());
                continue;
            }
            if (!(value != null & prop.getWriteMethod() != null) || prop.getReadMethod() == null || ignoreSet.contains(prop.getName())) continue;
            System.out.println("Validating " + prop.getName() + " type = " + prop.getPropertyType());
            prop.getWriteMethod().invoke(pojo, value);
            Assert.assertEquals((String)("Property " + prop.getName()), (Object)value, (Object)prop.getReadMethod().invoke(pojo, new Object[0]));
        }
    }

    @Before
    public void setUp() throws Exception {
        this.testDir = this.temporaryFolder.getRoot().getAbsolutePath();
        this.clearDataRecreateServerDirs();
        OperationContextImpl.clearContext();
        InVMRegistry.instance.clear();
        this.previousThreads = Thread.getAllStackTraces();
        this.logAndSystemOut("#test " + this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws Exception {
        this.closeAllSessionFactories();
        this.closeAllServerLocatorsFactories();
        try {
            this.assertAllClientConsumersAreClosed();
            this.assertAllClientProducersAreClosed();
            this.assertAllClientSessionsAreClosed();
        }
        finally {
            ArrayList<Exception> exceptions;
            Collection<HornetQServer> collection = this.servers;
            synchronized (collection) {
                for (HornetQServer server : this.servers) {
                    if (server == null) continue;
                    try {
                        ClusterManager clusterManager = server.getClusterManager();
                        if (clusterManager != null) {
                            for (ClusterConnection cc : clusterManager.getClusterConnections()) {
                                UnitTestCase.stopComponent((HornetQComponent)cc);
                            }
                        }
                    }
                    catch (Exception e) {}
                    UnitTestCase.stopComponentOutputExceptions((HornetQComponent)server);
                }
                this.servers.clear();
            }
            this.closeAllOtherComponents();
            try {
                exceptions = this.checkCsfStopped();
            }
            finally {
                this.cleanupPools();
            }
            if (!exceptions.isEmpty()) {
                for (Exception exception : exceptions) {
                    exception.printStackTrace();
                }
                UnitTestCase.fail((String)"Client Session Factories still trying to reconnect, see above to see where created");
            }
            Map<Thread, StackTraceElement[]> threadMap = Thread.getAllStackTraces();
            for (Thread thread : threadMap.keySet()) {
                StackTraceElement[] stack;
                for (StackTraceElement stackTraceElement : stack = threadMap.get(thread)) {
                    if (stackTraceElement.getMethodName().contains("getConnectionWithRetry") && !alreadyFailedThread.contains(thread)) {
                        alreadyFailedThread.add(thread);
                        System.out.println(UnitTestCase.threadDump(this.getName() + " has left threads running. Look at thread " + thread.getName() + " id = " + thread.getId() + " has running locators on test " + this.getName() + " on this following dump"));
                        UnitTestCase.fail((String)("test '" + this.getName() + "' left serverlocator running, this could effect other tests"));
                        continue;
                    }
                    if (!stackTraceElement.getMethodName().contains("BroadcastGroupImpl.run") || alreadyFailedThread.contains(thread)) continue;
                    alreadyFailedThread.add(thread);
                    System.out.println(UnitTestCase.threadDump(this.getName() + " has left threads running. Look at thread " + thread.getName() + " id = " + thread.getId() + " is still broadcasting " + this.getName() + " on this following dump"));
                    UnitTestCase.fail((String)"test left broadcastgroupimpl running, this could effect other tests");
                }
            }
            if (this.checkThread) {
                StringBuffer buffer = null;
                boolean failed = true;
                long timeout = System.currentTimeMillis() + 60000L;
                while (failed && timeout > System.currentTimeMillis()) {
                    buffer = new StringBuffer();
                    failed = this.checkThread(buffer);
                    if (!failed) continue;
                    UnitTestCase.forceGC();
                    Thread.sleep(500L);
                    log.info((Object)"There are still threads running, trying again");
                }
                if (failed) {
                    this.logAndSystemOut("Thread leaked on test " + ((Object)((Object)this)).getClass().getName() + "::" + this.getName() + "\n" + buffer);
                    this.logAndSystemOut("Thread leakage");
                    UnitTestCase.fail((String)"Thread leaked");
                }
            } else {
                this.checkThread = true;
            }
            this.checkFilesUsage();
        }
    }

    private ArrayList<Exception> checkCsfStopped() {
        long time = System.currentTimeMillis();
        long waitUntil = time + 5000L;
        while (!ClientSessionFactoryImpl.CLOSE_RUNNABLES.isEmpty() && time < waitUntil) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            time = System.currentTimeMillis();
        }
        ArrayList closeRunnables = new ArrayList(ClientSessionFactoryImpl.CLOSE_RUNNABLES);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        if (!closeRunnables.isEmpty()) {
            for (ClientSessionFactoryImpl.CloseRunnable closeRunnable : closeRunnables) {
                if (closeRunnable == null) continue;
                exceptions.add(closeRunnable.stop().e);
            }
        }
        return exceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertAllClientProducersAreClosed() {
        Collection<ClientProducer> collection = this.clientProducers;
        synchronized (collection) {
            for (ClientProducer p : this.clientProducers) {
                UnitTestCase.assertTrue((String)(p + " should be closed"), (boolean)p.isClosed());
            }
            this.clientProducers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllOtherComponents() {
        Collection<HornetQComponent> collection = this.otherComponents;
        synchronized (collection) {
            for (HornetQComponent c : this.otherComponents) {
                UnitTestCase.stopComponent(c);
            }
            this.otherComponents.clear();
        }
    }

    private boolean checkThread(StringBuffer buffer) {
        boolean failedThread = false;
        Map<Thread, StackTraceElement[]> postThreads = Thread.getAllStackTraces();
        if (postThreads != null && this.previousThreads != null && postThreads.size() > this.previousThreads.size()) {
            buffer.append("*********************************************************************************\n");
            buffer.append("LEAKING THREADS\n");
            for (Thread aliveThread : postThreads.keySet()) {
                StackTraceElement[] elements;
                if (this.isExpectedThread(aliveThread) || this.previousThreads.containsKey(aliveThread)) continue;
                failedThread = true;
                buffer.append("=============================================================================\n");
                buffer.append("Thread " + aliveThread + " is still alive with the following stackTrace:\n");
                for (StackTraceElement el : elements = postThreads.get(aliveThread)) {
                    buffer.append(el + "\n");
                }
            }
            buffer.append("*********************************************************************************\n");
        }
        return failedThread;
    }

    private boolean isExpectedThread(Thread thread) {
        String threadName = thread.getName();
        ThreadGroup group = thread.getThreadGroup();
        boolean isSystemThread = group != null && "system".equals(group.getName());
        String javaVendor = System.getProperty("java.vendor");
        if (threadName.contains("SunPKCS11")) {
            return true;
        }
        if (threadName.contains("Attach Listener")) {
            return true;
        }
        if (isSystemThread && threadName.equals("process reaper")) {
            return true;
        }
        if (javaVendor.contains("IBM") && threadName.equals("MemoryPoolMXBean notification dispatcher")) {
            return true;
        }
        for (StackTraceElement element : thread.getStackTrace()) {
            if (!element.getClassName().contains("org.jboss.byteman.agent.TransformListener")) continue;
            return true;
        }
        return false;
    }

    private void checkFilesUsage() {
        int totalMaxIO;
        long timeout = System.currentTimeMillis() + 15000L;
        while (AsynchronousFileImpl.getTotalMaxIO() != 0 && System.currentTimeMillis() > timeout) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception ignored) {}
        }
        int invmSize = InVMRegistry.instance.size();
        if (invmSize > 0) {
            InVMRegistry.instance.clear();
            log.info((Object)UnitTestCase.threadDump("Thread dump"));
            UnitTestCase.fail((String)"invm registry still had acceptors registered");
        }
        if ((totalMaxIO = AsynchronousFileImpl.getTotalMaxIO()) != 0) {
            AsynchronousFileImpl.resetMaxAIO();
            Assert.fail((String)("test did not close all its files " + totalMaxIO));
        }
    }

    private void cleanupPools() {
        OperationContextImpl.clearContext();
        try {
            ServerLocatorImpl.clearThreadPools();
        }
        catch (Throwable e) {
            log.info((Object)UnitTestCase.threadDump(e.getMessage()));
            System.err.println(UnitTestCase.threadDump(e.getMessage()));
        }
    }

    protected static final byte[] autoEncode(Object ... args) {
        int size = 0;
        for (Object arg : args) {
            if (arg instanceof Byte) {
                ++size;
                continue;
            }
            if (arg instanceof Boolean) {
                ++size;
                continue;
            }
            if (arg instanceof Integer) {
                size += 4;
                continue;
            }
            if (arg instanceof Long) {
                size += 8;
                continue;
            }
            if (arg instanceof Float) {
                size += 4;
                continue;
            }
            if (arg instanceof Double) {
                size += 8;
                continue;
            }
            throw HornetQMessageBundle.BUNDLE.autoConvertError(arg.getClass());
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (Object arg : args) {
            if (arg instanceof Byte) {
                buffer.put((Byte)arg);
                continue;
            }
            if (arg instanceof Boolean) {
                Boolean b = (Boolean)arg;
                buffer.put((byte)(b != false ? 1 : 0));
                continue;
            }
            if (arg instanceof Integer) {
                buffer.putInt((Integer)arg);
                continue;
            }
            if (arg instanceof Long) {
                buffer.putLong((Long)arg);
                continue;
            }
            if (arg instanceof Float) {
                buffer.putFloat(((Float)arg).floatValue());
                continue;
            }
            if (arg instanceof Double) {
                buffer.putDouble((Double)arg);
                continue;
            }
            throw HornetQMessageBundle.BUNDLE.autoConvertError(arg.getClass());
        }
        return buffer.array();
    }

    protected static final void recreateDirectory(String directory) {
        File file = new File(directory);
        UnitTestCase.deleteDirectory(file);
        file.mkdirs();
    }

    protected static final boolean deleteDirectory(File directory) {
        if (directory.isDirectory()) {
            String[] files = directory.list();
            int num = 5;
            for (int attempts = 0; files == null && attempts < num; ++attempts) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                files = directory.list();
            }
            for (String file : files) {
                File f = new File(directory, file);
                if (UnitTestCase.deleteDirectory(f)) continue;
                log.warn("Failed to clean up file: " + f.getAbsolutePath());
            }
        }
        return directory.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void copyRecursive(File from, File to) throws Exception {
        if (from.isDirectory()) {
            String[] subs;
            if (!to.exists()) {
                to.mkdir();
            }
            for (String sub : subs = from.list()) {
                UnitTestCase.copyRecursive(new File(from, sub), new File(to, sub));
            }
        } else {
            InputStream in = null;
            OutputStream out = null;
            try {
                int b;
                in = new BufferedInputStream(new FileInputStream(from));
                out = new BufferedOutputStream(new FileOutputStream(to));
                while ((b = in.read()) != -1) {
                    out.write(b);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    protected void assertRefListsIdenticalRefs(List<MessageReference> l1, List<MessageReference> l2) {
        if (l1.size() != l2.size()) {
            Assert.fail((String)("Lists different sizes: " + l1.size() + ", " + l2.size()));
        }
        Iterator<MessageReference> iter1 = l1.iterator();
        Iterator<MessageReference> iter2 = l2.iterator();
        while (iter1.hasNext()) {
            MessageReference o1 = iter1.next();
            MessageReference o2 = iter2.next();
            Assert.assertTrue((String)("expected " + o1 + " but was " + o2), (o1 == o2 ? 1 : 0) != 0);
        }
    }

    protected ServerMessage generateMessage(long id) {
        ServerMessageImpl message = new ServerMessageImpl(id, 1000);
        message.setMessageID(id);
        message.getBodyBuffer().writeString(UUID.randomUUID().toString());
        message.setAddress(new SimpleString("foo"));
        return message;
    }

    protected MessageReference generateReference(Queue queue, long id) {
        ServerMessage message = this.generateMessage(id);
        return message.createReference(queue);
    }

    protected int calculateRecordSize(int size, int alignment) {
        return (size / alignment + (size % alignment != 0 ? 1 : 0)) * alignment;
    }

    protected ClientMessage createTextMessage(ClientSession session, String s) {
        return this.createTextMessage(session, s, true);
    }

    protected ClientMessage createTextMessage(ClientSession session, String s, boolean durable) {
        ClientMessage message = session.createMessage((byte)3, durable, 0L, System.currentTimeMillis(), (byte)4);
        message.getBodyBuffer().writeString(s);
        return message;
    }

    protected XidImpl newXID() {
        return new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
    }

    protected int getMessageCount(HornetQServer service, String address) throws Exception {
        return this.getMessageCount(service.getPostOffice(), address);
    }

    protected int getMessageCount(PostOffice postOffice, String address) throws Exception {
        int messageCount = 0;
        List<QueueBinding> bindings = this.getLocalQueueBindings(postOffice, address);
        for (QueueBinding qBinding : bindings) {
            messageCount = (int)((long)messageCount + qBinding.getQueue().getMessageCount());
        }
        return messageCount;
    }

    protected List<QueueBinding> getLocalQueueBindings(PostOffice postOffice, String address) throws Exception {
        ArrayList<QueueBinding> bindingsFound = new ArrayList<QueueBinding>();
        Bindings bindings = postOffice.getBindingsForAddress(new SimpleString(address));
        for (Binding binding : bindings.getBindings()) {
            if (!(binding instanceof LocalQueueBinding)) continue;
            bindingsFound.add((QueueBinding)binding);
        }
        return bindingsFound;
    }

    protected Map<Long, AtomicInteger> loadQueues(HornetQServer serverToInvestigate) throws Exception {
        NIOSequentialFileFactory messagesFF = new NIOSequentialFileFactory(serverToInvestigate.getConfiguration().getJournalDirectory());
        JournalImpl messagesJournal = new JournalImpl(serverToInvestigate.getConfiguration().getJournalFileSize(), serverToInvestigate.getConfiguration().getJournalMinFiles(), 0, 0, (SequentialFileFactory)messagesFF, "hornetq-data", "hq", 1);
        LinkedList records = new LinkedList();
        LinkedList preparedTransactions = new LinkedList();
        messagesJournal.start();
        messagesJournal.load(records, preparedTransactions, null);
        HashMap<Long, AtomicInteger> messageRefCounts = new HashMap<Long, AtomicInteger>();
        for (RecordInfo info : records) {
            Object o = DescribeJournal.newObjectEncoding((RecordInfo)info);
            if (info.getUserRecordType() != 32) continue;
            DescribeJournal.ReferenceDescribe ref = (DescribeJournal.ReferenceDescribe)o;
            AtomicInteger count = (AtomicInteger)messageRefCounts.get(ref.refEncoding.queueID);
            if (count == null) {
                count = new AtomicInteger(1);
                messageRefCounts.put(ref.refEncoding.queueID, count);
                continue;
            }
            count.incrementAndGet();
        }
        messagesJournal.stop();
        return messageRefCounts;
    }

    protected final ServerLocator createInVMNonHALocator() {
        return this.createNonHALocator(false);
    }

    protected final ServerLocator createNettyNonHALocator() {
        return this.createNonHALocator(true);
    }

    protected final ServerLocator createNonHALocator(boolean isNetty) {
        ServerLocator locatorWithoutHA = isNetty ? HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(NETTY_CONNECTOR_FACTORY)}) : HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        return this.addServerLocator(locatorWithoutHA);
    }

    protected static final void stopComponent(HornetQComponent component) {
        if (component == null) {
            return;
        }
        try {
            component.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static final void stopComponentOutputExceptions(HornetQComponent component) {
        if (component == null) {
            return;
        }
        try {
            component.stop();
        }
        catch (Exception e) {
            System.err.println("Exception closing " + component);
            e.printStackTrace();
        }
    }

    protected final ClientSessionFactory createSessionFactory(ServerLocator locator) throws Exception {
        ClientSessionFactory sf = locator.createSessionFactory();
        this.addSessionFactory(sf);
        return sf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final HornetQServer addServer(HornetQServer server) {
        if (server != null) {
            Collection<HornetQServer> collection = this.servers;
            synchronized (collection) {
                this.servers.add(server);
            }
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ServerLocator addServerLocator(ServerLocator locator) {
        if (locator != null) {
            Collection<ServerLocator> collection = this.locators;
            synchronized (collection) {
                this.locators.add(locator);
            }
        }
        return locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ClientSession addClientSession(ClientSession session) {
        if (session != null) {
            Collection<ClientSession> collection = this.clientSessions;
            synchronized (collection) {
                this.clientSessions.add(session);
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ClientConsumer addClientConsumer(ClientConsumer consumer) {
        if (consumer != null) {
            Collection<ClientConsumer> collection = this.clientConsumers;
            synchronized (collection) {
                this.clientConsumers.add(consumer);
            }
        }
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ClientProducer addClientProducer(ClientProducer producer) {
        if (producer != null) {
            Collection<ClientProducer> collection = this.clientProducers;
            synchronized (collection) {
                this.clientProducers.add(producer);
            }
        }
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addHornetQComponent(HornetQComponent component) {
        if (component != null) {
            Collection<HornetQComponent> collection = this.otherComponents;
            synchronized (collection) {
                this.otherComponents.add(component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ClientSessionFactory addSessionFactory(ClientSessionFactory sf) {
        if (sf != null) {
            Collection<ClientSessionFactory> collection = this.sessionFactories;
            synchronized (collection) {
                this.sessionFactories.add(sf);
            }
        }
        return sf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertAllClientConsumersAreClosed() {
        Collection<ClientConsumer> collection = this.clientConsumers;
        synchronized (collection) {
            for (ClientConsumer cc : this.clientConsumers) {
                if (cc == null) continue;
                UnitTestCase.assertTrue((boolean)cc.isClosed());
            }
            this.clientConsumers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertAllClientSessionsAreClosed() {
        Collection<ClientSession> collection = this.clientSessions;
        synchronized (collection) {
            for (ClientSession cs : this.clientSessions) {
                if (cs == null) continue;
                UnitTestCase.assertTrue((boolean)cs.isClosed());
            }
            this.clientSessions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllSessionFactories() {
        Collection<ClientSessionFactory> collection = this.sessionFactories;
        synchronized (collection) {
            for (ClientSessionFactory sf : this.sessionFactories) {
                UnitTestCase.closeSessionFactory(sf);
                assert (sf.isClosed());
            }
            this.sessionFactories.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllServerLocatorsFactories() {
        Collection<ServerLocator> collection = this.locators;
        synchronized (collection) {
            for (ServerLocator locator : this.locators) {
                UnitTestCase.closeServerLocator(locator);
            }
            this.locators.clear();
        }
    }

    public static final void closeServerLocator(ServerLocator locator) {
        if (locator == null) {
            return;
        }
        try {
            locator.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void closeSessionFactory(ClientSessionFactory sf) {
        if (sf == null) {
            return;
        }
        try {
            sf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void crashAndWaitForFailure(HornetQServer server, ClientSession ... sessions) throws Exception {
        CountDownLatch latch = new CountDownLatch(sessions.length);
        for (ClientSession session : sessions) {
            CountDownSessionFailureListener listener = new CountDownSessionFailureListener(latch, session);
            session.addFailureListener((SessionFailureListener)listener);
        }
        ClusterManager clusterManager = server.getClusterManager();
        clusterManager.flushExecutor();
        clusterManager.clear();
        Assert.assertTrue((String)"server should be running!", (boolean)server.isStarted());
        server.stop(true);
        if (sessions.length > 0) {
            boolean ok = latch.await(10000L, TimeUnit.MILLISECONDS);
            Assert.assertTrue((String)("Failed to stop the server! Latch count is " + latch.getCount() + " out of " + sessions.length), (boolean)ok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void crashAndWaitForFailure(HornetQServer server, ServerLocator locator) throws Exception {
        ClientSessionFactory sf = locator.createSessionFactory();
        ClientSession session = sf.createSession();
        try {
            UnitTestCase.crashAndWaitForFailure(server, session);
        }
        finally {
            try {
                session.close();
                sf.close();
            }
            catch (Exception ignored) {}
        }
    }

    public static void waitForLatch(CountDownLatch latch) throws InterruptedException {
        UnitTestCase.assertTrue((String)"Latch has got to return within a minute", (boolean)latch.await(1L, TimeUnit.MINUTES));
    }

    static {
        Random random = new Random();
        DEFAULT_UDP_PORT = 6000 + random.nextInt(1000);
        alreadyFailedThread = new HashSet<Thread>();
    }

    protected static interface HornetQAction {
        public void run() throws Exception;
    }
}

