/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.tests.logging;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.junit.Assert;

public class AssertionLoggerHandler
extends ExtHandler {
    private static final Map<String, ExtLogRecord> messages = new ConcurrentHashMap<String, ExtLogRecord>();
    private static boolean capture = false;

    public void flush() {
    }

    public void close() throws SecurityException {
    }

    protected void doPublish(ExtLogRecord record) {
        if (capture) {
            messages.put(record.getFormattedMessage(), record);
        }
    }

    public static void assertMessageWasLogged(String assertionMessage, String expectedMessage) {
        if (!messages.containsKey(expectedMessage)) {
            throw new AssertionError((Object)assertionMessage);
        }
    }

    public static void assertMessageWasLogged(String message) {
        if (!messages.containsKey(message)) {
            throw new AssertionError((Object)Arrays.toString(messages.keySet().toArray()));
        }
    }

    public static boolean findText(String ... text) {
        for (String key : messages.keySet()) {
            String txtCheck;
            boolean found = true;
            String[] arr$ = text;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (found = key.contains(txtCheck = arr$[i$])); ++i$) {
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    public static void assertMessageWasLoggedWithLevel(String expectedMessage, Level expectedLevel) {
        if (!messages.containsKey(expectedMessage)) {
            throw new AssertionError((Object)Arrays.toString(messages.keySet().toArray()));
        }
        Assert.assertEquals((Object)expectedLevel, (Object)messages.get(expectedMessage).getLevel());
    }

    public static void assertMessageWasLoggedWithLevel(String assertionMessage, String expectedMessage, Level expectedLevel) {
        if (!messages.containsKey(expectedMessage)) {
            throw new AssertionError((Object)assertionMessage);
        }
        Assert.assertEquals((String)assertionMessage, (Object)expectedLevel, (Object)messages.get(expectedMessage).getLevel());
    }

    public static final void clear() {
        messages.clear();
    }

    public static final void startCapture() {
        AssertionLoggerHandler.clear();
        capture = true;
    }

    public static final void stopCapture() {
        capture = false;
        AssertionLoggerHandler.clear();
    }
}

