/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config.impl;

import java.util.Collections;
import java.util.Set;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.UDPBroadcastGroupConfiguration;
import org.hornetq.core.config.BridgeConfiguration;
import org.hornetq.core.config.ClusterConnectionConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.CoreQueueConfiguration;
import org.hornetq.core.config.DivertConfiguration;
import org.hornetq.core.config.impl.ConfigurationImplTest;
import org.hornetq.core.config.impl.FileConfiguration;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.settings.impl.AddressSettings;
import org.junit.Assert;
import org.junit.Test;

public class FileConfigurationTest
extends ConfigurationImplTest {
    @Override
    @Test
    public void testDefaults() {
        Assert.assertEquals((Object)"SomeNameForUseOnTheApplicationServer", (Object)this.conf.getName());
        Assert.assertEquals((Object)false, (Object)this.conf.isPersistenceEnabled());
        Assert.assertEquals((Object)true, (Object)this.conf.isFileDeploymentEnabled());
        Assert.assertEquals((Object)true, (Object)this.conf.isClustered());
        Assert.assertEquals((Object)true, (Object)this.conf.isFileDeploymentEnabled());
        Assert.assertEquals((long)12345L, (long)this.conf.getScheduledThreadPoolMaxSize());
        Assert.assertEquals((long)54321L, (long)this.conf.getThreadPoolMaxSize());
        Assert.assertEquals((Object)false, (Object)this.conf.isSecurityEnabled());
        Assert.assertEquals((long)5423L, (long)this.conf.getSecurityInvalidationInterval());
        Assert.assertEquals((Object)true, (Object)this.conf.isWildcardRoutingEnabled());
        Assert.assertEquals((Object)new SimpleString("Giraffe"), (Object)this.conf.getManagementAddress());
        Assert.assertEquals((Object)new SimpleString("Whatever"), (Object)this.conf.getManagementNotificationAddress());
        Assert.assertEquals((Object)"Frog", (Object)this.conf.getClusterUser());
        Assert.assertEquals((Object)"Wombat", (Object)this.conf.getClusterPassword());
        Assert.assertEquals((Object)false, (Object)this.conf.isJMXManagementEnabled());
        Assert.assertEquals((Object)"gro.qtenroh", (Object)this.conf.getJMXDomain());
        Assert.assertEquals((Object)true, (Object)this.conf.isMessageCounterEnabled());
        Assert.assertEquals((long)5L, (long)this.conf.getMessageCounterMaxDayHistory());
        Assert.assertEquals((long)123456L, (long)this.conf.getMessageCounterSamplePeriod());
        Assert.assertEquals((long)12345L, (long)this.conf.getConnectionTTLOverride());
        Assert.assertEquals((long)98765L, (long)this.conf.getTransactionTimeout());
        Assert.assertEquals((long)56789L, (long)this.conf.getTransactionTimeoutScanPeriod());
        Assert.assertEquals((long)10111213L, (long)this.conf.getMessageExpiryScanPeriod());
        Assert.assertEquals((long)8L, (long)this.conf.getMessageExpiryThreadPriority());
        Assert.assertEquals((long)127L, (long)this.conf.getIDCacheSize());
        Assert.assertEquals((Object)true, (Object)this.conf.isPersistIDCache());
        Assert.assertEquals((Object)true, (Object)this.conf.isBackup());
        Assert.assertEquals((Object)true, (Object)this.conf.isSharedStore());
        Assert.assertEquals((Object)true, (Object)this.conf.isPersistDeliveryCountBeforeDelivery());
        Assert.assertEquals((Object)"pagingdir", (Object)this.conf.getPagingDirectory());
        Assert.assertEquals((Object)"somedir", (Object)this.conf.getBindingsDirectory());
        Assert.assertEquals((Object)false, (Object)this.conf.isCreateBindingsDir());
        Assert.assertEquals((String)"max concurrent io", (long)17L, (long)this.conf.getPageMaxConcurrentIO());
        Assert.assertEquals((Object)"somedir2", (Object)this.conf.getJournalDirectory());
        Assert.assertEquals((Object)false, (Object)this.conf.isCreateJournalDir());
        Assert.assertEquals((Object)JournalType.NIO, (Object)this.conf.getJournalType());
        Assert.assertEquals((long)10000L, (long)this.conf.getJournalBufferSize_NIO());
        Assert.assertEquals((long)1000L, (long)this.conf.getJournalBufferTimeout_NIO());
        Assert.assertEquals((long)56546L, (long)this.conf.getJournalMaxIO_NIO());
        Assert.assertEquals((Object)false, (Object)this.conf.isJournalSyncTransactional());
        Assert.assertEquals((Object)true, (Object)this.conf.isJournalSyncNonTransactional());
        Assert.assertEquals((long)12345678L, (long)this.conf.getJournalFileSize());
        Assert.assertEquals((long)100L, (long)this.conf.getJournalMinFiles());
        Assert.assertEquals((long)123L, (long)this.conf.getJournalCompactMinFiles());
        Assert.assertEquals((long)33L, (long)this.conf.getJournalCompactPercentage());
        Assert.assertEquals((Object)"largemessagesdir", (Object)this.conf.getLargeMessagesDirectory());
        Assert.assertEquals((long)95L, (long)this.conf.getMemoryWarningThreshold());
        Assert.assertEquals((long)2L, (long)this.conf.getIncomingInterceptorClassNames().size());
        Assert.assertTrue((boolean)this.conf.getIncomingInterceptorClassNames().contains("org.hornetq.tests.unit.core.config.impl.TestInterceptor1"));
        Assert.assertTrue((boolean)this.conf.getIncomingInterceptorClassNames().contains("org.hornetq.tests.unit.core.config.impl.TestInterceptor2"));
        Assert.assertEquals((long)2L, (long)this.conf.getConnectorConfigurations().size());
        TransportConfiguration tc = (TransportConfiguration)this.conf.getConnectorConfigurations().get("connector1");
        Assert.assertNotNull((Object)tc);
        Assert.assertEquals((Object)"org.hornetq.tests.unit.core.config.impl.TestConnectorFactory1", (Object)tc.getFactoryClassName());
        Assert.assertEquals((Object)"v1", tc.getParams().get("a1"));
        Assert.assertEquals((Object)"123", tc.getParams().get("a2"));
        Assert.assertEquals((Object)"345", tc.getParams().get("a3"));
        Assert.assertEquals((Object)"v4", tc.getParams().get("a4"));
        tc = (TransportConfiguration)this.conf.getConnectorConfigurations().get("connector2");
        Assert.assertNotNull((Object)tc);
        Assert.assertEquals((Object)"org.hornetq.tests.unit.core.config.impl.TestConnectorFactory2", (Object)tc.getFactoryClassName());
        Assert.assertEquals((Object)"w1", tc.getParams().get("b1"));
        Assert.assertEquals((Object)"234", tc.getParams().get("b2"));
        Assert.assertEquals((long)2L, (long)this.conf.getAcceptorConfigurations().size());
        for (TransportConfiguration ac : this.conf.getAcceptorConfigurations()) {
            if (ac.getFactoryClassName().equals("org.hornetq.tests.unit.core.config.impl.TestAcceptorFactory1")) {
                Assert.assertEquals((Object)"org.hornetq.tests.unit.core.config.impl.TestAcceptorFactory1", (Object)ac.getFactoryClassName());
                Assert.assertEquals((Object)"y1", ac.getParams().get("d1"));
                Assert.assertEquals((Object)"456", ac.getParams().get("d2"));
                continue;
            }
            Assert.assertEquals((Object)"org.hornetq.tests.unit.core.config.impl.TestAcceptorFactory2", (Object)ac.getFactoryClassName());
            Assert.assertEquals((Object)"z1", ac.getParams().get("e1"));
            Assert.assertEquals((Object)"567", ac.getParams().get("e2"));
        }
        Assert.assertEquals((long)2L, (long)this.conf.getBroadcastGroupConfigurations().size());
        for (Object bc : this.conf.getBroadcastGroupConfigurations()) {
            UDPBroadcastGroupConfiguration udpBc = (UDPBroadcastGroupConfiguration)bc.getEndpointFactoryConfiguration();
            if (bc.getName().equals("bg1")) {
                Assert.assertEquals((Object)"bg1", (Object)bc.getName());
                Assert.assertEquals((long)10999L, (long)udpBc.getLocalBindPort());
                Assert.assertEquals((Object)"192.168.0.120", (Object)udpBc.getGroupAddress());
                Assert.assertEquals((long)11999L, (long)udpBc.getGroupPort());
                Assert.assertEquals((long)12345L, (long)bc.getBroadcastPeriod());
                Assert.assertEquals((Object)"connector1", bc.getConnectorInfos().get(0));
                continue;
            }
            Assert.assertEquals((Object)"bg2", (Object)bc.getName());
            Assert.assertEquals((long)12999L, (long)udpBc.getLocalBindPort());
            Assert.assertEquals((Object)"192.168.0.121", (Object)udpBc.getGroupAddress());
            Assert.assertEquals((long)13999L, (long)udpBc.getGroupPort());
            Assert.assertEquals((long)23456L, (long)bc.getBroadcastPeriod());
            Assert.assertEquals((Object)"connector2", bc.getConnectorInfos().get(0));
        }
        Assert.assertEquals((long)2L, (long)this.conf.getDiscoveryGroupConfigurations().size());
        DiscoveryGroupConfiguration dc = (DiscoveryGroupConfiguration)this.conf.getDiscoveryGroupConfigurations().get("dg1");
        Assert.assertEquals((Object)"dg1", (Object)dc.getName());
        Assert.assertEquals((Object)"192.168.0.120", (Object)((UDPBroadcastGroupConfiguration)dc.getBroadcastEndpointFactoryConfiguration()).getGroupAddress());
        FileConfigurationTest.assertEquals((Object)"172.16.8.10", (Object)((UDPBroadcastGroupConfiguration)dc.getBroadcastEndpointFactoryConfiguration()).getLocalBindAddress());
        Assert.assertEquals((long)11999L, (long)((UDPBroadcastGroupConfiguration)dc.getBroadcastEndpointFactoryConfiguration()).getGroupPort());
        Assert.assertEquals((long)12345L, (long)dc.getRefreshTimeout());
        dc = (DiscoveryGroupConfiguration)this.conf.getDiscoveryGroupConfigurations().get("dg2");
        Assert.assertEquals((Object)"dg2", (Object)dc.getName());
        Assert.assertEquals((Object)"192.168.0.121", (Object)((UDPBroadcastGroupConfiguration)dc.getBroadcastEndpointFactoryConfiguration()).getGroupAddress());
        FileConfigurationTest.assertEquals((Object)"172.16.8.11", (Object)((UDPBroadcastGroupConfiguration)dc.getBroadcastEndpointFactoryConfiguration()).getLocalBindAddress());
        Assert.assertEquals((long)12999L, (long)((UDPBroadcastGroupConfiguration)dc.getBroadcastEndpointFactoryConfiguration()).getGroupPort());
        Assert.assertEquals((long)23456L, (long)dc.getRefreshTimeout());
        Assert.assertEquals((long)2L, (long)this.conf.getDivertConfigurations().size());
        for (DivertConfiguration dic : this.conf.getDivertConfigurations()) {
            if (dic.getName().equals("divert1")) {
                Assert.assertEquals((Object)"divert1", (Object)dic.getName());
                Assert.assertEquals((Object)"routing-name1", (Object)dic.getRoutingName());
                Assert.assertEquals((Object)"address1", (Object)dic.getAddress());
                Assert.assertEquals((Object)"forwarding-address1", (Object)dic.getForwardingAddress());
                Assert.assertEquals((Object)"speed > 88", (Object)dic.getFilterString());
                Assert.assertEquals((Object)"org.foo.Transformer", (Object)dic.getTransformerClassName());
                Assert.assertEquals((Object)true, (Object)dic.isExclusive());
                continue;
            }
            Assert.assertEquals((Object)"divert2", (Object)dic.getName());
            Assert.assertEquals((Object)"routing-name2", (Object)dic.getRoutingName());
            Assert.assertEquals((Object)"address2", (Object)dic.getAddress());
            Assert.assertEquals((Object)"forwarding-address2", (Object)dic.getForwardingAddress());
            Assert.assertEquals((Object)"speed < 88", (Object)dic.getFilterString());
            Assert.assertEquals((Object)"org.foo.Transformer2", (Object)dic.getTransformerClassName());
            Assert.assertEquals((Object)false, (Object)dic.isExclusive());
        }
        Assert.assertEquals((long)2L, (long)this.conf.getBridgeConfigurations().size());
        for (BridgeConfiguration bc : this.conf.getBridgeConfigurations()) {
            if (bc.getName().equals("bridge1")) {
                Assert.assertEquals((Object)"bridge1", (Object)bc.getName());
                Assert.assertEquals((Object)"queue1", (Object)bc.getQueueName());
                Assert.assertEquals((String)"minLargeMessageSize", (long)4L, (long)bc.getMinLargeMessageSize());
                FileConfigurationTest.assertEquals((String)"check-period", (long)31L, (long)bc.getClientFailureCheckPeriod());
                FileConfigurationTest.assertEquals((String)"connection time-to-live", (long)370L, (long)bc.getConnectionTTL());
                Assert.assertEquals((Object)"bridge-forwarding-address1", (Object)bc.getForwardingAddress());
                Assert.assertEquals((Object)"sku > 1", (Object)bc.getFilterString());
                Assert.assertEquals((Object)"org.foo.BridgeTransformer", (Object)bc.getTransformerClassName());
                Assert.assertEquals((long)3L, (long)bc.getRetryInterval());
                Assert.assertEquals((double)0.2, (double)bc.getRetryIntervalMultiplier(), (double)1.0E-4);
                FileConfigurationTest.assertEquals((String)"max retry interval", (long)10002L, (long)bc.getMaxRetryInterval());
                Assert.assertEquals((long)2L, (long)bc.getReconnectAttempts());
                Assert.assertEquals((Object)true, (Object)bc.isUseDuplicateDetection());
                Assert.assertEquals((Object)"connector1", bc.getStaticConnectors().get(0));
                Assert.assertEquals(null, (Object)bc.getDiscoveryGroupName());
                continue;
            }
            Assert.assertEquals((Object)"bridge2", (Object)bc.getName());
            Assert.assertEquals((Object)"queue2", (Object)bc.getQueueName());
            Assert.assertEquals((Object)"bridge-forwarding-address2", (Object)bc.getForwardingAddress());
            Assert.assertEquals(null, (Object)bc.getFilterString());
            Assert.assertEquals(null, (Object)bc.getTransformerClassName());
            Assert.assertEquals(null, (Object)bc.getStaticConnectors());
            Assert.assertEquals((Object)"dg1", (Object)bc.getDiscoveryGroupName());
        }
        Assert.assertEquals((long)2L, (long)this.conf.getClusterConfigurations().size());
        Assert.assertEquals((String)"replication cluster name", (Object)"cluster-connection1", (Object)this.conf.getReplicationClustername());
        for (ClusterConnectionConfiguration ccc : this.conf.getClusterConfigurations()) {
            if (ccc.getName().equals("cluster-connection1")) {
                Assert.assertEquals((Object)"cluster-connection1", (Object)ccc.getName());
                Assert.assertEquals((String)"clusterConnectionConf minLargeMessageSize", (long)321L, (long)ccc.getMinLargeMessageSize());
                FileConfigurationTest.assertEquals((String)"check-period", (long)331L, (long)ccc.getClientFailureCheckPeriod());
                FileConfigurationTest.assertEquals((String)"connection time-to-live", (long)3370L, (long)ccc.getConnectionTTL());
                Assert.assertEquals((Object)"queues1", (Object)ccc.getAddress());
                Assert.assertEquals((long)3L, (long)ccc.getRetryInterval());
                Assert.assertEquals((Object)true, (Object)ccc.isDuplicateDetection());
                Assert.assertEquals((Object)false, (Object)ccc.isForwardWhenNoConsumers());
                Assert.assertEquals((long)1L, (long)ccc.getMaxHops());
                Assert.assertEquals((long)123L, (long)ccc.getCallTimeout());
                Assert.assertEquals((long)123L, (long)ccc.getCallFailoverTimeout());
                FileConfigurationTest.assertEquals((String)"multiplier", (double)0.25, (double)ccc.getRetryIntervalMultiplier(), (double)1.0E-5);
                FileConfigurationTest.assertEquals((String)"max retry interval", (long)10000L, (long)ccc.getMaxRetryInterval());
                FileConfigurationTest.assertEquals((long)72L, (long)ccc.getReconnectAttempts());
                Assert.assertEquals((Object)"connector1", ccc.getStaticConnectors().get(0));
                Assert.assertEquals((Object)"connector2", ccc.getStaticConnectors().get(1));
                Assert.assertEquals(null, (Object)ccc.getDiscoveryGroupName());
                continue;
            }
            Assert.assertEquals((Object)"cluster-connection2", (Object)ccc.getName());
            Assert.assertEquals((Object)"queues2", (Object)ccc.getAddress());
            Assert.assertEquals((long)4L, (long)ccc.getRetryInterval());
            Assert.assertEquals((long)456L, (long)ccc.getCallTimeout());
            Assert.assertEquals((long)456L, (long)ccc.getCallFailoverTimeout());
            Assert.assertEquals((Object)false, (Object)ccc.isDuplicateDetection());
            Assert.assertEquals((Object)true, (Object)ccc.isForwardWhenNoConsumers());
            Assert.assertEquals((long)2L, (long)ccc.getMaxHops());
            Assert.assertEquals(Collections.emptyList(), (Object)ccc.getStaticConnectors());
            Assert.assertEquals((Object)"dg1", (Object)ccc.getDiscoveryGroupName());
        }
        FileConfigurationTest.assertEquals((long)2L, (long)this.conf.getAddressesSettings().size());
        FileConfigurationTest.assertTrue((this.conf.getAddressesSettings().get("a1") != null ? 1 : 0) != 0);
        FileConfigurationTest.assertTrue((this.conf.getAddressesSettings().get("a2") != null ? 1 : 0) != 0);
        FileConfigurationTest.assertEquals((Object)"a1.1", (Object)((AddressSettings)this.conf.getAddressesSettings().get("a1")).getDeadLetterAddress().toString());
        FileConfigurationTest.assertEquals((Object)"a1.2", (Object)((AddressSettings)this.conf.getAddressesSettings().get("a1")).getExpiryAddress().toString());
        FileConfigurationTest.assertEquals((long)1L, (long)((AddressSettings)this.conf.getAddressesSettings().get("a1")).getRedeliveryDelay());
        FileConfigurationTest.assertEquals((long)81781728121878L, (long)((AddressSettings)this.conf.getAddressesSettings().get("a1")).getMaxSizeBytes());
        FileConfigurationTest.assertEquals((long)81738173872337L, (long)((AddressSettings)this.conf.getAddressesSettings().get("a1")).getPageSizeBytes());
        FileConfigurationTest.assertEquals((long)10L, (long)((AddressSettings)this.conf.getAddressesSettings().get("a1")).getPageCacheMaxSize());
        FileConfigurationTest.assertEquals((long)4L, (long)((AddressSettings)this.conf.getAddressesSettings().get("a1")).getMessageCounterHistoryDayLimit());
        FileConfigurationTest.assertEquals((Object)"a2.1", (Object)((AddressSettings)this.conf.getAddressesSettings().get("a2")).getDeadLetterAddress().toString());
        FileConfigurationTest.assertEquals((Object)"a2.2", (Object)((AddressSettings)this.conf.getAddressesSettings().get("a2")).getExpiryAddress().toString());
        FileConfigurationTest.assertEquals((long)5L, (long)((AddressSettings)this.conf.getAddressesSettings().get("a2")).getRedeliveryDelay());
        FileConfigurationTest.assertEquals((long)932489234928324L, (long)((AddressSettings)this.conf.getAddressesSettings().get("a2")).getMaxSizeBytes());
        FileConfigurationTest.assertEquals((long)7126716262626L, (long)((AddressSettings)this.conf.getAddressesSettings().get("a2")).getPageSizeBytes());
        FileConfigurationTest.assertEquals((long)20L, (long)((AddressSettings)this.conf.getAddressesSettings().get("a2")).getPageCacheMaxSize());
        FileConfigurationTest.assertEquals((long)8L, (long)((AddressSettings)this.conf.getAddressesSettings().get("a2")).getMessageCounterHistoryDayLimit());
        FileConfigurationTest.assertEquals((long)2L, (long)this.conf.getQueueConfigurations().size());
        FileConfigurationTest.assertEquals((Object)"queue1", (Object)((CoreQueueConfiguration)this.conf.getQueueConfigurations().get(0)).getName());
        FileConfigurationTest.assertEquals((Object)"address1", (Object)((CoreQueueConfiguration)this.conf.getQueueConfigurations().get(0)).getAddress());
        FileConfigurationTest.assertEquals((Object)"color='red'", (Object)((CoreQueueConfiguration)this.conf.getQueueConfigurations().get(0)).getFilterString());
        FileConfigurationTest.assertEquals((Object)false, (Object)((CoreQueueConfiguration)this.conf.getQueueConfigurations().get(0)).isDurable());
        FileConfigurationTest.assertEquals((Object)"queue2", (Object)((CoreQueueConfiguration)this.conf.getQueueConfigurations().get(1)).getName());
        FileConfigurationTest.assertEquals((Object)"address2", (Object)((CoreQueueConfiguration)this.conf.getQueueConfigurations().get(1)).getAddress());
        FileConfigurationTest.assertEquals((Object)"color='blue'", (Object)((CoreQueueConfiguration)this.conf.getQueueConfigurations().get(1)).getFilterString());
        FileConfigurationTest.assertEquals((Object)false, (Object)((CoreQueueConfiguration)this.conf.getQueueConfigurations().get(1)).isDurable());
        FileConfigurationTest.assertEquals((long)2L, (long)this.conf.getSecurityRoles().size());
        FileConfigurationTest.assertTrue((boolean)this.conf.getSecurityRoles().containsKey("a1"));
        FileConfigurationTest.assertTrue((boolean)this.conf.getSecurityRoles().containsKey("a2"));
        Role a1Role = ((Set)this.conf.getSecurityRoles().get("a1")).toArray(new Role[1])[0];
        FileConfigurationTest.assertFalse((boolean)a1Role.isSend());
        FileConfigurationTest.assertFalse((boolean)a1Role.isConsume());
        FileConfigurationTest.assertFalse((boolean)a1Role.isCreateDurableQueue());
        FileConfigurationTest.assertFalse((boolean)a1Role.isDeleteDurableQueue());
        FileConfigurationTest.assertTrue((boolean)a1Role.isCreateNonDurableQueue());
        FileConfigurationTest.assertFalse((boolean)a1Role.isDeleteNonDurableQueue());
        FileConfigurationTest.assertFalse((boolean)a1Role.isManage());
        Role a2Role = ((Set)this.conf.getSecurityRoles().get("a2")).toArray(new Role[1])[0];
        FileConfigurationTest.assertFalse((boolean)a2Role.isSend());
        FileConfigurationTest.assertFalse((boolean)a2Role.isConsume());
        FileConfigurationTest.assertFalse((boolean)a2Role.isCreateDurableQueue());
        FileConfigurationTest.assertFalse((boolean)a2Role.isDeleteDurableQueue());
        FileConfigurationTest.assertFalse((boolean)a2Role.isCreateNonDurableQueue());
        FileConfigurationTest.assertTrue((boolean)a2Role.isDeleteNonDurableQueue());
        FileConfigurationTest.assertFalse((boolean)a2Role.isManage());
    }

    @Test
    public void testSetGetConfigurationURL() {
        String file = "ghuuhhu";
        FileConfiguration fc = new FileConfiguration();
        fc.setConfigurationUrl("ghuuhhu");
        Assert.assertEquals((Object)"ghuuhhu", (Object)fc.getConfigurationUrl());
    }

    @Override
    protected Configuration createConfiguration() throws Exception {
        FileConfiguration fc = new FileConfiguration("ConfigurationTest-full-config.xml");
        fc.start();
        return fc;
    }
}

