/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.group.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import junit.framework.Assert;
import org.hornetq.api.core.BroadcastGroupConfiguration;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.ObjectNameBuilder;
import org.hornetq.core.config.BridgeConfiguration;
import org.hornetq.core.config.ClusterConnectionConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.DivertConfiguration;
import org.hornetq.core.management.impl.HornetQServerControlImpl;
import org.hornetq.core.messagecounter.MessageCounterManager;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.remoting.server.RemotingService;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.Divert;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.QueueFactory;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.cluster.Bridge;
import org.hornetq.core.server.cluster.BroadcastGroup;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.group.impl.Proposal;
import org.hornetq.core.server.group.impl.RemoteGroupingHandler;
import org.hornetq.core.server.group.impl.Response;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.server.management.NotificationListener;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.tests.util.UnitTestCase;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.ReusableLatch;
import org.junit.Test;

public class ClusteredResetMockTest
extends UnitTestCase {
    public static final SimpleString ANYCLUSTER = SimpleString.toSimpleString((String)"anycluster");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleSenders() throws Throwable {
        int i;
        int NUMBER_OF_SENDERS = 100;
        ReusableLatch latchSends = new ReusableLatch(NUMBER_OF_SENDERS);
        FakeManagement fake = new FakeManagement(latchSends);
        RemoteGroupingHandler handler = new RemoteGroupingHandler((ManagementService)fake, SimpleString.toSimpleString((String)"tst1"), SimpleString.toSimpleString((String)"tst2"), 50000L, 499L);
        handler.start();
        Sender[] sn = new Sender[NUMBER_OF_SENDERS];
        for (i = 0; i < sn.length; ++i) {
            sn[i] = new Sender("grp" + i, handler);
            sn[i].start();
        }
        try {
            Assert.assertTrue((boolean)latchSends.await(1L, TimeUnit.MINUTES));
            for (i = 0; i < NUMBER_OF_SENDERS; ++i) {
                latchSends.countUp();
            }
            fake.pendingNotifications.clear();
            handler.resendPending();
            ClusteredResetMockTest.assertTrue((boolean)latchSends.await(10L, TimeUnit.SECONDS));
            HashSet<SimpleString> codesAsked = new HashSet<SimpleString>();
            for (Notification notification : fake.pendingNotifications) {
                codesAsked.add(notification.getProperties().getSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID));
            }
            Sender[] senderArray = sn;
            int notification = senderArray.length;
            for (int j = 0; j < notification; ++j) {
                Sender snItem = senderArray[j];
                ClusteredResetMockTest.assertTrue((boolean)codesAsked.contains(snItem.code));
            }
            for (int i2 = NUMBER_OF_SENDERS - 1; i2 >= 0; --i2) {
                Response response = new Response(sn[i2].code, ANYCLUSTER);
                handler.proposed(response);
            }
            for (Sender sni : sn) {
                sni.join();
                if (sni.ex == null) continue;
                throw sni.ex;
            }
        }
        finally {
            for (Sender sni : sn) {
                sni.interrupt();
            }
        }
    }

    class FakeManagement
    implements ManagementService {
        public ConcurrentHashSet<Notification> pendingNotifications = new ConcurrentHashSet();
        final ReusableLatch latch;

        FakeManagement(ReusableLatch latch) {
            this.latch = latch;
        }

        public MessageCounterManager getMessageCounterManager() {
            return null;
        }

        public SimpleString getManagementAddress() {
            return null;
        }

        public SimpleString getManagementNotificationAddress() {
            return null;
        }

        public ObjectNameBuilder getObjectNameBuilder() {
            return null;
        }

        public void setStorageManager(StorageManager storageManager) {
        }

        public HornetQServerControlImpl registerServer(PostOffice postOffice, StorageManager storageManager, Configuration configuration, HierarchicalRepository<AddressSettings> addressSettingsRepository, HierarchicalRepository<Set<Role>> securityRepository, ResourceManager resourceManager, RemotingService remotingService, HornetQServer messagingServer, QueueFactory queueFactory, ScheduledExecutorService scheduledThreadPool, PagingManager pagingManager, boolean backup) throws Exception {
            return null;
        }

        public void unregisterServer() throws Exception {
        }

        public void registerInJMX(ObjectName objectName, Object managedResource) throws Exception {
        }

        public void unregisterFromJMX(ObjectName objectName) throws Exception {
        }

        public void registerInRegistry(String resourceName, Object managedResource) {
        }

        public void unregisterFromRegistry(String resourceName) {
        }

        public void registerAddress(SimpleString address) throws Exception {
        }

        public void unregisterAddress(SimpleString address) throws Exception {
        }

        public void registerQueue(Queue queue, SimpleString address, StorageManager storageManager) throws Exception {
        }

        public void unregisterQueue(SimpleString name, SimpleString address) throws Exception {
        }

        public void registerAcceptor(Acceptor acceptor, TransportConfiguration configuration) throws Exception {
        }

        public void unregisterAcceptors() {
        }

        public void registerDivert(Divert divert, DivertConfiguration config) throws Exception {
        }

        public void unregisterDivert(SimpleString name) throws Exception {
        }

        public void registerBroadcastGroup(BroadcastGroup broadcastGroup, BroadcastGroupConfiguration configuration) throws Exception {
        }

        public void unregisterBroadcastGroup(String name) throws Exception {
        }

        public void registerBridge(Bridge bridge, BridgeConfiguration configuration) throws Exception {
        }

        public void unregisterBridge(String name) throws Exception {
        }

        public void registerCluster(ClusterConnection cluster, ClusterConnectionConfiguration configuration) throws Exception {
        }

        public void unregisterCluster(String name) throws Exception {
        }

        public Object getResource(String resourceName) {
            return null;
        }

        public Object[] getResources(Class<?> resourceType) {
            return new Object[0];
        }

        public ServerMessage handleMessage(ServerMessage message) throws Exception {
            return null;
        }

        public void start() throws Exception {
        }

        public void stop() throws Exception {
        }

        public boolean isStarted() {
            return false;
        }

        public void sendNotification(Notification notification) throws Exception {
            this.pendingNotifications.add((Object)notification);
            this.latch.countDown();
        }

        public void enableNotifications(boolean enable) {
        }

        public void addNotificationListener(NotificationListener listener) {
        }

        public void removeNotificationListener(NotificationListener listener) {
        }
    }

    class Sender
    extends Thread {
        SimpleString code;
        public RemoteGroupingHandler handler;
        Throwable ex;

        Sender(String code, RemoteGroupingHandler handler) {
            super("Sender::" + code);
            this.code = SimpleString.toSimpleString((String)code);
            this.handler = handler;
        }

        @Override
        public void run() {
            Proposal proposal = new Proposal(this.code, ANYCLUSTER);
            try {
                Response response = this.handler.propose(proposal);
                if (response == null) {
                    this.ex = new NullPointerException("expected value on " + this.getName());
                }
                if (!response.getGroupId().equals((Object)this.code)) {
                    this.ex = new IllegalStateException("expected code=" + this.code + " but it was " + response.getGroupId());
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                this.ex = ex;
            }
        }
    }
}

