/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config.impl;

import java.util.Collections;
import junit.framework.Assert;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.ConfigurationImplTest;
import org.hornetq.core.config.impl.FileConfiguration;

public class DefaultsFileConfigurationTest
extends ConfigurationImplTest {
    @Override
    public void testDefaults() {
        Assert.assertEquals((boolean)HornetQDefaultConfiguration.isDefaultBackup(), (boolean)this.conf.isBackup());
        Assert.assertEquals((boolean)HornetQDefaultConfiguration.isDefaultSharedStore(), (boolean)this.conf.isSharedStore());
        Assert.assertEquals((int)HornetQDefaultConfiguration.getDefaultScheduledThreadPoolMaxSize(), (int)this.conf.getScheduledThreadPoolMaxSize());
        Assert.assertEquals((int)HornetQDefaultConfiguration.getDefaultThreadPoolMaxSize(), (int)this.conf.getThreadPoolMaxSize());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultSecurityInvalidationInterval(), (long)this.conf.getSecurityInvalidationInterval());
        Assert.assertEquals((boolean)HornetQDefaultConfiguration.isDefaultSecurityEnabled(), (boolean)this.conf.isSecurityEnabled());
        Assert.assertEquals((boolean)HornetQDefaultConfiguration.isDefaultJmxManagementEnabled(), (boolean)this.conf.isJMXManagementEnabled());
        Assert.assertEquals((String)HornetQDefaultConfiguration.getDefaultJmxDomain(), (String)this.conf.getJMXDomain());
        Assert.assertEquals((int)0, (int)this.conf.getIncomingInterceptorClassNames().size());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultConnectionTtlOverride(), (long)this.conf.getConnectionTTLOverride());
        Assert.assertEquals((int)0, (int)this.conf.getAcceptorConfigurations().size());
        Assert.assertEquals(Collections.emptyMap(), (Object)this.conf.getConnectorConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getBroadcastGroupConfigurations());
        Assert.assertEquals(Collections.emptyMap(), (Object)this.conf.getDiscoveryGroupConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getBridgeConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getDivertConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getClusterConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getQueueConfigurations());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.getDefaultManagementAddress(), (Object)this.conf.getManagementAddress());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.getDefaultManagementNotificationAddress(), (Object)this.conf.getManagementNotificationAddress());
        Assert.assertEquals((String)HornetQDefaultConfiguration.getDefaultClusterUser(), (String)this.conf.getClusterUser());
        Assert.assertEquals((String)HornetQDefaultConfiguration.getDefaultClusterPassword(), (String)this.conf.getClusterPassword());
        Assert.assertEquals((int)HornetQDefaultConfiguration.getDefaultIdCacheSize(), (int)this.conf.getIDCacheSize());
        Assert.assertEquals((boolean)HornetQDefaultConfiguration.isDefaultPersistIdCache(), (boolean)this.conf.isPersistIDCache());
        Assert.assertEquals((String)HornetQDefaultConfiguration.getDefaultBindingsDirectory(), (String)this.conf.getBindingsDirectory());
        Assert.assertEquals((String)HornetQDefaultConfiguration.getDefaultJournalDir(), (String)this.conf.getJournalDirectory());
        Assert.assertEquals((Object)DefaultsFileConfigurationTest.getDefaultJournalType(), (Object)this.conf.getJournalType());
        Assert.assertEquals((boolean)HornetQDefaultConfiguration.isDefaultJournalSyncTransactional(), (boolean)this.conf.isJournalSyncTransactional());
        Assert.assertEquals((boolean)HornetQDefaultConfiguration.isDefaultJournalSyncNonTransactional(), (boolean)this.conf.isJournalSyncNonTransactional());
        Assert.assertEquals((int)HornetQDefaultConfiguration.getDefaultJournalFileSize(), (int)this.conf.getJournalFileSize());
        Assert.assertEquals((int)HornetQDefaultConfiguration.getDefaultJournalCompactMinFiles(), (int)this.conf.getJournalCompactMinFiles());
        Assert.assertEquals((int)HornetQDefaultConfiguration.getDefaultJournalCompactPercentage(), (int)this.conf.getJournalCompactPercentage());
        Assert.assertEquals((int)HornetQDefaultConfiguration.getDefaultJournalMinFiles(), (int)this.conf.getJournalMinFiles());
        Assert.assertEquals((int)HornetQDefaultConfiguration.getDefaultJournalMaxIoAio(), (int)this.conf.getJournalMaxIO_AIO());
        Assert.assertEquals((int)500000, (int)this.conf.getJournalBufferTimeout_AIO());
        Assert.assertEquals((int)501760, (int)this.conf.getJournalBufferSize_AIO());
        Assert.assertEquals((int)HornetQDefaultConfiguration.getDefaultJournalMaxIoNio(), (int)this.conf.getJournalMaxIO_NIO());
        Assert.assertEquals((int)3333333, (int)this.conf.getJournalBufferTimeout_NIO());
        Assert.assertEquals((int)501760, (int)this.conf.getJournalBufferSize_NIO());
        Assert.assertEquals((boolean)HornetQDefaultConfiguration.isDefaultCreateBindingsDir(), (boolean)this.conf.isCreateBindingsDir());
        Assert.assertEquals((boolean)HornetQDefaultConfiguration.isDefaultCreateJournalDir(), (boolean)this.conf.isCreateJournalDir());
        Assert.assertEquals((String)HornetQDefaultConfiguration.getDefaultPagingDir(), (String)this.conf.getPagingDirectory());
        Assert.assertEquals((String)HornetQDefaultConfiguration.getDefaultLargeMessagesDir(), (String)this.conf.getLargeMessagesDirectory());
        Assert.assertEquals((boolean)HornetQDefaultConfiguration.isDefaultWildcardRoutingEnabled(), (boolean)this.conf.isWildcardRoutingEnabled());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultTransactionTimeout(), (long)this.conf.getTransactionTimeout());
        Assert.assertEquals((boolean)HornetQDefaultConfiguration.isDefaultMessageCounterEnabled(), (boolean)this.conf.isMessageCounterEnabled());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultTransactionTimeoutScanPeriod(), (long)this.conf.getTransactionTimeoutScanPeriod());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultMessageExpiryScanPeriod(), (long)this.conf.getMessageExpiryScanPeriod());
        Assert.assertEquals((int)HornetQDefaultConfiguration.getDefaultMessageExpiryThreadPriority(), (int)this.conf.getMessageExpiryThreadPriority());
        Assert.assertEquals((String)"replication cluster name", null, (String)this.conf.getReplicationClustername());
    }

    @Override
    protected Configuration createConfiguration() throws Exception {
        FileConfiguration fc = new FileConfiguration("ConfigurationTest-defaults.xml");
        fc.start();
        return fc;
    }
}

