/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config.impl;

import java.util.Collections;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.ConfigurationImplTest;
import org.hornetq.core.config.impl.FileConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class DefaultsFileConfigurationTest
extends ConfigurationImplTest {
    @Override
    @Test
    public void testDefaults() {
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultBackup(), (Object)this.conf.isBackup());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultSharedStore(), (Object)this.conf.isSharedStore());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultScheduledThreadPoolMaxSize(), (long)this.conf.getScheduledThreadPoolMaxSize());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultThreadPoolMaxSize(), (long)this.conf.getThreadPoolMaxSize());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultSecurityInvalidationInterval(), (long)this.conf.getSecurityInvalidationInterval());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultSecurityEnabled(), (Object)this.conf.isSecurityEnabled());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultJmxManagementEnabled(), (Object)this.conf.isJMXManagementEnabled());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.getDefaultJmxDomain(), (Object)this.conf.getJMXDomain());
        Assert.assertEquals((long)0L, (long)this.conf.getIncomingInterceptorClassNames().size());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultConnectionTtlOverride(), (long)this.conf.getConnectionTTLOverride());
        Assert.assertEquals((long)0L, (long)this.conf.getAcceptorConfigurations().size());
        Assert.assertEquals(Collections.emptyMap(), (Object)this.conf.getConnectorConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getBroadcastGroupConfigurations());
        Assert.assertEquals(Collections.emptyMap(), (Object)this.conf.getDiscoveryGroupConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getBridgeConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getDivertConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getClusterConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getQueueConfigurations());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.getDefaultManagementAddress(), (Object)this.conf.getManagementAddress());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.getDefaultManagementNotificationAddress(), (Object)this.conf.getManagementNotificationAddress());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.getDefaultClusterUser(), (Object)this.conf.getClusterUser());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.getDefaultClusterPassword(), (Object)this.conf.getClusterPassword());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultIdCacheSize(), (long)this.conf.getIDCacheSize());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultPersistIdCache(), (Object)this.conf.isPersistIDCache());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.getDefaultBindingsDirectory(), (Object)this.conf.getBindingsDirectory());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.getDefaultJournalDir(), (Object)this.conf.getJournalDirectory());
        Assert.assertEquals((Object)DefaultsFileConfigurationTest.getDefaultJournalType(), (Object)this.conf.getJournalType());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultJournalSyncTransactional(), (Object)this.conf.isJournalSyncTransactional());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultJournalSyncNonTransactional(), (Object)this.conf.isJournalSyncNonTransactional());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultJournalFileSize(), (long)this.conf.getJournalFileSize());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultJournalCompactMinFiles(), (long)this.conf.getJournalCompactMinFiles());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultJournalCompactPercentage(), (long)this.conf.getJournalCompactPercentage());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultJournalMinFiles(), (long)this.conf.getJournalMinFiles());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultJournalMaxIoAio(), (long)this.conf.getJournalMaxIO_AIO());
        Assert.assertEquals((long)500000L, (long)this.conf.getJournalBufferTimeout_AIO());
        Assert.assertEquals((long)501760L, (long)this.conf.getJournalBufferSize_AIO());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultJournalMaxIoNio(), (long)this.conf.getJournalMaxIO_NIO());
        Assert.assertEquals((long)3333333L, (long)this.conf.getJournalBufferTimeout_NIO());
        Assert.assertEquals((long)501760L, (long)this.conf.getJournalBufferSize_NIO());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultCreateBindingsDir(), (Object)this.conf.isCreateBindingsDir());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultCreateJournalDir(), (Object)this.conf.isCreateJournalDir());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.getDefaultPagingDir(), (Object)this.conf.getPagingDirectory());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.getDefaultLargeMessagesDir(), (Object)this.conf.getLargeMessagesDirectory());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultWildcardRoutingEnabled(), (Object)this.conf.isWildcardRoutingEnabled());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultTransactionTimeout(), (long)this.conf.getTransactionTimeout());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultMessageCounterEnabled(), (Object)this.conf.isMessageCounterEnabled());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultTransactionTimeoutScanPeriod(), (long)this.conf.getTransactionTimeoutScanPeriod());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultMessageExpiryScanPeriod(), (long)this.conf.getMessageExpiryScanPeriod());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultMessageExpiryThreadPriority(), (long)this.conf.getMessageExpiryThreadPriority());
        Assert.assertEquals((String)"replication cluster name", null, (Object)this.conf.getReplicationClustername());
    }

    @Override
    protected Configuration createConfiguration() throws Exception {
        FileConfiguration fc = new FileConfiguration("ConfigurationTest-defaults.xml");
        fc.start();
        return fc;
    }
}

