/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.list;

import org.hornetq.utils.LinkedListIterator;
import org.hornetq.utils.PriorityLinkedListImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class PriorityLinkedListTest
extends Assert {
    protected Wibble a;
    protected Wibble b;
    protected Wibble c;
    protected Wibble d;
    protected Wibble e;
    protected Wibble f;
    protected Wibble g;
    protected Wibble h;
    protected Wibble i;
    protected Wibble j;
    protected Wibble k;
    protected Wibble l;
    protected Wibble m;
    protected Wibble n;
    protected Wibble o;
    protected Wibble p;
    protected Wibble q;
    protected Wibble r;
    protected Wibble s;
    protected Wibble t;
    protected Wibble u;
    protected Wibble v;
    protected Wibble w;
    protected Wibble x;
    protected Wibble y;
    protected Wibble z;
    private PriorityLinkedListImpl<Wibble> list;

    protected PriorityLinkedListImpl<Wibble> getList() {
        return new PriorityLinkedListImpl(10);
    }

    @Before
    public void setUp() throws Exception {
        this.list = this.getList();
        this.a = new Wibble("a");
        this.b = new Wibble("b");
        this.c = new Wibble("c");
        this.d = new Wibble("d");
        this.e = new Wibble("e");
        this.f = new Wibble("f");
        this.g = new Wibble("g");
        this.h = new Wibble("h");
        this.i = new Wibble("i");
        this.j = new Wibble("j");
        this.k = new Wibble("k");
        this.l = new Wibble("l");
        this.m = new Wibble("m");
        this.n = new Wibble("n");
        this.o = new Wibble("o");
        this.p = new Wibble("p");
        this.q = new Wibble("q");
        this.r = new Wibble("r");
        this.s = new Wibble("s");
        this.t = new Wibble("t");
        this.u = new Wibble("u");
        this.v = new Wibble("v");
        this.w = new Wibble("w");
        this.x = new Wibble("x");
        this.y = new Wibble("y");
        this.z = new Wibble("z");
    }

    @After
    public void tearDown() throws Exception {
        this.list = null;
    }

    @Test
    public void testEmpty() throws Exception {
        Assert.assertTrue((boolean)this.list.isEmpty());
        this.list.addHead((Object)this.a, 0);
        Assert.assertFalse((boolean)this.list.isEmpty());
        Wibble w = (Wibble)this.list.poll();
        Assert.assertEquals((Object)this.a, (Object)w);
        Assert.assertTrue((boolean)this.list.isEmpty());
        PriorityLinkedListTest.assertEquals((long)0L, (long)this.list.size());
    }

    @Test
    public void testaddHead() throws Exception {
        this.list.addHead((Object)this.a, 0);
        this.list.addHead((Object)this.b, 0);
        this.list.addHead((Object)this.c, 0);
        this.list.addHead((Object)this.d, 0);
        this.list.addHead((Object)this.e, 0);
        PriorityLinkedListTest.assertEquals((long)5L, (long)this.list.size());
        Assert.assertEquals((Object)this.e, (Object)this.list.poll());
        Assert.assertEquals((Object)this.d, (Object)this.list.poll());
        Assert.assertEquals((Object)this.c, (Object)this.list.poll());
        Assert.assertEquals((Object)this.b, (Object)this.list.poll());
        Assert.assertEquals((Object)this.a, (Object)this.list.poll());
        Assert.assertNull((Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((long)0L, (long)this.list.size());
    }

    @Test
    public void testaddTail() throws Exception {
        this.list.addTail((Object)this.a, 0);
        this.list.addTail((Object)this.b, 0);
        this.list.addTail((Object)this.c, 0);
        this.list.addTail((Object)this.d, 0);
        this.list.addTail((Object)this.e, 0);
        PriorityLinkedListTest.assertEquals((long)5L, (long)this.list.size());
        Assert.assertEquals((Object)this.a, (Object)this.list.poll());
        Assert.assertEquals((Object)this.b, (Object)this.list.poll());
        Assert.assertEquals((Object)this.c, (Object)this.list.poll());
        Assert.assertEquals((Object)this.d, (Object)this.list.poll());
        Assert.assertEquals((Object)this.e, (Object)this.list.poll());
        Assert.assertNull((Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((long)0L, (long)this.list.size());
    }

    @Test
    public void testAddLastAndFirst() throws Exception {
        this.list.addTail((Object)this.a, 0);
        this.list.addTail((Object)this.b, 0);
        this.list.addTail((Object)this.c, 0);
        this.list.addTail((Object)this.d, 0);
        this.list.addTail((Object)this.e, 0);
        this.list.addTail((Object)this.f, 0);
        this.list.addTail((Object)this.g, 0);
        this.list.addTail((Object)this.h, 0);
        this.list.addTail((Object)this.i, 0);
        this.list.addTail((Object)this.j, 0);
        this.list.addHead((Object)this.k, 0);
        this.list.addHead((Object)this.l, 0);
        this.list.addHead((Object)this.m, 0);
        this.list.addHead((Object)this.n, 0);
        this.list.addHead((Object)this.o, 0);
        this.list.addHead((Object)this.p, 0);
        this.list.addHead((Object)this.q, 0);
        this.list.addHead((Object)this.r, 0);
        this.list.addHead((Object)this.s, 0);
        this.list.addHead((Object)this.t, 0);
        PriorityLinkedListTest.assertEquals((Object)this.t, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.s, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.r, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.q, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.p, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.o, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.n, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.m, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.l, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.k, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.a, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.b, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.c, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.d, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.e, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.f, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.g, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.h, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.i, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.j, (Object)this.list.poll());
    }

    @Test
    public void testAddLastAndFirstWithIterator() throws Exception {
        this.list.addTail((Object)this.a, 0);
        this.list.addTail((Object)this.b, 0);
        this.list.addTail((Object)this.c, 0);
        this.list.addTail((Object)this.d, 0);
        this.list.addTail((Object)this.e, 0);
        this.list.addTail((Object)this.f, 0);
        this.list.addTail((Object)this.g, 0);
        this.list.addTail((Object)this.h, 0);
        this.list.addTail((Object)this.i, 0);
        this.list.addTail((Object)this.j, 0);
        this.list.addHead((Object)this.k, 0);
        this.list.addHead((Object)this.l, 0);
        this.list.addHead((Object)this.m, 0);
        this.list.addHead((Object)this.n, 0);
        this.list.addHead((Object)this.o, 0);
        this.list.addHead((Object)this.p, 0);
        this.list.addHead((Object)this.q, 0);
        this.list.addHead((Object)this.r, 0);
        this.list.addHead((Object)this.s, 0);
        this.list.addHead((Object)this.t, 0);
        LinkedListIterator iter = this.list.iterator();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.t, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.s, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.r, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.q, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.p, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.o, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.n, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.m, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.l, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.k, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.a, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.b, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.c, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.d, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.e, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.f, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.g, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.h, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.i, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.j, (Object)iter.next());
    }

    @Test
    public void testPoll() throws Exception {
        this.list.addTail((Object)this.a, 0);
        this.list.addTail((Object)this.b, 1);
        this.list.addTail((Object)this.c, 2);
        this.list.addTail((Object)this.d, 3);
        this.list.addTail((Object)this.e, 4);
        this.list.addTail((Object)this.f, 5);
        this.list.addTail((Object)this.g, 6);
        this.list.addTail((Object)this.h, 7);
        this.list.addTail((Object)this.i, 8);
        this.list.addTail((Object)this.j, 9);
        Assert.assertEquals((Object)this.j, (Object)this.list.poll());
        Assert.assertEquals((Object)this.i, (Object)this.list.poll());
        Assert.assertEquals((Object)this.h, (Object)this.list.poll());
        Assert.assertEquals((Object)this.g, (Object)this.list.poll());
        Assert.assertEquals((Object)this.f, (Object)this.list.poll());
        Assert.assertEquals((Object)this.e, (Object)this.list.poll());
        Assert.assertEquals((Object)this.d, (Object)this.list.poll());
        Assert.assertEquals((Object)this.c, (Object)this.list.poll());
        Assert.assertEquals((Object)this.b, (Object)this.list.poll());
        Assert.assertEquals((Object)this.a, (Object)this.list.poll());
        Assert.assertNull((Object)this.list.poll());
        this.list.addTail((Object)this.a, 9);
        this.list.addTail((Object)this.b, 8);
        this.list.addTail((Object)this.c, 7);
        this.list.addTail((Object)this.d, 6);
        this.list.addTail((Object)this.e, 5);
        this.list.addTail((Object)this.f, 4);
        this.list.addTail((Object)this.g, 3);
        this.list.addTail((Object)this.h, 2);
        this.list.addTail((Object)this.i, 1);
        this.list.addTail((Object)this.j, 0);
        Assert.assertEquals((Object)this.a, (Object)this.list.poll());
        Assert.assertEquals((Object)this.b, (Object)this.list.poll());
        Assert.assertEquals((Object)this.c, (Object)this.list.poll());
        Assert.assertEquals((Object)this.d, (Object)this.list.poll());
        Assert.assertEquals((Object)this.e, (Object)this.list.poll());
        Assert.assertEquals((Object)this.f, (Object)this.list.poll());
        Assert.assertEquals((Object)this.g, (Object)this.list.poll());
        Assert.assertEquals((Object)this.h, (Object)this.list.poll());
        Assert.assertEquals((Object)this.i, (Object)this.list.poll());
        Assert.assertEquals((Object)this.j, (Object)this.list.poll());
        Assert.assertNull((Object)this.list.poll());
        this.list.addTail((Object)this.a, 9);
        this.list.addTail((Object)this.b, 0);
        this.list.addTail((Object)this.c, 8);
        this.list.addTail((Object)this.d, 1);
        this.list.addTail((Object)this.e, 7);
        this.list.addTail((Object)this.f, 2);
        this.list.addTail((Object)this.g, 6);
        this.list.addTail((Object)this.h, 3);
        this.list.addTail((Object)this.i, 5);
        this.list.addTail((Object)this.j, 4);
        Assert.assertEquals((Object)this.a, (Object)this.list.poll());
        Assert.assertEquals((Object)this.c, (Object)this.list.poll());
        Assert.assertEquals((Object)this.e, (Object)this.list.poll());
        Assert.assertEquals((Object)this.g, (Object)this.list.poll());
        Assert.assertEquals((Object)this.i, (Object)this.list.poll());
        Assert.assertEquals((Object)this.j, (Object)this.list.poll());
        Assert.assertEquals((Object)this.h, (Object)this.list.poll());
        Assert.assertEquals((Object)this.f, (Object)this.list.poll());
        Assert.assertEquals((Object)this.d, (Object)this.list.poll());
        Assert.assertEquals((Object)this.b, (Object)this.list.poll());
        Assert.assertNull((Object)this.list.poll());
        this.list.addTail((Object)this.a, 0);
        this.list.addTail((Object)this.b, 3);
        this.list.addTail((Object)this.c, 3);
        this.list.addTail((Object)this.d, 3);
        this.list.addTail((Object)this.e, 6);
        this.list.addTail((Object)this.f, 6);
        this.list.addTail((Object)this.g, 6);
        this.list.addTail((Object)this.h, 9);
        this.list.addTail((Object)this.i, 9);
        this.list.addTail((Object)this.j, 9);
        Assert.assertEquals((Object)this.h, (Object)this.list.poll());
        Assert.assertEquals((Object)this.i, (Object)this.list.poll());
        Assert.assertEquals((Object)this.j, (Object)this.list.poll());
        Assert.assertEquals((Object)this.e, (Object)this.list.poll());
        Assert.assertEquals((Object)this.f, (Object)this.list.poll());
        Assert.assertEquals((Object)this.g, (Object)this.list.poll());
        Assert.assertEquals((Object)this.b, (Object)this.list.poll());
        Assert.assertEquals((Object)this.c, (Object)this.list.poll());
        Assert.assertEquals((Object)this.d, (Object)this.list.poll());
        Assert.assertEquals((Object)this.a, (Object)this.list.poll());
        Assert.assertNull((Object)this.list.poll());
        this.list.addTail((Object)this.a, 5);
        this.list.addTail((Object)this.b, 5);
        this.list.addTail((Object)this.c, 5);
        this.list.addTail((Object)this.d, 5);
        this.list.addTail((Object)this.e, 5);
        this.list.addTail((Object)this.f, 5);
        this.list.addTail((Object)this.g, 5);
        this.list.addTail((Object)this.h, 5);
        this.list.addTail((Object)this.i, 5);
        this.list.addTail((Object)this.j, 5);
        Assert.assertEquals((Object)this.a, (Object)this.list.poll());
        Assert.assertEquals((Object)this.b, (Object)this.list.poll());
        Assert.assertEquals((Object)this.c, (Object)this.list.poll());
        Assert.assertEquals((Object)this.d, (Object)this.list.poll());
        Assert.assertEquals((Object)this.e, (Object)this.list.poll());
        Assert.assertEquals((Object)this.f, (Object)this.list.poll());
        Assert.assertEquals((Object)this.g, (Object)this.list.poll());
        Assert.assertEquals((Object)this.h, (Object)this.list.poll());
        Assert.assertEquals((Object)this.i, (Object)this.list.poll());
        Assert.assertEquals((Object)this.j, (Object)this.list.poll());
        Assert.assertNull((Object)this.list.poll());
        this.list.addTail((Object)this.j, 5);
        this.list.addTail((Object)this.i, 5);
        this.list.addTail((Object)this.h, 5);
        this.list.addTail((Object)this.g, 5);
        this.list.addTail((Object)this.f, 5);
        this.list.addTail((Object)this.e, 5);
        this.list.addTail((Object)this.d, 5);
        this.list.addTail((Object)this.c, 5);
        this.list.addTail((Object)this.b, 5);
        this.list.addTail((Object)this.a, 5);
        Assert.assertEquals((Object)this.j, (Object)this.list.poll());
        Assert.assertEquals((Object)this.i, (Object)this.list.poll());
        Assert.assertEquals((Object)this.h, (Object)this.list.poll());
        Assert.assertEquals((Object)this.g, (Object)this.list.poll());
        Assert.assertEquals((Object)this.f, (Object)this.list.poll());
        Assert.assertEquals((Object)this.e, (Object)this.list.poll());
        Assert.assertEquals((Object)this.d, (Object)this.list.poll());
        Assert.assertEquals((Object)this.c, (Object)this.list.poll());
        Assert.assertEquals((Object)this.b, (Object)this.list.poll());
        Assert.assertEquals((Object)this.a, (Object)this.list.poll());
        Assert.assertNull((Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((long)0L, (long)this.list.size());
    }

    @Test
    public void testIterator() {
        Wibble w;
        this.list.addTail((Object)this.a, 9);
        this.list.addTail((Object)this.b, 9);
        this.list.addTail((Object)this.c, 8);
        this.list.addTail((Object)this.d, 8);
        this.list.addTail((Object)this.e, 7);
        this.list.addTail((Object)this.f, 7);
        this.list.addTail((Object)this.g, 7);
        this.list.addTail((Object)this.h, 6);
        this.list.addTail((Object)this.i, 6);
        this.list.addTail((Object)this.j, 6);
        this.list.addTail((Object)this.k, 5);
        this.list.addTail((Object)this.l, 5);
        this.list.addTail((Object)this.m, 4);
        this.list.addTail((Object)this.n, 4);
        this.list.addTail((Object)this.o, 4);
        this.list.addTail((Object)this.p, 3);
        this.list.addTail((Object)this.q, 3);
        this.list.addTail((Object)this.r, 3);
        this.list.addTail((Object)this.s, 2);
        this.list.addTail((Object)this.t, 2);
        this.list.addTail((Object)this.u, 2);
        this.list.addTail((Object)this.v, 1);
        this.list.addTail((Object)this.w, 1);
        this.list.addTail((Object)this.x, 1);
        this.list.addTail((Object)this.y, 0);
        this.list.addTail((Object)this.z, 0);
        LinkedListIterator iter = this.list.iterator();
        int count = 0;
        while (iter.hasNext()) {
            w = (Wibble)iter.next();
            ++count;
        }
        Assert.assertEquals((long)26L, (long)count);
        Assert.assertEquals((long)26L, (long)this.list.size());
        iter = this.list.iterator();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)"a", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)"b", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"c", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"d", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"e", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"f", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"g", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"h", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"i", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"j", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"k", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"l", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"m", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"n", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"o", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"p", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"q", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"r", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"s", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"t", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"u", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"v", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"w", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"x", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"y", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"z", (Object)w.s);
        PriorityLinkedListTest.assertFalse((boolean)iter.hasNext());
        iter = this.list.iterator();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"a", (Object)w.s);
        iter.remove();
        Assert.assertEquals((long)25L, (long)this.list.size());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"b", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"c", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"d", (Object)w.s);
        iter.remove();
        Assert.assertEquals((long)24L, (long)this.list.size());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"c", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"e", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"f", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"g", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"h", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"i", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"j", (Object)w.s);
        iter.remove();
        Assert.assertEquals((long)23L, (long)this.list.size());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"i", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"k", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"l", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"m", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"n", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"o", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"p", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"q", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"r", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"s", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"t", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"u", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"v", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"w", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"x", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"y", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"z", (Object)w.s);
        iter.remove();
        iter = this.list.iterator();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"b", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"c", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"e", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"f", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"g", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"h", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"i", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"k", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"l", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"m", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"n", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"o", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"p", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"q", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"r", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"s", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"t", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"u", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"v", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"w", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"x", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"y", (Object)w.s);
        PriorityLinkedListTest.assertFalse((boolean)iter.hasNext());
        PriorityLinkedListTest.assertFalse((boolean)iter.hasNext());
        this.list.addTail((Object)this.a, 4);
        this.list.addTail((Object)this.b, 4);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"a", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"b", (Object)w.s);
        PriorityLinkedListTest.assertFalse((boolean)iter.hasNext());
        this.list.addTail((Object)this.c, 4);
        this.list.addTail((Object)this.d, 4);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"c", (Object)w.s);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w = (Wibble)iter.next();
        Assert.assertEquals((Object)"d", (Object)w.s);
        PriorityLinkedListTest.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIteratorPicksUpHigherPriorities() {
        this.list.addTail((Object)this.a, 4);
        this.list.addTail((Object)this.b, 4);
        this.list.addTail((Object)this.c, 4);
        LinkedListIterator iter = this.list.iterator();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.a, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.b, (Object)iter.next());
        this.list.addTail((Object)this.d, 5);
        this.list.addTail((Object)this.e, 5);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.d, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.e, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.c, (Object)iter.next());
        this.list.addTail((Object)this.f, 1);
        this.list.addTail((Object)this.g, 9);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.g, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.f, (Object)iter.next());
    }

    @Test
    public void testClear() {
        this.list.addTail((Object)this.a, 0);
        this.list.addTail((Object)this.b, 3);
        this.list.addTail((Object)this.c, 3);
        this.list.addTail((Object)this.d, 3);
        this.list.addTail((Object)this.e, 6);
        this.list.addTail((Object)this.f, 6);
        this.list.addTail((Object)this.g, 6);
        this.list.addTail((Object)this.h, 9);
        this.list.addTail((Object)this.i, 9);
        this.list.addTail((Object)this.j, 9);
        this.list.clear();
        Assert.assertNull((Object)this.list.poll());
    }

    @Test
    public void testMixupIterator() {
        this.list.addTail((Object)this.c, 5);
        this.list.addTail((Object)this.a, 4);
        this.list.addTail((Object)this.b, 4);
        LinkedListIterator iter = this.list.iterator();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.c, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.a, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.b, (Object)iter.next());
        this.list.addTail((Object)this.d, 5);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.d, (Object)iter.next());
    }

    @Test
    public void testMixupIterator2() {
        this.list.addTail((Object)this.c, 5);
        this.list.addTail((Object)this.k, 0);
        this.list.addTail((Object)this.a, 2);
        this.list.addTail((Object)this.b, 2);
        LinkedListIterator iter = this.list.iterator();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.c, (Object)iter.next());
        iter.remove();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.a, (Object)iter.next());
        iter.remove();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.b, (Object)iter.next());
        iter.remove();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.k, (Object)iter.next());
        iter.remove();
        this.list.addTail((Object)this.d, 2);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.d, (Object)iter.next());
        iter.remove();
    }

    class Wibble {
        String s;

        Wibble(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }
}

