/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.tests.util;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.Topology;
import org.hornetq.core.client.impl.TopologyMemberImpl;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.journal.PreparedTransactionInfo;
import org.hornetq.core.journal.RecordInfo;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.impl.JournalFile;
import org.hornetq.core.journal.impl.JournalImpl;
import org.hornetq.core.journal.impl.JournalReaderCallback;
import org.hornetq.core.journal.impl.NIOSequentialFileFactory;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.Bindings;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.postoffice.QueueBinding;
import org.hornetq.core.postoffice.impl.LocalQueueBinding;
import org.hornetq.core.remoting.impl.invm.InVMRegistry;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.HornetQServers;
import org.hornetq.core.server.NodeManager;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.cluster.RemoteQueueBinding;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.core.settings.impl.AddressFullMessagePolicy;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.hornetq.spi.core.security.HornetQSecurityManagerImpl;
import org.hornetq.tests.util.InVMNodeManagerServer;
import org.hornetq.tests.util.UnitTestCase;
import org.hornetq.utils.UUIDGenerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class ServiceTestBase
extends UnitTestCase {
    private static final String SEND_CALL_NUMBER = "sendCallNumber";
    protected static final long WAIT_TIMEOUT = 10000L;
    private int sendMsgCount = 0;
    private final HornetQServerLogger log = HornetQServerLogger.LOGGER;

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (InVMRegistry.instance.size() > 0) {
            ServiceTestBase.fail((String)"InVMREgistry size > 0");
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.sendMsgCount = 0;
        super.setUp();
    }

    protected void waitForNotPaging(Queue queue) throws InterruptedException {
        this.waitForNotPaging(queue.getPageSubscription().getPagingStore());
    }

    protected void waitForNotPaging(PagingStore store) throws InterruptedException {
        long timeout = System.currentTimeMillis() + 10000L;
        while (timeout > System.currentTimeMillis() && store.isPaging()) {
            Thread.sleep(100L);
        }
        ServiceTestBase.assertFalse((boolean)store.isPaging());
    }

    protected Topology waitForTopology(HornetQServer server, int nodes) throws Exception {
        return this.waitForTopology(server, nodes, -1, 10000L);
    }

    protected Topology waitForTopology(HornetQServer server, int nodes, int backups) throws Exception {
        return this.waitForTopology(server, nodes, backups, 10000L);
    }

    protected Topology waitForTopology(HornetQServer server, int liveNodes, int backupNodes, long timeout) throws Exception {
        HornetQServerLogger.LOGGER.debug((Object)("waiting for " + liveNodes + " on the topology for server = " + server));
        long start = System.currentTimeMillis();
        Set ccs = server.getClusterManager().getClusterConnections();
        if (ccs.size() != 1) {
            throw new IllegalStateException("You need a single cluster connection on this version of waitForTopology on ServiceTestBase");
        }
        Topology topology = server.getClusterManager().getDefaultConnection(null).getTopology();
        int liveNodesCount = 0;
        int backupNodesCount = 0;
        do {
            liveNodesCount = 0;
            backupNodesCount = 0;
            for (TopologyMemberImpl member : topology.getMembers()) {
                if (member.getLive() != null) {
                    ++liveNodesCount;
                }
                if (member.getBackup() == null) continue;
                ++backupNodesCount;
            }
            if (!(liveNodes != -1 && liveNodes != liveNodesCount || backupNodes != -1 && backupNodes != backupNodesCount)) {
                return topology;
            }
            Thread.sleep(10L);
        } while (System.currentTimeMillis() - start < timeout);
        String msg = "Timed out waiting for cluster topology of live=" + liveNodes + ",backup=" + backupNodes + " (received live=" + liveNodesCount + ", backup=" + backupNodesCount + ") topology = " + topology.describe() + ")";
        HornetQServerLogger.LOGGER.error((Object)msg);
        throw new Exception(msg);
    }

    protected void waitForTopology(HornetQServer server, String clusterConnectionName, int nodes, long timeout) throws Exception {
        HornetQServerLogger.LOGGER.debug((Object)("waiting for " + nodes + " on the topology for server = " + server));
        long start = System.currentTimeMillis();
        ClusterConnection clusterConnection = server.getClusterManager().getClusterConnection(clusterConnectionName);
        Topology topology = clusterConnection.getTopology();
        do {
            if (nodes == topology.getMembers().size()) {
                return;
            }
            Thread.sleep(10L);
        } while (System.currentTimeMillis() - start < timeout);
        String msg = "Timed out waiting for cluster topology of " + nodes + " (received " + topology.getMembers().size() + ") topology = " + topology + ")";
        HornetQServerLogger.LOGGER.error((Object)msg);
        throw new Exception(msg);
    }

    protected static final void waitForComponent(HornetQComponent component, long seconds) throws InterruptedException {
        long time = System.currentTimeMillis();
        long toWait = seconds * 1000L;
        while (!component.isStarted()) {
            Thread.sleep(50L);
            if (System.currentTimeMillis() <= time + toWait) continue;
            ServiceTestBase.fail((String)("component did not start within timeout of " + seconds));
        }
    }

    protected static final Map<String, Object> generateParams(int node, boolean netty) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (netty) {
            params.put("port", 5445 + node);
        } else {
            params.put("server-id", node);
        }
        return params;
    }

    protected static final TransportConfiguration getNettyAcceptorTransportConfiguration(boolean live) {
        if (live) {
            return new TransportConfiguration(NETTY_ACCEPTOR_FACTORY);
        }
        HashMap<String, Integer> server1Params = new HashMap<String, Integer>();
        server1Params.put("port", 5446);
        return new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, server1Params);
    }

    protected static final TransportConfiguration getNettyConnectorTransportConfiguration(boolean live) {
        if (live) {
            return new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        }
        HashMap<String, Integer> server1Params = new HashMap<String, Integer>();
        server1Params.put("port", 5446);
        return new TransportConfiguration(NETTY_CONNECTOR_FACTORY, server1Params);
    }

    protected static final TransportConfiguration createTransportConfiguration(boolean netty, boolean acceptor, Map<String, Object> params) {
        String className = netty ? (acceptor ? NETTY_ACCEPTOR_FACTORY : NETTY_CONNECTOR_FACTORY) : (acceptor ? INVM_ACCEPTOR_FACTORY : INVM_CONNECTOR_FACTORY);
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        return new TransportConfiguration(className, params);
    }

    public ServiceTestBase() {
    }

    public ServiceTestBase(String name) {
        super(name);
    }

    protected void waitForServer(HornetQServer server) throws InterruptedException {
        if (server == null) {
            return;
        }
        long wait = 5000L;
        long timetowait = System.currentTimeMillis() + 5000L;
        while (!server.isStarted() && System.currentTimeMillis() < timetowait) {
            Thread.sleep(50L);
        }
        if (!server.isStarted()) {
            this.log.info((Object)ServiceTestBase.threadDump("Server didn't start"));
            ServiceTestBase.fail((String)("server didnt start: " + server));
        }
        if (!server.getConfiguration().isBackup() && !server.waitForActivation(5000L, TimeUnit.MILLISECONDS)) {
            ServiceTestBase.fail((String)("Server didn't initialize: " + server));
        }
    }

    public static final void waitForRemoteBackupSynchronization(HornetQServer backup) {
        ServiceTestBase.waitForRemoteBackup(null, 10, true, backup);
    }

    public static final void waitForRemoteBackup(ClientSessionFactoryInternal sessionFactory, int seconds, boolean waitForSync, HornetQServer backup) {
        HornetQServerImpl actualServer = (HornetQServerImpl)backup;
        long toWait = seconds * 1000;
        long time = System.currentTimeMillis();
        while (sessionFactory != null && sessionFactory.getBackupConnector() == null || !actualServer.isRemoteBackupUpToDate() && waitForSync) {
            if (System.currentTimeMillis() > time + toWait) {
                ServiceTestBase.fail((String)("backup started? (" + actualServer.isStarted() + "). Finished synchronizing (" + actualServer.isRemoteBackupUpToDate() + "). SessionFactory!=null ? " + (sessionFactory != null) + " || sessionFactory.getBackupConnector()==" + (sessionFactory != null ? sessionFactory.getBackupConnector() : "not-applicable")));
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                ServiceTestBase.fail((String)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final HornetQServer createServer(boolean realFiles, Configuration configuration, int pageSize, int maxAddressSize, Map<String, AddressSettings> settings, MBeanServer mbeanServer) {
        HornetQServer server = realFiles ? HornetQServers.newHornetQServer((Configuration)configuration, (MBeanServer)mbeanServer, (boolean)true) : HornetQServers.newHornetQServer((Configuration)configuration, (MBeanServer)mbeanServer, (boolean)false);
        try {
            for (Map.Entry<String, AddressSettings> setting : settings.entrySet()) {
                server.getAddressSettingsRepository().addMatch(setting.getKey(), (Object)setting.getValue());
            }
            AddressSettings defaultSetting = new AddressSettings();
            defaultSetting.setPageSizeBytes((long)pageSize);
            defaultSetting.setMaxSizeBytes((long)maxAddressSize);
            server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
            HornetQServer hornetQServer = server;
            return hornetQServer;
        }
        finally {
            this.addServer(server);
        }
    }

    protected final HornetQServer createServer(boolean realFiles, Configuration configuration, int pageSize, int maxAddressSize, Map<String, AddressSettings> settings) {
        return this.createServer(realFiles, configuration, pageSize, maxAddressSize, AddressFullMessagePolicy.PAGE, settings);
    }

    protected final HornetQServer createServer(boolean realFiles, Configuration configuration, int pageSize, int maxAddressSize, AddressFullMessagePolicy fullPolicy, Map<String, AddressSettings> settings) {
        HornetQServer server = this.addServer(HornetQServers.newHornetQServer((Configuration)configuration, (boolean)realFiles));
        if (settings != null) {
            for (Map.Entry<String, AddressSettings> setting : settings.entrySet()) {
                server.getAddressSettingsRepository().addMatch(setting.getKey(), (Object)setting.getValue());
            }
        }
        AddressSettings defaultSetting = new AddressSettings();
        defaultSetting.setPageSizeBytes((long)pageSize);
        defaultSetting.setMaxSizeBytes((long)maxAddressSize);
        defaultSetting.setAddressFullMessagePolicy(fullPolicy);
        server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        return server;
    }

    protected final HornetQServer createServer(boolean realFiles, Configuration conf, MBeanServer mbeanServer) {
        return this.createServer(realFiles, conf, mbeanServer, new HashMap<String, AddressSettings>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final HornetQServer createServer(boolean realFiles, Configuration configuration, MBeanServer mbeanServer, Map<String, AddressSettings> settings) {
        HornetQServer server = realFiles ? HornetQServers.newHornetQServer((Configuration)configuration, (MBeanServer)mbeanServer) : HornetQServers.newHornetQServer((Configuration)configuration, (MBeanServer)mbeanServer, (boolean)false);
        try {
            for (Map.Entry<String, AddressSettings> setting : settings.entrySet()) {
                server.getAddressSettingsRepository().addMatch(setting.getKey(), (Object)setting.getValue());
            }
            AddressSettings defaultSetting = new AddressSettings();
            server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
            HornetQServer hornetQServer = server;
            return hornetQServer;
        }
        finally {
            this.addServer(server);
        }
    }

    protected final HornetQServer createServer(boolean realFiles) throws Exception {
        return this.createServer(realFiles, false);
    }

    protected final HornetQServer createServer(boolean realFiles, boolean netty) throws Exception {
        return this.createServer(realFiles, this.createDefaultConfig(netty), -1, -1, new HashMap<String, AddressSettings>());
    }

    protected HornetQServer createServer(boolean realFiles, Configuration configuration) {
        return this.createServer(realFiles, configuration, -1, -1, new HashMap<String, AddressSettings>());
    }

    protected final HornetQServer createServer(Configuration configuration) {
        return this.createServer(configuration.isPersistenceEnabled(), configuration, -1, -1, new HashMap<String, AddressSettings>());
    }

    protected HornetQServer createInVMFailoverServer(boolean realFiles, Configuration configuration, NodeManager nodeManager, int id) {
        return this.createInVMFailoverServer(realFiles, configuration, -1, -1, new HashMap<String, AddressSettings>(), nodeManager, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HornetQServer createInVMFailoverServer(boolean realFiles, Configuration configuration, int pageSize, int maxAddressSize, Map<String, AddressSettings> settings, NodeManager nodeManager, int id) {
        HornetQSecurityManagerImpl securityManager = new HornetQSecurityManagerImpl();
        configuration.setPersistenceEnabled(realFiles);
        InVMNodeManagerServer server = new InVMNodeManagerServer(configuration, ManagementFactory.getPlatformMBeanServer(), (HornetQSecurityManager)securityManager, nodeManager);
        try {
            server.setIdentity("Server " + id);
            for (Map.Entry<String, AddressSettings> setting : settings.entrySet()) {
                server.getAddressSettingsRepository().addMatch(setting.getKey(), (Object)setting.getValue());
            }
            AddressSettings defaultSetting = new AddressSettings();
            defaultSetting.setPageSizeBytes((long)pageSize);
            defaultSetting.setMaxSizeBytes((long)maxAddressSize);
            server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
            InVMNodeManagerServer inVMNodeManagerServer = server;
            return inVMNodeManagerServer;
        }
        finally {
            this.addServer((HornetQServer)server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HornetQServer createServer(boolean realFiles, Configuration configuration, HornetQSecurityManager securityManager) {
        HornetQServer server = realFiles ? HornetQServers.newHornetQServer((Configuration)configuration, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (HornetQSecurityManager)securityManager) : HornetQServers.newHornetQServer((Configuration)configuration, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (HornetQSecurityManager)securityManager, (boolean)false);
        try {
            HashMap settings = new HashMap();
            for (Map.Entry setting : settings.entrySet()) {
                server.getAddressSettingsRepository().addMatch((String)setting.getKey(), setting.getValue());
            }
            AddressSettings defaultSetting = new AddressSettings();
            server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
            HornetQServer hornetQServer = server;
            return hornetQServer;
        }
        finally {
            this.addServer(server);
        }
    }

    protected HornetQServer createClusteredServerWithParams(boolean isNetty, int index, boolean realFiles, Map<String, Object> params) throws Exception {
        String acceptor = isNetty ? NETTY_ACCEPTOR_FACTORY : INVM_ACCEPTOR_FACTORY;
        return this.createServer(realFiles, this.createDefaultConfig(index, params, acceptor), -1, -1, new HashMap<String, AddressSettings>());
    }

    protected HornetQServer createClusteredServerWithParams(boolean isNetty, int index, boolean realFiles, int pageSize, int maxAddressSize, Map<String, Object> params) throws Exception {
        if (isNetty) {
            return this.createServer(realFiles, this.createDefaultConfig(index, params, NETTY_ACCEPTOR_FACTORY), pageSize, maxAddressSize, new HashMap<String, AddressSettings>());
        }
        return this.createServer(realFiles, this.createDefaultConfig(index, params, INVM_ACCEPTOR_FACTORY), -1, -1, new HashMap<String, AddressSettings>());
    }

    protected ServerLocator createFactory(boolean isNetty) throws Exception {
        if (isNetty) {
            return this.createNettyNonHALocator();
        }
        return this.createInVMNonHALocator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createQueue(String address, String queue) throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = locator.createSessionFactory();
        ClientSession session = sf.createSession();
        try {
            session.createQueue(address, queue);
        }
        finally {
            session.close();
            ServiceTestBase.closeSessionFactory(sf);
            ServiceTestBase.closeServerLocator(locator);
        }
    }

    protected final ServerLocator createInVMLocator(int serverID) {
        TransportConfiguration tnspConfig = this.createInVMTransportConnectorConfig(serverID, UUIDGenerator.getInstance().generateStringUUID());
        ServerLocator locator = HornetQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{tnspConfig});
        return this.addServerLocator(locator);
    }

    protected final TransportConfiguration createInVMTransportConnectorConfig(int serverID, String name) {
        HashMap<String, Integer> server1Params = new HashMap<String, Integer>();
        if (serverID != 0) {
            server1Params.put("server-id", serverID);
        }
        TransportConfiguration tnspConfig = new TransportConfiguration(INVM_CONNECTOR_FACTORY, server1Params, name);
        return tnspConfig;
    }

    public String getTextMessage(ClientMessage m) {
        m.getBodyBuffer().resetReaderIndex();
        return m.getBodyBuffer().readString();
    }

    protected ClientMessage createBytesMessage(ClientSession session, byte type, byte[] b, boolean durable) {
        ClientMessage message = session.createMessage(type, durable, 0L, System.currentTimeMillis(), (byte)1);
        message.getBodyBuffer().writeBytes(b);
        return message;
    }

    protected void setBody(int i, ClientMessage message) {
        message.getBodyBuffer().writeString("message" + i);
    }

    protected void assertMessageBody(int i, ClientMessage message) {
        Assert.assertEquals((String)message.toString(), (Object)("message" + i), (Object)message.getBodyBuffer().readString());
    }

    public final void sendMessages(ClientSession session, ClientProducer producer, int numMessages) throws HornetQException {
        for (int i = 0; i < numMessages; ++i) {
            producer.send((Message)this.createMessage(session, i, true));
        }
    }

    protected final ClientMessage createMessage(ClientSession session, int counter, boolean durable) throws HornetQException {
        ClientMessage message = session.createMessage(durable);
        this.setBody(counter, message);
        message.putIntProperty("counter", counter);
        message.putIntProperty(SEND_CALL_NUMBER, this.sendMsgCount++);
        return message;
    }

    protected final void receiveMessages(ClientConsumer consumer, int start, int msgCount, boolean ack) throws HornetQException {
        for (int i = start; i < msgCount; ++i) {
            ClientMessage message = consumer.receive(1000L);
            Assert.assertNotNull((String)("Expecting a message " + i), (Object)message);
            Object prop = message.getObjectProperty(SEND_CALL_NUMBER);
            if (prop == null) {
                prop = -1;
            }
            int actual = message.getIntProperty("counter");
            Assert.assertEquals((String)("expected=" + i + ". Got: property['counter']=" + actual + " sendNumber=" + prop), (long)i, (long)actual);
            this.assertMessageBody(i, message);
            if (!ack) continue;
            message.acknowledge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pair<List<RecordInfo>, List<PreparedTransactionInfo>> loadMessageJournal(Configuration config) throws Exception {
        JournalImpl messagesJournal = null;
        try {
            NIOSequentialFileFactory messagesFF = new NIOSequentialFileFactory(this.getJournalDir(), null);
            messagesJournal = new JournalImpl(config.getJournalFileSize(), config.getJournalMinFiles(), 0, 0, (SequentialFileFactory)messagesFF, "hornetq-data", "hq", 1);
            LinkedList committedRecords = new LinkedList();
            LinkedList preparedTransactions = new LinkedList();
            messagesJournal.start();
            messagesJournal.load(committedRecords, preparedTransactions, null, false);
            Pair pair = new Pair(committedRecords, preparedTransactions);
            return pair;
        }
        finally {
            try {
                if (messagesJournal != null) {
                    messagesJournal.stop();
                }
            }
            catch (Throwable ignored) {}
        }
    }

    protected HashMap<Integer, AtomicInteger> countJournal(Configuration config) throws Exception {
        HashMap<Integer, AtomicInteger> recordsType = new HashMap<Integer, AtomicInteger>();
        NIOSequentialFileFactory messagesFF = new NIOSequentialFileFactory(this.getJournalDir(), null);
        JournalImpl messagesJournal = new JournalImpl(config.getJournalFileSize(), config.getJournalMinFiles(), 0, 0, (SequentialFileFactory)messagesFF, "hornetq-data", "hq", 1);
        List filesToRead = messagesJournal.orderFiles();
        for (JournalFile file : filesToRead) {
            JournalImpl.readJournalFile((SequentialFileFactory)messagesFF, (JournalFile)file, (JournalReaderCallback)new RecordTypeCounter(recordsType));
        }
        return recordsType;
    }

    protected HashMap<Integer, AtomicInteger> countJournalLivingRecords(Configuration config) throws Exception {
        HashMap<Integer, AtomicInteger> recordsType = new HashMap<Integer, AtomicInteger>();
        NIOSequentialFileFactory messagesFF = new NIOSequentialFileFactory(this.getJournalDir(), null);
        JournalImpl messagesJournal = new JournalImpl(config.getJournalFileSize(), config.getJournalMinFiles(), 0, 0, (SequentialFileFactory)messagesFF, "hornetq-data", "hq", 1);
        messagesJournal.start();
        LinkedList committedRecords = new LinkedList();
        LinkedList preparedTransactions = new LinkedList();
        messagesJournal.load(committedRecords, preparedTransactions, null, false);
        for (RecordInfo info : committedRecords) {
            Integer ikey = new Integer(info.getUserRecordType());
            AtomicInteger value = recordsType.get(ikey);
            if (value == null) {
                value = new AtomicInteger();
                recordsType.put(ikey, value);
            }
            value.incrementAndGet();
        }
        messagesJournal.stop();
        return recordsType;
    }

    protected boolean waitForBindings(HornetQServer server, String address, boolean local, int expectedBindingCount, int expectedConsumerCount, long timeout) throws Exception, InterruptedException {
        PostOffice po = server.getPostOffice();
        long start = System.currentTimeMillis();
        int bindingCount = 0;
        int totConsumers = 0;
        do {
            bindingCount = 0;
            totConsumers = 0;
            Bindings bindings = po.getBindingsForAddress(new SimpleString(address));
            for (Binding binding : bindings.getBindings()) {
                if ((!(binding instanceof LocalQueueBinding) || !local) && (!(binding instanceof RemoteQueueBinding) || local)) continue;
                QueueBinding qBinding = (QueueBinding)binding;
                ++bindingCount;
                totConsumers += qBinding.consumerCount();
            }
            if (bindingCount == expectedBindingCount && totConsumers == expectedConsumerCount) {
                return true;
            }
            Thread.sleep(10L);
        } while (System.currentTimeMillis() - start < timeout);
        String msg = "Timed out waiting for bindings (bindingCount = " + bindingCount + " (expecting " + expectedBindingCount + ") " + ", totConsumers = " + totConsumers + " (expecting " + expectedConsumerCount + ")" + ")";
        this.log.error((Object)msg);
        return false;
    }

    protected void validateNoFilesOnLargeDir(int expect) throws Exception {
        File largeMessagesFileDir = new File(this.getLargeMessagesDir());
        long timeout = System.currentTimeMillis() + 5000L;
        while (timeout > System.currentTimeMillis() && largeMessagesFileDir.listFiles().length != expect) {
            Thread.sleep(100L);
        }
        if (expect != largeMessagesFileDir.listFiles().length) {
            for (File file : largeMessagesFileDir.listFiles()) {
                System.out.println("File " + file + " still on ");
            }
        }
        Assert.assertEquals((long)expect, (long)largeMessagesFileDir.listFiles().length);
    }

    protected void validateNoFilesOnLargeDir() throws Exception {
        this.validateNoFilesOnLargeDir(0);
    }

    private static final class RecordTypeCounter
    implements JournalReaderCallback {
        private final HashMap<Integer, AtomicInteger> recordsType;

        public RecordTypeCounter(HashMap<Integer, AtomicInteger> recordsType) {
            this.recordsType = recordsType;
        }

        AtomicInteger getType(byte key) {
            Integer ikey;
            AtomicInteger value;
            if (key == 0) {
                System.out.println("huh?");
            }
            if ((value = this.recordsType.get(ikey = new Integer(key))) == null) {
                value = new AtomicInteger();
                this.recordsType.put(ikey, value);
            }
            return value;
        }

        public void onReadUpdateRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
            this.getType(recordInfo.getUserRecordType()).incrementAndGet();
        }

        public void onReadUpdateRecord(RecordInfo recordInfo) throws Exception {
            this.getType(recordInfo.getUserRecordType()).incrementAndGet();
        }

        public void onReadAddRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
            this.getType(recordInfo.getUserRecordType()).incrementAndGet();
        }

        public void onReadAddRecord(RecordInfo recordInfo) throws Exception {
            this.getType(recordInfo.getUserRecordType()).incrementAndGet();
        }

        public void onReadRollbackRecord(long transactionID) throws Exception {
        }

        public void onReadPrepareRecord(long transactionID, byte[] extraData, int numberOfRecords) throws Exception {
        }

        public void onReadDeleteRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
        }

        public void onReadDeleteRecord(long recordID) throws Exception {
        }

        public void onReadCommitRecord(long transactionID, int numberOfRecords) throws Exception {
        }

        public void markAsDataFile(JournalFile file0) {
        }
    }
}

