/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.hornetq.api.core.BroadcastGroupConfiguration;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.config.BridgeConfiguration;
import org.hornetq.core.config.ClusterConnectionConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.ConfigurationUtils;
import org.hornetq.core.filter.impl.FilterImpl;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.wireformat.BackupRegistrationMessage;
import org.hornetq.core.protocol.core.impl.wireformat.HornetQExceptionMessage;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.NodeManager;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.cluster.Bridge;
import org.hornetq.core.server.cluster.BroadcastGroup;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.cluster.Transformer;
import org.hornetq.core.server.cluster.impl.BridgeImpl;
import org.hornetq.core.server.cluster.impl.BroadcastGroupImpl;
import org.hornetq.core.server.cluster.impl.ClusterConnectionImpl;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.FutureLatch;

public final class ClusterManager
implements HornetQComponent {
    private final Map<String, BroadcastGroup> broadcastGroups = new HashMap<String, BroadcastGroup>();
    private final Map<String, Bridge> bridges = new HashMap<String, Bridge>();
    private final ExecutorFactory executorFactory;
    private final HornetQServer server;
    private final PostOffice postOffice;
    private final ScheduledExecutorService scheduledExecutor;
    private ClusterConnection defaultClusterConnection;
    private final ManagementService managementService;
    private final Configuration configuration;
    private final ExecutorService threadPool;
    private volatile State state = State.STOPPED;
    private volatile boolean backup;
    private final Map<String, ClusterConnection> clusterConnections = new HashMap<String, ClusterConnection>();
    private final Set<ServerLocatorInternal> clusterLocators = new ConcurrentHashSet();
    private final Executor executor;
    private final NodeManager nodeManager;

    public ClusterManager(ExecutorFactory executorFactory, HornetQServer server, PostOffice postOffice, ScheduledExecutorService scheduledExecutor, ManagementService managementService, Configuration configuration, NodeManager nodeManager, boolean backup, ExecutorService threadPool) {
        this.executorFactory = executorFactory;
        this.executor = executorFactory.getExecutor();
        this.server = server;
        this.postOffice = postOffice;
        this.scheduledExecutor = scheduledExecutor;
        this.managementService = managementService;
        this.configuration = configuration;
        this.nodeManager = nodeManager;
        this.backup = backup;
        this.threadPool = threadPool;
    }

    public String describe() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println("Information on " + this);
        out.println("*******************************************************");
        for (ClusterConnection conn : this.cloneClusterConnections()) {
            out.println(conn.describe());
        }
        out.println("*******************************************************");
        return str.toString();
    }

    public ClusterConnection getDefaultConnection(TransportConfiguration acceptorConfig) {
        if (acceptorConfig == null) {
            return this.defaultClusterConnection;
        }
        if (this.defaultClusterConnection != null && this.defaultClusterConnection.getConnector().isEquivalent(acceptorConfig)) {
            return this.defaultClusterConnection;
        }
        for (ClusterConnection conn : this.cloneClusterConnections()) {
            if (!conn.getConnector().isEquivalent(acceptorConfig)) continue;
            return conn;
        }
        return null;
    }

    public String toString() {
        return "ClusterManagerImpl[server=" + this.server + "]@" + System.identityHashCode(this);
    }

    public String getNodeId() {
        return this.nodeManager.getNodeId().toString();
    }

    public String getNodeGroupName() {
        return this.configuration.getBackupGroupName();
    }

    public synchronized void deploy() throws Exception {
        if (this.state != State.STOPPED) {
            throw new IllegalStateException();
        }
        this.state = State.DEPLOYED;
        for (BroadcastGroupConfiguration broadcastGroupConfiguration : this.configuration.getBroadcastGroupConfigurations()) {
            this.deployBroadcastGroup(broadcastGroupConfiguration);
        }
        for (ClusterConnectionConfiguration clusterConnectionConfiguration : this.configuration.getClusterConfigurations()) {
            this.deployClusterConnection(clusterConnectionConfiguration);
        }
    }

    public synchronized void start() throws Exception {
        if (this.state == State.STARTED) {
            return;
        }
        for (BroadcastGroup group : this.broadcastGroups.values()) {
            if (this.backup) continue;
            group.start();
        }
        for (ClusterConnection conn : this.clusterConnections.values()) {
            conn.start();
            if (!this.backup || !this.configuration.isSharedStore()) continue;
            conn.informTopology();
            conn.announceBackup();
        }
        this.deployConfiguredBridges();
        this.state = State.STARTED;
    }

    private final void deployConfiguredBridges() throws Exception {
        if (this.backup) {
            return;
        }
        for (BridgeConfiguration config : this.configuration.getBridgeConfigurations()) {
            this.deployBridge(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        ClusterManager clusterManager = this;
        synchronized (clusterManager) {
            if (this.state == State.STOPPED || this.state == State.STOPPING) {
                return;
            }
            this.state = State.STOPPING;
            for (BroadcastGroup group : this.broadcastGroups.values()) {
                group.stop();
                this.managementService.unregisterBroadcastGroup(group.getName());
            }
            this.broadcastGroups.clear();
            for (ClusterConnection clusterConnection : this.clusterConnections.values()) {
                clusterConnection.stop();
                this.managementService.unregisterCluster(clusterConnection.getName().toString());
            }
            for (Bridge bridge : this.bridges.values()) {
                bridge.stop();
                this.managementService.unregisterBridge(bridge.getName().toString());
            }
            this.bridges.clear();
        }
        for (ServerLocatorInternal clusterLocator : this.clusterLocators) {
            try {
                clusterLocator.close();
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.errorClosingServerLocator(e, clusterLocator);
            }
        }
        this.clusterLocators.clear();
        this.state = State.STOPPED;
        this.clearClusterConnections();
    }

    public void flushExecutor() {
        FutureLatch future = new FutureLatch();
        this.executor.execute((Runnable)future);
        if (!future.await(10000L)) {
            this.server.threadDump("Couldn't flush ClusterManager executor (" + this + ") in 10 seconds, verify your thread pool size");
        }
    }

    public boolean isStarted() {
        return this.state == State.STARTED;
    }

    public Map<String, Bridge> getBridges() {
        return new HashMap<String, Bridge>(this.bridges);
    }

    public Set<ClusterConnection> getClusterConnections() {
        return new HashSet<ClusterConnection>(this.clusterConnections.values());
    }

    public Set<BroadcastGroup> getBroadcastGroups() {
        return new HashSet<BroadcastGroup>(this.broadcastGroups.values());
    }

    public ClusterConnection getClusterConnection(String name) {
        return this.clusterConnections.get(name);
    }

    public synchronized void activate() throws Exception {
        if (this.state != State.STARTED && this.state != State.DEPLOYED) {
            return;
        }
        if (this.backup) {
            this.backup = false;
            this.deployConfiguredBridges();
            for (BroadcastGroup broadcastGroup : this.broadcastGroups.values()) {
                try {
                    broadcastGroup.start();
                }
                catch (Exception e) {
                    HornetQServerLogger.LOGGER.unableToStartBroadcastGroup(e, broadcastGroup.getName());
                }
            }
            for (ClusterConnection clusterConnection : this.clusterConnections.values()) {
                try {
                    clusterConnection.activate();
                }
                catch (Exception e) {
                    HornetQServerLogger.LOGGER.unableToStartClusterConnection(e, clusterConnection.getName());
                }
            }
            for (Bridge bridge : this.bridges.values()) {
                try {
                    bridge.start();
                }
                catch (Exception e) {
                    HornetQServerLogger.LOGGER.unableToStartBridge(e, bridge.getName());
                }
            }
        }
    }

    public void announceBackup() {
        for (ClusterConnection conn : this.cloneClusterConnections()) {
            conn.announceBackup();
        }
    }

    public void announceReplicatingBackupToLive(Channel liveChannel, boolean attemptingFailBack) throws HornetQException {
        ClusterConnectionConfiguration config = ConfigurationUtils.getReplicationClusterConfiguration(this.configuration);
        if (config == null) {
            HornetQServerLogger.LOGGER.announceBackupNoClusterConnections();
            throw new HornetQException("lacking cluster connection");
        }
        TransportConfiguration connector = this.configuration.getConnectorConfigurations().get(config.getConnectorName());
        if (connector == null) {
            HornetQServerLogger.LOGGER.announceBackupNoConnector(config.getConnectorName());
            throw new HornetQException("lacking cluster connection");
        }
        liveChannel.send((Packet)new BackupRegistrationMessage(connector, this.configuration.getClusterUser(), this.configuration.getClusterPassword(), attemptingFailBack));
    }

    public void removeClusterLocator(ServerLocatorInternal serverLocator) {
        this.clusterLocators.remove(serverLocator);
    }

    public synchronized void deployBridge(BridgeConfiguration config) throws Exception {
        ServerLocatorInternal serverLocator;
        if (config.getName() == null) {
            HornetQServerLogger.LOGGER.bridgeNotUnique();
            return;
        }
        if (config.getQueueName() == null) {
            HornetQServerLogger.LOGGER.bridgeNoQueue(config.getName());
            return;
        }
        if (config.getForwardingAddress() == null) {
            HornetQServerLogger.LOGGER.bridgeNoForwardAddress(config.getName());
        }
        if (this.bridges.containsKey(config.getName())) {
            HornetQServerLogger.LOGGER.bridgeAlreadyDeployed(config.getName());
            return;
        }
        Transformer transformer = this.instantiateTransformer(config.getTransformerClassName());
        Binding binding = this.postOffice.getBinding(new SimpleString(config.getQueueName()));
        if (binding == null) {
            HornetQServerLogger.LOGGER.bridgeQueueNotFound(config.getQueueName(), config.getName());
            return;
        }
        Queue queue = (Queue)binding.getBindable();
        if (config.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration discoveryGroupConfiguration = this.configuration.getDiscoveryGroupConfigurations().get(config.getDiscoveryGroupName());
            if (discoveryGroupConfiguration == null) {
                HornetQServerLogger.LOGGER.bridgeNoDiscoveryGroup(config.getDiscoveryGroupName());
                return;
            }
            serverLocator = config.isHA() ? (ServerLocatorInternal)HornetQClient.createServerLocatorWithHA((DiscoveryGroupConfiguration)discoveryGroupConfiguration) : (ServerLocatorInternal)HornetQClient.createServerLocatorWithoutHA((DiscoveryGroupConfiguration)discoveryGroupConfiguration);
        } else {
            TransportConfiguration[] tcConfigs = this.connectorNameListToArray(config.getStaticConnectors());
            if (tcConfigs == null) {
                HornetQServerLogger.LOGGER.bridgeCantFindConnectors(config.getName());
                return;
            }
            serverLocator = config.isHA() ? (ServerLocatorInternal)HornetQClient.createServerLocatorWithHA((TransportConfiguration[])tcConfigs) : (ServerLocatorInternal)HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])tcConfigs);
        }
        if (config.getForwardingAddress() != null) {
            AddressSettings addressConfig = this.configuration.getAddressesSettings().get(config.getForwardingAddress());
            if (addressConfig == null) {
                HornetQServerLogger.LOGGER.bridgeCantFindAddressConfig(config.getName(), config.getForwardingAddress());
            } else {
                int windowSize = config.getConfirmationWindowSize();
                long maxBytes = addressConfig.getMaxSizeBytes();
                if (maxBytes != -1L && maxBytes < (long)windowSize) {
                    HornetQServerLogger.LOGGER.bridgeConfirmationWindowTooSmall(config.getName(), config.getForwardingAddress(), windowSize, maxBytes);
                }
            }
        }
        serverLocator.setIdentity("Bridge " + config.getName());
        serverLocator.setConfirmationWindowSize(config.getConfirmationWindowSize());
        serverLocator.setReconnectAttempts(0);
        serverLocator.setInitialConnectAttempts(0);
        serverLocator.setRetryInterval(config.getRetryInterval());
        serverLocator.setMaxRetryInterval(config.getMaxRetryInterval());
        serverLocator.setRetryIntervalMultiplier(config.getRetryIntervalMultiplier());
        serverLocator.setClientFailureCheckPeriod(config.getClientFailureCheckPeriod());
        serverLocator.setBlockOnDurableSend(!config.isUseDuplicateDetection());
        serverLocator.setBlockOnNonDurableSend(!config.isUseDuplicateDetection());
        serverLocator.setMinLargeMessageSize(config.getMinLargeMessageSize());
        serverLocator.setProducerWindowSize(-1);
        serverLocator.setCallTimeout(config.getCallTimeout());
        serverLocator.addIncomingInterceptor((Interceptor)new IncomingInterceptorLookingForExceptionMessage(this, this.executor));
        if (!config.isUseDuplicateDetection()) {
            HornetQServerLogger.LOGGER.debug("Bridge " + config.getName() + " is configured to not use duplicate detecion, it will send messages synchronously");
        }
        this.clusterLocators.add(serverLocator);
        BridgeImpl bridge = new BridgeImpl(serverLocator, config.getReconnectAttempts(), config.getReconnectAttemptsOnSameNode(), config.getRetryInterval(), config.getRetryIntervalMultiplier(), config.getMaxRetryInterval(), this.nodeManager.getUUID(), new SimpleString(config.getName()), queue, this.executorFactory.getExecutor(), FilterImpl.createFilter(config.getFilterString()), SimpleString.toSimpleString((String)config.getForwardingAddress()), this.scheduledExecutor, transformer, config.isUseDuplicateDetection(), config.getUser(), config.getPassword(), !this.backup, this.server.getStorageManager());
        this.bridges.put(config.getName(), bridge);
        this.managementService.registerBridge(bridge, config);
        bridge.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyBridge(String name) throws Exception {
        Bridge bridge;
        ClusterManager clusterManager = this;
        synchronized (clusterManager) {
            bridge = this.bridges.remove(name);
            if (bridge != null) {
                bridge.stop();
                this.managementService.unregisterBridge(name);
            }
        }
        if (bridge != null) {
            bridge.flushExecutor();
        }
    }

    public void clear() {
        for (Bridge bridge : this.bridges.values()) {
            try {
                bridge.stop();
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.warn(e.getMessage(), e);
            }
        }
        this.bridges.clear();
        for (ClusterConnection clusterConnection : this.clusterConnections.values()) {
            try {
                clusterConnection.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.clearClusterConnections();
    }

    private void clearClusterConnections() {
        this.clusterConnections.clear();
        this.defaultClusterConnection = null;
    }

    private void deployClusterConnection(ClusterConnectionConfiguration config) throws Exception {
        ClusterConnectionImpl clusterConnection;
        if (config.getName() == null) {
            HornetQServerLogger.LOGGER.clusterConnectionNotUnique();
            return;
        }
        if (config.getAddress() == null) {
            HornetQServerLogger.LOGGER.clusterConnectionNoForwardAddress();
            return;
        }
        TransportConfiguration connector = this.configuration.getConnectorConfigurations().get(config.getConnectorName());
        if (connector == null) {
            HornetQServerLogger.LOGGER.clusterConnectionNoConnector(config.getConnectorName());
            return;
        }
        if (this.clusterConnections.containsKey(config.getName())) {
            HornetQServerLogger.LOGGER.clusterConnectionAlreadyExists(config.getConnectorName());
            return;
        }
        if (config.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration dg = this.configuration.getDiscoveryGroupConfigurations().get(config.getDiscoveryGroupName());
            if (dg == null) {
                HornetQServerLogger.LOGGER.clusterConnectionNoDiscoveryGroup(config.getDiscoveryGroupName());
                return;
            }
            if (HornetQServerLogger.LOGGER.isDebugEnabled()) {
                HornetQServerLogger.LOGGER.debug(this + " Starting a Discovery Group Cluster Connection, name=" + config.getDiscoveryGroupName() + ", dg=" + dg);
            }
            clusterConnection = new ClusterConnectionImpl(this, dg, connector, new SimpleString(config.getName()), new SimpleString(config.getAddress()), config.getMinLargeMessageSize(), config.getClientFailureCheckPeriod(), config.getConnectionTTL(), config.getRetryInterval(), config.getRetryIntervalMultiplier(), config.getMaxRetryInterval(), config.getReconnectAttempts(), config.getCallTimeout(), config.getCallFailoverTimeout(), config.isDuplicateDetection(), config.isForwardWhenNoConsumers(), config.getConfirmationWindowSize(), this.executorFactory, this.threadPool, this.server, this.postOffice, this.managementService, this.scheduledExecutor, config.getMaxHops(), this.nodeManager, this.backup, this.server.getConfiguration().getClusterUser(), this.server.getConfiguration().getClusterPassword(), config.isAllowDirectConnectionsOnly(), config.getClusterNotificationInterval(), config.getClusterNotificationAttempts());
        } else {
            Object[] tcConfigs;
            Object[] objectArray = tcConfigs = config.getStaticConnectors() != null ? this.connectorNameListToArray(config.getStaticConnectors()) : null;
            if (HornetQServerLogger.LOGGER.isDebugEnabled()) {
                HornetQServerLogger.LOGGER.debug(this + " defining cluster connection towards " + Arrays.toString(tcConfigs));
            }
            clusterConnection = new ClusterConnectionImpl(this, (TransportConfiguration[])tcConfigs, connector, new SimpleString(config.getName()), new SimpleString(config.getAddress()), config.getMinLargeMessageSize(), config.getClientFailureCheckPeriod(), config.getConnectionTTL(), config.getRetryInterval(), config.getRetryIntervalMultiplier(), config.getMaxRetryInterval(), config.getReconnectAttempts(), config.getCallTimeout(), config.getCallFailoverTimeout(), config.isDuplicateDetection(), config.isForwardWhenNoConsumers(), config.getConfirmationWindowSize(), this.executorFactory, this.threadPool, this.server, this.postOffice, this.managementService, this.scheduledExecutor, config.getMaxHops(), this.nodeManager, this.backup, this.server.getConfiguration().getClusterUser(), this.server.getConfiguration().getClusterPassword(), config.isAllowDirectConnectionsOnly(), config.getClusterNotificationInterval(), config.getClusterNotificationAttempts());
        }
        if (this.defaultClusterConnection == null) {
            this.defaultClusterConnection = clusterConnection;
        }
        this.managementService.registerCluster(clusterConnection, config);
        this.clusterConnections.put(config.getName(), clusterConnection);
        if (HornetQServerLogger.LOGGER.isTraceEnabled()) {
            HornetQServerLogger.LOGGER.trace("ClusterConnection.start at " + clusterConnection, new Exception("trace"));
        }
    }

    private Transformer instantiateTransformer(String transformerClassName) {
        Transformer transformer = null;
        if (transformerClassName != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clz = loader.loadClass(transformerClassName);
                transformer = (Transformer)clz.newInstance();
            }
            catch (Exception e) {
                throw HornetQMessageBundle.BUNDLE.errorCreatingTransformerClass(e, transformerClassName);
            }
        }
        return transformer;
    }

    private synchronized void deployBroadcastGroup(BroadcastGroupConfiguration config) throws Exception {
        if (this.broadcastGroups.containsKey(config.getName())) {
            HornetQServerLogger.LOGGER.broadcastGroupAlreadyExists(config.getName());
            return;
        }
        BroadcastGroup group = this.createBroadcastGroup(config);
        this.managementService.registerBroadcastGroup(group, config);
    }

    private BroadcastGroup createBroadcastGroup(BroadcastGroupConfiguration config) throws Exception {
        BroadcastGroup group = this.broadcastGroups.get(config.getName());
        if (group == null) {
            group = new BroadcastGroupImpl(this.nodeManager, config.getName(), config.getBroadcastPeriod(), this.scheduledExecutor, config.getEndpointFactoryConfiguration().createBroadcastEndpointFactory());
            for (String connectorInfo : config.getConnectorInfos()) {
                TransportConfiguration connector = this.configuration.getConnectorConfigurations().get(connectorInfo);
                if (connector == null) {
                    this.logWarnNoConnector(config.getName(), connectorInfo);
                    return null;
                }
                group.addConnector(connector);
            }
        }
        if (group.size() == 0) {
            this.logWarnNoConnector(config.getConnectorInfos().toString(), group.getName());
            return null;
        }
        this.broadcastGroups.put(config.getName(), group);
        return group;
    }

    private void logWarnNoConnector(String connectorName, String bgName) {
        HornetQServerLogger.LOGGER.broadcastGroupNoConnector(connectorName, bgName);
    }

    private TransportConfiguration[] connectorNameListToArray(List<String> connectorNames) {
        TransportConfiguration[] tcConfigs = (TransportConfiguration[])Array.newInstance(TransportConfiguration.class, connectorNames.size());
        int count = 0;
        for (String connectorName : connectorNames) {
            TransportConfiguration connector = this.configuration.getConnectorConfigurations().get(connectorName);
            if (connector == null) {
                HornetQServerLogger.LOGGER.bridgeNoConnector(connectorName);
                return null;
            }
            tcConfigs[count++] = connector;
        }
        return tcConfigs;
    }

    private synchronized Collection<ClusterConnection> cloneClusterConnections() {
        ArrayList<ClusterConnection> list = new ArrayList<ClusterConnection>(this.clusterConnections.size());
        list.addAll(this.clusterConnections.values());
        return list;
    }

    public static class IncomingInterceptorLookingForExceptionMessage
    implements Interceptor {
        private final ClusterManager manager;
        private final Executor executor;

        public IncomingInterceptorLookingForExceptionMessage(ClusterManager manager, Executor executor) {
            this.manager = manager;
            this.executor = executor;
        }

        public boolean intercept(Packet packet, RemotingConnection connection) throws HornetQException {
            HornetQExceptionMessage msg;
            HornetQException exception;
            if (packet.getType() == 20 && (exception = (msg = (HornetQExceptionMessage)packet).getException()).getType() == HornetQExceptionType.CLUSTER_SECURITY_EXCEPTION) {
                HornetQServerLogger.LOGGER.clusterManagerAuthenticationError(exception.getMessage());
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IncomingInterceptorLookingForExceptionMessage.this.manager.stop();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            return true;
        }
    }

    static enum State {
        STOPPED,
        STOPPING,
        DEPLOYED,
        STARTED;

    }
}

