/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import org.hornetq.core.config.impl.Validators;
import org.hornetq.utils.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLConfigurationUtil {
    public static final String getAttributeValue(Node element, String attribute) {
        return element.getAttributes().getNamedItem(attribute).getNodeValue();
    }

    public static final String getTrimmedTextContent(Node element) {
        String content = element.getTextContent();
        if (content == null) {
            return null;
        }
        return content.trim();
    }

    public static final Double getDouble(Element e, String name, double def, Validators.Validator validator) {
        NodeList nl = e.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            double val = XMLUtil.parseDouble((Node)nl.item(0));
            validator.validate(name, val);
            return val;
        }
        validator.validate(name, def);
        return def;
    }

    public static final String getString(Element e, String name, String def, Validators.Validator validator) {
        NodeList nl = e.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            String val = nl.item(0).getTextContent().trim();
            validator.validate(name, val);
            return val;
        }
        validator.validate(name, def);
        return def;
    }

    public static final Long getLong(Element e, String name, long def, Validators.Validator validator) {
        NodeList nl = e.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            long val = XMLUtil.parseLong((Node)nl.item(0));
            validator.validate(name, val);
            return val;
        }
        validator.validate(name, def);
        return def;
    }

    public static final Integer getInteger(Element e, String name, int def, Validators.Validator validator) {
        NodeList nl = e.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            int val = XMLUtil.parseInt((Node)nl.item(0));
            validator.validate(name, val);
            return val;
        }
        validator.validate(name, def);
        return def;
    }

    public static final Boolean getBoolean(Element e, String name, boolean def) {
        NodeList nl = e.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            return XMLUtil.parseBoolean((Node)nl.item(0));
        }
        return def;
    }
}

