/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.version.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.hornetq.core.version.impl.VersionImpl;
import org.junit.Assert;
import org.junit.Test;

public class VersionImplTest
extends Assert {
    @Test
    public void testVersionImpl() throws Exception {
        String versionName = "HORNETQ";
        int majorVersion = 2;
        int minorVersion = 0;
        int microVersion = 1;
        int incrementingVersion = 10;
        String versionSuffix = "suffix";
        String nettyVersion = "netty";
        int[] compatibleVersionList = new int[]{7, 8, 9, 10};
        VersionImpl version = new VersionImpl(versionName, majorVersion, minorVersion, microVersion, incrementingVersion, versionSuffix, nettyVersion, compatibleVersionList);
        Assert.assertEquals((Object)versionName, (Object)version.getVersionName());
        Assert.assertEquals((long)majorVersion, (long)version.getMajorVersion());
        Assert.assertEquals((long)minorVersion, (long)version.getMinorVersion());
        Assert.assertEquals((long)microVersion, (long)version.getMicroVersion());
        Assert.assertEquals((long)incrementingVersion, (long)version.getIncrementingVersion());
        Assert.assertEquals((Object)versionSuffix, (Object)version.getVersionSuffix());
    }

    @Test
    public void testEquals() throws Exception {
        String nettyVersion = "netty";
        VersionImpl version = new VersionImpl("HORNETQ", 2, 0, 1, 10, "suffix", nettyVersion, new int[]{7, 8, 9, 10});
        VersionImpl sameVersion = new VersionImpl("HORNETQ", 2, 0, 1, 10, "suffix", nettyVersion, new int[]{7, 8, 9, 10});
        VersionImpl differentVersion = new VersionImpl("HORNETQ", 2, 0, 1, 11, "suffix", nettyVersion, new int[]{7, 8, 9, 10, 11});
        Assert.assertFalse((boolean)version.equals(new Object()));
        Assert.assertTrue((boolean)version.equals((Object)version));
        Assert.assertTrue((boolean)version.equals((Object)sameVersion));
        Assert.assertFalse((boolean)version.equals((Object)differentVersion));
    }

    @Test
    public void testSerialize() throws Exception {
        String nettyVersion = "netty";
        VersionImpl version = new VersionImpl("uyiuy", 3, 7, 6, 12, "uhuhuh", nettyVersion, new int[]{9, 10, 11, 12});
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(version);
        oos.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        VersionImpl version2 = (VersionImpl)ois.readObject();
        Assert.assertTrue((boolean)version.equals((Object)version2));
    }
}

