/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQPropertyConversionException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.message.BodyEncoder;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.impl.MessageReferenceImpl;
import org.hornetq.core.server.impl.ScheduledDeliveryHandlerImpl;
import org.hornetq.tests.util.RandomUtil;
import org.hornetq.utils.TypedProperties;
import org.hornetq.utils.UUID;
import org.junit.Assert;
import org.junit.Test;

public class ScheduledDeliveryHandlerTest
extends Assert {
    @Test
    public void testScheduleRandom() throws Exception {
        ScheduledDeliveryHandlerImpl handler = new ScheduledDeliveryHandlerImpl(null);
        long nextMessage = 0L;
        long NUMBER_OF_SEQUENCES = 100000L;
        int i = 0;
        while ((long)i < NUMBER_OF_SEQUENCES) {
            int numberOfMessages = RandomUtil.randomInt() % 10;
            if (numberOfMessages == 0) {
                numberOfMessages = 1;
            }
            long nextScheduledTime = RandomUtil.randomPositiveLong();
            for (int j = 0; j < numberOfMessages; ++j) {
                boolean tail = RandomUtil.randomBoolean();
                this.addMessage(handler, nextMessage++, nextScheduledTime, tail);
            }
            ++i;
        }
        this.debugList(true, handler, nextMessage);
    }

    @Test
    public void testScheduleSameTimeHeadAndTail() throws Exception {
        int i;
        ScheduledDeliveryHandlerImpl handler = new ScheduledDeliveryHandlerImpl(null);
        long time = System.currentTimeMillis() + 10000L;
        for (i = 10001; i < 20000; ++i) {
            this.addMessage(handler, i, time, true);
        }
        this.addMessage(handler, 10000L, time, false);
        time = System.currentTimeMillis() + 5000L;
        for (i = 1; i < 10000; ++i) {
            this.addMessage(handler, i, time, true);
        }
        this.addMessage(handler, 0L, time, false);
        this.debugList(true, handler, 20000L);
        this.validateSequence(handler);
    }

    @Test
    public void testScheduleFixedSample() throws Exception {
        ScheduledDeliveryHandlerImpl handler = new ScheduledDeliveryHandlerImpl(null);
        this.addMessage(handler, 0L, 48L, true);
        this.addMessage(handler, 1L, 75L, true);
        this.addMessage(handler, 2L, 56L, true);
        this.addMessage(handler, 3L, 7L, false);
        this.addMessage(handler, 4L, 69L, true);
        this.debugList(true, handler, 5L);
    }

    @Test
    public void testScheduleWithAddHeads() throws Exception {
        ScheduledDeliveryHandlerImpl handler = new ScheduledDeliveryHandlerImpl(null);
        this.addMessage(handler, 0L, 1L, true);
        this.addMessage(handler, 1L, 2L, true);
        this.addMessage(handler, 2L, 3L, true);
        this.addMessage(handler, 3L, 3L, true);
        this.addMessage(handler, 4L, 4L, true);
        this.addMessage(handler, 10L, 5L, false);
        this.addMessage(handler, 9L, 5L, false);
        this.addMessage(handler, 8L, 5L, false);
        this.addMessage(handler, 7L, 5L, false);
        this.addMessage(handler, 6L, 5L, false);
        this.addMessage(handler, 5L, 5L, false);
        this.validateSequence(handler);
    }

    @Test
    public void testScheduleFixedSampleTailAndHead() throws Exception {
        ScheduledDeliveryHandlerImpl handler = new ScheduledDeliveryHandlerImpl(null);
        this.addMessage(handler, 1L, 48L, true);
        this.addMessage(handler, 2L, 48L, true);
        this.addMessage(handler, 3L, 48L, true);
        this.addMessage(handler, 4L, 48L, true);
        this.addMessage(handler, 5L, 48L, true);
        this.addMessage(handler, 0L, 48L, false);
        this.addMessage(handler, 13L, 59L, true);
        this.addMessage(handler, 14L, 59L, true);
        this.addMessage(handler, 15L, 59L, true);
        this.addMessage(handler, 16L, 59L, true);
        this.addMessage(handler, 17L, 59L, true);
        this.addMessage(handler, 12L, 59L, false);
        this.addMessage(handler, 7L, 49L, true);
        this.addMessage(handler, 8L, 49L, true);
        this.addMessage(handler, 9L, 49L, true);
        this.addMessage(handler, 10L, 49L, true);
        this.addMessage(handler, 11L, 49L, true);
        this.addMessage(handler, 6L, 49L, false);
        this.validateSequence(handler);
    }

    private void validateSequence(ScheduledDeliveryHandlerImpl handler) {
        long lastSequence = -1L;
        for (MessageReference ref : handler.getScheduledReferences()) {
            ScheduledDeliveryHandlerTest.assertEquals((long)(lastSequence + 1L), (long)ref.getMessage().getMessageID());
            lastSequence = ref.getMessage().getMessageID();
        }
    }

    private void addMessage(ScheduledDeliveryHandlerImpl handler, long nextMessageID, long nextScheduledTime, boolean tail) {
        MessageReferenceImpl refImpl = new MessageReferenceImpl((ServerMessage)new FakeMessage(nextMessageID), null);
        refImpl.setScheduledDeliveryTime(nextScheduledTime);
        handler.addInPlace(nextScheduledTime, (MessageReference)refImpl, tail);
    }

    private void debugList(boolean fail, ScheduledDeliveryHandlerImpl handler, long numberOfExpectedMessages) {
        List refs = handler.getScheduledReferences();
        HashSet<Long> messages = new HashSet<Long>();
        long lastTime = -1L;
        for (MessageReference ref : refs) {
            ScheduledDeliveryHandlerTest.assertFalse((boolean)messages.contains(ref.getMessage().getMessageID()));
            messages.add(ref.getMessage().getMessageID());
            if (fail) {
                ScheduledDeliveryHandlerTest.assertTrue((ref.getScheduledDeliveryTime() >= lastTime ? 1 : 0) != 0);
            } else if (ref.getScheduledDeliveryTime() < lastTime) {
                System.out.println("^^^fail at " + ref.getScheduledDeliveryTime());
            }
            lastTime = ref.getScheduledDeliveryTime();
        }
        for (long i = 0L; i < numberOfExpectedMessages; ++i) {
            ScheduledDeliveryHandlerTest.assertTrue((boolean)messages.contains(i));
        }
    }

    class FakeMessage
    implements ServerMessage {
        final long id;

        public FakeMessage(long id) {
            this.id = id;
        }

        public void setMessageID(long id) {
        }

        public long getMessageID() {
            return this.id;
        }

        public MessageReference createReference(Queue queue) {
            return null;
        }

        public void forceAddress(SimpleString address) {
        }

        public int incrementRefCount() throws Exception {
            return 0;
        }

        public int decrementRefCount() throws Exception {
            return 0;
        }

        public int incrementDurableRefCount() {
            return 0;
        }

        public int decrementDurableRefCount() {
            return 0;
        }

        public ServerMessage copy(long newID) {
            return null;
        }

        public void finishCopy() throws Exception {
        }

        public ServerMessage copy() {
            return null;
        }

        public int getMemoryEstimate() {
            return 0;
        }

        public int getRefCount() {
            return 0;
        }

        public ServerMessage makeCopyForExpiryOrDLA(long newID, MessageReference originalReference, boolean expiry) throws Exception {
            return null;
        }

        public void setOriginalHeaders(ServerMessage other, MessageReference originalReference, boolean expiry) {
        }

        public void setPagingStore(PagingStore store) {
        }

        public PagingStore getPagingStore() {
            return null;
        }

        public boolean hasInternalProperties() {
            return false;
        }

        public boolean storeIsPaging() {
            return false;
        }

        public void encodeMessageIDToBuffer() {
        }

        public byte[] getDuplicateIDBytes() {
            return new byte[0];
        }

        public Object getDuplicateProperty() {
            return null;
        }

        public void encode(HornetQBuffer buffer) {
        }

        public void decode(HornetQBuffer buffer) {
        }

        public void decodeFromBuffer(HornetQBuffer buffer) {
        }

        public int getEndOfMessagePosition() {
            return 0;
        }

        public int getEndOfBodyPosition() {
            return 0;
        }

        public void checkCopy() {
        }

        public void bodyChanged() {
        }

        public void resetCopied() {
        }

        public boolean isServerMessage() {
            return false;
        }

        public HornetQBuffer getEncodedBuffer() {
            return null;
        }

        public int getHeadersAndPropertiesEncodeSize() {
            return 0;
        }

        public HornetQBuffer getWholeBuffer() {
            return null;
        }

        public void encodeHeadersAndProperties(HornetQBuffer buffer) {
        }

        public void decodeHeadersAndProperties(HornetQBuffer buffer) {
        }

        public BodyEncoder getBodyEncoder() throws HornetQException {
            return null;
        }

        public InputStream getBodyInputStream() {
            return null;
        }

        public void setAddressTransient(SimpleString address) {
        }

        public TypedProperties getTypedProperties() {
            return null;
        }

        public UUID getUserID() {
            return null;
        }

        public void setUserID(UUID userID) {
        }

        public SimpleString getAddress() {
            return null;
        }

        public Message setAddress(SimpleString address) {
            return null;
        }

        public byte getType() {
            return 0;
        }

        public boolean isDurable() {
            return false;
        }

        public void setDurable(boolean durable) {
        }

        public long getExpiration() {
            return 0L;
        }

        public boolean isExpired() {
            return false;
        }

        public void setExpiration(long expiration) {
        }

        public long getTimestamp() {
            return 0L;
        }

        public void setTimestamp(long timestamp) {
        }

        public byte getPriority() {
            return 0;
        }

        public void setPriority(byte priority) {
        }

        public int getEncodeSize() {
            return 0;
        }

        public boolean isLargeMessage() {
            return false;
        }

        public HornetQBuffer getBodyBuffer() {
            return null;
        }

        public HornetQBuffer getBodyBufferCopy() {
            return null;
        }

        public Message putBooleanProperty(SimpleString key, boolean value) {
            return null;
        }

        public Message putBooleanProperty(String key, boolean value) {
            return null;
        }

        public Message putByteProperty(SimpleString key, byte value) {
            return null;
        }

        public Message putByteProperty(String key, byte value) {
            return null;
        }

        public Message putBytesProperty(SimpleString key, byte[] value) {
            return null;
        }

        public Message putBytesProperty(String key, byte[] value) {
            return null;
        }

        public Message putShortProperty(SimpleString key, short value) {
            return null;
        }

        public Message putShortProperty(String key, short value) {
            return null;
        }

        public Message putCharProperty(SimpleString key, char value) {
            return null;
        }

        public Message putCharProperty(String key, char value) {
            return null;
        }

        public Message putIntProperty(SimpleString key, int value) {
            return null;
        }

        public Message putIntProperty(String key, int value) {
            return null;
        }

        public Message putLongProperty(SimpleString key, long value) {
            return null;
        }

        public Message putLongProperty(String key, long value) {
            return null;
        }

        public Message putFloatProperty(SimpleString key, float value) {
            return null;
        }

        public Message putFloatProperty(String key, float value) {
            return null;
        }

        public Message putDoubleProperty(SimpleString key, double value) {
            return null;
        }

        public Message putDoubleProperty(String key, double value) {
            return null;
        }

        public Message putStringProperty(SimpleString key, SimpleString value) {
            return null;
        }

        public Message putStringProperty(String key, String value) {
            return null;
        }

        public Message putObjectProperty(SimpleString key, Object value) throws HornetQPropertyConversionException {
            return null;
        }

        public Message putObjectProperty(String key, Object value) throws HornetQPropertyConversionException {
            return null;
        }

        public Object removeProperty(SimpleString key) {
            return null;
        }

        public Object removeProperty(String key) {
            return null;
        }

        public boolean containsProperty(SimpleString key) {
            return false;
        }

        public boolean containsProperty(String key) {
            return false;
        }

        public Boolean getBooleanProperty(SimpleString key) throws HornetQPropertyConversionException {
            return null;
        }

        public Boolean getBooleanProperty(String key) throws HornetQPropertyConversionException {
            return null;
        }

        public Byte getByteProperty(SimpleString key) throws HornetQPropertyConversionException {
            return null;
        }

        public Byte getByteProperty(String key) throws HornetQPropertyConversionException {
            return null;
        }

        public Double getDoubleProperty(SimpleString key) throws HornetQPropertyConversionException {
            return null;
        }

        public Double getDoubleProperty(String key) throws HornetQPropertyConversionException {
            return null;
        }

        public Integer getIntProperty(SimpleString key) throws HornetQPropertyConversionException {
            return null;
        }

        public Integer getIntProperty(String key) throws HornetQPropertyConversionException {
            return null;
        }

        public Long getLongProperty(SimpleString key) throws HornetQPropertyConversionException {
            return null;
        }

        public Long getLongProperty(String key) throws HornetQPropertyConversionException {
            return null;
        }

        public Object getObjectProperty(SimpleString key) {
            return null;
        }

        public Object getObjectProperty(String key) {
            return null;
        }

        public Short getShortProperty(SimpleString key) throws HornetQPropertyConversionException {
            return null;
        }

        public Short getShortProperty(String key) throws HornetQPropertyConversionException {
            return null;
        }

        public Float getFloatProperty(SimpleString key) throws HornetQPropertyConversionException {
            return null;
        }

        public Float getFloatProperty(String key) throws HornetQPropertyConversionException {
            return null;
        }

        public String getStringProperty(SimpleString key) throws HornetQPropertyConversionException {
            return null;
        }

        public String getStringProperty(String key) throws HornetQPropertyConversionException {
            return null;
        }

        public SimpleString getSimpleStringProperty(SimpleString key) throws HornetQPropertyConversionException {
            return null;
        }

        public SimpleString getSimpleStringProperty(String key) throws HornetQPropertyConversionException {
            return null;
        }

        public byte[] getBytesProperty(SimpleString key) throws HornetQPropertyConversionException {
            return new byte[0];
        }

        public byte[] getBytesProperty(String key) throws HornetQPropertyConversionException {
            return new byte[0];
        }

        public Set<SimpleString> getPropertyNames() {
            return null;
        }

        public Map<String, Object> toMap() {
            return null;
        }
    }
}

