/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.group.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.group.GroupingHandler;
import org.hornetq.core.server.group.impl.GroupBinding;
import org.hornetq.core.server.group.impl.Proposal;
import org.hornetq.core.server.group.impl.Response;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.Notification;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.TypedProperties;

public final class LocalGroupingHandler
implements GroupingHandler {
    private final ConcurrentHashMap<SimpleString, GroupBinding> map = new ConcurrentHashMap();
    private final ConcurrentHashMap<SimpleString, List<GroupBinding>> groupMap = new ConcurrentHashMap();
    private final SimpleString name;
    private final ManagementService managementService;
    private final SimpleString address;
    private final StorageManager storageManager;
    private final long timeout;
    private final Lock lock = new ReentrantLock();
    private final Condition awaitCondition = this.lock.newCondition();
    private final List<SimpleString> bindingsAdded = new ArrayList<SimpleString>();
    private final long groupTimeout;
    private boolean waitingForBindings = false;
    private final Executor executor;
    private final ScheduledExecutorService scheduledExecutor;
    private boolean started;
    private GroupIdReaper reaperRunnable;
    private ScheduledFuture reaperFuture;
    private long reaperPeriod;

    public LocalGroupingHandler(ExecutorFactory executorFactory, ScheduledExecutorService scheduledExecutor, ManagementService managementService, SimpleString name, SimpleString address, StorageManager storageManager, long timeout, long groupTimeout, long reaperPeriod) {
        this.reaperPeriod = reaperPeriod;
        this.executor = executorFactory.getExecutor();
        this.scheduledExecutor = scheduledExecutor;
        this.managementService = managementService;
        this.name = name;
        this.address = address;
        this.storageManager = storageManager;
        this.timeout = timeout;
        this.groupTimeout = groupTimeout;
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response propose(Proposal proposal) throws Exception {
        OperationContext originalCtx = this.storageManager.getContext();
        try {
            this.storageManager.setContext(this.storageManager.newSingleThreadContext());
            if (proposal.getClusterName() == null) {
                GroupBinding original = this.map.get(proposal.getGroupId());
                Response response = original == null ? null : new Response(proposal.getGroupId(), original.getClusterName());
                return response;
            }
            GroupBinding groupBinding = new GroupBinding(proposal.getGroupId(), proposal.getClusterName());
            if (this.map.putIfAbsent(groupBinding.getGroupId(), groupBinding) == null) {
                groupBinding.setId(this.storageManager.generateUniqueID());
                List<GroupBinding> newList = new ArrayList<GroupBinding>();
                List oldList = this.groupMap.putIfAbsent(groupBinding.getClusterName(), newList);
                if (oldList != null) {
                    newList = oldList;
                }
                newList.add(groupBinding);
                this.storageManager.addGrouping(groupBinding);
                if (!this.storageManager.waitOnOperations(this.timeout)) {
                    throw HornetQMessageBundle.BUNDLE.ioTimeout();
                }
                Response response = new Response(groupBinding.getGroupId(), groupBinding.getClusterName());
                return response;
            }
            groupBinding = this.map.get(proposal.getGroupId());
            Response response = new Response(groupBinding.getGroupId(), proposal.getClusterName(), groupBinding.getClusterName());
            return response;
        }
        finally {
            this.storageManager.setContext(originalCtx);
        }
    }

    @Override
    public void proposed(Response response) throws Exception {
    }

    @Override
    public void remove(SimpleString groupid, SimpleString clusterName, int distance) {
    }

    @Override
    public void send(Response response, int distance) throws Exception {
        TypedProperties props = new TypedProperties();
        props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID, response.getGroupId());
        props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_VALUE, response.getClusterName());
        props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_ALT_VALUE, response.getAlternativeClusterName());
        props.putIntProperty(ManagementHelper.HDR_BINDING_TYPE, 0);
        props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, this.address);
        props.putIntProperty(ManagementHelper.HDR_DISTANCE, distance);
        Notification notification = new Notification(null, NotificationType.PROPOSAL_RESPONSE, props);
        this.managementService.sendNotification(notification);
    }

    @Override
    public Response receive(Proposal proposal, int distance) throws Exception {
        HornetQServerLogger.LOGGER.trace("received proposal " + proposal);
        return this.propose(proposal);
    }

    @Override
    public void addGroupBinding(GroupBinding groupBinding) {
        this.map.put(groupBinding.getGroupId(), groupBinding);
        List<GroupBinding> newList = new ArrayList<GroupBinding>();
        List oldList = this.groupMap.putIfAbsent(groupBinding.getClusterName(), newList);
        if (oldList != null) {
            newList = oldList;
        }
        newList.add(groupBinding);
    }

    @Override
    public Response getProposal(SimpleString fullID) {
        GroupBinding original = this.map.get(fullID);
        return original == null ? null : new Response(fullID, original.getClusterName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitBindings() throws Exception {
        if (this.groupMap.size() > 0) {
            try {
                this.lock.lock();
                this.waitingForBindings = true;
                ArrayList<SimpleString> bindingsAlreadyAdded = new ArrayList<SimpleString>(this.bindingsAdded);
                this.bindingsAdded.clear();
                this.bindingsAdded.addAll(this.groupMap.keySet());
                this.bindingsAdded.removeAll(bindingsAlreadyAdded);
                if (!this.awaitCondition.await(this.timeout, TimeUnit.MILLISECONDS)) {
                    for (SimpleString clusterName : this.groupMap.keySet()) {
                        if (!this.bindingsAdded.contains(clusterName)) continue;
                        this.removeGrouping(clusterName, true);
                    }
                }
            }
            finally {
                this.waitingForBindings = false;
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNotification(Notification notification) {
        if (notification.getType() == NotificationType.BINDING_REMOVED) {
            SimpleString clusterName = notification.getProperties().getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
            this.removeGrouping(clusterName, false);
        } else if (notification.getType() == NotificationType.BINDING_ADDED) {
            SimpleString clusterName = notification.getProperties().getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
            try {
                this.lock.lock();
                if (!this.waitingForBindings && !this.bindingsAdded.contains(clusterName)) {
                    this.bindingsAdded.add(clusterName);
                } else {
                    this.bindingsAdded.remove(clusterName);
                }
                if (this.waitingForBindings && this.bindingsAdded.size() == 0) {
                    this.awaitCondition.signal();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        if (this.reaperPeriod > 0L && this.groupTimeout > 0L) {
            if (this.reaperFuture != null) {
                this.reaperFuture.cancel(true);
                this.reaperFuture = null;
            }
            this.reaperRunnable = new GroupIdReaper();
            this.reaperFuture = this.scheduledExecutor.scheduleAtFixedRate(this.reaperRunnable, this.reaperPeriod, this.reaperPeriod, TimeUnit.MILLISECONDS);
        }
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        this.started = false;
        if (this.reaperFuture != null) {
            this.reaperFuture.cancel(true);
            this.reaperFuture = null;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    private void removeGrouping(final SimpleString clusterName, final boolean warn) {
        final List<GroupBinding> list = this.groupMap.remove(clusterName);
        if (warn && list != null) {
            HornetQServerLogger.LOGGER.groupingQueueRemoved(list.size(), clusterName);
        }
        if (list != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    for (GroupBinding val : list) {
                        if (val == null) continue;
                        LocalGroupingHandler.this.map.remove(val.getGroupId());
                        try {
                            LocalGroupingHandler.this.storageManager.deleteGrouping(val, LocalGroupingHandler.this.map.isEmpty());
                        }
                        catch (Exception e) {
                            HornetQServerLogger.LOGGER.unableToDeleteGroupBindings(e, val.getGroupId());
                        }
                    }
                    if (warn) {
                        HornetQServerLogger.LOGGER.groupingQueueRemovedComplete(clusterName);
                    }
                }
            });
        }
    }

    private final class GroupIdReaper
    implements Runnable {
        private GroupIdReaper() {
        }

        @Override
        public void run() {
            if (LocalGroupingHandler.this.isStarted()) {
                if (!LocalGroupingHandler.this.isStarted()) {
                    return;
                }
                for (GroupBinding groupBinding : LocalGroupingHandler.this.map.values()) {
                    if (groupBinding.getTimeCreated() + LocalGroupingHandler.this.groupTimeout <= System.currentTimeMillis()) continue;
                    LocalGroupingHandler.this.map.remove(groupBinding.getGroupId());
                    List groupBindings = (List)LocalGroupingHandler.this.groupMap.get(groupBinding.getClusterName());
                    groupBindings.remove(groupBinding);
                    TypedProperties props = new TypedProperties();
                    props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID, groupBinding.getGroupId());
                    props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_VALUE, groupBinding.getClusterName());
                    props.putIntProperty(ManagementHelper.HDR_BINDING_TYPE, 0);
                    props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, LocalGroupingHandler.this.address);
                    props.putIntProperty(ManagementHelper.HDR_DISTANCE, 0);
                    Notification notification = new Notification(null, NotificationType.UNPROPOSAL, props);
                    try {
                        LocalGroupingHandler.this.managementService.sendNotification(notification);
                    }
                    catch (Exception e) {
                        HornetQServerLogger.LOGGER.errorHandlingMessage(e);
                    }
                    try {
                        LocalGroupingHandler.this.storageManager.deleteGrouping(groupBinding, true);
                    }
                    catch (Exception e) {
                        HornetQServerLogger.LOGGER.unableToDeleteGroupBindings(e, groupBinding.getGroupId());
                    }
                }
            }
        }
    }
}

