/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.invm;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hornetq.api.config.HornetQDefaultConfiguration;

public final class TransportConstants {
    public static final String SERVER_ID_PROP_NAME = "server-id";
    public static final Set<String> ALLOWABLE_CONNECTOR_KEYS;
    public static final Set<String> ALLOWABLE_ACCEPTOR_KEYS;

    private TransportConstants() {
    }

    static {
        HashSet<String> allowableAcceptorKeys = new HashSet<String>();
        allowableAcceptorKeys.add(SERVER_ID_PROP_NAME);
        allowableAcceptorKeys.add("cluster-connection");
        allowableAcceptorKeys.add(HornetQDefaultConfiguration.getPropMaskPassword());
        allowableAcceptorKeys.add(HornetQDefaultConfiguration.getPropPasswordCodec());
        ALLOWABLE_ACCEPTOR_KEYS = Collections.unmodifiableSet(allowableAcceptorKeys);
        HashSet<String> allowableConnectorKeys = new HashSet<String>();
        allowableConnectorKeys.add(SERVER_ID_PROP_NAME);
        allowableConnectorKeys.add(HornetQDefaultConfiguration.getPropMaskPassword());
        allowableConnectorKeys.add(HornetQDefaultConfiguration.getPropPasswordCodec());
        ALLOWABLE_CONNECTOR_KEYS = Collections.unmodifiableSet(allowableConnectorKeys);
    }
}

