/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config;

import java.io.Serializable;
import org.hornetq.utils.UUIDGenerator;

public class DivertConfiguration
implements Serializable {
    private static final long serialVersionUID = 6910543740464269629L;
    private String name;
    private String routingName;
    private String address;
    private String forwardingAddress;
    private boolean exclusive;
    private String filterString;
    private String transformerClassName;

    public DivertConfiguration(String name, String routingName, String address, String forwardingAddress, boolean exclusive, String filterString, String transformerClassName) {
        this.name = name;
        this.routingName = routingName == null ? UUIDGenerator.getInstance().generateStringUUID() : routingName;
        this.address = address;
        this.forwardingAddress = forwardingAddress;
        this.exclusive = exclusive;
        this.filterString = filterString;
        this.transformerClassName = transformerClassName;
    }

    public String getName() {
        return this.name;
    }

    public String getRoutingName() {
        return this.routingName;
    }

    public String getAddress() {
        return this.address;
    }

    public String getForwardingAddress() {
        return this.forwardingAddress;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public String getTransformerClassName() {
        return this.transformerClassName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRoutingName(String routingName) {
        this.routingName = routingName;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setForwardingAddress(String forwardingAddress) {
        this.forwardingAddress = forwardingAddress;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    public void setTransformerClassName(String transformerClassName) {
        this.transformerClassName = transformerClassName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.exclusive ? 1231 : 1237);
        result = 31 * result + (this.filterString == null ? 0 : this.filterString.hashCode());
        result = 31 * result + (this.forwardingAddress == null ? 0 : this.forwardingAddress.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.routingName == null ? 0 : this.routingName.hashCode());
        result = 31 * result + (this.transformerClassName == null ? 0 : this.transformerClassName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DivertConfiguration other = (DivertConfiguration)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.exclusive != other.exclusive) {
            return false;
        }
        if (this.filterString == null ? other.filterString != null : !this.filterString.equals(other.filterString)) {
            return false;
        }
        if (this.forwardingAddress == null ? other.forwardingAddress != null : !this.forwardingAddress.equals(other.forwardingAddress)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.routingName == null ? other.routingName != null : !this.routingName.equals(other.routingName)) {
            return false;
        }
        return !(this.transformerClassName == null ? other.transformerClassName != null : !this.transformerClassName.equals(other.transformerClassName));
    }
}

