/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.HAPolicyConfiguration;
import org.hornetq.core.config.ha.LiveOnlyPolicyConfiguration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.server.JournalType;
import org.hornetq.tests.util.RandomUtil;
import org.hornetq.tests.util.UnitTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConfigurationImplTest
extends UnitTestCase {
    protected Configuration conf;

    @Test
    public void testDefaults() {
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultScheduledThreadPoolMaxSize(), (long)this.conf.getScheduledThreadPoolMaxSize());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultSecurityInvalidationInterval(), (long)this.conf.getSecurityInvalidationInterval());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultSecurityEnabled(), (Object)this.conf.isSecurityEnabled());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.getDefaultBindingsDirectory(), (Object)this.conf.getBindingsDirectory());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultCreateBindingsDir(), (Object)this.conf.isCreateBindingsDir());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.getDefaultJournalDir(), (Object)this.conf.getJournalDirectory());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultCreateJournalDir(), (Object)this.conf.isCreateJournalDir());
        Assert.assertEquals((Object)ConfigurationImpl.DEFAULT_JOURNAL_TYPE, (Object)this.conf.getJournalType());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultJournalSyncTransactional(), (Object)this.conf.isJournalSyncTransactional());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultJournalSyncNonTransactional(), (Object)this.conf.isJournalSyncNonTransactional());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultJournalFileSize(), (long)this.conf.getJournalFileSize());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultJournalMinFiles(), (long)this.conf.getJournalMinFiles());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultJournalMaxIoAio(), (long)this.conf.getJournalMaxIO_AIO());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultJournalMaxIoNio(), (long)this.conf.getJournalMaxIO_NIO());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultWildcardRoutingEnabled(), (Object)this.conf.isWildcardRoutingEnabled());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultTransactionTimeout(), (long)this.conf.getTransactionTimeout());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultMessageExpiryScanPeriod(), (long)this.conf.getMessageExpiryScanPeriod());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultMessageExpiryThreadPriority(), (long)this.conf.getMessageExpiryThreadPriority());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultTransactionTimeoutScanPeriod(), (long)this.conf.getTransactionTimeoutScanPeriod());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.getDefaultManagementAddress(), (Object)this.conf.getManagementAddress());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.getDefaultManagementNotificationAddress(), (Object)this.conf.getManagementNotificationAddress());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.getDefaultClusterUser(), (Object)this.conf.getClusterUser());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.getDefaultClusterPassword(), (Object)this.conf.getClusterPassword());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultPersistenceEnabled(), (Object)this.conf.isPersistenceEnabled());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultFileDeploymentEnabled(), (Object)this.conf.isFileDeploymentEnabled());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultPersistDeliveryCountBeforeDelivery(), (Object)this.conf.isPersistDeliveryCountBeforeDelivery());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultFileDeployerScanPeriod(), (long)this.conf.getFileDeployerScanPeriod());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultThreadPoolMaxSize(), (long)this.conf.getThreadPoolMaxSize());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultJmxManagementEnabled(), (Object)this.conf.isJMXManagementEnabled());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultConnectionTtlOverride(), (long)this.conf.getConnectionTTLOverride());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultAsyncConnectionExecutionEnabled(), (Object)this.conf.isAsyncConnectionExecutionEnabled());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.getDefaultPagingDir(), (Object)this.conf.getPagingDirectory());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.getDefaultLargeMessagesDir(), (Object)this.conf.getLargeMessagesDirectory());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultJournalCompactPercentage(), (long)this.conf.getJournalCompactPercentage());
        Assert.assertEquals((long)500000L, (long)this.conf.getJournalBufferTimeout_AIO());
        Assert.assertEquals((long)3333333L, (long)this.conf.getJournalBufferTimeout_NIO());
        Assert.assertEquals((long)501760L, (long)this.conf.getJournalBufferSize_AIO());
        Assert.assertEquals((long)501760L, (long)this.conf.getJournalBufferSize_NIO());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultJournalLogWriteRate(), (Object)this.conf.isLogJournalWriteRate());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultJournalPerfBlastPages(), (long)this.conf.getJournalPerfBlastPages());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultMessageCounterEnabled(), (Object)this.conf.isMessageCounterEnabled());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultMessageCounterMaxDayHistory(), (long)this.conf.getMessageCounterMaxDayHistory());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultMessageCounterSamplePeriod(), (long)this.conf.getMessageCounterSamplePeriod());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultIdCacheSize(), (long)this.conf.getIDCacheSize());
        Assert.assertEquals((Object)HornetQDefaultConfiguration.isDefaultPersistIdCache(), (Object)this.conf.isPersistIDCache());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultServerDumpInterval(), (long)this.conf.getServerDumpInterval());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultMemoryWarningThreshold(), (long)this.conf.getMemoryWarningThreshold());
        Assert.assertEquals((long)HornetQDefaultConfiguration.getDefaultMemoryMeasureInterval(), (long)this.conf.getMemoryMeasureInterval());
    }

    @Test
    public void testSetGetAttributes() throws Exception {
        for (int j = 0; j < 100; ++j) {
            int i = RandomUtil.randomInt();
            this.conf.setScheduledThreadPoolMaxSize(i);
            Assert.assertEquals((long)i, (long)this.conf.getScheduledThreadPoolMaxSize());
            long l = RandomUtil.randomLong();
            this.conf.setSecurityInvalidationInterval(l);
            Assert.assertEquals((long)l, (long)this.conf.getSecurityInvalidationInterval());
            boolean b = RandomUtil.randomBoolean();
            this.conf.setSecurityEnabled(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isSecurityEnabled());
            String s = RandomUtil.randomString();
            this.conf.setBindingsDirectory(s);
            Assert.assertEquals((Object)s, (Object)this.conf.getBindingsDirectory());
            b = RandomUtil.randomBoolean();
            this.conf.setCreateBindingsDir(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isCreateBindingsDir());
            s = RandomUtil.randomString();
            this.conf.setJournalDirectory(s);
            Assert.assertEquals((Object)s, (Object)this.conf.getJournalDirectory());
            b = RandomUtil.randomBoolean();
            this.conf.setCreateJournalDir(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isCreateJournalDir());
            i = RandomUtil.randomInt() % 2;
            JournalType journal = i == 0 ? JournalType.ASYNCIO : JournalType.NIO;
            this.conf.setJournalType(journal);
            Assert.assertEquals((Object)journal, (Object)this.conf.getJournalType());
            b = RandomUtil.randomBoolean();
            this.conf.setJournalSyncTransactional(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isJournalSyncTransactional());
            b = RandomUtil.randomBoolean();
            this.conf.setJournalSyncNonTransactional(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isJournalSyncNonTransactional());
            i = RandomUtil.randomInt();
            this.conf.setJournalFileSize(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalFileSize());
            i = RandomUtil.randomInt();
            this.conf.setJournalMinFiles(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalMinFiles());
            i = RandomUtil.randomInt();
            this.conf.setJournalMaxIO_AIO(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalMaxIO_AIO());
            i = RandomUtil.randomInt();
            this.conf.setJournalMaxIO_NIO(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalMaxIO_NIO());
            s = RandomUtil.randomString();
            this.conf.setManagementAddress(new SimpleString(s));
            Assert.assertEquals((Object)s, (Object)this.conf.getManagementAddress().toString());
            i = RandomUtil.randomInt();
            this.conf.setMessageExpiryThreadPriority(i);
            Assert.assertEquals((long)i, (long)this.conf.getMessageExpiryThreadPriority());
            l = RandomUtil.randomLong();
            this.conf.setMessageExpiryScanPeriod(l);
            Assert.assertEquals((long)l, (long)this.conf.getMessageExpiryScanPeriod());
            b = RandomUtil.randomBoolean();
            this.conf.setPersistDeliveryCountBeforeDelivery(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isPersistDeliveryCountBeforeDelivery());
            b = RandomUtil.randomBoolean();
            this.conf.setEnabledAsyncConnectionExecution(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isAsyncConnectionExecutionEnabled());
            b = RandomUtil.randomBoolean();
            this.conf.setFileDeploymentEnabled(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isFileDeploymentEnabled());
            b = RandomUtil.randomBoolean();
            this.conf.setPersistenceEnabled(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isPersistenceEnabled());
            b = RandomUtil.randomBoolean();
            this.conf.setJMXManagementEnabled(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isJMXManagementEnabled());
            l = RandomUtil.randomLong();
            this.conf.setFileDeployerScanPeriod(l);
            Assert.assertEquals((long)l, (long)this.conf.getFileDeployerScanPeriod());
            l = RandomUtil.randomLong();
            this.conf.setConnectionTTLOverride(l);
            Assert.assertEquals((long)l, (long)this.conf.getConnectionTTLOverride());
            i = RandomUtil.randomInt();
            this.conf.setThreadPoolMaxSize(i);
            Assert.assertEquals((long)i, (long)this.conf.getThreadPoolMaxSize());
            SimpleString ss = RandomUtil.randomSimpleString();
            this.conf.setManagementNotificationAddress(ss);
            Assert.assertEquals((Object)ss, (Object)this.conf.getManagementNotificationAddress());
            s = RandomUtil.randomString();
            this.conf.setClusterUser(s);
            Assert.assertEquals((Object)s, (Object)this.conf.getClusterUser());
            i = RandomUtil.randomInt();
            this.conf.setIDCacheSize(i);
            Assert.assertEquals((long)i, (long)this.conf.getIDCacheSize());
            b = RandomUtil.randomBoolean();
            this.conf.setPersistIDCache(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isPersistIDCache());
            i = RandomUtil.randomInt();
            this.conf.setJournalCompactMinFiles(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalCompactMinFiles());
            i = RandomUtil.randomInt();
            this.conf.setJournalCompactPercentage(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalCompactPercentage());
            i = RandomUtil.randomInt();
            this.conf.setJournalBufferSize_AIO(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalBufferSize_AIO());
            i = RandomUtil.randomInt();
            this.conf.setJournalBufferTimeout_AIO(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalBufferTimeout_AIO());
            i = RandomUtil.randomInt();
            this.conf.setJournalBufferSize_NIO(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalBufferSize_NIO());
            i = RandomUtil.randomInt();
            this.conf.setJournalBufferTimeout_NIO(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalBufferTimeout_NIO());
            b = RandomUtil.randomBoolean();
            this.conf.setLogJournalWriteRate(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isLogJournalWriteRate());
            i = RandomUtil.randomInt();
            this.conf.setJournalPerfBlastPages(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalPerfBlastPages());
            l = RandomUtil.randomLong();
            this.conf.setServerDumpInterval(l);
            Assert.assertEquals((long)l, (long)this.conf.getServerDumpInterval());
            s = RandomUtil.randomString();
            this.conf.setPagingDirectory(s);
            Assert.assertEquals((Object)s, (Object)this.conf.getPagingDirectory());
            s = RandomUtil.randomString();
            this.conf.setLargeMessagesDirectory(s);
            Assert.assertEquals((Object)s, (Object)this.conf.getLargeMessagesDirectory());
            b = RandomUtil.randomBoolean();
            this.conf.setWildcardRoutingEnabled(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isWildcardRoutingEnabled());
            l = RandomUtil.randomLong();
            this.conf.setTransactionTimeout(l);
            Assert.assertEquals((long)l, (long)this.conf.getTransactionTimeout());
            b = RandomUtil.randomBoolean();
            this.conf.setMessageCounterEnabled(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isMessageCounterEnabled());
            l = RandomUtil.randomPositiveLong();
            this.conf.setMessageCounterSamplePeriod(l);
            Assert.assertEquals((long)l, (long)this.conf.getMessageCounterSamplePeriod());
            i = RandomUtil.randomInt();
            this.conf.setMessageCounterMaxDayHistory(i);
            Assert.assertEquals((long)i, (long)this.conf.getMessageCounterMaxDayHistory());
            l = RandomUtil.randomLong();
            this.conf.setTransactionTimeoutScanPeriod(l);
            Assert.assertEquals((long)l, (long)this.conf.getTransactionTimeoutScanPeriod());
            s = RandomUtil.randomString();
            this.conf.setClusterPassword(s);
            Assert.assertEquals((Object)s, (Object)this.conf.getClusterPassword());
        }
    }

    @Test
    public void testGetSetInterceptors() {
        String name1 = "uqwyuqywuy";
        String name2 = "yugyugyguyg";
        this.conf.getIncomingInterceptorClassNames().add("uqwyuqywuy");
        this.conf.getIncomingInterceptorClassNames().add("yugyugyguyg");
        Assert.assertTrue((boolean)this.conf.getIncomingInterceptorClassNames().contains("uqwyuqywuy"));
        Assert.assertTrue((boolean)this.conf.getIncomingInterceptorClassNames().contains("yugyugyguyg"));
        Assert.assertFalse((boolean)this.conf.getIncomingInterceptorClassNames().contains("iijij"));
    }

    @Test
    public void testSerialize() throws Exception {
        boolean b = RandomUtil.randomBoolean();
        this.conf.setHAPolicyConfiguration((HAPolicyConfiguration)new LiveOnlyPolicyConfiguration());
        int i = RandomUtil.randomInt();
        this.conf.setScheduledThreadPoolMaxSize(i);
        Assert.assertEquals((long)i, (long)this.conf.getScheduledThreadPoolMaxSize());
        long l = RandomUtil.randomLong();
        this.conf.setSecurityInvalidationInterval(l);
        Assert.assertEquals((long)l, (long)this.conf.getSecurityInvalidationInterval());
        b = RandomUtil.randomBoolean();
        this.conf.setSecurityEnabled(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isSecurityEnabled());
        String s = RandomUtil.randomString();
        this.conf.setBindingsDirectory(s);
        Assert.assertEquals((Object)s, (Object)this.conf.getBindingsDirectory());
        b = RandomUtil.randomBoolean();
        this.conf.setCreateBindingsDir(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isCreateBindingsDir());
        s = RandomUtil.randomString();
        this.conf.setJournalDirectory(s);
        Assert.assertEquals((Object)s, (Object)this.conf.getJournalDirectory());
        b = RandomUtil.randomBoolean();
        this.conf.setCreateJournalDir(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isCreateJournalDir());
        i = RandomUtil.randomInt() % 2;
        JournalType journal = i == 0 ? JournalType.ASYNCIO : JournalType.NIO;
        this.conf.setJournalType(journal);
        Assert.assertEquals((Object)journal, (Object)this.conf.getJournalType());
        b = RandomUtil.randomBoolean();
        this.conf.setJournalSyncTransactional(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isJournalSyncTransactional());
        b = RandomUtil.randomBoolean();
        this.conf.setJournalSyncNonTransactional(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isJournalSyncNonTransactional());
        i = RandomUtil.randomInt();
        this.conf.setJournalFileSize(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalFileSize());
        i = RandomUtil.randomInt();
        this.conf.setJournalMinFiles(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalMinFiles());
        i = RandomUtil.randomInt();
        this.conf.setJournalMaxIO_AIO(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalMaxIO_AIO());
        i = RandomUtil.randomInt();
        this.conf.setJournalMaxIO_NIO(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalMaxIO_NIO());
        s = RandomUtil.randomString();
        this.conf.setManagementAddress(new SimpleString(s));
        Assert.assertEquals((Object)s, (Object)this.conf.getManagementAddress().toString());
        i = RandomUtil.randomInt();
        this.conf.setMessageExpiryThreadPriority(i);
        Assert.assertEquals((long)i, (long)this.conf.getMessageExpiryThreadPriority());
        l = RandomUtil.randomLong();
        this.conf.setMessageExpiryScanPeriod(l);
        Assert.assertEquals((long)l, (long)this.conf.getMessageExpiryScanPeriod());
        b = RandomUtil.randomBoolean();
        this.conf.setPersistDeliveryCountBeforeDelivery(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isPersistDeliveryCountBeforeDelivery());
        b = RandomUtil.randomBoolean();
        this.conf.setEnabledAsyncConnectionExecution(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isAsyncConnectionExecutionEnabled());
        b = RandomUtil.randomBoolean();
        this.conf.setFileDeploymentEnabled(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isFileDeploymentEnabled());
        b = RandomUtil.randomBoolean();
        this.conf.setPersistenceEnabled(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isPersistenceEnabled());
        b = RandomUtil.randomBoolean();
        this.conf.setJMXManagementEnabled(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isJMXManagementEnabled());
        l = RandomUtil.randomLong();
        this.conf.setFileDeployerScanPeriod(l);
        Assert.assertEquals((long)l, (long)this.conf.getFileDeployerScanPeriod());
        l = RandomUtil.randomLong();
        this.conf.setConnectionTTLOverride(l);
        Assert.assertEquals((long)l, (long)this.conf.getConnectionTTLOverride());
        i = RandomUtil.randomInt();
        this.conf.setThreadPoolMaxSize(i);
        Assert.assertEquals((long)i, (long)this.conf.getThreadPoolMaxSize());
        SimpleString ss = RandomUtil.randomSimpleString();
        this.conf.setManagementNotificationAddress(ss);
        Assert.assertEquals((Object)ss, (Object)this.conf.getManagementNotificationAddress());
        s = RandomUtil.randomString();
        this.conf.setClusterUser(s);
        Assert.assertEquals((Object)s, (Object)this.conf.getClusterUser());
        i = RandomUtil.randomInt();
        this.conf.setIDCacheSize(i);
        Assert.assertEquals((long)i, (long)this.conf.getIDCacheSize());
        b = RandomUtil.randomBoolean();
        this.conf.setPersistIDCache(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isPersistIDCache());
        i = RandomUtil.randomInt();
        this.conf.setJournalCompactMinFiles(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalCompactMinFiles());
        i = RandomUtil.randomInt();
        this.conf.setJournalCompactPercentage(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalCompactPercentage());
        i = RandomUtil.randomInt();
        this.conf.setJournalBufferSize_AIO(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalBufferSize_AIO());
        i = RandomUtil.randomInt();
        this.conf.setJournalBufferTimeout_AIO(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalBufferTimeout_AIO());
        i = RandomUtil.randomInt();
        this.conf.setJournalBufferSize_NIO(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalBufferSize_NIO());
        i = RandomUtil.randomInt();
        this.conf.setJournalBufferTimeout_NIO(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalBufferTimeout_NIO());
        b = RandomUtil.randomBoolean();
        this.conf.setLogJournalWriteRate(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isLogJournalWriteRate());
        i = RandomUtil.randomInt();
        this.conf.setJournalPerfBlastPages(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalPerfBlastPages());
        l = RandomUtil.randomLong();
        this.conf.setServerDumpInterval(l);
        Assert.assertEquals((long)l, (long)this.conf.getServerDumpInterval());
        s = RandomUtil.randomString();
        this.conf.setPagingDirectory(s);
        Assert.assertEquals((Object)s, (Object)this.conf.getPagingDirectory());
        s = RandomUtil.randomString();
        this.conf.setLargeMessagesDirectory(s);
        Assert.assertEquals((Object)s, (Object)this.conf.getLargeMessagesDirectory());
        b = RandomUtil.randomBoolean();
        this.conf.setWildcardRoutingEnabled(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isWildcardRoutingEnabled());
        l = RandomUtil.randomLong();
        this.conf.setTransactionTimeout(l);
        Assert.assertEquals((long)l, (long)this.conf.getTransactionTimeout());
        b = RandomUtil.randomBoolean();
        this.conf.setMessageCounterEnabled(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isMessageCounterEnabled());
        l = RandomUtil.randomPositiveLong();
        this.conf.setMessageCounterSamplePeriod(l);
        Assert.assertEquals((long)l, (long)this.conf.getMessageCounterSamplePeriod());
        i = RandomUtil.randomInt();
        this.conf.setMessageCounterMaxDayHistory(i);
        Assert.assertEquals((long)i, (long)this.conf.getMessageCounterMaxDayHistory());
        l = RandomUtil.randomLong();
        this.conf.setTransactionTimeoutScanPeriod(l);
        Assert.assertEquals((long)l, (long)this.conf.getTransactionTimeoutScanPeriod());
        s = RandomUtil.randomString();
        this.conf.setClusterPassword(s);
        Assert.assertEquals((Object)s, (Object)this.conf.getClusterPassword());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.conf);
        oos.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Configuration conf2 = (Configuration)ois.readObject();
        Assert.assertTrue((boolean)this.conf.equals(conf2));
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.conf = this.createConfiguration();
    }

    protected Configuration createConfiguration() throws Exception {
        return new ConfigurationImpl();
    }
}

