/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.settings;

import org.hornetq.api.core.SimpleString;
import org.hornetq.core.settings.impl.AddressFullMessagePolicy;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.tests.util.UnitTestCase;
import org.junit.Assert;
import org.junit.Test;

public class AddressSettingsTest
extends UnitTestCase {
    @Test
    public void testDefaults() {
        AddressSettings addressSettings = new AddressSettings();
        Assert.assertEquals(null, (Object)addressSettings.getDeadLetterAddress());
        Assert.assertEquals(null, (Object)addressSettings.getExpiryAddress());
        Assert.assertEquals((long)10L, (long)addressSettings.getMaxDeliveryAttempts());
        Assert.assertEquals((long)addressSettings.getMaxSizeBytes(), (long)-1L);
        Assert.assertEquals((long)0xA00000L, (long)addressSettings.getPageSizeBytes());
        Assert.assertEquals((long)0L, (long)addressSettings.getMessageCounterHistoryDayLimit());
        Assert.assertEquals((long)0L, (long)addressSettings.getRedeliveryDelay());
        Assert.assertEquals((double)1.0, (double)addressSettings.getRedeliveryMultiplier(), (double)1.0E-6);
        Assert.assertEquals((long)-1L, (long)addressSettings.getSlowConsumerThreshold());
        Assert.assertEquals((long)5L, (long)addressSettings.getSlowConsumerCheckPeriod());
        Assert.assertEquals((Object)AddressSettings.DEFAULT_SLOW_CONSUMER_POLICY, (Object)addressSettings.getSlowConsumerPolicy());
    }

    @Test
    public void testSingleMerge() {
        AddressSettings addressSettings = new AddressSettings();
        AddressSettings addressSettingsToMerge = new AddressSettings();
        SimpleString DLQ = new SimpleString("testDLQ");
        SimpleString exp = new SimpleString("testExpiryQueue");
        addressSettingsToMerge.setDeadLetterAddress(DLQ);
        addressSettingsToMerge.setExpiryAddress(exp);
        addressSettingsToMerge.setMaxDeliveryAttempts(1000);
        addressSettingsToMerge.setAddressFullMessagePolicy(AddressFullMessagePolicy.DROP);
        addressSettingsToMerge.setMaxSizeBytes(1001L);
        addressSettingsToMerge.setMessageCounterHistoryDayLimit(1002);
        addressSettingsToMerge.setRedeliveryDelay(1003L);
        addressSettingsToMerge.setPageSizeBytes(1004L);
        addressSettings.merge(addressSettingsToMerge);
        Assert.assertEquals((Object)addressSettings.getDeadLetterAddress(), (Object)DLQ);
        Assert.assertEquals((Object)addressSettings.getExpiryAddress(), (Object)exp);
        Assert.assertEquals((long)addressSettings.getMaxDeliveryAttempts(), (long)1000L);
        Assert.assertEquals((long)addressSettings.getMaxSizeBytes(), (long)1001L);
        Assert.assertEquals((long)addressSettings.getMessageCounterHistoryDayLimit(), (long)1002L);
        Assert.assertEquals((long)addressSettings.getRedeliveryDelay(), (long)1003L);
        Assert.assertEquals((long)addressSettings.getPageSizeBytes(), (long)1004L);
        Assert.assertEquals((Object)AddressFullMessagePolicy.DROP, (Object)addressSettings.getAddressFullMessagePolicy());
    }

    @Test
    public void testMultipleMerge() {
        AddressSettings addressSettings = new AddressSettings();
        AddressSettings addressSettingsToMerge = new AddressSettings();
        SimpleString DLQ = new SimpleString("testDLQ");
        SimpleString exp = new SimpleString("testExpiryQueue");
        addressSettingsToMerge.setDeadLetterAddress(DLQ);
        addressSettingsToMerge.setExpiryAddress(exp);
        addressSettingsToMerge.setMaxDeliveryAttempts(1000);
        addressSettingsToMerge.setMaxSizeBytes(1001L);
        addressSettingsToMerge.setMessageCounterHistoryDayLimit(1002);
        addressSettingsToMerge.setAddressFullMessagePolicy(AddressFullMessagePolicy.DROP);
        addressSettings.merge(addressSettingsToMerge);
        AddressSettings addressSettingsToMerge2 = new AddressSettings();
        SimpleString exp2 = new SimpleString("testExpiryQueue2");
        addressSettingsToMerge2.setExpiryAddress(exp2);
        addressSettingsToMerge2.setMaxSizeBytes(2001L);
        addressSettingsToMerge2.setRedeliveryDelay(2003L);
        addressSettingsToMerge2.setRedeliveryMultiplier(2.5);
        addressSettings.merge(addressSettingsToMerge2);
        Assert.assertEquals((Object)addressSettings.getDeadLetterAddress(), (Object)DLQ);
        Assert.assertEquals((Object)addressSettings.getExpiryAddress(), (Object)exp);
        Assert.assertEquals((long)addressSettings.getMaxDeliveryAttempts(), (long)1000L);
        Assert.assertEquals((long)addressSettings.getMaxSizeBytes(), (long)1001L);
        Assert.assertEquals((long)addressSettings.getMessageCounterHistoryDayLimit(), (long)1002L);
        Assert.assertEquals((long)addressSettings.getRedeliveryDelay(), (long)2003L);
        Assert.assertEquals((double)addressSettings.getRedeliveryMultiplier(), (double)2.5, (double)1.0E-6);
        Assert.assertEquals((Object)AddressFullMessagePolicy.DROP, (Object)addressSettings.getAddressFullMessagePolicy());
    }

    @Test
    public void testMultipleMergeAll() {
        AddressSettings addressSettings = new AddressSettings();
        AddressSettings addressSettingsToMerge = new AddressSettings();
        SimpleString DLQ = new SimpleString("testDLQ");
        SimpleString exp = new SimpleString("testExpiryQueue");
        addressSettingsToMerge.setDeadLetterAddress(DLQ);
        addressSettingsToMerge.setExpiryAddress(exp);
        addressSettingsToMerge.setMaxSizeBytes(1001L);
        addressSettingsToMerge.setRedeliveryDelay(1003L);
        addressSettingsToMerge.setRedeliveryMultiplier(1.0);
        addressSettingsToMerge.setAddressFullMessagePolicy(AddressFullMessagePolicy.DROP);
        addressSettings.merge(addressSettingsToMerge);
        AddressSettings addressSettingsToMerge2 = new AddressSettings();
        SimpleString exp2 = new SimpleString("testExpiryQueue2");
        SimpleString DLQ2 = new SimpleString("testDlq2");
        addressSettingsToMerge2.setExpiryAddress(exp2);
        addressSettingsToMerge2.setDeadLetterAddress(DLQ2);
        addressSettingsToMerge2.setMaxDeliveryAttempts(2000);
        addressSettingsToMerge2.setMaxSizeBytes(2001L);
        addressSettingsToMerge2.setMessageCounterHistoryDayLimit(2002);
        addressSettingsToMerge2.setRedeliveryDelay(2003L);
        addressSettingsToMerge2.setRedeliveryMultiplier(2.0);
        addressSettingsToMerge2.setMaxRedeliveryDelay(5000L);
        addressSettingsToMerge.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        addressSettings.merge(addressSettingsToMerge2);
        Assert.assertEquals((Object)addressSettings.getDeadLetterAddress(), (Object)DLQ);
        Assert.assertEquals((Object)addressSettings.getExpiryAddress(), (Object)exp);
        Assert.assertEquals((long)addressSettings.getMaxDeliveryAttempts(), (long)2000L);
        Assert.assertEquals((long)addressSettings.getMaxSizeBytes(), (long)1001L);
        Assert.assertEquals((long)addressSettings.getMessageCounterHistoryDayLimit(), (long)2002L);
        Assert.assertEquals((long)addressSettings.getRedeliveryDelay(), (long)1003L);
        Assert.assertEquals((double)addressSettings.getRedeliveryMultiplier(), (double)1.0, (double)1.0E-6);
        Assert.assertEquals((long)addressSettings.getMaxRedeliveryDelay(), (long)5000L);
        Assert.assertEquals((Object)AddressFullMessagePolicy.DROP, (Object)addressSettings.getAddressFullMessagePolicy());
    }
}

