/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.tests.util;

import java.util.concurrent.CountDownLatch;
import org.hornetq.api.core.SimpleString;
import org.hornetq.tests.util.RandomUtil;
import org.hornetq.tests.util.UnitTestCase;
import org.junit.Assert;
import org.junit.Test;

public class SimpleStringTest
extends Assert {
    @Test
    public void testGetChar() {
        SimpleString p1 = new SimpleString("foo");
        SimpleString p2 = new SimpleString("bar");
        for (int i = 0; i < 65536; ++i) {
            String msg = "expecting " + i;
            char c = (char)i;
            SimpleString s = new SimpleString(String.valueOf(c));
            char[] c1 = new char[1];
            s.getChars(0, 1, c1, 0);
            SimpleStringTest.assertEquals((String)msg, (long)c, (long)c1[0]);
            SimpleStringTest.assertEquals((String)msg, (long)c, (long)s.charAt(0));
            SimpleString s2 = s.concat(c);
            SimpleStringTest.assertEquals((String)msg, (long)c, (long)s2.charAt(1));
            SimpleString sSplit = new SimpleString("foo" + String.valueOf(c) + "bar");
            SimpleString[] chunks = sSplit.split(c);
            SimpleString[] split1 = p1.split(c);
            SimpleString[] split2 = p2.split(c);
            SimpleStringTest.assertEquals((long)(split1.length + split2.length), (long)chunks.length);
            int j = 0;
            for (SimpleString iS : split1) {
                SimpleStringTest.assertEquals((String)iS.toString(), (Object)iS, (Object)chunks[j++]);
            }
            for (SimpleString iS : split2) {
                SimpleStringTest.assertEquals((String)iS.toString(), (Object)iS, (Object)chunks[j++]);
            }
        }
    }

    @Test
    public void testString() throws Exception {
        String str = "hello123ABC__524`16254`6125!%^$!%$!%$!%$!%!$%!$$!\ua324";
        SimpleString s = new SimpleString("hello123ABC__524`16254`6125!%^$!%$!%$!%$!%!$%!$$!\ua324");
        Assert.assertEquals((Object)"hello123ABC__524`16254`6125!%^$!%$!%$!%$!%!$%!$$!\ua324", (Object)s.toString());
        Assert.assertEquals((long)(2 * "hello123ABC__524`16254`6125!%^$!%$!%$!%$!%!$%!$$!\ua324".length()), (long)s.getData().length);
        byte[] data = s.getData();
        SimpleString s2 = new SimpleString(data);
        Assert.assertEquals((Object)"hello123ABC__524`16254`6125!%^$!%$!%$!%$!%!$%!$$!\ua324", (Object)s2.toString());
    }

    @Test
    public void testStartsWith() throws Exception {
        SimpleString s1 = new SimpleString("abcdefghi");
        Assert.assertTrue((boolean)s1.startsWith(new SimpleString("abc")));
        Assert.assertTrue((boolean)s1.startsWith(new SimpleString("abcdef")));
        Assert.assertTrue((boolean)s1.startsWith(new SimpleString("abcdefghi")));
        Assert.assertFalse((boolean)s1.startsWith(new SimpleString("abcdefghijklmn")));
        Assert.assertFalse((boolean)s1.startsWith(new SimpleString("aardvark")));
        Assert.assertFalse((boolean)s1.startsWith(new SimpleString("z")));
    }

    @Test
    public void testCharSequence() throws Exception {
        String s = "abcdefghijkl";
        SimpleString s1 = new SimpleString(s);
        Assert.assertEquals((long)97L, (long)s1.charAt(0));
        Assert.assertEquals((long)98L, (long)s1.charAt(1));
        Assert.assertEquals((long)99L, (long)s1.charAt(2));
        Assert.assertEquals((long)107L, (long)s1.charAt(10));
        Assert.assertEquals((long)108L, (long)s1.charAt(11));
        try {
            s1.charAt(-1);
            Assert.fail((String)"Should throw exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            s1.charAt(-2);
            Assert.fail((String)"Should throw exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            s1.charAt(s.length());
            Assert.fail((String)"Should throw exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            s1.charAt(s.length() + 1);
            Assert.fail((String)"Should throw exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        Assert.assertEquals((long)s.length(), (long)s1.length());
        CharSequence ss = s1.subSequence(0, s1.length());
        Assert.assertEquals((Object)ss, (Object)s1);
        ss = s1.subSequence(1, 4);
        Assert.assertEquals((Object)ss, (Object)new SimpleString("bcd"));
        ss = s1.subSequence(5, 10);
        Assert.assertEquals((Object)ss, (Object)new SimpleString("fghij"));
        ss = s1.subSequence(5, 12);
        Assert.assertEquals((Object)ss, (Object)new SimpleString("fghijkl"));
        try {
            s1.subSequence(-1, 2);
            Assert.fail((String)"Should throw exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            s1.subSequence(-4, -2);
            Assert.fail((String)"Should throw exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            s1.subSequence(0, s1.length() + 1);
            Assert.fail((String)"Should throw exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            s1.subSequence(0, s1.length() + 2);
            Assert.fail((String)"Should throw exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            s1.subSequence(5, 1);
            Assert.fail((String)"Should throw exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    @Test
    public void testEquals() throws Exception {
        Assert.assertFalse((boolean)new SimpleString("abcdef").equals(new Object()));
        Assert.assertFalse((boolean)new SimpleString("abcef").equals(null));
        Assert.assertEquals((Object)new SimpleString("abcdef"), (Object)new SimpleString("abcdef"));
        Assert.assertFalse((boolean)new SimpleString("abcdef").equals((Object)new SimpleString("abggcdef")));
        Assert.assertFalse((boolean)new SimpleString("abcdef").equals((Object)new SimpleString("ghijkl")));
    }

    @Test
    public void testHashcode() throws Exception {
        SimpleString str = new SimpleString("abcdef");
        SimpleString sameStr = new SimpleString("abcdef");
        SimpleString differentStr = new SimpleString("ghijk");
        Assert.assertTrue((str.hashCode() == sameStr.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((str.hashCode() == differentStr.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testUnicode() throws Exception {
        String myString = "abcdef&^*&!^ghijkl\ub5e2\ucac7\ub2bb\ub7dd\ub7c7\ub3a3\ubce4\ub5a5";
        SimpleString s = new SimpleString(myString);
        byte[] data = s.getData();
        s = new SimpleString(data);
        Assert.assertEquals((Object)myString, (Object)s.toString());
    }

    @Test
    public void testUnicodeWithSurrogates() throws Exception {
        String myString = "abcdef&^*&!^ghijkl\ud900\udd00";
        SimpleString s = new SimpleString(myString);
        byte[] data = s.getData();
        s = new SimpleString(data);
        Assert.assertEquals((Object)myString, (Object)s.toString());
    }

    @Test
    public void testSizeofString() throws Exception {
        Assert.assertEquals((long)4L, (long)SimpleString.sizeofString((SimpleString)new SimpleString("")));
        SimpleString str = new SimpleString(RandomUtil.randomString());
        Assert.assertEquals((long)(4 + str.getData().length), (long)SimpleString.sizeofString((SimpleString)str));
    }

    @Test
    public void testSizeofNullableString() throws Exception {
        Assert.assertEquals((long)1L, (long)SimpleString.sizeofNullableString(null));
        Assert.assertEquals((long)5L, (long)SimpleString.sizeofNullableString((SimpleString)new SimpleString("")));
        SimpleString str = new SimpleString(RandomUtil.randomString());
        Assert.assertEquals((long)(5 + str.getData().length), (long)SimpleString.sizeofNullableString((SimpleString)str));
    }

    @Test
    public void testSplitNoDelimeter() throws Exception {
        SimpleString s = new SimpleString("abcdefghi");
        SimpleString[] strings = s.split('.');
        Assert.assertNotNull((Object)strings);
        Assert.assertEquals((long)strings.length, (long)1L);
        Assert.assertEquals((Object)strings[0], (Object)s);
    }

    @Test
    public void testSplit1Delimeter() throws Exception {
        SimpleString s = new SimpleString("abcd.efghi");
        SimpleString[] strings = s.split('.');
        Assert.assertNotNull((Object)strings);
        Assert.assertEquals((long)strings.length, (long)2L);
        Assert.assertEquals((Object)strings[0], (Object)new SimpleString("abcd"));
        Assert.assertEquals((Object)strings[1], (Object)new SimpleString("efghi"));
    }

    @Test
    public void testSplitmanyDelimeters() throws Exception {
        SimpleString s = new SimpleString("abcd.efghi.jklmn.opqrs.tuvw.xyz");
        SimpleString[] strings = s.split('.');
        Assert.assertNotNull((Object)strings);
        Assert.assertEquals((long)strings.length, (long)6L);
        Assert.assertEquals((Object)strings[0], (Object)new SimpleString("abcd"));
        Assert.assertEquals((Object)strings[1], (Object)new SimpleString("efghi"));
        Assert.assertEquals((Object)strings[2], (Object)new SimpleString("jklmn"));
        Assert.assertEquals((Object)strings[3], (Object)new SimpleString("opqrs"));
        Assert.assertEquals((Object)strings[4], (Object)new SimpleString("tuvw"));
        Assert.assertEquals((Object)strings[5], (Object)new SimpleString("xyz"));
    }

    @Test
    public void testContains() {
        SimpleString simpleString = new SimpleString("abcdefghijklmnopqrst");
        Assert.assertFalse((boolean)simpleString.contains('.'));
        Assert.assertFalse((boolean)simpleString.contains('%'));
        Assert.assertFalse((boolean)simpleString.contains('8'));
        Assert.assertFalse((boolean)simpleString.contains('.'));
        Assert.assertTrue((boolean)simpleString.contains('a'));
        Assert.assertTrue((boolean)simpleString.contains('b'));
        Assert.assertTrue((boolean)simpleString.contains('c'));
        Assert.assertTrue((boolean)simpleString.contains('d'));
        Assert.assertTrue((boolean)simpleString.contains('e'));
        Assert.assertTrue((boolean)simpleString.contains('f'));
        Assert.assertTrue((boolean)simpleString.contains('g'));
        Assert.assertTrue((boolean)simpleString.contains('h'));
        Assert.assertTrue((boolean)simpleString.contains('i'));
        Assert.assertTrue((boolean)simpleString.contains('j'));
        Assert.assertTrue((boolean)simpleString.contains('k'));
        Assert.assertTrue((boolean)simpleString.contains('l'));
        Assert.assertTrue((boolean)simpleString.contains('m'));
        Assert.assertTrue((boolean)simpleString.contains('n'));
        Assert.assertTrue((boolean)simpleString.contains('o'));
        Assert.assertTrue((boolean)simpleString.contains('p'));
        Assert.assertTrue((boolean)simpleString.contains('q'));
        Assert.assertTrue((boolean)simpleString.contains('r'));
        Assert.assertTrue((boolean)simpleString.contains('s'));
        Assert.assertTrue((boolean)simpleString.contains('t'));
    }

    @Test
    public void testConcat() {
        SimpleString start = new SimpleString("abcdefg");
        SimpleString middle = new SimpleString("hijklmnop");
        SimpleString end = new SimpleString("qrstuvwxyz");
        Assert.assertEquals((Object)start.concat(middle).concat(end), (Object)new SimpleString("abcdefghijklmnopqrstuvwxyz"));
        Assert.assertEquals((Object)start.concat('.').concat(end), (Object)new SimpleString("abcdefg.qrstuvwxyz"));
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)new SimpleString("abcdefg-" + i), (Object)start.concat("-" + Integer.toString(i)));
        }
    }

    @Test
    public void testMultithreadHashCode() throws Exception {
        for (int repeat = 0; repeat < 10; ++repeat) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < 100; ++i) {
                buffer.append("Some Big String " + i);
            }
            String strvalue = buffer.toString();
            final int initialhash = new SimpleString(strvalue).hashCode();
            final SimpleString value = new SimpleString(strvalue);
            int nThreads = 100;
            final CountDownLatch latch = new CountDownLatch(nThreads);
            final CountDownLatch start = new CountDownLatch(1);
            class T
            extends Thread {
                boolean failed = false;

                T() {
                }

                @Override
                public void run() {
                    try {
                        latch.countDown();
                        start.await();
                        int newhash = value.hashCode();
                        if (newhash != initialhash) {
                            this.failed = true;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.failed = true;
                    }
                }
            }
            T[] x = new T[nThreads];
            for (int i = 0; i < nThreads; ++i) {
                x[i] = new T();
                x[i].start();
            }
            UnitTestCase.waitForLatch(latch);
            start.countDown();
            for (T t : x) {
                t.join();
            }
            for (T t : x) {
                Assert.assertFalse((boolean)t.failed);
            }
        }
    }
}

