/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.tests.util;

import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.tests.util.ServiceTestBase;
import org.hornetq.tests.util.UnitTestCase;
import org.junit.Before;

public abstract class SingleServerTestBase
extends ServiceTestBase {
    protected HornetQServer server;
    protected ClientSession session;
    protected ClientSessionFactory sf;
    protected ServerLocator locator;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration configuration = this.createDefaultConfig().setSecurityEnabled(false);
        this.server = this.createServer(false, configuration);
        this.server.start();
        this.locator = this.createLocator();
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.addClientSession(this.sf.createSession(false, true, true));
    }

    protected ServerLocator createLocator() {
        ServerLocator retlocator = HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(UnitTestCase.INVM_CONNECTOR_FACTORY)});
        this.addServerLocator(retlocator);
        return retlocator;
    }
}

