/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.filter.impl;

import org.hornetq.api.core.FilterConstants;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.selector.SelectorParser;
import org.hornetq.selector.filter.BooleanExpression;
import org.hornetq.selector.filter.FilterException;
import org.hornetq.selector.filter.Filterable;

public class FilterImpl
implements Filter {
    private final SimpleString sfilterString;
    private final BooleanExpression booleanExpression;

    public static Filter createFilter(String filterStr) throws HornetQException {
        return FilterImpl.createFilter(SimpleString.toSimpleString((String)(filterStr == null ? null : filterStr.trim())));
    }

    public static Filter createFilter(SimpleString filterStr) throws HornetQException {
        BooleanExpression booleanExpression;
        if (filterStr == null || filterStr.length() == 0) {
            return null;
        }
        try {
            booleanExpression = SelectorParser.parse((String)filterStr.toString());
        }
        catch (Throwable e) {
            HornetQServerLogger.LOGGER.invalidFilter(e, filterStr);
            throw HornetQMessageBundle.BUNDLE.invalidFilter(e, filterStr);
        }
        return new FilterImpl(filterStr, booleanExpression);
    }

    private FilterImpl(SimpleString str, BooleanExpression expression) {
        this.sfilterString = str;
        this.booleanExpression = expression;
    }

    @Override
    public SimpleString getFilterString() {
        return this.sfilterString;
    }

    @Override
    public synchronized boolean match(ServerMessage message) {
        try {
            boolean result = this.booleanExpression.matches((Filterable)new FilterableServerMessage(message));
            return result;
        }
        catch (Exception e) {
            HornetQServerLogger.LOGGER.invalidFilter(e, this.sfilterString);
            return false;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sfilterString == null ? 0 : this.sfilterString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterImpl other = (FilterImpl)obj;
        return !(this.sfilterString == null ? other.sfilterString != null : !this.sfilterString.equals((Object)other.sfilterString));
    }

    public String toString() {
        return "FilterImpl [sfilterString=" + this.sfilterString + "]";
    }

    private static Object getHeaderFieldValue(ServerMessage msg, SimpleString fieldName) {
        if (FilterConstants.HORNETQ_USERID.equals((Object)fieldName)) {
            return new SimpleString("ID:" + msg.getUserID());
        }
        if (FilterConstants.HORNETQ_PRIORITY.equals((Object)fieldName)) {
            return (int)msg.getPriority();
        }
        if (FilterConstants.HORNETQ_TIMESTAMP.equals((Object)fieldName)) {
            return msg.getTimestamp();
        }
        if (FilterConstants.HORNETQ_DURABLE.equals((Object)fieldName)) {
            return msg.isDurable() ? FilterConstants.DURABLE : FilterConstants.NON_DURABLE;
        }
        if (FilterConstants.HORNETQ_EXPIRATION.equals((Object)fieldName)) {
            return msg.getExpiration();
        }
        if (FilterConstants.HORNETQ_SIZE.equals((Object)fieldName)) {
            return msg.getEncodeSize();
        }
        return null;
    }

    private static class FilterableServerMessage
    implements Filterable {
        private final ServerMessage message;

        public FilterableServerMessage(ServerMessage message) {
            this.message = message;
        }

        public Object getProperty(String id) {
            Object result = null;
            if (id.startsWith(FilterConstants.HORNETQ_PREFIX.toString())) {
                result = FilterImpl.getHeaderFieldValue(this.message, new SimpleString(id));
            }
            if (result == null) {
                result = this.message.getObjectProperty(new SimpleString(id));
            }
            if (result != null && result.getClass() == SimpleString.class) {
                result = result.toString();
            }
            return result;
        }

        public <T> T getBodyAs(Class<T> type) throws FilterException {
            return null;
        }

        public Object getLocalConnectionId() {
            return null;
        }
    }
}

