/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.security.impl;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.management.CoreNotificationType;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.security.CheckType;
import org.hornetq.core.security.Role;
import org.hornetq.core.security.SecurityStore;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.server.management.NotificationService;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.HierarchicalRepositoryChangeListener;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.TypedProperties;

public class SecurityStoreImpl
implements SecurityStore,
HierarchicalRepositoryChangeListener {
    private final boolean trace = HornetQServerLogger.LOGGER.isTraceEnabled();
    private final HierarchicalRepository<Set<Role>> securityRepository;
    private final HornetQSecurityManager securityManager;
    private final ConcurrentMap<String, ConcurrentHashSet<SimpleString>> cache = new ConcurrentHashMap<String, ConcurrentHashSet<SimpleString>>();
    private final long invalidationInterval;
    private volatile long lastCheck;
    private final boolean securityEnabled;
    private final String managementClusterUser;
    private final String managementClusterPassword;
    private final NotificationService notificationService;

    public SecurityStoreImpl(HierarchicalRepository<Set<Role>> securityRepository, HornetQSecurityManager securityManager, long invalidationInterval, boolean securityEnabled, String managementClusterUser, String managementClusterPassword, NotificationService notificationService) {
        this.securityRepository = securityRepository;
        this.securityManager = securityManager;
        this.invalidationInterval = invalidationInterval;
        this.securityEnabled = securityEnabled;
        this.managementClusterUser = managementClusterUser;
        this.managementClusterPassword = managementClusterPassword;
        this.notificationService = notificationService;
        this.securityRepository.registerListener(this);
    }

    @Override
    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    @Override
    public void stop() {
        this.securityRepository.unRegisterListener(this);
    }

    @Override
    public void authenticate(String user, String password) throws Exception {
        if (this.securityEnabled) {
            if (this.managementClusterUser.equals(user)) {
                if (this.trace) {
                    HornetQServerLogger.LOGGER.trace("Authenticating cluster admin user");
                }
                if (!this.managementClusterPassword.equals(password)) {
                    throw HornetQMessageBundle.BUNDLE.unableToValidateClusterUser(user);
                }
                return;
            }
            if (!this.securityManager.validateUser(user, password)) {
                if (this.notificationService != null) {
                    TypedProperties props = new TypedProperties();
                    props.putSimpleStringProperty(ManagementHelper.HDR_USER, SimpleString.toSimpleString((String)user));
                    Notification notification = new Notification(null, (NotificationType)CoreNotificationType.SECURITY_AUTHENTICATION_VIOLATION, props);
                    this.notificationService.sendNotification(notification);
                }
                throw HornetQMessageBundle.BUNDLE.unableToValidateUser(user);
            }
        }
    }

    @Override
    public void check(SimpleString address, CheckType checkType, ServerSession session) throws Exception {
        if (this.securityEnabled) {
            String user;
            if (this.trace) {
                HornetQServerLogger.LOGGER.trace("checking access permissions to " + address);
            }
            if (this.checkCached(address, user = session.getUsername(), checkType)) {
                return;
            }
            String saddress = address.toString();
            Set<Role> roles = this.securityRepository.getMatch(saddress);
            if (this.managementClusterUser.equals(user) && session.getPassword().equals(this.managementClusterPassword)) {
                return;
            }
            if (!this.securityManager.validateUserAndRole(user, session.getPassword(), roles, checkType)) {
                if (this.notificationService != null) {
                    TypedProperties props = new TypedProperties();
                    props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, address);
                    props.putSimpleStringProperty(ManagementHelper.HDR_CHECK_TYPE, new SimpleString(checkType.toString()));
                    props.putSimpleStringProperty(ManagementHelper.HDR_USER, SimpleString.toSimpleString((String)user));
                    Notification notification = new Notification(null, (NotificationType)CoreNotificationType.SECURITY_PERMISSION_VIOLATION, props);
                    this.notificationService.sendNotification(notification);
                }
                throw HornetQMessageBundle.BUNDLE.userNoPermissions(session.getUsername(), checkType, saddress);
            }
            ConcurrentHashSet<SimpleString> set = new ConcurrentHashSet<SimpleString>();
            ConcurrentHashSet<SimpleString> act = this.cache.putIfAbsent(user + "." + checkType.name(), set);
            if (act != null) {
                set = act;
            }
            set.add((Object)address);
        }
    }

    @Override
    public void onChange() {
        this.invalidateCache();
    }

    private void invalidateCache() {
        this.cache.clear();
    }

    private boolean checkCached(SimpleString dest, String user, CheckType checkType) {
        long now = System.currentTimeMillis();
        boolean granted = false;
        if (now - this.lastCheck > this.invalidationInterval) {
            this.invalidateCache();
            this.lastCheck = now;
        } else {
            ConcurrentHashSet act = (ConcurrentHashSet)this.cache.get(user + "." + checkType.name());
            if (act != null) {
                granted = act.contains((Object)dest);
            }
        }
        return granted;
    }
}

