/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.ha;

import java.util.Map;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.core.server.cluster.ha.HAPolicy;
import org.hornetq.core.server.cluster.ha.SharedStoreSlavePolicy;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.core.server.impl.LiveActivation;
import org.hornetq.core.server.impl.SharedStoreLiveActivation;

public class SharedStoreMasterPolicy
implements HAPolicy<LiveActivation> {
    private long failbackDelay = HornetQDefaultConfiguration.getDefaultFailbackDelay();
    private boolean failoverOnServerShutdown = HornetQDefaultConfiguration.isDefaultFailoverOnServerShutdown();
    private SharedStoreSlavePolicy sharedStoreSlavePolicy;

    public SharedStoreMasterPolicy() {
    }

    public SharedStoreMasterPolicy(long failbackDelay, boolean failoverOnServerShutdown) {
        this.failbackDelay = failbackDelay;
        this.failoverOnServerShutdown = failoverOnServerShutdown;
    }

    public long getFailbackDelay() {
        return this.failbackDelay;
    }

    public void setFailbackDelay(long failbackDelay) {
        this.failbackDelay = failbackDelay;
    }

    public boolean isFailoverOnServerShutdown() {
        return this.failoverOnServerShutdown;
    }

    public void setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        this.failoverOnServerShutdown = failoverOnServerShutdown;
    }

    public SharedStoreSlavePolicy getSharedStoreSlavePolicy() {
        return this.sharedStoreSlavePolicy;
    }

    public void setSharedStoreSlavePolicy(SharedStoreSlavePolicy sharedStoreSlavePolicy) {
        this.sharedStoreSlavePolicy = sharedStoreSlavePolicy;
    }

    @Override
    public boolean isSharedStore() {
        return true;
    }

    @Override
    public boolean isBackup() {
        return false;
    }

    @Override
    public boolean canScaleDown() {
        return false;
    }

    @Override
    public LiveActivation createActivation(HornetQServerImpl server, boolean wasLive, Map<String, Object> activationParams, HornetQServerImpl.ShutdownOnCriticalErrorListener shutdownOnCriticalIO) {
        return new SharedStoreLiveActivation(server, this);
    }

    @Override
    public String getBackupGroupName() {
        return null;
    }

    @Override
    public String getScaleDownGroupName() {
        return null;
    }

    @Override
    public String getScaleDownClustername() {
        return null;
    }
}

