/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.postoffice.DuplicateIDCache;
import org.hornetq.core.postoffice.impl.PostOfficeImpl;
import org.hornetq.core.remoting.server.RemotingService;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.LiveNodeLocator;
import org.hornetq.core.server.cluster.HornetQServerSideProtocolManagerFactory;
import org.hornetq.core.server.cluster.ha.LiveOnlyPolicy;
import org.hornetq.core.server.cluster.ha.ScaleDownPolicy;
import org.hornetq.core.server.impl.Activation;
import org.hornetq.core.server.impl.AnyLiveNodeLocatorForScaleDown;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.core.server.impl.NamedLiveNodeLocatorForScaleDown;
import org.hornetq.core.server.impl.ScaleDownHandler;
import org.hornetq.spi.core.remoting.ClientProtocolManagerFactory;

public class LiveOnlyActivation
extends Activation {
    private LiveOnlyPolicy liveOnlyPolicy;
    private final HornetQServerImpl hornetQServer;
    private ServerLocatorInternal scaleDownServerLocator;
    private ClientSessionFactoryInternal scaleDownClientSessionFactory;

    public LiveOnlyActivation(HornetQServerImpl server, LiveOnlyPolicy liveOnlyPolicy) {
        this.hornetQServer = server;
        this.liveOnlyPolicy = liveOnlyPolicy;
    }

    @Override
    public void run() {
        try {
            this.hornetQServer.initialisePart1(false);
            this.hornetQServer.initialisePart2(false);
            if (this.hornetQServer.getIdentity() != null) {
                HornetQServerLogger.LOGGER.serverIsLive(this.hornetQServer.getIdentity());
            } else {
                HornetQServerLogger.LOGGER.serverIsLive();
            }
        }
        catch (Exception e) {
            HornetQServerLogger.LOGGER.initializationError(e);
        }
    }

    @Override
    public void close(boolean permanently, boolean restarting) throws Exception {
        if (this.scaleDownServerLocator != null) {
            this.scaleDownServerLocator.close();
            this.scaleDownServerLocator = null;
        }
    }

    @Override
    public void freezeConnections(RemotingService remotingService) {
        String nodeID;
        if (this.liveOnlyPolicy.getScaleDownPolicy() != null && this.liveOnlyPolicy.getScaleDownPolicy().isEnabled()) {
            this.connectToScaleDownTarget(this.liveOnlyPolicy.getScaleDownPolicy());
        }
        TransportConfiguration tc = this.scaleDownClientSessionFactory == null ? null : this.scaleDownClientSessionFactory.getConnectorConfiguration();
        String string = nodeID = tc == null ? null : this.scaleDownClientSessionFactory.getServerLocator().getTopology().getMember(tc).getNodeId();
        if (remotingService != null) {
            remotingService.freeze(nodeID, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postConnectionFreeze() {
        if (this.liveOnlyPolicy.getScaleDownPolicy() != null && this.liveOnlyPolicy.getScaleDownPolicy().isEnabled() && this.scaleDownClientSessionFactory != null) {
            try {
                this.scaleDown();
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.failedToScaleDown(e);
            }
            finally {
                this.scaleDownClientSessionFactory.close();
                this.scaleDownServerLocator.close();
            }
        }
    }

    public void connectToScaleDownTarget(ScaleDownPolicy scaleDownPolicy) {
        try {
            this.scaleDownServerLocator = ScaleDownPolicy.getScaleDownConnector(scaleDownPolicy, this.hornetQServer);
            this.scaleDownServerLocator.setProtocolManagerFactory((ClientProtocolManagerFactory)HornetQServerSideProtocolManagerFactory.getInstance());
            LiveNodeLocator nodeLocator = scaleDownPolicy.getGroupName() == null ? new AnyLiveNodeLocatorForScaleDown(this.hornetQServer) : new NamedLiveNodeLocatorForScaleDown(scaleDownPolicy.getGroupName(), this.hornetQServer);
            this.scaleDownServerLocator.addClusterTopologyListener((ClusterTopologyListener)nodeLocator);
            nodeLocator.connectToCluster(this.scaleDownServerLocator);
            nodeLocator.locateNode(10000L);
            ClientSessionFactoryInternal clientSessionFactory = null;
            while (clientSessionFactory == null) {
                Pair<TransportConfiguration, TransportConfiguration> possibleLive = null;
                try {
                    possibleLive = nodeLocator.getLiveConfiguration();
                    if (possibleLive == null) break;
                    clientSessionFactory = (ClientSessionFactoryInternal)this.scaleDownServerLocator.createSessionFactory((TransportConfiguration)possibleLive.getA(), 0, false);
                }
                catch (Exception e) {
                    HornetQServerLogger.LOGGER.trace("Failed to connect to " + possibleLive.getA());
                    nodeLocator.notifyRegistrationFailed(false);
                    if (clientSessionFactory != null) {
                        clientSessionFactory.close();
                    }
                    clientSessionFactory = null;
                }
            }
            if (clientSessionFactory == null) {
                throw new HornetQException("Unable to connect to server for scale-down");
            }
            this.scaleDownClientSessionFactory = clientSessionFactory;
        }
        catch (Exception e) {
            HornetQServerLogger.LOGGER.failedToScaleDown(e);
        }
    }

    public long scaleDown() throws Exception {
        ScaleDownHandler scaleDownHandler = new ScaleDownHandler(this.hornetQServer.getPagingManager(), this.hornetQServer.getPostOffice(), this.hornetQServer.getNodeManager(), this.hornetQServer.getClusterManager().getClusterController());
        ConcurrentMap<SimpleString, DuplicateIDCache> duplicateIDCaches = ((PostOfficeImpl)this.hornetQServer.getPostOffice()).getDuplicateIDCaches();
        HashMap<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap = new HashMap<SimpleString, List<Pair<byte[], Long>>>();
        for (SimpleString address : duplicateIDCaches.keySet()) {
            DuplicateIDCache duplicateIDCache = this.hornetQServer.getPostOffice().getDuplicateIDCache(address);
            duplicateIDMap.put(address, duplicateIDCache.getMap());
        }
        return scaleDownHandler.scaleDown((ClientSessionFactory)this.scaleDownClientSessionFactory, this.hornetQServer.getResourceManager(), duplicateIDMap, this.hornetQServer.getManagementService().getManagementAddress(), null);
    }
}

