/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.TopologyMember;
import org.hornetq.core.server.LiveNodeLocator;
import org.hornetq.core.server.cluster.qourum.SharedNothingBackupQuorum;

public class NamedLiveNodeLocatorForReplication
extends LiveNodeLocator {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final String backupGroupName;
    private Pair<TransportConfiguration, TransportConfiguration> liveConfiguration;
    private String nodeID;

    public NamedLiveNodeLocatorForReplication(String backupGroupName, SharedNothingBackupQuorum quorumManager) {
        super(quorumManager);
        this.backupGroupName = backupGroupName;
    }

    @Override
    public void locateNode() throws HornetQException {
        this.locateNode(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locateNode(long timeout) throws HornetQException {
        block6: {
            try {
                this.lock.lock();
                if (this.liveConfiguration != null) break block6;
                try {
                    if (timeout != -1L) {
                        this.condition.await(timeout, TimeUnit.MILLISECONDS);
                        break block6;
                    }
                    this.condition.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeUP(TopologyMember topologyMember, boolean last) {
        try {
            this.lock.lock();
            if (this.backupGroupName.equals(topologyMember.getBackupGroupName()) && topologyMember.getLive() != null) {
                this.liveConfiguration = new Pair((Object)topologyMember.getLive(), (Object)topologyMember.getBackup());
                this.nodeID = topologyMember.getNodeId();
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void nodeDown(long eventUID, String nodeID) {
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public Pair<TransportConfiguration, TransportConfiguration> getLiveConfiguration() {
        return this.liveConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyRegistrationFailed(boolean alreadyReplicating) {
        try {
            this.lock.lock();
            this.liveConfiguration = null;
            super.notifyRegistrationFailed(alreadyReplicating);
        }
        finally {
            this.lock.unlock();
        }
    }
}

