/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientRequestor;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.message.impl.MessageImpl;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.paging.cursor.PageSubscription;
import org.hornetq.core.paging.cursor.PagedReference;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.postoffice.impl.LocalQueueBinding;
import org.hornetq.core.postoffice.impl.PostOfficeImpl;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.NodeManager;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.cluster.ClusterControl;
import org.hornetq.core.server.cluster.ClusterController;
import org.hornetq.core.server.impl.RefsOperation;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.TransactionOperation;
import org.hornetq.utils.LinkedListIterator;

public class ScaleDownHandler {
    final PagingManager pagingManager;
    final PostOffice postOffice;
    private NodeManager nodeManager;
    private final ClusterController clusterController;
    private String targetNodeId;

    public ScaleDownHandler(PagingManager pagingManager, PostOffice postOffice, NodeManager nodeManager, ClusterController clusterController) {
        this.pagingManager = pagingManager;
        this.postOffice = postOffice;
        this.nodeManager = nodeManager;
        this.clusterController = clusterController;
    }

    public long scaleDown(ClientSessionFactory sessionFactory, ResourceManager resourceManager, Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap, SimpleString managementAddress, SimpleString targetNodeId) throws Exception {
        ClusterControl clusterControl = this.clusterController.connectToNodeInCluster((ClientSessionFactoryInternal)sessionFactory);
        clusterControl.authorize();
        long num = this.scaleDownMessages(sessionFactory, targetNodeId);
        HornetQServerLogger.LOGGER.info("Scaled down " + num + " messages total.");
        this.scaleDownTransactions(sessionFactory, resourceManager);
        this.scaleDownDuplicateIDs(duplicateIDMap, sessionFactory, managementAddress);
        clusterControl.announceScaleDown(new SimpleString(this.targetNodeId), this.nodeManager.getNodeId());
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long scaleDownMessages(ClientSessionFactory sessionFactory, SimpleString nodeId) throws Exception {
        long messageCount = 0L;
        this.targetNodeId = nodeId != null ? nodeId.toString() : this.getTargetNodeId(sessionFactory);
        ClientSession session = sessionFactory.createSession(false, true, true);
        HashMap<String, Long> queueIDs = new HashMap<String, Long>();
        ClientProducer producer = session.createProducer();
        ArrayList<SimpleString> addresses = new ArrayList<SimpleString>();
        for (Map.Entry<SimpleString, Binding> entry : this.postOffice.getAllBindings().entrySet()) {
            if (!(entry.getValue() instanceof LocalQueueBinding)) continue;
            SimpleString address = entry.getValue().getAddress();
            boolean storeAndForward = false;
            if (address.toString().startsWith("sf.")) {
                storeAndForward = true;
            }
            if (addresses.contains(address)) continue;
            addresses.add(address);
            PagingStore store = this.pagingManager.getPageStore(address);
            ArrayList<Queue> queues = new ArrayList<Queue>();
            HashMap<SimpleString, LinkedListIterator<MessageReference>> queueIterators = new HashMap<SimpleString, LinkedListIterator<MessageReference>>();
            for (Binding binding : this.postOffice.getBindingsForAddress(address).getBindings()) {
                if (!(binding instanceof LocalQueueBinding)) continue;
                Queue queue = ((LocalQueueBinding)binding).getQueue();
                List<MessageReference> messageReferences = queue.cancelScheduledMessages();
                for (MessageReference ref : messageReferences) {
                    ref.getMessage().putLongProperty(MessageImpl.HDR_SCHEDULED_DELIVERY_TIME, ref.getScheduledDeliveryTime());
                    ref.setScheduledDeliveryTime(0L);
                }
                queue.addHead(messageReferences);
                queues.add(queue);
                queueIterators.put(queue.getName(), queue.totalIterator());
            }
            Collections.sort(queues, new OrderQueueByNumberOfReferencesComparator());
            ArrayList<SimpleString> checkedQueues = new ArrayList<SimpleString>();
            for (Queue bigLoopQueue : queues) {
                checkedQueues.add(bigLoopQueue.getName());
                LinkedListIterator<MessageReference> bigLoopMessageIterator = bigLoopQueue.totalIterator();
                try {
                    while (bigLoopMessageIterator.hasNext()) {
                        MessageReference bigLoopRef = (MessageReference)bigLoopMessageIterator.next();
                        ServerMessage message = bigLoopRef.getMessage().copy();
                        if (storeAndForward) {
                            ArrayList<SimpleString> propertiesToRemove;
                            byte[] oldRouteToIDs;
                            if (address.toString().endsWith(this.targetNodeId)) {
                                oldRouteToIDs = null;
                                propertiesToRemove = new ArrayList<SimpleString>();
                                message.removeProperty(MessageImpl.HDR_ROUTE_TO_IDS);
                                for (SimpleString propName : message.getPropertyNames()) {
                                    if (!propName.startsWith(MessageImpl.HDR_ROUTE_TO_IDS)) continue;
                                    if (propName.toString().endsWith(this.targetNodeId)) {
                                        oldRouteToIDs = message.getBytesProperty(propName);
                                    }
                                    propertiesToRemove.add(propName);
                                }
                                for (SimpleString propertyToRemove : propertiesToRemove) {
                                    message.removeProperty(propertyToRemove);
                                }
                                message.putBytesProperty(MessageImpl.HDR_ROUTE_TO_IDS, oldRouteToIDs);
                            } else {
                                oldRouteToIDs = null;
                                propertiesToRemove = new ArrayList();
                                message.removeProperty(MessageImpl.HDR_ROUTE_TO_IDS);
                                for (SimpleString propName : message.getPropertyNames()) {
                                    if (!propName.startsWith(MessageImpl.HDR_ROUTE_TO_IDS)) continue;
                                    if (propName.toString().endsWith(address.toString().substring(address.toString().lastIndexOf(".")))) {
                                        oldRouteToIDs = message.getBytesProperty(propName);
                                    }
                                    propertiesToRemove.add(propName);
                                }
                                for (SimpleString propertyToRemove : propertiesToRemove) {
                                    message.removeProperty(propertyToRemove);
                                }
                                message.putBytesProperty(MessageImpl.HDR_SCALEDOWN_TO_IDS, oldRouteToIDs);
                            }
                            HornetQServerLogger.LOGGER.debug("Scaling down message " + message + " from " + address + " to " + message.getAddress() + " on node " + this.targetNodeId);
                            producer.send(message.getAddress(), (Message)message);
                            ++messageCount;
                            bigLoopQueue.deleteReference(message.getMessageID());
                            continue;
                        }
                        ArrayList<Queue> queuesWithMessage = new ArrayList<Queue>();
                        queuesWithMessage.add(bigLoopQueue);
                        long messageId = message.getMessageID();
                        this.getQueuesWithMessage(store, queues, queueIterators, checkedQueues, bigLoopQueue, queuesWithMessage, bigLoopRef, messageId);
                        ByteBuffer buffer = ByteBuffer.allocate(queuesWithMessage.size() * 8);
                        StringBuilder logMessage = new StringBuilder();
                        logMessage.append("Scaling down message ").append(messageId).append(" to ");
                        for (Queue queue : queuesWithMessage) {
                            long queueID;
                            String queueName = queue.getName().toString();
                            if (queueIDs.containsKey(queueName)) {
                                queueID = (Long)queueIDs.get(queueName);
                            } else {
                                queueID = this.createQueueIfNecessaryAndGetID(session, queue, address);
                                queueIDs.put(queueName, queueID);
                            }
                            logMessage.append(queueName).append("(").append(queueID).append(")").append(", ");
                            buffer.putLong(queueID);
                        }
                        logMessage.delete(logMessage.length() - 2, logMessage.length());
                        HornetQServerLogger.LOGGER.debug(logMessage.append(" on address ").append((CharSequence)address));
                        message.putBytesProperty(MessageImpl.HDR_ROUTE_TO_IDS, buffer.array());
                        if (message.containsProperty(MessageImpl.HDR_DUPLICATE_DETECTION_ID)) {
                            byte[] bytes = new byte[24];
                            ByteBuffer bb = ByteBuffer.wrap(bytes);
                            bb.put(this.nodeManager.getUUID().asBytes());
                            bb.putLong(messageId);
                            message.putBytesProperty(MessageImpl.HDR_BRIDGE_DUPLICATE_ID, bb.array());
                        }
                        producer.send(address, (Message)message);
                        ++messageCount;
                        bigLoopQueue.deleteReference(messageId);
                        for (Queue queue : queuesWithMessage) {
                            queue.deleteReference(messageId);
                        }
                    }
                }
                finally {
                    bigLoopMessageIterator.close();
                    ((LinkedListIterator)queueIterators.get(bigLoopQueue.getName())).close();
                }
            }
        }
        producer.close();
        session.close();
        return messageCount;
    }

    private String getTargetNodeId(ClientSessionFactory sessionFactory) {
        return sessionFactory.getServerLocator().getTopology().getMember(sessionFactory.getConnectorConfiguration()).getNodeId();
    }

    public void scaleDownTransactions(ClientSessionFactory sessionFactory, ResourceManager resourceManager) throws Exception {
        ClientSession session = sessionFactory.createSession(true, false, false);
        ClientSession queueCreateSession = sessionFactory.createSession(false, true, true);
        List<Xid> preparedTransactions = resourceManager.getPreparedTransactions();
        HashMap<String, Long> queueIDs = new HashMap<String, Long>();
        for (Xid xid : preparedTransactions) {
            HornetQServerLogger.LOGGER.debug("Scaling down transaction: " + xid);
            Transaction transaction = resourceManager.getTransaction(xid);
            session.start(xid, 0);
            List<TransactionOperation> allOperations = transaction.getAllOperations();
            HashMap<ServerMessage, Pair> queuesToSendTo = new HashMap<ServerMessage, Pair>();
            for (TransactionOperation operation : allOperations) {
                Pair queueIds;
                long queueID;
                String queueName;
                Queue queue;
                ServerMessage message;
                List<MessageReference> refs;
                if (operation instanceof PostOfficeImpl.AddOperation) {
                    PostOfficeImpl.AddOperation addOperation = (PostOfficeImpl.AddOperation)operation;
                    refs = addOperation.getRelatedMessageReferences();
                    for (MessageReference ref : refs) {
                        message = ref.getMessage();
                        queue = ref.getQueue();
                        queueName = queue.getName().toString();
                        if (queueIDs.containsKey(queueName)) {
                            queueID = (Long)queueIDs.get(queueName);
                        } else {
                            queueID = this.createQueueIfNecessaryAndGetID(queueCreateSession, queue, message.getAddress());
                            queueIDs.put(queueName, queueID);
                        }
                        queueIds = (Pair)queuesToSendTo.get(message);
                        if (queueIds == null) {
                            queueIds = new Pair(new ArrayList(), new ArrayList());
                            queuesToSendTo.put(message, queueIds);
                        }
                        ((List)queueIds.getA()).add(queueID);
                    }
                    continue;
                }
                if (!(operation instanceof RefsOperation)) continue;
                RefsOperation refsOperation = (RefsOperation)operation;
                refs = refsOperation.getReferencesToAcknowledge();
                for (MessageReference ref : refs) {
                    message = ref.getMessage();
                    queue = ref.getQueue();
                    queueName = queue.getName().toString();
                    if (queueIDs.containsKey(queueName)) {
                        queueID = (Long)queueIDs.get(queueName);
                    } else {
                        queueID = this.createQueueIfNecessaryAndGetID(queueCreateSession, queue, message.getAddress());
                        queueIDs.put(queueName, queueID);
                    }
                    queueIds = (Pair)queuesToSendTo.get(message);
                    if (queueIds == null) {
                        queueIds = new Pair(new ArrayList(), new ArrayList());
                        queuesToSendTo.put(message, queueIds);
                    }
                    ((List)queueIds.getA()).add(queueID);
                    ((List)queueIds.getB()).add(queueID);
                }
            }
            ClientProducer producer = session.createProducer();
            for (Map.Entry entry : queuesToSendTo.entrySet()) {
                List ids = (List)((Pair)entry.getValue()).getA();
                ByteBuffer buffer = ByteBuffer.allocate(ids.size() * 8);
                for (Long id : ids) {
                    buffer.putLong(id);
                }
                ServerMessage message = (ServerMessage)entry.getKey();
                message.putBytesProperty(MessageImpl.HDR_ROUTE_TO_IDS, buffer.array());
                ids = (List)((Pair)entry.getValue()).getB();
                if (ids.size() > 0) {
                    buffer = ByteBuffer.allocate(ids.size() * 8);
                    for (Long id : ids) {
                        buffer.putLong(id);
                    }
                    message.putBytesProperty(MessageImpl.HDR_ROUTE_TO_ACK_IDS, buffer.array());
                }
                producer.send(message.getAddress(), (Message)message);
            }
            session.end(xid, 0x4000000);
            session.prepare(xid);
        }
    }

    public void scaleDownDuplicateIDs(Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap, ClientSessionFactory sessionFactory, SimpleString managementAddress) throws Exception {
        ClientSession session = sessionFactory.createSession(true, false, false);
        ClientProducer producer = session.createProducer(managementAddress);
        for (SimpleString address : duplicateIDMap.keySet()) {
            ClientMessage message = session.createMessage(false);
            List<Pair<byte[], Long>> list = duplicateIDMap.get(address);
            String[] array = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Pair<byte[], Long> pair = list.get(i);
                array[i] = new String((byte[])pair.getA());
            }
            ManagementHelper.putOperationInvocation((Message)message, (String)"core.server", (String)"updateDuplicateIdCache", (Object[])new Object[]{address.toString(), array});
            producer.send((Message)message);
        }
        session.close();
    }

    private void getQueuesWithMessage(PagingStore store, List<Queue> queues, Map<SimpleString, LinkedListIterator<MessageReference>> queueIterators, List<SimpleString> checkedQueues, Queue bigLoopQueue, List<Queue> queuesWithMessage, MessageReference bigLoopRef, long messageId) throws Exception {
        block0: for (Queue queue : queues) {
            ServerMessage m;
            if (checkedQueues.contains(queue.getName()) || (queue.getFilter() != null || bigLoopQueue.getFilter() != null) && (queue.getFilter() == null || !queue.getFilter().equals(bigLoopQueue.getFilter()))) continue;
            if (bigLoopRef.isPaged()) {
                PageSubscription subscription = store.getCursorProvider().getSubscription(queue.getID());
                if (!subscription.contains((PagedReference)bigLoopRef)) continue;
                queuesWithMessage.add(queue);
                continue;
            }
            LinkedListIterator<MessageReference> queueIterator = queueIterators.get(queue.getName());
            boolean first = true;
            long initialMessageID = 0L;
            while (queueIterator.hasNext()) {
                m = ((MessageReference)queueIterator.next()).getMessage();
                if (first) {
                    initialMessageID = m.getMessageID();
                    first = false;
                }
                if (m.getMessageID() != messageId) continue;
                queuesWithMessage.add(queue);
                break;
            }
            if (queueIterator.hasNext()) continue;
            queueIterator = queue.totalIterator();
            queueIterators.put(queue.getName(), queueIterator);
            while (queueIterator.hasNext() && (m = ((MessageReference)queueIterator.next()).getMessage()).getMessageID() != initialMessageID) {
                if (m.getMessageID() != messageId) continue;
                queuesWithMessage.add(queue);
                continue block0;
            }
        }
    }

    private long createQueueIfNecessaryAndGetID(ClientSession session, Queue queue, SimpleString addressName) throws Exception {
        long queueID = this.getQueueID(session, queue.getName()).intValue();
        if (queueID == -1L) {
            session.createQueue(addressName, queue.getName(), queue.getFilter() == null ? null : queue.getFilter().getFilterString(), queue.isDurable());
            HornetQServerLogger.LOGGER.debug("Failed to get queue ID, creating queue [addressName=" + addressName + ", queueName=" + queue.getName() + ", filter=" + (queue.getFilter() == null ? "" : queue.getFilter().getFilterString()) + ", durable=" + queue.isDurable() + "]");
            queueID = this.getQueueID(session, queue.getName()).intValue();
        }
        HornetQServerLogger.LOGGER.debug("ID for " + queue + " is: " + queueID);
        return queueID;
    }

    private Integer getQueueID(ClientSession session, SimpleString queueName) throws Exception {
        Integer queueID = -1;
        ClientRequestor requestor = new ClientRequestor(session, "jms.queue.hornetq.management");
        ClientMessage managementMessage = session.createMessage(false);
        ManagementHelper.putAttribute((Message)managementMessage, (String)("core.queue." + queueName), (String)"ID");
        session.start();
        HornetQServerLogger.LOGGER.debug("Requesting ID for: " + queueName);
        ClientMessage reply = requestor.request(managementMessage);
        Object result = ManagementHelper.getResult((Message)reply);
        if (result != null && result instanceof Integer) {
            queueID = (Integer)result;
        }
        requestor.close();
        return queueID;
    }

    public static class OrderQueueByNumberOfReferencesComparator
    implements Comparator<Queue> {
        @Override
        public int compare(Queue queue1, Queue queue2) {
            int BEFORE = -1;
            boolean EQUAL = false;
            boolean AFTER = true;
            int result = 0;
            if (queue1 == queue2) {
                return 0;
            }
            if (queue1.getMessageCount() == queue2.getMessageCount()) {
                return 0;
            }
            if (queue1.getMessageCount() > queue2.getMessageCount()) {
                return -1;
            }
            if (queue1.getMessageCount() < queue2.getMessageCount()) {
                return 1;
            }
            return result;
        }
    }
}

