/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.lang.reflect.Array;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.HornetQAlreadyReplicatingException;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.TopologyMember;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.config.ClusterConnectionConfiguration;
import org.hornetq.core.config.ConfigurationUtils;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.ChannelHandler;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.wireformat.BackupRegistrationMessage;
import org.hornetq.core.protocol.core.impl.wireformat.BackupReplicationStartFailedMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationLiveIsStoppingMessage;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.core.remoting.server.RemotingService;
import org.hornetq.core.replication.ReplicationManager;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.NodeManager;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.cluster.ha.ReplicatedPolicy;
import org.hornetq.core.server.impl.BackupTopologyListener;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.core.server.impl.LiveActivation;
import org.hornetq.spi.core.remoting.Acceptor;

public class SharedNothingLiveActivation
extends LiveActivation {
    private ReplicatedPolicy replicatedPolicy;
    private HornetQServerImpl hornetQServer;
    private ReplicationManager replicationManager;
    private final Object replicationLock = new Object();

    public SharedNothingLiveActivation(HornetQServerImpl hornetQServer, ReplicatedPolicy replicatedPolicy) {
        this.hornetQServer = hornetQServer;
        this.replicatedPolicy = replicatedPolicy;
    }

    @Override
    public void freezeConnections(RemotingService remotingService) {
        ReplicationManager localReplicationManager = this.replicationManager;
        if (remotingService != null && localReplicationManager != null) {
            remotingService.freeze(null, localReplicationManager.getBackupTransportConnection());
        } else if (remotingService != null) {
            remotingService.freeze(null, null);
        }
    }

    @Override
    public void run() {
        try {
            if (this.replicatedPolicy.isCheckForLiveServer() && this.isNodeIdUsed()) {
                this.replicatedPolicy.getReplicaPolicy().setReplicatedPolicy(this.replicatedPolicy);
                this.hornetQServer.setHAPolicy(this.replicatedPolicy.getReplicaPolicy());
                return;
            }
            this.hornetQServer.initialisePart1(false);
            this.hornetQServer.initialisePart2(false);
            if (this.hornetQServer.getIdentity() != null) {
                HornetQServerLogger.LOGGER.serverIsLive(this.hornetQServer.getIdentity());
            } else {
                HornetQServerLogger.LOGGER.serverIsLive();
            }
        }
        catch (Exception e) {
            HornetQServerLogger.LOGGER.initializationError(e);
        }
    }

    @Override
    public ChannelHandler getActivationChannelHandler(final Channel channel, final Acceptor acceptorUsed) {
        return new ChannelHandler(){

            public void handlePacket(Packet packet) {
                if (packet.getType() == 115) {
                    BackupRegistrationMessage msg = (BackupRegistrationMessage)packet;
                    ClusterConnection clusterConnection = acceptorUsed.getClusterConnection();
                    try {
                        SharedNothingLiveActivation.this.startReplication(channel.getConnection(), clusterConnection, (Pair<TransportConfiguration, TransportConfiguration>)SharedNothingLiveActivation.this.getPair(msg.getConnector(), true), msg.isFailBackRequest());
                    }
                    catch (HornetQAlreadyReplicatingException are) {
                        channel.send((Packet)new BackupReplicationStartFailedMessage(BackupReplicationStartFailedMessage.BackupRegistrationProblem.ALREADY_REPLICATING));
                    }
                    catch (HornetQException e) {
                        channel.send((Packet)new BackupReplicationStartFailedMessage(BackupReplicationStartFailedMessage.BackupRegistrationProblem.EXCEPTION));
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReplication(CoreRemotingConnection rc, final ClusterConnection clusterConnection, final Pair<TransportConfiguration, TransportConfiguration> pair, final boolean isFailBackRequest) throws HornetQException {
        if (this.replicationManager != null) {
            throw new HornetQAlreadyReplicatingException();
        }
        if (!this.hornetQServer.isStarted()) {
            throw new HornetQIllegalStateException();
        }
        Object object = this.replicationLock;
        synchronized (object) {
            if (this.replicationManager != null) {
                throw new HornetQAlreadyReplicatingException();
            }
            ReplicationFailureListener listener = new ReplicationFailureListener();
            rc.addCloseListener((CloseListener)listener);
            rc.addFailureListener((FailureListener)listener);
            this.replicationManager = new ReplicationManager(rc, this.hornetQServer.getExecutorFactory());
            this.replicationManager.start();
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block22: {
                        try {
                            SharedNothingLiveActivation.this.hornetQServer.getStorageManager().startReplication(SharedNothingLiveActivation.this.replicationManager, SharedNothingLiveActivation.this.hornetQServer.getPagingManager(), SharedNothingLiveActivation.this.hornetQServer.getNodeID().toString(), isFailBackRequest && SharedNothingLiveActivation.this.replicatedPolicy.isAllowAutoFailBack());
                            clusterConnection.nodeAnnounced(System.currentTimeMillis(), SharedNothingLiveActivation.this.hornetQServer.getNodeID().toString(), SharedNothingLiveActivation.this.replicatedPolicy.getGroupName(), SharedNothingLiveActivation.this.replicatedPolicy.getScaleDownGroupName(), (Pair<TransportConfiguration, TransportConfiguration>)pair, true);
                            if (!isFailBackRequest || !SharedNothingLiveActivation.this.replicatedPolicy.isAllowAutoFailBack()) break block22;
                            BackupTopologyListener listener1 = new BackupTopologyListener(SharedNothingLiveActivation.this.hornetQServer.getNodeID().toString());
                            clusterConnection.addClusterTopologyListener(listener1);
                            if (listener1.waitForBackup()) {
                                try {
                                    Thread.sleep(SharedNothingLiveActivation.this.replicatedPolicy.getFailbackDelay());
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                                if (!SharedNothingLiveActivation.this.replicatedPolicy.getReplicaPolicy().isRestartBackup() && SharedNothingLiveActivation.this.hornetQServer.countNumberOfCopiedJournals() >= SharedNothingLiveActivation.this.replicatedPolicy.getReplicaPolicy().getMaxSavedReplicatedJournalsSize() && SharedNothingLiveActivation.this.replicatedPolicy.getReplicaPolicy().getMaxSavedReplicatedJournalsSize() >= 0) {
                                    SharedNothingLiveActivation.this.hornetQServer.stop(true);
                                    HornetQServerLogger.LOGGER.stopReplicatedBackupAfterFailback();
                                } else {
                                    SharedNothingLiveActivation.this.hornetQServer.stop(true);
                                    HornetQServerLogger.LOGGER.restartingReplicatedBackupAfterFailback();
                                    SharedNothingLiveActivation.this.hornetQServer.setHAPolicy(SharedNothingLiveActivation.this.replicatedPolicy.getReplicaPolicy());
                                    SharedNothingLiveActivation.this.hornetQServer.start();
                                }
                                break block22;
                            }
                            HornetQServerLogger.LOGGER.failbackMissedBackupAnnouncement();
                        }
                        catch (Exception e) {
                            if (SharedNothingLiveActivation.this.hornetQServer.getState() == HornetQServerImpl.SERVER_STATE.STARTED) {
                                HornetQServerLogger.LOGGER.errorStartingReplication(e);
                            }
                            try {
                                HornetQServerImpl.stopComponent(SharedNothingLiveActivation.this.replicationManager);
                            }
                            catch (Exception hqe) {
                                HornetQServerLogger.LOGGER.errorStoppingReplication(hqe);
                            }
                            finally {
                                Object object = SharedNothingLiveActivation.this.replicationLock;
                                synchronized (object) {
                                    SharedNothingLiveActivation.this.replicationManager = null;
                                }
                            }
                        }
                    }
                }
            });
            t.start();
        }
    }

    private Pair<TransportConfiguration, TransportConfiguration> getPair(TransportConfiguration conn, boolean isBackup) {
        if (isBackup) {
            return new Pair(null, (Object)conn);
        }
        return new Pair((Object)conn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNodeIdUsed() throws Exception {
        SimpleString nodeId0;
        if (this.hornetQServer.getConfiguration().getClusterConfigurations().isEmpty()) {
            return false;
        }
        try {
            nodeId0 = this.hornetQServer.getNodeManager().readNodeId();
        }
        catch (HornetQIllegalStateException e) {
            nodeId0 = null;
        }
        ClusterConnectionConfiguration config = ConfigurationUtils.getReplicationClusterConfiguration(this.hornetQServer.getConfiguration(), this.replicatedPolicy.getClusterName());
        ServerLocatorInternal locator = this.getLocator(config);
        ClientSessionFactoryInternal factory = null;
        NodeIdListener listener = new NodeIdListener(nodeId0);
        locator.addClusterTopologyListener((ClusterTopologyListener)listener);
        try {
            locator.setReconnectAttempts(0);
            try {
                locator.addClusterTopologyListener((ClusterTopologyListener)listener);
                factory = locator.connectNoWarnings();
            }
            catch (Exception notConnected) {
                boolean bl = false;
                if (factory != null) {
                    factory.close();
                }
                if (locator != null) {
                    locator.close();
                }
                return bl;
            }
            listener.latch.await(5L, TimeUnit.SECONDS);
            boolean bl = listener.isNodePresent;
            return bl;
        }
        finally {
            if (factory != null) {
                factory.close();
            }
            if (locator != null) {
                locator.close();
            }
        }
    }

    @Override
    public void close(boolean permanently, boolean restarting) throws Exception {
        this.replicationManager = null;
        NodeManager nodeManagerInUse = this.hornetQServer.getNodeManager();
        if (nodeManagerInUse != null) {
            if (permanently) {
                nodeManagerInUse.crashLiveServer();
            } else {
                nodeManagerInUse.pauseLiveServer();
            }
        }
    }

    @Override
    public void sendLiveIsStopping() {
        final ReplicationManager localReplicationManager = this.replicationManager;
        if (localReplicationManager != null) {
            localReplicationManager.sendLiveIsStopping(ReplicationLiveIsStoppingMessage.LiveStopping.STOP_CALLED);
            this.hornetQServer.getScheduledPool().schedule(new Runnable(){

                @Override
                public void run() {
                    localReplicationManager.clearReplicationTokens();
                }
            }, 30L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationManager getReplicationManager() {
        Object object = this.replicationLock;
        synchronized (object) {
            return this.replicationManager;
        }
    }

    private ServerLocatorInternal getLocator(ClusterConnectionConfiguration config) throws HornetQException {
        ServerLocatorInternal locator;
        if (config.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration dg = this.hornetQServer.getConfiguration().getDiscoveryGroupConfigurations().get(config.getDiscoveryGroupName());
            if (dg == null) {
                throw HornetQMessageBundle.BUNDLE.noDiscoveryGroupFound(dg);
            }
            locator = (ServerLocatorInternal)HornetQClient.createServerLocatorWithHA((DiscoveryGroupConfiguration)dg);
        } else {
            TransportConfiguration[] tcConfigs = config.getStaticConnectors() != null ? this.connectorNameListToArray(config.getStaticConnectors()) : null;
            locator = (ServerLocatorInternal)HornetQClient.createServerLocatorWithHA((TransportConfiguration[])tcConfigs);
        }
        return locator;
    }

    private TransportConfiguration[] connectorNameListToArray(List<String> connectorNames) {
        TransportConfiguration[] tcConfigs = (TransportConfiguration[])Array.newInstance(TransportConfiguration.class, connectorNames.size());
        int count = 0;
        for (String connectorName : connectorNames) {
            TransportConfiguration connector = this.hornetQServer.getConfiguration().getConnectorConfigurations().get(connectorName);
            if (connector == null) {
                HornetQServerLogger.LOGGER.bridgeNoConnector(connectorName);
                return null;
            }
            tcConfigs[count++] = connector;
        }
        return tcConfigs;
    }

    static final class NodeIdListener
    implements ClusterTopologyListener {
        volatile boolean isNodePresent = false;
        private final SimpleString nodeId;
        private final CountDownLatch latch = new CountDownLatch(1);

        public NodeIdListener(SimpleString nodeId) {
            this.nodeId = nodeId;
        }

        public void nodeUP(TopologyMember topologyMember, boolean last) {
            boolean isOurNodeId;
            boolean bl = isOurNodeId = this.nodeId != null && this.nodeId.toString().equals(topologyMember.getNodeId());
            if (isOurNodeId) {
                this.isNodePresent = true;
            }
            if (isOurNodeId || last) {
                this.latch.countDown();
            }
        }

        public void nodeDown(long eventUID, String nodeID) {
        }
    }

    private final class ReplicationFailureListener
    implements FailureListener,
    CloseListener {
        private ReplicationFailureListener() {
        }

        public void connectionFailed(HornetQException exception, boolean failedOver) {
            this.connectionClosed();
        }

        public void connectionFailed(HornetQException me, boolean failedOver, String scaleDownTargetNodeID) {
            this.connectionFailed(me, failedOver);
        }

        public void connectionClosed() {
            SharedNothingLiveActivation.this.hornetQServer.getThreadPool().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = SharedNothingLiveActivation.this.replicationLock;
                    synchronized (object) {
                        if (SharedNothingLiveActivation.this.replicationManager != null) {
                            SharedNothingLiveActivation.this.hornetQServer.getStorageManager().stopReplication();
                            SharedNothingLiveActivation.this.replicationManager = null;
                        }
                    }
                }
            });
        }
    }
}

