/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.NodeManager;
import org.hornetq.core.server.cluster.ha.SharedStoreMasterPolicy;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.core.server.impl.LiveActivation;

public final class SharedStoreLiveActivation
extends LiveActivation {
    private SharedStoreMasterPolicy sharedStoreMasterPolicy;
    private HornetQServerImpl hornetQServer;

    public SharedStoreLiveActivation(HornetQServerImpl server, SharedStoreMasterPolicy sharedStoreMasterPolicy) {
        this.hornetQServer = server;
        this.sharedStoreMasterPolicy = sharedStoreMasterPolicy;
    }

    @Override
    public void run() {
        try {
            HornetQServerLogger.LOGGER.awaitingLiveLock();
            this.hornetQServer.checkJournalDirectory();
            if (HornetQServerLogger.LOGGER.isDebugEnabled()) {
                HornetQServerLogger.LOGGER.debug("First part initialization on " + this);
            }
            if (!this.hornetQServer.initialisePart1(false)) {
                return;
            }
            if (this.hornetQServer.getNodeManager().isBackupLive()) {
                if (HornetQServerLogger.LOGGER.isDebugEnabled()) {
                    HornetQServerLogger.LOGGER.debug("announcing backup to the former live" + this);
                }
                this.hornetQServer.getBackupManager().start();
                this.hornetQServer.getBackupManager().announceBackup();
                Thread.sleep(this.sharedStoreMasterPolicy.getFailbackDelay());
            }
            this.hornetQServer.getNodeManager().startLiveNode();
            if (this.hornetQServer.getState() == HornetQServerImpl.SERVER_STATE.STOPPED || this.hornetQServer.getState() == HornetQServerImpl.SERVER_STATE.STOPPING) {
                return;
            }
            this.hornetQServer.initialisePart2(false);
            HornetQServerLogger.LOGGER.serverIsLive();
        }
        catch (Exception e) {
            HornetQServerLogger.LOGGER.initializationError(e);
        }
    }

    @Override
    public void close(boolean permanently, boolean restarting) throws Exception {
        NodeManager nodeManagerInUse = this.hornetQServer.getNodeManager();
        if (nodeManagerInUse != null) {
            if (this.sharedStoreMasterPolicy.isFailoverOnServerShutdown() || permanently) {
                nodeManagerInUse.crashLiveServer();
            } else {
                nodeManagerInUse.pauseLiveServer();
            }
        }
    }
}

