/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.integration.twitter.impl;

import java.util.List;
import java.util.Map;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.server.ConnectorService;
import org.hornetq.core.server.Consumer;
import org.hornetq.core.server.HandleStatus;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.twitter.HornetQTwitterLogger;
import org.hornetq.utils.ConfigurationHelper;
import twitter4j.GeoLocation;
import twitter4j.StatusUpdate;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.http.AccessToken;

public class OutgoingTweetsHandler
implements Consumer,
ConnectorService {
    private final String connectorName;
    private final String consumerKey;
    private final String consumerSecret;
    private final String accessToken;
    private final String accessTokenSecret;
    private final String queueName;
    private final PostOffice postOffice;
    private Twitter twitter = null;
    private Queue queue = null;
    private Filter filter = null;
    private boolean isStarted = false;

    public String debug() {
        return this.toString();
    }

    public OutgoingTweetsHandler(String connectorName, Map<String, Object> configuration, PostOffice postOffice) {
        this.connectorName = connectorName;
        this.consumerKey = ConfigurationHelper.getStringProperty((String)"consumerKey", null, configuration);
        this.consumerSecret = ConfigurationHelper.getStringProperty((String)"consumerSecret", null, configuration);
        this.accessToken = ConfigurationHelper.getStringProperty((String)"accessToken", null, configuration);
        this.accessTokenSecret = ConfigurationHelper.getStringProperty((String)"accessTokenSecret", null, configuration);
        this.queueName = ConfigurationHelper.getStringProperty((String)"queue", null, configuration);
        this.postOffice = postOffice;
    }

    public synchronized void start() throws Exception {
        if (this.isStarted) {
            return;
        }
        if (this.connectorName == null || this.connectorName.trim().equals("")) {
            throw new Exception("invalid connector name: " + this.connectorName);
        }
        if (this.queueName == null || this.queueName.trim().equals("")) {
            throw new Exception("invalid queue name: " + this.queueName);
        }
        SimpleString name = new SimpleString(this.queueName);
        Binding b = this.postOffice.getBinding(name);
        if (b == null) {
            throw new Exception(this.connectorName + ": queue " + this.queueName + " not found");
        }
        this.queue = (Queue)b.getBindable();
        TwitterFactory tf = new TwitterFactory();
        this.twitter = tf.getOAuthAuthorizedInstance(this.consumerKey, this.consumerSecret, new AccessToken(this.accessToken, this.accessTokenSecret));
        this.twitter.verifyCredentials();
        this.filter = null;
        this.queue.addConsumer((Consumer)this);
        this.queue.deliverAsync();
        this.isStarted = true;
        HornetQTwitterLogger.LOGGER.debug(this.connectorName + ": started");
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public synchronized void stop() throws Exception {
        if (!this.isStarted) {
            return;
        }
        HornetQTwitterLogger.LOGGER.debug(this.connectorName + ": receive shutdown request");
        this.queue.removeConsumer((Consumer)this);
        this.isStarted = false;
        HornetQTwitterLogger.LOGGER.debug(this.connectorName + ": shutdown");
    }

    public String getName() {
        return this.connectorName;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void getDeliveringMessages(List<MessageReference> refList) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandleStatus handle(MessageReference ref) throws Exception {
        if (this.filter != null && !this.filter.match(ref.getMessage())) {
            return HandleStatus.NO_MATCH;
        }
        OutgoingTweetsHandler outgoingTweetsHandler = this;
        synchronized (outgoingTweetsHandler) {
            ref.handled();
            ServerMessage message = ref.getMessage();
            StatusUpdate status = new StatusUpdate(message.getBodyBuffer().readString());
            if (message.containsProperty("inReplyToStatusId")) {
                status.setInReplyToStatusId(message.getLongProperty("inReplyToStatusId").longValue());
            }
            if (message.containsProperty("geoLocation.latitude")) {
                double geolat = message.getDoubleProperty("geoLocation.latitude");
                double geolong = message.getDoubleProperty("geoLocation.longitude");
                status.setLocation(new GeoLocation(geolat, geolong));
            }
            if (message.containsProperty("place.id")) {
                status.setPlaceId(message.getStringProperty("place.id"));
            }
            if (message.containsProperty("displayCoodinates")) {
                status.setDisplayCoordinates(message.getBooleanProperty("displayCoodinates").booleanValue());
            }
            try {
                this.twitter.updateStatus(status);
            }
            catch (TwitterException e) {
                if (e.getStatusCode() == 403) {
                    HornetQTwitterLogger.LOGGER.error403(this.connectorName);
                    this.queue.acknowledge(ref);
                    return HandleStatus.HANDLED;
                }
                throw e;
            }
            this.queue.acknowledge(ref);
            HornetQTwitterLogger.LOGGER.debug(this.connectorName + ": forwarded to twitter: " + message.getMessageID());
            return HandleStatus.HANDLED;
        }
    }

    public void proceedDeliver(MessageReference ref) {
    }

    public String toManagementString() {
        return this.toString();
    }
}

