/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.deployers.common;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterAssociation;
import org.ironjacamar.common.api.metadata.common.Timeout;
import org.ironjacamar.common.api.metadata.common.TransactionSupportEnum;
import org.ironjacamar.common.api.metadata.common.Validation;
import org.ironjacamar.common.api.metadata.resourceadapter.Activation;
import org.ironjacamar.common.api.metadata.resourceadapter.AdminObject;
import org.ironjacamar.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.ironjacamar.common.api.metadata.spec.Connector;
import org.ironjacamar.core.api.connectionmanager.ConnectionManager;
import org.ironjacamar.core.api.connectionmanager.pool.Pool;
import org.ironjacamar.core.api.connectionmanager.pool.PoolConfiguration;
import org.ironjacamar.core.api.deploymentrepository.ConfigProperty;
import org.ironjacamar.core.api.deploymentrepository.ConnectionFactory;
import org.ironjacamar.core.api.deploymentrepository.Deployment;
import org.ironjacamar.core.api.deploymentrepository.DeploymentRepository;
import org.ironjacamar.core.api.deploymentrepository.Recovery;
import org.ironjacamar.core.api.deploymentrepository.ResourceAdapter;
import org.ironjacamar.core.api.metadatarepository.Metadata;
import org.ironjacamar.core.api.metadatarepository.MetadataRepository;
import org.ironjacamar.core.connectionmanager.ConnectionManagerFactory;
import org.ironjacamar.core.connectionmanager.pool.PoolFactory;
import org.ironjacamar.core.deploymentrepository.AdminObjectImpl;
import org.ironjacamar.core.deploymentrepository.ConfigPropertyImpl;
import org.ironjacamar.core.deploymentrepository.ConnectionFactoryImpl;
import org.ironjacamar.core.deploymentrepository.DeploymentBuilder;
import org.ironjacamar.core.deploymentrepository.PoolImpl;
import org.ironjacamar.core.deploymentrepository.ResourceAdapterImpl;
import org.ironjacamar.core.metadatarepository.MetadataImpl;
import org.ironjacamar.core.spi.naming.JndiStrategy;
import org.ironjacamar.core.spi.statistics.Statistics;
import org.ironjacamar.core.spi.statistics.StatisticsPlugin;
import org.ironjacamar.core.util.Injection;
import org.ironjacamar.deployers.common.DeployException;

public abstract class AbstractResourceAdapterDeployer {
    protected DeploymentRepository deploymentRepository = null;
    protected MetadataRepository metadataRepository = null;
    protected BootstrapContext bootstrapContext = null;
    protected JndiStrategy jndiStrategy = null;

    public void setDeploymentRepository(DeploymentRepository v) {
        this.deploymentRepository = v;
    }

    public void setMetadataRepository(MetadataRepository v) {
        this.metadataRepository = v;
    }

    public void setBootstrapContext(BootstrapContext v) {
        this.bootstrapContext = v;
    }

    public void setJndiStrategy(JndiStrategy v) {
        this.jndiStrategy = v;
    }

    public Metadata registerMetadata(String name, Connector c, File archive) {
        MetadataImpl md = new MetadataImpl(name, c, archive);
        this.metadataRepository.registerMetadata((Metadata)md);
        return md;
    }

    public Deployment activate(Connector connector, Activation activation, ClassLoader cl) throws DeployException {
        try {
            DeploymentBuilder builder = new DeploymentBuilder();
            TransactionSupportEnum transactionSupport = this.getTransactionSupport(connector, activation);
            Metadata md = this.metadataRepository.findByName(activation.getArchive());
            builder.identifier(activation.getId());
            builder.name(md.getName());
            builder.metadata(connector);
            builder.activation(activation);
            builder.archive(md.getArchive());
            builder.classLoader(cl);
            if (connector.getResourceadapter().getResourceadapterClass() != null) {
                this.createResourceAdapter(builder, connector.getResourceadapter().getResourceadapterClass(), connector.getResourceadapter().getConfigProperties(), transactionSupport);
            }
            if (activation.getConnectionDefinitions() != null) {
                for (ConnectionDefinition cd : activation.getConnectionDefinitions()) {
                    this.createConnectionDefinition(builder, connector, cd, transactionSupport);
                }
            }
            if (activation.getAdminObjects() != null) {
                for (AdminObject ao : activation.getAdminObjects()) {
                    this.createAdminObject(builder, connector, ao);
                }
            }
            Deployment deployment = builder.build();
            deployment.activate();
            if (!this.deploymentRepository.registerDeployment(deployment)) {
                throw new DeployException("Not registered");
            }
            return deployment;
        }
        catch (DeployException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DeployException(e.getMessage(), e);
        }
    }

    protected void createResourceAdapter(DeploymentBuilder builder, String raClz, Collection<org.ironjacamar.common.api.metadata.spec.ConfigProperty> configProperties, TransactionSupportEnum transactionSupport) throws DeployException {
        try {
            Class<?> clz = Class.forName(raClz, true, builder.getClassLoader());
            javax.resource.spi.ResourceAdapter resourceAdapter = (javax.resource.spi.ResourceAdapter)clz.newInstance();
            Collection<ConfigProperty> dcps = this.injectConfigProperties(resourceAdapter, configProperties, builder.getClassLoader());
            StatisticsPlugin statisticsPlugin = null;
            if (resourceAdapter instanceof Statistics) {
                statisticsPlugin = ((Statistics)resourceAdapter).getStatistics();
            }
            Recovery recovery = null;
            if (this.isXA(transactionSupport)) {
                // empty if block
            }
            builder.resourceAdapter((ResourceAdapter)new ResourceAdapterImpl(resourceAdapter, this.bootstrapContext, dcps, statisticsPlugin, recovery));
        }
        catch (Throwable t) {
            throw new DeployException("createResourceAdapter", t);
        }
    }

    protected void createConnectionDefinition(DeploymentBuilder builder, Connector connector, ConnectionDefinition cd, TransactionSupportEnum transactionSupport) throws DeployException {
        try {
            String mcfClass = this.findManagedConnectionFactory(cd.getClassName(), connector);
            Class<?> clz = Class.forName(mcfClass, true, builder.getClassLoader());
            ManagedConnectionFactory mcf = (ManagedConnectionFactory)clz.newInstance();
            Collection<ConfigProperty> dcps = this.injectConfigProperties(mcf, this.findConfigProperties(mcfClass, connector), builder.getClassLoader());
            org.ironjacamar.core.connectionmanager.ConnectionManager cm = ConnectionManagerFactory.createConnectionManager((TransactionSupportEnum)transactionSupport, (ManagedConnectionFactory)mcf);
            String poolType = cd.getPool() != null ? cd.getPool().getType() : null;
            PoolConfiguration pc = new PoolConfiguration();
            this.applyPoolConfiguration(pc, cd.getPool());
            this.applyPoolConfiguration(pc, cd.getTimeout());
            this.applyPoolConfiguration(pc, cd.getValidation());
            org.ironjacamar.core.connectionmanager.pool.Pool pool = PoolFactory.createPool((String)poolType, (org.ironjacamar.core.connectionmanager.ConnectionManager)cm, (PoolConfiguration)pc);
            cm.setPool(pool);
            PoolImpl dpool = new PoolImpl((Pool)pool, null);
            StatisticsPlugin statisticsPlugin = null;
            if (mcf instanceof Statistics) {
                statisticsPlugin = ((Statistics)mcf).getStatistics();
            }
            Recovery recovery = null;
            if (this.isXA(transactionSupport)) {
                // empty if block
            }
            if (builder.getResourceAdapter() != null) {
                this.associateResourceAdapter(builder.getResourceAdapter().getResourceAdapter(), mcf);
            }
            Object cf = mcf.createConnectionFactory((javax.resource.spi.ConnectionManager)cm);
            builder.connectionFactory((ConnectionFactory)new ConnectionFactoryImpl(cd.getJndiName(), cf, dcps, cd, (ConnectionManager)cm, (org.ironjacamar.core.api.deploymentrepository.Pool)dpool, statisticsPlugin, recovery, this.jndiStrategy));
        }
        catch (Throwable t) {
            throw new DeployException("createConnectionDefinition", t);
        }
    }

    protected void createAdminObject(DeploymentBuilder builder, Connector connector, AdminObject ao) throws DeployException {
        try {
            String aoClass = this.findAdminObject(ao.getClassName(), connector);
            Class<?> clz = Class.forName(aoClass, true, builder.getClassLoader());
            Object adminObject = clz.newInstance();
            Collection<ConfigProperty> dcps = this.injectConfigProperties(adminObject, this.findConfigProperties(aoClass, connector), builder.getClassLoader());
            StatisticsPlugin statisticsPlugin = null;
            if (adminObject instanceof Statistics) {
                statisticsPlugin = ((Statistics)adminObject).getStatistics();
            }
            if (builder.getResourceAdapter() != null) {
                this.associateResourceAdapter(builder.getResourceAdapter().getResourceAdapter(), adminObject);
            }
            builder.adminObject((org.ironjacamar.core.api.deploymentrepository.AdminObject)new AdminObjectImpl(ao.getJndiName(), adminObject, dcps, ao, statisticsPlugin, this.jndiStrategy));
        }
        catch (Throwable t) {
            throw new DeployException("createAdminObject", t);
        }
    }

    private String findManagedConnectionFactory(String className, Connector connector) {
        for (org.ironjacamar.common.api.metadata.spec.ConnectionDefinition cd : connector.getResourceadapter().getOutboundResourceadapter().getConnectionDefinitions()) {
            if (!className.equals(cd.getManagedConnectionFactoryClass().getValue()) && !className.equals(cd.getConnectionFactoryInterface().getValue())) continue;
            return cd.getManagedConnectionFactoryClass().getValue();
        }
        return className;
    }

    private String findAdminObject(String className, Connector connector) {
        for (org.ironjacamar.common.api.metadata.spec.AdminObject ao : connector.getResourceadapter().getAdminObjects()) {
            if (!className.equals(ao.getAdminobjectClass().getValue()) && !className.equals(ao.getAdminobjectInterface().getValue())) continue;
            return ao.getAdminobjectClass().getValue();
        }
        return className;
    }

    private Collection<org.ironjacamar.common.api.metadata.spec.ConfigProperty> findConfigProperties(String className, Connector connector) {
        for (org.ironjacamar.common.api.metadata.spec.ConnectionDefinition cd : connector.getResourceadapter().getOutboundResourceadapter().getConnectionDefinitions()) {
            if (!className.equals(cd.getManagedConnectionFactoryClass().getValue()) && !className.equals(cd.getConnectionFactoryInterface().getValue())) continue;
            return cd.getConfigProperties();
        }
        return null;
    }

    private Collection<ConfigProperty> injectConfigProperties(Object o, Collection<org.ironjacamar.common.api.metadata.spec.ConfigProperty> configProperties, ClassLoader classLoader) throws Throwable {
        ArrayList<ConfigPropertyImpl> dcps = null;
        if (configProperties != null && configProperties.size() > 0) {
            Injection injector = new Injection();
            dcps = new ArrayList<ConfigPropertyImpl>(configProperties.size());
            for (org.ironjacamar.common.api.metadata.spec.ConfigProperty cp : configProperties) {
                String name = cp.getConfigPropertyName().getValue();
                Class<?> type = Class.forName(cp.getConfigPropertyType().getValue(), true, classLoader);
                String value = cp.isValueSet() ? cp.getConfigPropertyValue().getValue() : null;
                boolean readOnly = cp.getConfigPropertySupportsDynamicUpdates() != null ? cp.getConfigPropertySupportsDynamicUpdates() : true;
                boolean confidential = cp.getConfigPropertyConfidential() != null ? cp.getConfigPropertyConfidential() : false;
                boolean declared = true;
                if (cp.isValueSet()) {
                    try {
                        injector.inject(o, cp.getConfigPropertyName().getValue(), (Object)cp.getConfigPropertyValue().getValue(), cp.getConfigPropertyType().getValue());
                    }
                    catch (Throwable t) {
                        type = this.convertType(type);
                        if (type != null) {
                            injector.inject(o, cp.getConfigPropertyName().getValue(), (Object)cp.getConfigPropertyValue().getValue(), type.getName());
                        }
                        throw t;
                    }
                }
                dcps.add(new ConfigPropertyImpl(o, name, type, (Object)value, readOnly, confidential, declared));
            }
        }
        return dcps;
    }

    private Class<?> convertType(Class<?> old) {
        if (Boolean.class.equals(old)) {
            return Boolean.TYPE;
        }
        if (Boolean.TYPE.equals(old)) {
            return Boolean.class;
        }
        if (Byte.class.equals(old)) {
            return Byte.TYPE;
        }
        if (Byte.TYPE.equals(old)) {
            return Byte.class;
        }
        if (Short.class.equals(old)) {
            return Short.TYPE;
        }
        if (Short.TYPE.equals(old)) {
            return Short.class;
        }
        if (Integer.class.equals(old)) {
            return Integer.TYPE;
        }
        if (Integer.TYPE.equals(old)) {
            return Integer.class;
        }
        if (Long.class.equals(old)) {
            return Long.TYPE;
        }
        if (Long.TYPE.equals(old)) {
            return Long.class;
        }
        if (Float.class.equals(old)) {
            return Float.TYPE;
        }
        if (Float.TYPE.equals(old)) {
            return Float.class;
        }
        if (Double.class.equals(old)) {
            return Double.TYPE;
        }
        if (Double.TYPE.equals(old)) {
            return Double.class;
        }
        if (Character.class.equals(old)) {
            return Character.TYPE;
        }
        if (Character.TYPE.equals(old)) {
            return Character.class;
        }
        return null;
    }

    protected void associateResourceAdapter(javax.resource.spi.ResourceAdapter resourceAdapter, Object object) throws DeployException {
        if (resourceAdapter != null && object != null && object instanceof ResourceAdapterAssociation) {
            try {
                ResourceAdapterAssociation raa = (ResourceAdapterAssociation)object;
                raa.setResourceAdapter(resourceAdapter);
            }
            catch (Throwable t) {
                throw new DeployException("associateResourceAdapter", t);
            }
        }
    }

    private TransactionSupportEnum getTransactionSupport(Connector connector, Activation activation) {
        if (activation.getTransactionSupport() != null) {
            return activation.getTransactionSupport();
        }
        if (connector.getResourceadapter().getOutboundResourceadapter() != null) {
            return connector.getResourceadapter().getOutboundResourceadapter().getTransactionSupport();
        }
        return TransactionSupportEnum.XATransaction;
    }

    private boolean isXA(TransactionSupportEnum tse) {
        return TransactionSupportEnum.XATransaction == tse;
    }

    private PoolConfiguration applyPoolConfiguration(PoolConfiguration pc, org.ironjacamar.common.api.metadata.common.Pool p) {
        if (p != null) {
            if (p.getMinPoolSize() != null) {
                pc.setMinSize(p.getMinPoolSize().intValue());
            }
            if (p.getInitialPoolSize() != null) {
                pc.setInitialSize(p.getInitialPoolSize().intValue());
            }
            if (p.getMaxPoolSize() != null) {
                pc.setMaxSize(p.getMaxPoolSize().intValue());
            }
            if (p.isPrefill() != null) {
                pc.setPrefill(p.isPrefill().booleanValue());
            }
        }
        return pc;
    }

    private PoolConfiguration applyPoolConfiguration(PoolConfiguration pc, Timeout t) {
        if (t != null) {
            if (t.getBlockingTimeoutMillis() != null) {
                pc.setBlockingTimeout(t.getBlockingTimeoutMillis().longValue());
            }
            if (t.getIdleTimeoutMinutes() != null) {
                pc.setIdleTimeoutMinutes(t.getIdleTimeoutMinutes().intValue());
            }
        }
        return pc;
    }

    private PoolConfiguration applyPoolConfiguration(PoolConfiguration pc, Validation v) {
        if (v != null) {
            if (v.isValidateOnMatch() != null) {
                pc.setValidateOnMatch(v.isValidateOnMatch().booleanValue());
            }
            if (v.isBackgroundValidation() != null) {
                pc.setBackgroundValidation(v.isBackgroundValidation().booleanValue());
            }
            if (v.getBackgroundValidationMillis() != null) {
                pc.setBackgroundValidationMillis(v.getBackgroundValidationMillis().longValue());
            }
            if (v.isUseFastFail() != null) {
                pc.setUseFastFail(v.isUseFastFail().booleanValue());
            }
        }
        return pc;
    }
}

