/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.camel;

import _private.JBeretCamelLogger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.BatchRuntime;
import javax.batch.runtime.context.JobContext;
import javax.inject.Inject;
import org.apache.camel.ProducerTemplate;
import org.jberet.camel.CamelArtifactBase;

public abstract class CamelListenerBase
extends CamelArtifactBase {
    @Inject
    protected JobContext jobContext;
    protected JobOperator jobOperator;
    protected ProducerTemplate producerTemplate;

    @PostConstruct
    private void postConstruct() {
        this.init();
        if (this.producerTemplate == null) {
            this.producerTemplate = this.camelContext.createProducerTemplate();
        }
        try {
            this.producerTemplate.start();
        }
        catch (Exception e) {
            throw new BatchRuntimeException((Throwable)e);
        }
        this.jobOperator = BatchRuntime.getJobOperator();
    }

    @PreDestroy
    private void preDestroy() {
        if (this.producerTemplate != null) {
            try {
                this.producerTemplate.stop();
            }
            catch (Exception e) {
                JBeretCamelLogger.LOGGER.failToStop(e, this);
            }
        }
    }
}

