/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.camel.component;

import _private.JBeretCamelMessages;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.JobExecution;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultProducer;
import org.jberet.camel.component.JBeretComponent;
import org.jberet.camel.component.JBeretEndpoint;

public class JBeretProducer
extends DefaultProducer {
    public static final String JOBS = "jobs";
    public static final String JOBINSTANCES = "jobinstances";
    public static final String JOBEXECUTIONS = "jobexecutions";
    public static final String START = "start";
    public static final String RESTART = "restart";
    public static final String STOP = "stop";
    public static final String ABANDON = "abandon";
    public static final String COUNT = "count";
    public static final String JOB_NAME = "jobName";
    public static final String RUNNING = "running";

    public JBeretProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        JBeretEndpoint endpoint = (JBeretEndpoint)this.getEndpoint();
        JBeretComponent component = (JBeretComponent)endpoint.getComponent();
        this.runJobOperation(component.getJobOperator(), exchange, endpoint.getRemainingPath());
    }

    private void runJobOperation(JobOperator jobOperator, Exchange exchange, String remainingPath) throws Exception {
        if (remainingPath.isEmpty()) {
            throw JBeretCamelMessages.MESSAGES.invalidJBeretComponentUri(remainingPath);
        }
        String[] parts = remainingPath.split("/");
        if (parts.length == 0) {
            throw JBeretCamelMessages.MESSAGES.invalidJBeretComponentUri(remainingPath);
        }
        String resourceType = parts[0].toLowerCase();
        if (resourceType.equals(JOBS)) {
            this.doJobs(jobOperator, exchange, parts);
        } else if (JOBEXECUTIONS.equals(resourceType)) {
            this.doJobExecutions(jobOperator, exchange, parts);
        } else if (JOBINSTANCES.equals(resourceType)) {
            this.doJobInstances(jobOperator, exchange, parts);
        } else {
            throw JBeretCamelMessages.MESSAGES.invalidJBeretComponentUri(remainingPath);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doJobs(JobOperator jobOperator, Exchange exchange, String[] paths) throws Exception {
        Message in = exchange.getIn();
        if (paths.length == 1) {
            in.setBody((Object)jobOperator.getJobNames(), Set.class);
            return;
        } else if (paths.length == 2) {
            in.setBody((Object)jobOperator.start(paths[1], (Properties)in.getBody()), Long.TYPE);
            return;
        } else {
            if (paths.length != 3) throw JBeretCamelMessages.MESSAGES.invalidJBeretComponentUri(Arrays.toString(paths));
            if (!START.equals(paths[2])) throw JBeretCamelMessages.MESSAGES.invalidJBeretComponentUri(Arrays.toString(paths));
            in.setBody((Object)jobOperator.start(paths[1], (Properties)in.getBody()), Long.TYPE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doJobInstances(JobOperator jobOperator, Exchange exchange, String[] paths) throws Exception {
        Message in = exchange.getIn();
        if (paths.length == 1) {
            String jobName = ((JBeretEndpoint)this.getEndpoint()).getJobName();
            if (jobName == null) {
                throw JBeretCamelMessages.MESSAGES.invalidOrMissingParameterInJBeretComponentUrk(JOB_NAME, null);
            }
            int startInt = ((JBeretEndpoint)this.getEndpoint()).getStart();
            int countInt = ((JBeretEndpoint)this.getEndpoint()).getCount();
            in.setBody((Object)jobOperator.getJobInstances(jobName, startInt, countInt), List.class);
            return;
        } else {
            if (paths.length != 2) throw JBeretCamelMessages.MESSAGES.invalidJBeretComponentUri(Arrays.toString(paths));
            String resourceName = paths[1];
            if (!COUNT.equals(resourceName)) throw JBeretCamelMessages.MESSAGES.invalidJBeretComponentUri(Arrays.toString(paths));
            String jobName = ((JBeretEndpoint)this.getEndpoint()).getJobName();
            if (jobName == null) {
                throw JBeretCamelMessages.MESSAGES.invalidOrMissingParameterInJBeretComponentUrk(JOB_NAME, null);
            }
            in.setBody((Object)jobOperator.getJobInstanceCount(jobName), Integer.TYPE);
        }
    }

    private void doJobExecutions(JobOperator jobOperator, Exchange exchange, String[] paths) throws Exception {
        Message in = exchange.getIn();
        if (paths.length == 1) {
            throw JBeretCamelMessages.MESSAGES.invalidJBeretComponentUri(Arrays.toString(paths));
        }
        if (paths.length == 2) {
            if (RUNNING.equals(paths[1])) {
                String jobName = ((JBeretEndpoint)this.getEndpoint()).getJobName();
                if (jobName == null) {
                    jobName = "*";
                }
                in.setBody((Object)jobOperator.getRunningExecutions(jobName), List.class);
            } else {
                long jobExecutionId = Long.parseLong(paths[1]);
                in.setBody((Object)jobOperator.getJobExecution(jobExecutionId), JobExecution.class);
            }
        } else if (paths.length == 3) {
            long jobExecutionId = Long.parseLong(paths[1]);
            String resourceOperation = paths[2];
            if (STOP.equals(resourceOperation)) {
                jobOperator.stop(jobExecutionId);
            } else if (RESTART.equals(resourceOperation)) {
                in.setBody((Object)jobOperator.restart(jobExecutionId, (Properties)in.getBody()), Long.TYPE);
            } else if (ABANDON.equals(resourceOperation)) {
                jobOperator.abandon(jobExecutionId);
            } else {
                throw JBeretCamelMessages.MESSAGES.invalidJBeretComponentUri(Arrays.toString(paths));
            }
        }
    }
}

