/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.camel;

import _private.JBeretCamelLogger;
import javax.annotation.PostConstruct;
import javax.batch.api.chunk.ItemProcessor;
import javax.inject.Named;
import org.apache.camel.ProducerTemplate;
import org.jberet.camel.CamelArtifactBase;

@Named
public class CamelItemProcessor
extends CamelArtifactBase
implements ItemProcessor {
    protected ProducerTemplate producerTemplate;

    @PostConstruct
    private void postConstruct() {
        this.init();
        if (this.producerTemplate == null) {
            this.producerTemplate = this.camelContext.createProducerTemplate();
        }
        JBeretCamelLogger.LOGGER.openProcessor(this, this.endpointUri, this.camelContext, this.producerTemplate);
    }

    public Object processItem(Object item) throws Exception {
        return this.producerTemplate.requestBody(this.endpoint, item);
    }
}

