/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.camel;

import _private.JBeretCamelLogger;
import java.io.Serializable;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.camel.ConsumerTemplate;
import org.jberet.camel.CamelArtifactBase;

@Named
public class CamelItemReader
extends CamelArtifactBase
implements ItemReader {
    @Inject
    @BatchProperty
    protected long timeout;
    @Inject
    @BatchProperty
    protected Class beanType;
    protected ConsumerTemplate consumerTemplate;

    public void open(Serializable checkpoint) throws Exception {
        this.init();
        if (this.consumerTemplate == null) {
            this.consumerTemplate = this.camelContext.createConsumerTemplate();
        }
        JBeretCamelLogger.LOGGER.openReader(this, this.endpointUri, this.camelContext, this.consumerTemplate);
        this.consumerTemplate.start();
    }

    public void close() throws Exception {
        if (this.consumerTemplate != null) {
            this.consumerTemplate.stop();
        }
    }

    public Object readItem() throws Exception {
        Object item = this.beanType == null ? this.consumerTemplate.receiveBody(this.endpoint, this.timeout) : this.consumerTemplate.receiveBody(this.endpoint, this.timeout, this.beanType);
        return item;
    }

    public Serializable checkpointInfo() {
        return null;
    }
}

