/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.wildfly.cluster.servlet;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.jberet.creation.ArtifactFactoryWrapper;
import org.jberet.operations.AbstractJobOperator;
import org.jberet.repository.JobRepository;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;
import org.jberet.spi.PartitionInfo;
import org.jberet.wildfly.cluster.jms.JmsPartitionResource;
import org.jberet.wildfly.cluster.jms._private.ClusterJmsMessages;

@WebListener
public class PartitionContextListener
implements ServletContextListener {
    private Topic stopRequestTopic;
    private JMSContext partitionQueueContext;
    private Queue partitionQueue;
    private JmsPartitionResource jmsPartitionResource;

    public void contextInitialized(ServletContextEvent sce) {
        AbstractJobOperator jobOperator = JmsPartitionResource.getJobOperator();
        BatchEnvironment batchEnvironment = jobOperator.getBatchEnvironment();
        JobRepository jobRepository = jobOperator.getJobRepository();
        ArtifactFactoryWrapper artifactFactory = new ArtifactFactoryWrapper(batchEnvironment.getArtifactFactory());
        this.jmsPartitionResource = new JmsPartitionResource();
        this.partitionQueue = this.jmsPartitionResource.getPartitionQueue();
        ConnectionFactory connectionFactory = this.jmsPartitionResource.getConnectionFactory();
        this.partitionQueueContext = connectionFactory.createContext();
        this.stopRequestTopic = this.jmsPartitionResource.getStopRequestTopic();
        String messageSelector = JmsPartitionResource.getMessageSelector((String)"P", (long)0L);
        JMSConsumer consumer = this.partitionQueueContext.createConsumer((Destination)this.partitionQueue, messageSelector);
        consumer.setMessageListener(message -> {
            PartitionInfo partitionInfo;
            try {
                partitionInfo = (PartitionInfo)message.getBody(PartitionInfo.class);
            }
            catch (JMSException e) {
                throw ClusterJmsMessages.MESSAGES.failedInJms((Throwable)e);
            }
            JmsPartitionResource.runPartition((PartitionInfo)partitionInfo, (BatchEnvironment)batchEnvironment, (JobRepository)jobRepository, (ArtifactFactory)artifactFactory, (ConnectionFactory)connectionFactory, (Queue)this.partitionQueue, (Topic)this.stopRequestTopic);
        });
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.jmsPartitionResource.close();
        JmsPartitionResource.closeJmsContext((JMSContext)this.partitionQueueContext);
    }
}

