/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.testapps.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemWriter;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.testapps.common.IntegerArrayReaderWriterProcessorBase;

@Named(value="integerArrayWriter")
public class IntegerArrayWriter
extends IntegerArrayReaderWriterProcessorBase
implements ItemWriter {
    @Inject
    @BatchProperty(name="writer.sleep.time")
    protected long writerSleepTime;

    public void writeItems(List<Object> items) throws Exception {
        if (items == null) {
            return;
        }
        if (this.failOnValues != null) {
            Object matchingValue = null;
            for (Object e : items) {
                if (Arrays.binarySearch((Object[])this.failOnValues, e) < 0) continue;
                matchingValue = e;
                break;
            }
            if (matchingValue != null && (this.repeatFailure || !this.failedValues.contains(matchingValue))) {
                this.failedValues.add((Integer)matchingValue);
                System.out.printf("About to throw ArithmeticException on value %s%n", matchingValue);
                throw new ArithmeticException("integerArrayWriter failing on value " + matchingValue);
            }
        }
        if (this.writerSleepTime > 0L) {
            Thread.sleep(this.writerSleepTime);
        }
        System.out.printf("Wrote Chunk (%s Items): %s%n", items.size(), String.valueOf(items));
        ArrayList<List<Object>> recorded = (ArrayList<List<Object>>)this.stepContext.getPersistentUserData();
        if (recorded == null) {
            recorded = new ArrayList<List<Object>>();
        }
        recorded.add(items);
        this.stepContext.setPersistentUserData(recorded);
    }

    public void open(Serializable checkpoint) throws Exception {
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }
}

