/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.testapps.loadBatchXml;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jberet.spi.JobXmlResolver;
import org.wildfly.security.manager.WildFlySecurityManager;

public class FileSystemJobXmlResolver
implements JobXmlResolver {
    private static final File dir = new File(WildFlySecurityManager.getPropertyPrivileged((String)"jberet.job.path.custom", (String)"."));

    public InputStream resolveJobXml(String jobXml, ClassLoader classLoader) throws IOException {
        Collection<File> jobFiles = this.listFiles();
        for (File file : jobFiles) {
            if (!jobXml.endsWith(file.getName())) continue;
            return new BufferedInputStream(new FileInputStream(file));
        }
        return null;
    }

    public Collection<String> getJobXmlNames(ClassLoader classLoader) {
        return Collections2.transform(this.listFiles(), (Function)new Function<File, String>(){

            public String apply(File file) {
                return file.getName();
            }
        });
    }

    public String resolveJobName(String jobXml, ClassLoader classLoader) {
        return null;
    }

    private Collection<File> listFiles() {
        File[] files = dir.listFiles(XmlFileFilter.INSTANCE);
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    private static class XmlFileFilter
    implements FilenameFilter {
        static final XmlFileFilter INSTANCE = new XmlFileFilter();

        private XmlFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".xml");
        }
    }
}

