/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.testapps.postconstruct;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.listener.JobListener;
import jakarta.batch.operations.BatchRuntimeException;
import jakarta.batch.runtime.BatchRuntime;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobExecution;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Date;
import org.jberet.testapps.common.PostConstructPreDestroyBase;

@Named
public class JobListener1
extends PostConstructPreDestroyBase
implements JobListener {
    @Inject
    @BatchProperty(name="os.name")
    private String osName;

    public void beforeJob() throws Exception {
        this.addToJobExitStatus("JobListener1.beforeJob");
    }

    public void afterJob() throws Exception {
        this.addToJobExitStatus("JobListener1.afterJob");
        long executionId = this.jobContext.getExecutionId();
        JobExecution jobExecution = BatchRuntime.getJobOperator().getJobExecution(executionId);
        BatchStatus batchStatus = this.jobContext.getBatchStatus();
        Date endTime = jobExecution.getEndTime();
        System.out.printf("%nJobListener1.afterJob, batchStatus=%s, endTime=%s%n%n", batchStatus, endTime);
        if (batchStatus != BatchStatus.COMPLETED) {
            throw new BatchRuntimeException("Expecting BatchStatus.COMPLETED in JobListener1.afterJob(), but got " + String.valueOf(batchStatus));
        }
        if (endTime == null) {
            throw new BatchRuntimeException("Expecting a valid end time in JobListener1.afterJob(), but got " + String.valueOf(endTime));
        }
    }

    @PostConstruct
    public void ps() {
        System.out.printf("JobListener1 PostConstruct of %s%n", new Object[]{this});
        if (this.osName == null) {
            throw new BatchRuntimeException("osNmae field has not been initialized when checking from PostConstruct method.");
        }
        this.addToJobExitStatus("JobListener1.ps");
    }

    @PreDestroy
    public void pd() {
        System.out.printf("JobListener1 PreDestroy of %s%n", new Object[]{this});
        this.addToJobExitStatus("JobListener1.pd");
    }
}

