/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.embedded;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import org.jboss.arquillian.protocol.jmx.JMXMethodExecutor;
import org.jboss.arquillian.protocol.jmx.JMXTestRunnerMBean;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.LifecycleException;
import org.jboss.as.arquillian.container.AbstractDeployableContainer;
import org.jboss.as.embedded.EmbeddedServerFactory;
import org.jboss.as.embedded.StandaloneServer;

public class JBossAsEmbeddedContainer
extends AbstractDeployableContainer {
    private StandaloneServer server;

    public void start(Context context) throws LifecycleException {
        try {
            String jbossHomeKey = "jboss.home";
            String jbossHomeProp = System.getProperty(jbossHomeKey);
            if (jbossHomeProp == null) {
                throw new IllegalStateException("Cannot find system property: " + jbossHomeKey);
            }
            File jbossHomeDir = new File(jbossHomeProp).getAbsoluteFile();
            if (!jbossHomeDir.isDirectory()) {
                throw new IllegalStateException("Invalid jboss home directory: " + jbossHomeDir);
            }
            File modulesJar = new File(jbossHomeDir + "/jboss-modules.jar");
            if (!modulesJar.exists()) {
                throw new IllegalStateException("Cannot find: " + modulesJar);
            }
            Properties sysprops = new Properties();
            sysprops.putAll((Map<?, ?>)System.getProperties());
            sysprops.setProperty("jboss.home.dir", jbossHomeDir.getAbsolutePath());
            sysprops.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
            sysprops.setProperty("logging.configuration", "file:" + jbossHomeDir + "/standalone/configuration/logging.properties");
            sysprops.setProperty("org.jboss.boot.log.file", jbossHomeDir + "/standalone/log/boot.log");
            this.server = EmbeddedServerFactory.create((File)jbossHomeDir, (Properties)sysprops, System.getenv(), (String[])this.getSystemPackages(sysprops, "org.jboss.logmanager"));
            this.server.start();
            this.waitForMBean(JMXTestRunnerMBean.OBJECT_NAME, 5000L);
        }
        catch (Throwable th) {
            throw this.handleStartThrowable(th);
        }
    }

    private String[] getSystemPackages(Properties props, String ... packages) {
        if (Boolean.valueOf(props.getProperty("org.jboss.surefire.modular", Boolean.FALSE.toString())).booleanValue()) {
            return new String[0];
        }
        return packages;
    }

    public void stop(Context context) throws LifecycleException {
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop container", (Throwable)e);
        }
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    protected ContainerMethodExecutor getContainerMethodExecutor() {
        return new JMXMethodExecutor(this.getMBeanServerConnection(), JMXMethodExecutor.ExecutionType.EMBEDDED);
    }

    private LifecycleException handleStartThrowable(Throwable th) throws LifecycleException {
        if (th instanceof UndeclaredThrowableException) {
            throw this.handleStartThrowable(((UndeclaredThrowableException)th).getUndeclaredThrowable());
        }
        if (th instanceof InvocationTargetException) {
            throw this.handleStartThrowable(((InvocationTargetException)th).getTargetException());
        }
        if (th instanceof RuntimeException) {
            throw (RuntimeException)th;
        }
        return new LifecycleException("Could not start container", th);
    }
}

