/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import jline.Completor;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;

public class OperationRequestCompleter
implements Completor {
    private final CommandContext ctx;

    public OperationRequestCompleter(CommandContext ctx) {
        this.ctx = ctx;
    }

    public int complete(String buffer, int cursor, List candidates) {
        return this.doComplete(buffer, candidates, true);
    }

    public int doComplete(String buffer, List candidates, boolean requireSlashOrDotSlash) {
        String chunk;
        int firstCharIndex;
        for (firstCharIndex = 0; firstCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(firstCharIndex)); ++firstCharIndex) {
        }
        if (requireSlashOrDotSlash) {
            if (firstCharIndex == buffer.length()) {
                return -1;
            }
            if (!buffer.startsWith("./", firstCharIndex) && buffer.charAt(firstCharIndex) != ':' && buffer.charAt(firstCharIndex) != '/' && !buffer.startsWith("..", firstCharIndex)) {
                return -1;
            }
        }
        if (buffer.endsWith("..")) {
            return 0;
        }
        DefaultOperationCallbackHandler handler = new DefaultOperationCallbackHandler(new DefaultOperationRequestAddress(this.ctx.getPrefix()));
        try {
            this.ctx.getOperationRequestParser().parse(buffer, handler);
        }
        catch (OperationFormatException e1) {
            return -1;
        }
        if (handler.isRequestComplete()) {
            return -1;
        }
        if (handler.hasProperties() || handler.endsOnPropertyListStart()) {
            if (handler.endsOnPropertyValueSeparator()) {
                return -1;
            }
            OperationCandidatesProvider provider = this.ctx.getOperationCandidatesProvider();
            List<String> propertyNames = provider.getPropertyNames(handler.getOperationName(), handler.getAddress());
            if (propertyNames.isEmpty()) {
                if (handler.endsOnPropertyListStart()) {
                    candidates.add(")");
                    return buffer.length();
                }
                return -1;
            }
            if (handler.endsOnPropertyListStart()) {
                if (propertyNames.size() == 1) {
                    candidates.add(propertyNames.get(0) + '=');
                } else {
                    candidates.addAll(propertyNames);
                    Collections.sort(candidates);
                }
                return buffer.length();
            }
            Set<String> specifiedNames = handler.getPropertyNames();
            String chunk2 = null;
            for (String specifiedName : specifiedNames) {
                String value = handler.getPropertyValue(specifiedName);
                if (value == null) {
                    chunk2 = specifiedName;
                    continue;
                }
                propertyNames.remove(specifiedName);
            }
            if (chunk2 == null) {
                if (handler.endsOnPropertySeparator()) {
                    if (propertyNames.size() == 1) {
                        candidates.add(propertyNames.get(0) + '=');
                    } else {
                        candidates.addAll(propertyNames);
                        Collections.sort(candidates);
                    }
                } else if (propertyNames.isEmpty()) {
                    candidates.add(")");
                }
                return buffer.length();
            }
            for (String candidate : propertyNames) {
                if (!candidate.startsWith(chunk2)) continue;
                candidates.add(candidate);
            }
            if (candidates.size() == 1) {
                candidates.set(0, (String)candidates.get(0) + '=');
            } else {
                Collections.sort(candidates);
            }
            return handler.getLastSeparatorIndex() + 1;
        }
        if (handler.hasOperationName() || handler.endsOnAddressOperationNameSeparator()) {
            if (handler.getAddress().endsOnType()) {
                return -1;
            }
            OperationCandidatesProvider provider = this.ctx.getOperationCandidatesProvider();
            List<String> names = provider.getOperationNames(handler.getAddress());
            if (names.isEmpty()) {
                return -1;
            }
            String chunk3 = handler.getOperationName();
            if (chunk3 == null) {
                candidates.addAll(names);
            } else {
                for (String name : names) {
                    if (chunk3 != null && !name.startsWith(chunk3)) continue;
                    candidates.add(name);
                }
            }
            Collections.sort(candidates);
            return handler.getLastSeparatorIndex() + 1;
        }
        OperationRequestAddress address = handler.getAddress();
        if (address.isEmpty() || handler.endsOnNodeSeparator() || handler.endsOnNodeTypeNameSeparator() || address.equals(this.ctx.getPrefix()) || buffer.endsWith("..")) {
            chunk = null;
        } else if (address.endsOnType()) {
            chunk = address.getNodeType();
            address.toParentNode();
        } else {
            chunk = address.toNodeType();
        }
        OperationCandidatesProvider provider = this.ctx.getOperationCandidatesProvider();
        List<String> names = address.endsOnType() ? provider.getNodeNames(address) : provider.getNodeTypes(address);
        if (names.isEmpty()) {
            return -1;
        }
        if (chunk == null) {
            candidates.addAll(names);
        } else {
            for (String name : names) {
                if (chunk != null && !name.startsWith(chunk)) continue;
                candidates.add(name);
            }
        }
        if (candidates.size() == 1) {
            if (address.endsOnType()) {
                candidates.set(0, OperationRequestCompleter.formatName((String)candidates.get(0)));
            } else {
                String onlyType = (String)candidates.get(0);
                address.toNodeType(onlyType);
                List<String> childNames = provider.getNodeNames(address);
                if (!childNames.isEmpty()) {
                    candidates.clear();
                    if (childNames.size() == 1) {
                        candidates.add(onlyType + '=' + OperationRequestCompleter.formatName(childNames.get(0)));
                    } else {
                        for (String name : childNames) {
                            candidates.add(onlyType + '=' + name);
                        }
                    }
                }
            }
        }
        Collections.sort(candidates);
        return handler.getLastSeparatorIndex() + 1;
    }

    private static String formatName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch != ':' && ch != '/' && ch != '=') continue;
            StringBuilder builder = new StringBuilder();
            builder.append('\"');
            for (int j = 0; j < name.length(); ++j) {
                ch = name.charAt(j);
                if (ch == '\"') {
                    builder.append('\\');
                }
                builder.append(ch);
            }
            builder.append('\"');
            return builder.toString();
        }
        return name;
    }
}

