/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.SimpleTabCompleterWithDelegate;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class DeleteJmsCFHandler
extends BatchModeCommandHandler {
    public DeleteJmsCFHandler() {
        super("delete-jms-cf", true, new SimpleTabCompleterWithDelegate(new String[]{"--help"}, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int nextCharIndex;
                for (nextCharIndex = 0; nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex)); ++nextCharIndex) {
                }
                if (ctx.getModelControllerClient() != null) {
                    List<String> deployments = Util.getJmsResources(ctx.getModelControllerClient(), "connection-factory");
                    if (deployments.isEmpty()) {
                        return -1;
                    }
                    String opBuffer = buffer.substring(nextCharIndex).trim();
                    if (opBuffer.isEmpty()) {
                        candidates.addAll(deployments);
                    } else {
                        for (String name : deployments) {
                            if (!name.startsWith(opBuffer)) continue;
                            candidates.add(name);
                        }
                        Collections.sort(candidates);
                    }
                    return nextCharIndex;
                }
                return -1;
            }
        }));
    }

    @Override
    protected void doHandle(CommandContext ctx) {
        ModelNode result;
        ModelNode request;
        try {
            request = this.buildRequest(ctx);
        }
        catch (OperationFormatException e1) {
            ctx.printLine(e1.getLocalizedMessage());
            return;
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        try {
            result = client.execute(request);
        }
        catch (Exception e) {
            ctx.printLine("Failed to perform operation: " + e.getLocalizedMessage());
            return;
        }
        String name = ctx.getNamedArgument("name");
        if (!Util.isSuccess(result)) {
            ctx.printLine("Failed to delete connection factory '" + name + "': " + Util.getFailureDescription(result));
            return;
        }
        ctx.printLine("Removed connection factory " + name);
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws OperationFormatException {
        List<String> args;
        if (!ctx.hasArguments()) {
            throw new OperationFormatException("Missing required argument 'name'.");
        }
        String name = ctx.getNamedArgument("name");
        if (name == null && !(args = ctx.getArguments()).isEmpty()) {
            name = args.get(0);
        }
        if (name == null) {
            throw new OperationFormatException("Missing required argument 'name'.");
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.addNode("subsystem", "jms");
        builder.addNode("connection-factory", name);
        builder.setOperationName("remove");
        return builder.buildRequest();
    }
}

