/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class DeleteJmsResourceHandler
extends BatchModeCommandHandler {
    public DeleteJmsResourceHandler() {
        super("delete-jms-resource", true);
    }

    @Override
    protected void doHandle(CommandContext ctx) {
        ModelNode result;
        ModelNode request;
        try {
            request = this.buildRequest(ctx);
        }
        catch (OperationFormatException e1) {
            ctx.printLine(e1.getLocalizedMessage());
            return;
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        try {
            result = client.execute(request);
        }
        catch (Exception e) {
            ctx.printLine("Failed to perform operation: " + e.getLocalizedMessage());
            return;
        }
        if (!Util.isSuccess(result)) {
            ctx.printLine(Util.getFailureDescription(result));
            return;
        }
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws OperationFormatException {
        String resource;
        if (!ctx.hasArguments()) {
            throw new OperationFormatException("Arguments are missing");
        }
        String jndiName = null;
        String[] args = ctx.getCommandArguments().split("\\s+");
        int i = 0;
        while (i < args.length) {
            String arg;
            if ((arg = args[i++]).equals("--target")) continue;
            jndiName = arg;
        }
        if (jndiName == null) {
            throw new OperationFormatException("name is missing.");
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        if (Util.isTopic(client, jndiName)) {
            resource = "topic";
        } else if (Util.isQueue(client, jndiName)) {
            resource = "queue";
        } else if (Util.isConnectionFactory(client, jndiName)) {
            resource = "connection-factory";
        } else {
            throw new OperationFormatException("'" + jndiName + "' wasn't found among existing JMS resources.");
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.addNode("subsystem", "jms");
        builder.addNode(resource, jndiName);
        builder.setOperationName("remove");
        return builder.buildRequest();
    }
}

